/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cat;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class FieldAccessTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FieldAccessTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testAccessFieldsFromSubClass() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import org.drools.mvel.compiler.Person;\n";
        rule = rule + "import org.drools.mvel.compiler.Pet;\n";
        rule = rule + "import org.drools.mvel.compiler.Cat;\n";
        rule = rule + "declare Person @typesafe(false) end\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    Person(\n";
        rule = rule + "      pet.breed == \"Siamise\"\n";
        rule = rule + "    )\n";
        rule = rule + "then\n";
        rule = rule + "    System.out.println(\"hello person\");\n";
        rule = rule + "end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession session = kbase.newKieSession();
        Person person = new Person();
        person.setPet(new Cat("Mittens"));
        session.insert((Object)person);
        session.fireAllRules();
    }

    @Test
    public void testAccessClassTypeField() {
        String str = "package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Primitives());
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testGenericsOption() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addressOption.get.street == $type )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addressOption.get.street == $type )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("x");
        p.setAddress(new Address("x", "x", "x"));
        ksession.insert((Object)p);
        ksession.insert((Object)new Cheese("x"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }
}

