/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.PropertySpecificOption;

@RunWith(value=Parameterized.class)
public class AccumulateMvelDialectTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AccumulateMvelDialectTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMVELAccumulate() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateMVEL.drl"});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new Person("Bob", "stilton", 20));
            wm.insert((Object)new Person("Mark", "provolone"));
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Cheese("brie", 5));
            wm.insert((Object)new Cheese("provolone", 150));
            wm.fireAllRules();
            Assertions.assertThat(results.get(0)).isEqualTo((Object)165);
            Assertions.assertThat(results.get(1)).isEqualTo((Object)10);
            Assertions.assertThat(results.get(2)).isEqualTo((Object)150);
            Assertions.assertThat(results.get(3)).isEqualTo((Object)10);
            Assertions.assertThat(results.get(4)).isEqualTo((Object)210);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMVELAccumulate2WM() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_AccumulateMVEL.drl"});
        KieSession wm1 = kbase.newKieSession();
        try {
            ArrayList results1 = new ArrayList();
            wm1.setGlobal("results", results1);
            ArrayList results2 = new ArrayList();
            KieSession wm2 = kbase.newKieSession();
            try {
                wm2.setGlobal("results", results2);
                wm1.insert((Object)new Person("Bob", "stilton", 20));
                wm1.insert((Object)new Person("Mark", "provolone"));
                wm2.insert((Object)new Person("Bob", "stilton", 20));
                wm2.insert((Object)new Person("Mark", "provolone"));
                wm1.insert((Object)new Cheese("stilton", 10));
                wm1.insert((Object)new Cheese("brie", 5));
                wm2.insert((Object)new Cheese("stilton", 10));
                wm1.insert((Object)new Cheese("provolone", 150));
                wm2.insert((Object)new Cheese("brie", 5));
                wm2.insert((Object)new Cheese("provolone", 150));
                wm1.fireAllRules();
                wm2.fireAllRules();
            }
            finally {
                wm2.dispose();
            }
            Assertions.assertThat(results1.get(0)).isEqualTo((Object)165);
            Assertions.assertThat(results1.get(1)).isEqualTo((Object)10);
            Assertions.assertThat(results1.get(2)).isEqualTo((Object)150);
            Assertions.assertThat(results1.get(3)).isEqualTo((Object)10);
            Assertions.assertThat(results1.get(4)).isEqualTo((Object)210);
            Assertions.assertThat(results2.get(0)).isEqualTo((Object)165);
            Assertions.assertThat(results2.get(1)).isEqualTo((Object)10);
            Assertions.assertThat(results2.get(2)).isEqualTo((Object)150);
            Assertions.assertThat(results2.get(3)).isEqualTo((Object)10);
            Assertions.assertThat(results2.get(4)).isEqualTo((Object)210);
        }
        finally {
            wm1.dispose();
        }
    }

    @Test
    public void testAccFunctionOpaqueJoins() {
        this.testAccFunctionOpaqueJoins(PropertySpecificOption.ALLOWED);
    }

    @Test
    public void testAccFunctionOpaqueJoinsWithPropertyReactivity() {
        this.testAccFunctionOpaqueJoins(PropertySpecificOption.ALWAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAccFunctionOpaqueJoins(PropertySpecificOption propertySpecificOption) {
        String drl = "package org.test; import java.util.*; global List list; global List list2; declare Tick   tick : int end declare Data   values : List   bias : int = 0 end rule Init when then   insert( new Data( Arrays.asList( 1, 2, 3 ), 1 ) );   insert( new Data( Arrays.asList( 4, 5, 6 ), 2 ) );   insert( new Tick( 0 ) );end rule Update   no-loop when   $i : Integer()   $t : Tick() then   System.out.println( 'Set tick to ' + $i );   modify( $t ) {       setTick( $i );   } end rule M   dialect 'mvel' when     Tick( $index : tick )     accumulate ( $data : Data( $bias : bias ),                 $tot : sum( ((Integer) $data.values[ $index ]) + $bias ) ) then     System.out.println( $tot + ' for J ' + $index );     list.add( $tot.intValue() ); end rule J when     Tick( $index : tick )     accumulate ( $data : Data( $bias : bias ),                 $tot : sum( ((Integer)$data.getValues().get( $index )) + $bias ) ) then     System.out.println( $tot + ' for M ' + $index );     list2.add( $tot.intValue() ); end ";
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "accumulate-test", "1");
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", propertySpecificOption.toString());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, kieModuleConfigurationProperties, (String[])new String[]{"package org.test; import java.util.*; global List list; global List list2; declare Tick   tick : int end declare Data   values : List   bias : int = 0 end rule Init when then   insert( new Data( Arrays.asList( 1, 2, 3 ), 1 ) );   insert( new Data( Arrays.asList( 4, 5, 6 ), 2 ) );   insert( new Tick( 0 ) );end rule Update   no-loop when   $i : Integer()   $t : Tick() then   System.out.println( 'Set tick to ' + $i );   modify( $t ) {       setTick( $i );   } end rule M   dialect 'mvel' when     Tick( $index : tick )     accumulate ( $data : Data( $bias : bias ),                 $tot : sum( ((Integer) $data.values[ $index ]) + $bias ) ) then     System.out.println( $tot + ' for J ' + $index );     list.add( $tot.intValue() ); end rule J when     Tick( $index : tick )     accumulate ( $data : Data( $bias : bias ),                 $tot : sum( ((Integer)$data.getValues().get( $index )) + $bias ) ) then     System.out.println( $tot + ' for M ' + $index );     list2.add( $tot.intValue() ); end "});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ks = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ks.setGlobal("list", list);
            ArrayList list2 = new ArrayList();
            ks.setGlobal("list2", list2);
            ks.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Collections.singletonList(8));
            Assertions.assertThat(list2).isEqualTo(Collections.singletonList(8));
            ks.insert((Object)1);
            ks.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(8, 10));
            Assertions.assertThat(list2).isEqualTo(Arrays.asList(8, 10));
            ks.insert((Object)2);
            ks.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(8, 10, 12));
            Assertions.assertThat(list2).isEqualTo(Arrays.asList(8, 10, 12));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccumulateWithSameSubnetwork() {
        String drl = "package org.drools.compiler.test;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list; \nrule r1 salience 100 \n    when\n        $person      : Person( name == 'Alice', $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                min($c.getPrice()) )\n    then\n        list.add( 'r1' + ':' + $total);\nend\nrule r2 \n    when\n        $person      : Person( name == 'Alice', $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                max($c.getPrice()) )\n    then\n        list.add( 'r2' + ':' + $total);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            wm.setGlobal("list", list);
            ObjectTypeNode cheeseOtn = KieUtil.getObjectTypeNode((KieBase)kbase, Cheese.class);
            Assertions.assertThat((Object)cheeseOtn).isNotNull();
            ObjectSink[] oSinks = cheeseOtn.getObjectSinkPropagator().getSinks();
            Assertions.assertThat((int)oSinks.length).isEqualTo(1);
            JoinNode cheeseJoin = (JoinNode)oSinks[0];
            LeftTupleSink[] ltSinks = cheeseJoin.getSinkPropagator().getSinks();
            Assertions.assertThat((int)ltSinks.length).isEqualTo(1);
            RightInputAdapterNode rian = (RightInputAdapterNode)ltSinks[0];
            Assertions.assertThat((int)rian.getObjectSinkPropagator().size()).isEqualTo(2);
            wm.insert((Object)new Cheese("stilton", 10));
            wm.insert((Object)new Person("Alice", "brie"));
            wm.insert((Object)new Person("Bob", "stilton"));
            wm.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"r1:10");
            Assertions.assertThat(list.get(1)).isEqualTo((Object)"r2:10");
        }
        finally {
            wm.dispose();
        }
    }
}

