/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.api;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Results;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class KnowledgeBuilderTest {
    @Test
    public void testKnowledgeProvider() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Assertions.assertThat((Object)builder).isNotNull();
    }

    @Test
    public void testKnowledgeProviderWithRules() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "package org.drools.mvel.compiler.test1\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule2\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        str = "package org.drools.mvel.compiler.test2\n";
        str = str + "rule rule3\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule4\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Collection pkgs = builder.getKnowledgePackages();
        Assertions.assertThat((Iterable)pkgs).isNotNull();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(2);
        KiePackage test1 = this.getKnowledgePackage(pkgs, "org.drools.mvel.compiler.test1");
        Collection rules = test1.getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(2);
        Rule rule = this.getRule(rules, "rule1");
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule1");
        rule = this.getRule(rules, "rule2");
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule2");
        KiePackage test2 = this.getKnowledgePackage(pkgs, "org.drools.mvel.compiler.test2");
        rules = test2.getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(2);
        rule = this.getRule(rules, "rule3");
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule3");
        rule = this.getRule(rules, "rule4");
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule4");
    }

    public Rule getRule(Collection<Rule> rules, String name) {
        for (Rule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public KiePackage getKnowledgePackage(Collection<KiePackage> pkgs, String name) {
        for (KiePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    @Test
    public void testMalformedDrl() throws Exception {
        KieFileSystem kfs;
        byte[] content = new byte[]{4, 68, 0, 0, 96, 0, 0, 0};
        KieServices ks = KieServices.Factory.get();
        Results results = ks.newKieBuilder(kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", new String(content))).buildAll().getResults();
        Assertions.assertThat((results.getMessages().size() > 0 ? 1 : 0) != 0).isTrue();
    }
}

