/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.util.DroolsAssert;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class KieContainerTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieContainerTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testMainKieModule() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieModule kmodule = ((InternalKieContainer)kieContainer).getMainKieModule();
        Assertions.assertThat((Comparable)kmodule.getReleaseId()).isEqualTo((Object)releaseId);
    }

    @Test
    public void testUpdateToNonExistingRelease() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-release", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        Results results = kieContainer.updateToVersion(ks.newReleaseId("org.kie", "test-release", "1.0.1"));
        Assertions.assertThat((int)results.getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
        Assertions.assertThat((String)((InternalKieContainer)kieContainer).getContainerReleaseId().getVersion()).isEqualTo("1.0.0");
    }

    @Test
    public void testReleaseIdGetters() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-delete-v", "1.0.1");
        ReleaseId newReleaseId = ks.newReleaseId("org.kie", "test-delete-v", "1.0.2");
        ks.getRepository().removeKieModule(releaseId);
        ks.getRepository().removeKieModule(newReleaseId);
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        ReleaseId configuredReleaseId = ks.newReleaseId("org.kie", "test-delete-v", "RELEASE");
        KieContainer kieContainer = ks.newKieContainer(configuredReleaseId);
        InternalKieContainer iKieContainer = (InternalKieContainer)kieContainer;
        Assertions.assertThat((Comparable)iKieContainer.getConfiguredReleaseId()).isEqualTo((Object)configuredReleaseId);
        Assertions.assertThat((Comparable)iKieContainer.getResolvedReleaseId()).isEqualTo((Object)releaseId);
        Assertions.assertThat((Comparable)iKieContainer.getReleaseId()).isEqualTo((Object)releaseId);
        Assertions.assertThat((Comparable)iKieContainer.getContainerReleaseId()).isEqualTo((Object)configuredReleaseId);
        KieUtil.getKieModuleFromDrls((ReleaseId)newReleaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("ruleA")});
        iKieContainer.updateToVersion(newReleaseId);
        Assertions.assertThat((Comparable)iKieContainer.getConfiguredReleaseId()).isEqualTo((Object)configuredReleaseId);
        Assertions.assertThat((Comparable)iKieContainer.getResolvedReleaseId()).isEqualTo((Object)newReleaseId);
        Assertions.assertThat((Comparable)iKieContainer.getReleaseId()).isEqualTo((Object)newReleaseId);
        Assertions.assertThat((Comparable)iKieContainer.getContainerReleaseId()).isEqualTo((Object)newReleaseId);
    }

    @Test
    public void testSharedTypeDeclarationsUsingClassLoader() throws Exception {
        String type = "package org.drools.test\ndeclare Message\n   message : String\nend\n";
        String drl1 = "package org.drools.test\nrule R1 when\n   $o : Object()\nthen\n   if ($o.getClass().getName().equals(\"org.drools.test.Message\") && $o.getClass() != new Message(\"Test\").getClass()) {\n       throw new RuntimeException();\n   }\nend\n";
        String drl2 = "package org.drools.test\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\n   if ($m.getClass() != new Message(\"Test\").getClass()) {\n       throw new RuntimeException();\n   }\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type, drl1, drl2});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieContainer kieContainer2 = ks.newKieContainer(releaseId1);
        KieSession ksession = kieContainer.newKieSession();
        KieSession ksession2 = kieContainer2.newKieSession();
        Class<?> cls1 = kieContainer.getClassLoader().loadClass("org.drools.test.Message");
        Constructor<?> constructor = cls1.getConstructor(String.class);
        ksession.insert(constructor.newInstance("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        Class<?> cls2 = kieContainer2.getClassLoader().loadClass("org.drools.test.Message");
        Constructor<?> constructor2 = cls2.getConstructor(String.class);
        ksession2.insert(constructor2.newInstance("Hello World"));
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testSharedTypeDeclarationsUsingFactTypes() throws Exception {
        String type = "package org.drools.test\ndeclare Message\n   message : String\nend\n";
        String drl1 = "package org.drools.test\nrule R1 when\n   $m : Message()\nthen\n   if ($m.getClass() != new Message(\"Test\").getClass()) {\n       throw new RuntimeException();\n   }\nend\n";
        String drl2 = "package org.drools.test\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\n   if ($m.getClass() != new Message(\"Test\").getClass()) {\n       throw new RuntimeException();\n   }\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type, drl1, drl2});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieContainer kieContainer2 = ks.newKieContainer(releaseId1);
        KieSession ksession = kieContainer.newKieSession();
        KieSession ksession2 = kieContainer2.newKieSession();
        this.insertMessageFromTypeDeclaration(ksession);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-delete", "1.0.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{type, null, drl2});
        kieContainer.updateToVersion(releaseId2);
        ksession = kieContainer.newKieSession();
        this.insertMessageFromTypeDeclaration(ksession);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession = kieContainer.newKieSession();
        this.insertMessageFromTypeDeclaration(ksession);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        this.insertMessageFromTypeDeclaration(ksession2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(2);
        ksession2 = kieContainer2.newKieSession();
        this.insertMessageFromTypeDeclaration(ksession2);
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(2);
    }

    private void insertMessageFromTypeDeclaration(KieSession ksession) throws InstantiationException, IllegalAccessException {
        FactType messageType = ksession.getKieBase().getFactType("org.drools.test", "Message");
        Object message = messageType.newInstance();
        messageType.set(message, "message", (Object)"Hello World");
        ksession.insert(message);
    }

    @Test(timeout=20000L)
    public void testIncrementalCompilationSynchronization() {
        KieServices kieServices = KieServices.Factory.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie.test", "sync-scanner-test", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("rule0")});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSession kieSession = kieContainer.newKieSession();
        ArrayList list = new ArrayList();
        kieSession.setGlobal("list", list);
        kieSession.fireAllRules();
        kieSession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Thread t = new Thread(() -> {
            for (int i = 1; i < 10; ++i) {
                ReleaseId releaseId1 = kieServices.newReleaseId("org.kie.test", "sync-scanner-test", "1.0." + i);
                KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.createDRL("rule" + i)});
                kieContainer.updateToVersion(releaseId1);
            }
        });
        t.setDaemon(true);
        t.start();
        do {
            kieSession = kieContainer.newKieSession();
            list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.fireAllRules();
            kieSession.dispose();
            Assertions.assertThat(list).isNotEmpty();
        } while (!((String)list.get(0)).equals("rule9"));
    }

    @Test
    public void testMemoryFileSystemFolderUniqueness() {
        KieServices kieServices = KieServices.Factory.get();
        String drl = "package org.drools.test\nrule R1 when\n   $m : Object()\nthen\nend\n";
        Resource resource = kieServices.getResources().newReaderResource((Reader)new StringReader(drl), "UTF-8");
        resource.setTargetPath("org/drools/test/rules.drl");
        String kmodule = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"testKbase\" packages=\"org.drools.test\">\n    <ksession name=\"testKsession\"/>\n  </kbase>\n</kmodule>";
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId, (KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (Resource[])new Resource[]{resource});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieModule kieModule = ((InternalKieContainer)kieContainer).getMainKieModule();
        MemoryFileSystem memoryFileSystem = ((MemoryKieModule)kieModule).getMemoryFileSystem();
        Folder rootFolder = memoryFileSystem.getFolder("");
        Object[] members = rootFolder.getMembers().toArray();
        Assertions.assertThat((int)members.length).isEqualTo(2);
        Folder firstFolder = (Folder)members[0];
        Folder secondFolder = (Folder)members[1];
        Assertions.assertThat((Object)secondFolder.getParent()).isEqualTo((Object)firstFolder.getParent());
    }

    @Test
    public void testClassLoaderGetResources() throws IOException {
        KieServices kieServices = KieServices.Factory.get();
        String drl1 = "package org.drools.testdrl;\nrule R1 when\n   $m : Object()\nthen\nend\n";
        Resource resource1 = kieServices.getResources().newReaderResource((Reader)new StringReader(drl1), "UTF-8");
        resource1.setTargetPath("org/drools/testdrl/rules1.drl");
        String drl2 = "package org.drools.testdrl;\nrule R2 when\n   $m : Object()\nthen\nend\n";
        Resource resource2 = kieServices.getResources().newReaderResource((Reader)new StringReader(drl2), "UTF-8");
        resource2.setTargetPath("org/drools/testdrl/rules2.drl");
        String java3 = "package org.drools.testjava;\npublic class Message {}";
        Resource resource3 = kieServices.getResources().newReaderResource((Reader)new StringReader(java3), "UTF-8");
        resource3.setTargetPath("org/drools/testjava/Message.java");
        resource3.setResourceType(ResourceType.JAVA);
        String kmodule = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"testKbase\" packages=\"org.drools.testdrl\">\n    <ksession name=\"testKsession\"/>\n  </kbase>\n</kmodule>";
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId, (KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (Resource[])new Resource[]{resource1, resource2, resource3});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        ClassLoader classLoader = kieContainer.getClassLoader();
        DroolsAssert.assertEnumerationSize((int)1, classLoader.getResources("org/drools/testjava"));
        DroolsAssert.assertEnumerationSize((int)1, classLoader.getResources("org/drools/testdrl/"));
        URL url = classLoader.getResources("org/drools/testdrl").nextElement();
        List lines = IOUtils.readLines((InputStream)url.openStream());
        Assertions.assertThat((List)lines).contains((Object[])new String[]{"rules1.drl", "rules1.drl.properties", "rules2.drl", "rules2.drl.properties"});
        DroolsAssert.assertUrlEnumerationContainsMatch((String)"^mfs\\:/$", classLoader.getResources(""));
    }

    @Test
    public void testGetDefaultKieSessionModel() {
        KieServices kieServices = KieServices.Factory.get();
        String drl = "package org.drools.test\nrule R1 when\n   $m : Object()\nthen\nend\n";
        Resource resource = kieServices.getResources().newReaderResource((Reader)new StringReader(drl), "UTF-8");
        resource.setTargetPath("org/drools/test/rules.drl");
        String kmodule = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"testKbase\" packages=\"org.drools.test\">\n    <ksession name=\"testKsession\" default=\"true\"/>\n  </kbase>\n</kmodule>";
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-testGetDefaultKieSessionModel", "1.0.0");
        KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId, (KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (Resource[])new Resource[]{resource});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSessionModel sessionModel = kieContainer.getKieSessionModel(null);
        Assertions.assertThat((Object)sessionModel).isNotNull();
        Assertions.assertThat((String)sessionModel.getName()).isEqualTo("testKsession");
    }

    @Test
    public void testGetDefaultKieSessionModelEmptyKmodule() {
        KieServices kieServices = KieServices.Factory.get();
        String drl = "package org.drools.test\nrule R1 when\n   $m : Object()\nthen\nend\n";
        Resource resource = kieServices.getResources().newReaderResource((Reader)new StringReader(drl), "UTF-8");
        resource.setTargetPath("org/drools/test/rules.drl");
        String kmodule = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n</kmodule>";
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-testGetDefaultKieSessionModelEmptyKmodule", "1.0.0");
        KieUtil.buildAndInstallKieModuleIntoRepo((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (ReleaseId)releaseId, (KieModuleModel)KieModuleModelImpl.fromXML((String)kmodule), (Resource[])new Resource[]{resource});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSessionModel sessionModel = kieContainer.getKieSessionModel(null);
        Assertions.assertThat((Object)sessionModel).isNotNull();
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }
}

