/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.commands.runtime.BatchExecutionCommandImpl;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Cheesery;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class StatelessSessionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    final List list = new ArrayList();
    final Cheesery cheesery = new Cheesery();

    public StatelessSessionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSingleObjectAssert() throws Exception {
        StatelessKieSession session = this.getSession2("statelessSessionTest.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.execute((Object)stilton);
        Assertions.assertThat(this.list.get(0)).isEqualTo((Object)"stilton");
    }

    @Test
    public void testArrayObjectAssert() throws Exception {
        StatelessKieSession session = this.getSession2("statelessSessionTest.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.execute(Arrays.asList(stilton));
        Assertions.assertThat(this.list.get(0)).isEqualTo((Object)"stilton");
    }

    @Test
    public void testCollectionObjectAssert() throws Exception {
        StatelessKieSession session = this.getSession2("statelessSessionTest.drl");
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        Assertions.assertThat(this.list.get(0)).isEqualTo((Object)"stilton");
    }

    @Test
    public void testInsertObject() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        StatelessKieSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ExecutableCommand cmd = (ExecutableCommand)CommandFactory.newInsert((Object)stilton, (String)"outStilton");
        BatchExecutionCommandImpl batch = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults result = (ExecutionResults)ksession.execute((Command)batch);
        stilton = (Cheese)result.getValue("outStilton");
        Assertions.assertThat((int)stilton.getPrice()).isEqualTo(30);
    }

    @Test
    public void testSetGlobal() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "global java.util.List list2 \n";
        str = str + "global java.util.List list3 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "    list2.add( $c ); \n";
        str = str + "    list3.add( $c ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList list1 = new ArrayList();
        List list2 = new ArrayList();
        List list3 = new ArrayList();
        StatelessKieSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        Command setGlobal1 = CommandFactory.newSetGlobal((String)"list1", list1);
        Command setGlobal2 = CommandFactory.newSetGlobal((String)"list2", list2, (boolean)true);
        Command setGlobal3 = CommandFactory.newSetGlobal((String)"list3", list3, (String)"outList3");
        Command insert = CommandFactory.newInsert((Object)stilton);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(setGlobal1);
        cmds.add(setGlobal2);
        cmds.add(setGlobal3);
        cmds.add(insert);
        ExecutionResults result = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
        Assertions.assertThat((int)stilton.getPrice()).isEqualTo(30);
        Assertions.assertThat((Object)result.getValue("list1")).isNull();
        list2 = (List)result.getValue("list2");
        Assertions.assertThat((int)list2.size()).isEqualTo(1);
        Assertions.assertThat(list2.get(0)).isSameAs((Object)stilton);
        list3 = (List)result.getValue("outList3");
        Assertions.assertThat((int)list3.size()).isEqualTo(1);
        Assertions.assertThat(list3.get(0)).isSameAs((Object)stilton);
    }

    @Test
    public void testQuery() throws Exception {
        String str = "";
        str = str + "package org.kie.test  \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        StatelessKieSession ksession = kbase.newStatelessKieSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(CommandFactory.newInsert((Object)stilton1));
        cmds.add(CommandFactory.newInsert((Object)stilton2));
        cmds.add(CommandFactory.newInsert((Object)stilton3));
        cmds.add(CommandFactory.newInsert((Object)cheddar1));
        cmds.add(CommandFactory.newInsert((Object)cheddar2));
        cmds.add(CommandFactory.newInsert((Object)cheddar3));
        cmds.add(CommandFactory.newQuery((String)"cheeses", (String)"cheeses"));
        ExecutionResults batchResult = (ExecutionResults)ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
        QueryResults results = (QueryResults)batchResult.getValue("cheeses");
        Assertions.assertThat((int)results.size()).isEqualTo(3);
        Assertions.assertThat((int)results.getIdentifiers().length).isEqualTo(2);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assertions.assertThat(newSet).isEqualTo(set);
    }

    @Test
    public void testNotInStatelessSession() throws Exception {
        KieModule kieModule = KieUtil.getKieModuleFromClasspathResources((String)"test", this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_NotInStatelessSession.drl"});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        StatelessKieSession session = kbase.newStatelessKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)"not integer");
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"not integer");
    }

    @Test
    public void testChannels() throws Exception {
        String str = "";
        str = str + "package org.kie \n";
        str = str + "import org.drools.mvel.compiler.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    channels[\"x\"].send( $c ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        StatelessKieSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        ksession.registerChannel("x", channel);
        Assertions.assertThat((int)ksession.getChannels().size()).isEqualTo(1);
        Assertions.assertThat((Object)((Channel)ksession.getChannels().get("x"))).isEqualTo((Object)channel);
        ksession.execute((Object)stilton);
        ((Channel)Mockito.verify((Object)channel)).send((Object)stilton);
        ksession.unregisterChannel("x");
        Assertions.assertThat((int)ksession.getChannels().size()).isEqualTo(0);
        Assertions.assertThat((Object)((Channel)ksession.getChannels().get("x"))).isNull();
    }

    private StatelessKieSession getSession2(String fileName) throws Exception {
        return this.getSession2(ResourceFactory.newClassPathResource((String)fileName, this.getClass()));
    }

    private StatelessKieSession getSession2(Resource resource) throws Exception {
        resource.setTargetPath("r1.drl");
        KieBase kbase = KieBaseUtil.getKieBaseFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{resource});
        StatelessKieSession session = kbase.newStatelessKieSession();
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }
}

