/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.Collection;
import org.drools.compiler.integrationtests.concurrency.Album;
import org.drools.compiler.integrationtests.concurrency.BaseConcurrencyTest;
import org.drools.compiler.integrationtests.concurrency.Bus;
import org.drools.compiler.integrationtests.concurrency.StaticUtils;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class ConstraintWithAndOrConcurrencyTest
extends BaseConcurrencyTest {
    public ConstraintWithAndOrConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Override
    protected String getDrl() {
        return "package com.example.reproducer\nimport " + Bus.class.getCanonicalName() + ";\nimport static " + StaticUtils.class.getCanonicalName() + ".TOSTRING;\ndialect \"mvel\"\nrule \"rule_mt_1a\"\n    when\n        $bus : Bus( $check: \"GAMMA RAY\",\n                    $title: \"POWER PLANT\",\n                    karaoke.dvd[$title] != null,\n                    TOSTRING(karaoke.dvd[$title].artist) == \"BBB\" || TOSTRING(karaoke.dvd[$title].artist) >= \"01\" && TOSTRING(karaoke.dvd[$title].artist) <= \"39\" )\n    then\nend";
    }

    @Override
    protected void preprocess(KieBase kieBase) {
        KieSession kSession1 = kieBase.newKieSession();
        Bus bus1 = new Bus("red", 30);
        bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "BBB"));
        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession1.insert((Object)bus1);
        kSession1.fireAllRules();
        kSession1.dispose();
        KieSession kSession2 = kieBase.newKieSession();
        Bus bus2 = new Bus("red", 30);
        bus2.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "00"));
        bus2.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession2.insert((Object)bus2);
        kSession2.fireAllRules();
        kSession2.dispose();
    }

    @Override
    protected void insertFacts(KieSession kSession) {
        Bus bus1 = new Bus("red", 30);
        bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "10"));
        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession.insert((Object)bus1);
    }
}

