/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.ClassA;
import org.drools.testcoverage.common.model.ClassB;
import org.drools.testcoverage.common.model.FactA;
import org.drools.testcoverage.common.model.FactB;
import org.drools.testcoverage.common.model.FactC;
import org.drools.testcoverage.common.model.InterfaceB;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.model.Sensor;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PatternTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PatternTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeclaringAndUsingBindsInSamePattern() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Sensor.class.getCanonicalName() + ";\n\nglobal java.util.List sensors;\n\nrule \"BindsTest1_returnValue\"\n    when\n        $sensor1 : Sensor( $temp1 : temperature, pressure < $temp1 )\n        $sensor2 : Sensor( $temp2 : temperature, pressure < ( $temp1 + $temp2 ) )\n    then\n        sensors.add( $sensor1 );\nend\n\nrule \"BindsTest2_predicate\"\n    when\n        $sensor1 : Sensor( $temp1 : temperature, pressure < $temp1 )\n        $sensor2 : Sensor( $temp2 : temperature, $p : pressure,  eval ( $p < ($temp1 + $temp2 ) ) )\n    then\n        sensors.add( $sensor1 );\nend\n\nrule \"BindsTest3_eval\"\n    when\n        $sensor1 : Sensor( $temp1 : temperature, pressure < $temp1 )\n        $sensor2 : Sensor( $temp2 : temperature, $p : pressure )\n        eval( $p < $temp1 + $temp2 )\n    then\n        sensors.add( $sensor1 );\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)RemoveIdentitiesOption.YES);
        KieBase kbase = kieContainer.newKieBase(kieBaseConfiguration);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList sensors = new ArrayList();
            ksession.setGlobal("sensors", sensors);
            Sensor sensor1 = new Sensor(100, 150);
            ksession.insert((Object)sensor1);
            ksession.fireAllRules();
            Assertions.assertThat((int)sensors.size()).isEqualTo(0);
            Sensor sensor2 = new Sensor(200, 150);
            ksession.insert((Object)sensor2);
            ksession.fireAllRules();
            Assertions.assertThat((int)sensors.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyPattern() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n \nimport " + Cheese.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n \nrule \"simple rule\"\n    when\n        cheese : Cheese( )\n    then\n        list.add( new Integer(5) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 5);
            session.insert((Object)stilton);
            session.fireAllRules();
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)5);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatternMatchingOnThis() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nrule R1 when\n    $i1: Integer()\n    $i2: Integer( this > $i1 )\nthen\n   System.out.println( $i2 + \" > \" + $i1 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nrule R1 when\n    $i1: Integer()\n    $i2: Integer( this > $i1 )\nthen\n   System.out.println( $i2 + \" > \" + $i1 );\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)1);
            ksession.insert((Object)2);
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatternOffset() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl;\ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) or ( A( ) and B( ) ) ) and (\n   A( ) or ( B( $bField : field ) and C( field != $bField ) )\n)\nthen\n    System.out.println(\"rule fired\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) or ( A( ) and B( ) ) ) and (\n   A( ) or ( B( $bField : field ) and C( field != $bField ) )\n)\nthen\n    System.out.println(\"rule fired\");\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType typeA = kbase.getFactType("org.drools.compiler.integrationtests.drl", "A");
            FactType typeB = kbase.getFactType("org.drools.compiler.integrationtests.drl", "B");
            FactType typeC = kbase.getFactType("org.drools.compiler.integrationtests.drl", "C");
            Object a = typeA.newInstance();
            ksession.insert(a);
            Object b = typeB.newInstance();
            typeB.set(b, "field", (Object)1);
            ksession.insert(b);
            Object c = typeC.newInstance();
            typeC.set(c, "field", (Object)1);
            ksession.insert(c);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatternOnClass() {
        String drl = "import " + InitialFactImpl.class.getCanonicalName() + "\nimport " + FactB.class.getCanonicalName() + "\nrule \"Clear\" when\n   $f: Object(getClass() != FactB.class)\nthen\n   if( ! ($f instanceof InitialFactImpl) ){\n     delete( $f );\n   }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new FactA());
            ksession.insert((Object)new FactA());
            ksession.insert((Object)new FactB());
            ksession.insert((Object)new FactB());
            ksession.insert((Object)new FactC());
            ksession.insert((Object)new FactC());
            ksession.fireAllRules();
            for (FactHandle fact : ksession.getFactHandles()) {
                InternalFactHandle internalFact = (InternalFactHandle)fact;
                Assertions.assertThat((boolean)(internalFact.getObject() instanceof FactB)).isTrue();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredicateAsFirstPattern() {
        String drl = "package oreg.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\n\nrule \"Using Predicate as first pattern\"\n  when\n    cheese: Cheese( type == \"Mussarela\", $price:price, eval( $price < 30 ))\n  then\n    cheese.setPrice(40);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese mussarela = new Cheese("Mussarela", 35);
            ksession.insert((Object)mussarela);
            Cheese provolone = new Cheese("Provolone", 20);
            ksession.insert((Object)provolone);
            ksession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)mussarela.getPrice()).as("The rule is being incorrectly fired", new Object[0])).isEqualTo(35);
            ((AbstractIntegerAssert)Assertions.assertThat((int)provolone.getPrice()).as("Rule is incorrectly being fired", new Object[0])).isEqualTo(20);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantLeft() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nrule R1 when\n   $p : Person( \"Mark\" == name )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person(null));
            ksession.insert((Object)new Person("Mark"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUppercaseField() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare Address\n    Street: String\nend\nrule \"r1\"\nwhen\n    Address($street: Street)\nthen\n    list.add($street);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nglobal java.util.List list\ndeclare Address\n    Street: String\nend\nrule \"r1\"\nwhen\n    Address($street: Street)\nthen\n    list.add($street);\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("list", new ArrayList());
            FactType addressType = kbase.getFactType("org.drools.compiler.integrationtests.drl", "Address");
            Object address = addressType.newInstance();
            addressType.set(address, "Street", (Object)"5th Avenue");
            ksession.insert(address);
            ksession.fireAllRules();
            List list = (List)ksession.getGlobal("list");
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"5th Avenue");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUppercaseField2() throws Exception {
        String drl = "package org.drools.compiler.integrationtests.drl;\ndeclare SomeFact\n    Field : String\n    aField : String\nend\nrule X\nwhen\n    SomeFact( Field == \"foo\", aField == \"bar\" )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\ndeclare SomeFact\n    Field : String\n    aField : String\nend\nrule X\nwhen\n    SomeFact( Field == \"foo\", aField == \"bar\" )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType factType = kbase.getFactType("org.drools.compiler.integrationtests.drl", "SomeFact");
            Object fact = factType.newInstance();
            factType.set(fact, "Field", (Object)"foo");
            factType.set(fact, "aField", (Object)"bar");
            ksession.insert(fact);
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHelloWorld() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n \n//we don't use the import, as class is fully qualified below\n\nglobal java.util.List list;\n\nrule \"Hello World\"\n    when\n        $m : " + Message.class.getCanonicalName() + "(list contains \"hello\",\n                                text:message, message == \"hola\",\n                                fired == false,\n                                number > 40,\n                                birthday > \"10-Jul-1974\",\n                                message matches \".*ho.*\",\n                                list excludes \"wax\")\n    then\n        // putting in a complex consequence, to make sure it picks up the variabels correctly\n        if (1==1)  {\n            int a = 0;\n        }\n        try {\n            //System.out.println(\"hello world with collections \" + $m.getMessage());\n        } catch  ( Exception e ) {\n\n        } finally {\n            list.add( $m );\n        }\n        modify($m) { setFired(true) }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Message message = new Message("hola");
            message.addToList("hello");
            message.setNumber(42);
            ksession.insert((Object)message);
            ksession.insert((Object)"boo");
            ksession.fireAllRules();
            Assertions.assertThat((boolean)message.isFired()).isTrue();
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(0)).isEqualTo((Object)message);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimal() {
        String drl = "package org.drools.compiler.integrationtests.drl;\n\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Primitives.class.getCanonicalName() + ";\nimport java.math.BigDecimal;\n\nglobal java.util.List list;\n\nrule \"BigDec\"\n\n    when\n        Cheese($price : price)\n        p : Primitives(bigDecimal < $price)\n    then\n        list.add( p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Primitives bill = new Primitives();
            bill.setBigDecimal(new BigDecimal("42"));
            Primitives ben = new Primitives();
            ben.setBigDecimal(new BigDecimal("43"));
            session.insert((Object)bill);
            session.insert((Object)new Cheese("gorgonzola", 43));
            session.insert((Object)ben);
            session.fireAllRules();
            Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfReference() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Order.class.getCanonicalName() + ";\nimport " + OrderItem.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"reversed references\"\nwhen\n    $item : OrderItem( $order : order )\n    Order( this == $order )\nthen\n    results.add( $item );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Order order = new Order(10, "Bob");
            OrderItem item1 = new OrderItem(order, 1);
            OrderItem item2 = new OrderItem(order, 2);
            OrderItem anotherItem1 = new OrderItem(null, 3);
            OrderItem anotherItem2 = new OrderItem(null, 4);
            ksession.insert((Object)order);
            ksession.insert((Object)item1);
            ksession.insert((Object)item2);
            ksession.insert((Object)anotherItem1);
            ksession.insert((Object)anotherItem2);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((boolean)results.contains(item1)).isTrue();
            Assertions.assertThat((boolean)results.contains(item2)).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfReference2() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"reversed references\"\nwhen\n    $cheese : Cheese( )\n    Cheese( this != $cheese )\nthen\n    results.add( $cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese());
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImplicitDeclarations() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nglobal java.lang.Double factor;\n\nrule \"test implicit declarations\"\n    when\n         // implicit binding\n        Cheese( type == \"stilton\", eval( price < 20*factor ) )\n        // late declaration\n        Cheese( price < ( price * factor ), eval( price < price * factor ), price : price  )\n    then\n        results.add( \"Rule Fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.setGlobal("factor", (Object)1.2);
            Cheese cheese = new Cheese("stilton", 10);
            ksession.insert((Object)cheese);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMethodCalls() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nrule \"method calls\"\nwhen\n    Person( getName().substring(2) == 'b' )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("mark", 50));
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(0);
            ksession.insert((Object)new Person("bob", 18));
            rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfJoinWithIndex() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\nrule test1\nwhen\n   $p1 : Person( $name : name, $age : age )\n   $p2 : Person( name == $name, age < $age)\nthen\n    list.add( $p1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", 30);
            FactHandle fh1 = ksession.insert((Object)p1);
            Person p2 = new Person("darth", 25);
            ksession.insert((Object)p2);
            p1.setName("yoda");
            ksession.update(fh1, (Object)p1);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfJoinAndNotWithIndex() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\nrule test1\nwhen\n   $p1 : Person( )\n     not Person( name == $p1.name, age < $p1.age )\n   $p2 : Person( name == $p1.name, likes != $p1.likes, age > $p1.age)\n     not Person( name == $p1.name, likes == $p2.likes, age < $p2.age )\nthen\n    System.out.println( $p1 + \":\" + $p2 );\n    list.add( $p1 );\n    list.add( $p2 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p0 = new Person("yoda", 0);
            p0.setLikes("cheddar");
            ksession.insert((Object)p0);
            Person p1 = new Person("darth", 15);
            p1.setLikes("cheddar");
            FactHandle fh1 = ksession.insert((Object)p1);
            Person p2 = new Person("darth", 25);
            p2.setLikes("cheddar");
            ksession.insert((Object)p2);
            Person p3 = new Person("darth", 30);
            p3.setLikes("brie");
            ksession.insert((Object)p3);
            ksession.fireAllRules();
            if (((RuleBase)kbase).getConfiguration().getAssertBehaviour().equals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY)) {
                Assertions.assertThat((int)list.size()).isEqualTo(2);
                Assertions.assertThat(list.get(0)).isSameAs((Object)p1);
                Assertions.assertThat(list.get(1)).isSameAs((Object)p3);
                p1.setName("yoda");
                ksession.update(fh1, (Object)p1);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(4);
                Assertions.assertThat(list.get(2)).isSameAs((Object)p2);
                Assertions.assertThat(list.get(3)).isSameAs((Object)p3);
            } else {
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                p1.setName("yoda");
                ksession.update(fh1, (Object)p1);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQualifiedFieldReference() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"test qualified field reference\"\nwhen\n    $p : Person( $p.name == \"bob\" );\n    $c : Cheese( $c.type == $p.likes )\nthen\n    results.add( $p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Person bob = new Person("bob");
            bob.setLikes("stilton");
            Cheese stilton = new Cheese("stilton", 12);
            ksession.insert((Object)bob);
            ksession.insert((Object)stilton);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)bob);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutovivificationOfVariableRestrictions() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"autovivification\"\nwhen\n     Cheese( price > oldPrice, price > this.oldPrice )\nthen\n     results.add( \"OK\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheese stilton = new Cheese("stilton");
            stilton.setPrice(10);
            stilton.setOldPrice(8);
            ksession.insert((Object)stilton);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParentheses() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results\n\nrule \"TestRule\"\nwhen\n    $p : Person( alive ==true ||(alive==false && age ==0) )\nthen\n    results.add( $p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            Person bob = new Person("Bob", 20);
            bob.setAlive(true);
            Person foo = new Person("Foo", 0);
            foo.setAlive(false);
            session.insert((Object)bob);
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((Object)((Person)results.get(0))).isEqualTo((Object)bob);
            session.insert((Object)foo);
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((Object)((Person)results.get(1))).isEqualTo((Object)foo);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCovariance() {
        String drl = "import " + ClassA.class.getCanonicalName() + ";\nimport " + ClassB.class.getCanonicalName() + ";\nrule x\nwhen\n   $b : ClassB( )\n   $a : ClassA( b.id == $b.id )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ClassA a = new ClassA();
            ClassB b = new ClassB();
            a.setB((InterfaceB)b);
            ksession.insert((Object)a);
            ksession.insert((Object)b);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testCheckDuplicateVariables() {
        Object drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nrule R1 when\n   Person( $a: age, $a: name ) // this should cause a compile-time error\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(org.kie.api.builder.Message::getText).doesNotContain((Object[])new String[]{""});
        drl = "package org.drools.compiler.integrationtests.drl;\nrule R1 when\n   accumulate( Object(), $c: count(1), $c: max(1) ) // this should cause a compile-time error\nthen\nend";
        kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(org.kie.api.builder.Message::getText).doesNotContain((Object[])new String[]{""});
        drl = "package org.drools.compiler.integrationtests.drl;\nrule R1 when\n   Number($i: intValue) from accumulate( Object(), $i: count(1) ) // this should cause a compile-time error\nthen\nend";
        kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(org.kie.api.builder.Message::getText).doesNotContain((Object[])new String[]{""});
    }

    @Test
    public void testCompilationFailureOnTernaryComparison() {
        String drl = "declare Cont\n  val:Integer\nend\nrule makeFacts\nsalience 10\nwhen\nthen\n    insert( new Cont(2) );\nend\nrule R1\nwhen\n    $c: Cont( 3 < val < 10 )\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"declare Cont\n  val:Integer\nend\nrule makeFacts\nsalience 10\nwhen\nthen\n    insert( new Cont(2) );\nend\nrule R1\nwhen\n    $c: Cont( 3 < val < 10 )\nthen\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).extracting(org.kie.api.builder.Message::getText).doesNotContain((Object[])new String[]{""});
    }
}

