/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;

public class ClassLoaderLeakTest {
    private static final String KIEBASE = "test";
    private static final String PACKAGE = "org.build.example.rules";
    private static final String RULES = "package org.build.example.rules\n\ndeclare Fact1\n    x : Integer\n    y : String\n    z : Integer\nend\n\ndeclare Fact2\n    id : Integer\n    f3Ids : java.util.List\nend\n\ndeclare Fact3\n    id : Integer\n    a : Integer\n    b : String\n    c : String\nend\n\nrule \"Test\"\n    when\n        $f3 : Fact3(a == 5, b == \"M\" || b == \"F\")\n        $f2 : Fact2(f3Ids contains $f3.id)\n        $f1 : Fact1(z == $f2.id, y == null, x > 1)\n    then\n    end\n\nrule \"Test_1%\"\nsalience 1\n    when\n        $f3 : Fact3(c == \"QWE\")\n        $f2 : Fact2(f3Ids contains $f3.id)\n        $f1 : Fact1(z == $f2.id, y == null, x == 1)\n    then\n    end\n\n\nrule \"Test_2\"\nsalience 1\n    when\n        $f3 : Fact3(c == \"XYZ\")\n        $f2 : Fact2(f3Ids contains $f3.id)\n        $f1 : Fact1(z == $f2.id, y == null, x == 2)\n    then\n    end\n\n\nrule \"Test_3\"\nsalience 1\n    when\n        $f3 : Fact3(c == \"ABC\")\n        $f2 : Fact2(f3Ids contains $f3.id)\n        $f1 : Fact1(z == $f2.id, y == null, x == 1)\n    then\n    end\n";

    private KieModule buildKieModule(String version, String rules, boolean withExecModel) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId rid = ks.newReleaseId(PACKAGE, KIEBASE, version);
        kfs.generateAndWritePomXML(rid);
        KieModuleModel kModuleModel = ks.newKieModuleModel();
        kModuleModel.newKieBaseModel(KIEBASE).addPackage(PACKAGE);
        kfs.writeKModuleXML(kModuleModel.toXML());
        kfs.write("src/main/resources/org/build/example/rules/rules.drl", rules);
        KieBuilder kb = ks.newKieBuilder(kfs);
        if (withExecModel) {
            kb.buildAll(ExecutableModelProject.class);
        } else {
            kb.buildAll();
        }
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        return kb.getKieModule();
    }

    private void buildKjarsInALoop(boolean withExecModel) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieContainer kieContainer = null;
        int oldSize = Integer.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            KieModule kModule = this.buildKieModule("1.0." + i, RULES, withExecModel);
            if (kieContainer == null) {
                kieContainer = ks.newKieContainer(kModule.getReleaseId());
            } else {
                kieContainer.updateToVersion(kModule.getReleaseId());
            }
            KieProject kp = ((KieContainerImpl)kieContainer).getKieProject();
            ProjectClassLoader cl = (ProjectClassLoader)kp.getClassLoader();
            System.out.println(String.format("ProjectClassLoader.store size: %d, retained bytes: %d.", cl.getStore().size(), cl.getStore().values().stream().map(b -> ((byte[])b).length).reduce(0, Integer::sum)));
            Assertions.assertThat((cl.getStore().size() <= oldSize ? 1 : 0) != 0).isTrue();
            oldSize = cl.getStore().size();
            kr.removeKieModule(kModule.getReleaseId());
        }
    }

    @Test
    public void loadKjarsInALoopWithExecModel() {
        this.buildKjarsInALoop(true);
    }

    @Test
    public void loadKjarsInALoopWithoutExecModel() {
        this.buildKjarsInALoop(false);
    }
}

