/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.event.DebugAgendaEventListener;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.rule.EntryPointId;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.DomainObject;
import org.drools.testcoverage.common.model.DomainObjectHolder;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Pet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.conf.PropertySpecificOption;

@RunWith(value=Parameterized.class)
public class FromTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private final String RULE_HEAD = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\n";
    private final String RULE_WITH_JOIN = "rule R1\nagenda-group \"group2\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $s : String(this == \"ABC\")\n    then\nend\n";
    private final String RULE_WITH_FROM = "rule R2\nsalience -70\nagenda-group \"group1\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $p2 : Person ( age < 2 ) from $p1\n    then\n       list.add( $p2.getName() );\nend\nrule R3\nagenda-group \"group1\"\nsalience -30\nno-loop true\n    when\n        $p : Person ( age == 1 )\n    then\n       modify($p){setAge(10)};\nend\n";

    public FromTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testFromSharing() {
        FromTest.testFromSharingCommon(this.kieBaseTestConfiguration, new HashMap<String, String>(), 2, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testFromSharingCommon(KieBaseTestConfiguration kieBaseTestConfiguration, Map<String, String> configurationProperties, int expectedNumberOfFromNode, int numberOfSinksInSecondFromNode) {
        String drl = FromTest.fromSharingRule();
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "from-test", "1");
        configurationProperties.put("drools.propertySpecific", PropertySpecificOption.ALLOWED.toString());
        KieModule kieModule = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATEFUL_REALTIME, configurationProperties, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ObjectTypeNode otn = FromTest.insertObjectFireRules((InternalKnowledgeBase)kbase, ksession);
            Assertions.assertThat((int)otn.getObjectSinkPropagator().size()).isEqualTo(1);
            LeftInputAdapterNode lian = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
            LeftTupleSink[] sinks = lian.getSinkPropagator().getSinks();
            Assertions.assertThat((int)sinks.length).isEqualTo(expectedNumberOfFromNode);
            Assertions.assertThat((int)sinks[0].getSinkPropagator().size()).isEqualTo(1);
            Assertions.assertThat((int)sinks[1].getSinkPropagator().size()).isEqualTo(numberOfSinksInSecondFromNode);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromSharingWithPropertyReactive() {
        String drl = FromTest.fromSharingRule();
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ObjectTypeNode otn = FromTest.insertObjectFireRules((InternalKnowledgeBase)kbase, ksession);
            Assertions.assertThat((int)otn.getObjectSinkPropagator().size()).isEqualTo(2);
            LeftInputAdapterNode lia0 = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
            LeftTupleSink[] sinks0 = lia0.getSinkPropagator().getSinks();
            Assertions.assertThat((int)sinks0.length).isEqualTo(1);
            Assertions.assertThat((int)sinks0[0].getSinkPropagator().size()).isEqualTo(1);
            LeftInputAdapterNode lia1 = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[1];
            LeftTupleSink[] sinks1 = lia1.getSinkPropagator().getSinks();
            Assertions.assertThat((int)sinks1.length).isEqualTo(1);
            Assertions.assertThat((int)sinks1[0].getSinkPropagator().size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    public static String fromSharingRule() {
        return "import " + ListsContainer.class.getCanonicalName() + "\nglobal java.util.List output1;\nglobal java.util.List output2;\nrule R1 when\n    ListsContainer( $list : list1 )\n    $s : String( length == 2 ) from $list\nthen\n    output1.add($s);\nend\nrule R2 when\n    ListsContainer( $list : list2 )\n    $s : String( length == 2 ) from $list\nthen\n    output2.add($s);\nend\nrule R3 when\n    ListsContainer( $list : list2 )\n    $s : String( length == 2 ) from $list\nthen\n    output2.add($s);\nend\n";
    }

    private static ObjectTypeNode insertObjectFireRules(InternalKnowledgeBase kbase, KieSession ksession) {
        ArrayList output1 = new ArrayList();
        ksession.setGlobal("output1", output1);
        ArrayList output2 = new ArrayList();
        ksession.setGlobal("output2", output2);
        ksession.insert((Object)new ListsContainer());
        ksession.fireAllRules();
        Assertions.assertThat((String)((String)output1.get(0))).isEqualTo("bb");
        Assertions.assertThat((String)((String)output2.get(0))).isEqualTo("22");
        Assertions.assertThat((String)((String)output2.get(1))).isEqualTo("22");
        EntryPointNode epn = (EntryPointNode)kbase.getRete().getEntryPointNodes().values().iterator().next();
        return (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(ListsContainer.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromSharingWithAccumulate() {
        String drl = "package org.drools.compiler.integrationtests.operators;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport " + Cheesery.class.getCanonicalName() + " ;\nimport " + Cheese.class.getCanonicalName() + " ;\n\nglobal java.util.List output1;\nglobal java.util.List output2;\n\nrule R1\n    when\n        $cheesery : Cheesery()\n        $list     : List( ) from accumulate( $cheese : Cheese( ) from $cheesery.getCheeses(),\n                                             init( List l = new ArrayList(); ),\n                                             action( l.add( $cheese ); )\n                                             result( l ) )\n    then\n        output1.add( $list );\nend\nrule R2\n    when\n        $cheesery : Cheesery()\n        $list     : List( ) from accumulate( $cheese : Cheese( ) from $cheesery.getCheeses(),\n                                             init( List l = new ArrayList(); ),\n                                             action( l.add( $cheese ); )\n                                             result( l ) )\n    then\n        output2.add( $list );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        EntryPointNode epn = ((InternalKnowledgeBase)kbase).getRete().getEntryPointNode(EntryPointId.DEFAULT);
        ObjectTypeNode otn = (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(Cheesery.class));
        Sink[] otnSinks = otn.getSinks();
        Assertions.assertThat((int)otnSinks.length).isEqualTo(1);
        LeftInputAdapterNode lia = (LeftInputAdapterNode)otnSinks[0];
        Sink[] liaSinks = lia.getSinks();
        Assertions.assertThat((long)Stream.of(liaSinks).filter(sink -> sink instanceof FromNode).count()).isEqualTo(1L);
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList output1 = new ArrayList();
            ksession.setGlobal("output1", output1);
            ArrayList output2 = new ArrayList();
            ksession.setGlobal("output2", output2);
            Cheesery cheesery = new Cheesery();
            cheesery.addCheese(new Cheese("stilton", 8));
            cheesery.addCheese(new Cheese("provolone", 8));
            FactHandle cheeseryHandle = ksession.insert((Object)cheesery);
            ksession.fireAllRules();
            Assertions.assertThat((int)output1.size()).isEqualTo(1);
            Assertions.assertThat((int)((List)output1.get(0)).size()).isEqualTo(2);
            Assertions.assertThat((int)output2.size()).isEqualTo(1);
            Assertions.assertThat((int)((List)output2.get(0)).size()).isEqualTo(2);
            output1.clear();
            output2.clear();
            ksession.update(cheeseryHandle, (Object)cheesery);
            ksession.fireAllRules();
            Assertions.assertThat((int)output1.size()).isEqualTo(1);
            Assertions.assertThat((int)((List)output1.get(0)).size()).isEqualTo(2);
            Assertions.assertThat((int)output2.size()).isEqualTo(1);
            Assertions.assertThat((int)((List)output2.get(0)).size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithSingleValue() {
        String drl = "import " + ListsContainer.class.getCanonicalName() + "\nglobal java.util.List out;\nrule R1 when\n    $list : ListsContainer( )\n    $s : Integer() from $list.singleValue\nthen\n    out.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList out = new ArrayList();
            ksession.setGlobal("out", out);
            ksession.insert((Object)new ListsContainer());
            ksession.fireAllRules();
            Assertions.assertThat((int)out.size()).isEqualTo(1);
            Assertions.assertThat((int)((Integer)out.get(0))).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testFromWithSingleValueAndIncompatibleType() {
        String drl = "import " + ListsContainer.class.getCanonicalName() + "\nglobal java.util.List out;\nrule R1 when\n    $list : ListsContainer( )\n    $s : String() from $list.singleValue\nthen\n    out.add($s);\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithInterfaceAndAbstractClass() {
        String drl = "import " + Container2.class.getCanonicalName() + "\nimport " + Comparable.class.getCanonicalName() + "\nglobal java.util.List out;\nrule R1 when\n    $c2 : Container2( )\n    $s : Comparable() from $c2.singleValue\nthen\n    out.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList out = new ArrayList();
            ksession.setGlobal("out", out);
            ksession.insert((Object)new Container2(1));
            ksession.fireAllRules();
            Assertions.assertThat((int)out.size()).isEqualTo(1);
            Assertions.assertThat((int)((Integer)out.get(0))).isEqualTo(1);
            out.clear();
            ksession.insert((Object)new Container2(new AtomicInteger(1)));
            ksession.fireAllRules();
            Assertions.assertThat((int)out.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithInterfaceAndConcreteClass() {
        String drl = "import " + Container2b.class.getCanonicalName() + "\nimport " + CustomIntegerMarker.class.getCanonicalName() + "\nglobal java.util.List out;\nrule R1 when\n    $c2 : Container2b( )\n    $s : CustomIntegerMarker() from $c2.singleValue\nthen\n    out.add($s);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList out = new ArrayList();
            ksession.setGlobal("out", out);
            ksession.insert((Object)new Container2b(new CustomInteger(1)));
            ksession.fireAllRules();
            Assertions.assertThat((int)out.size()).isEqualTo(1);
            Assertions.assertThat((int)((AtomicInteger)out.get(0)).get()).isEqualTo(1);
            out.clear();
            ksession.insert((Object)new Container2b(new AtomicInteger(1)));
            ksession.fireAllRules();
            Assertions.assertThat((int)out.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testFromWithInterfaceAndFinalClass() {
        String drl = "import " + Container3.class.getCanonicalName() + "\nimport " + CustomIntegerMarker.class.getCanonicalName() + "\nglobal java.util.List out;\nrule R1 when\n    $c3 : Container3( )\n    $s : CustomIntegerMarker() from $c3.singleValue\nthen\n    out.add($s);\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFrom() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Cheesery.class.getCanonicalName() + ";\nimport java.util.List;\n\nglobal List list1;\nglobal List list2;\nglobal List list3;\nglobal Cheesery cheesery;\n\nrule \"test from using a global\"\n    when\n        $cheese : Cheese() from cheesery.getCheeses()\n    then\n        list1.add( $cheese );\nend\n\n\nrule \"test from using a declaration\"\n    when\n        $ch : Cheesery()\n        $cheese : Cheese() from $ch.getCheeses()\n    then\n        list2.add( $cheese );\nend\n\n\nrule \"test from with filter\"\n    when\n        $cheese : Cheese(type == \"stilton\" ) from cheesery.getCheeses()\n    then\n        list3.add( $cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list1 = new ArrayList();
            ksession.setGlobal("list1", list1);
            ArrayList list2 = new ArrayList();
            ksession.setGlobal("list2", list2);
            ArrayList list3 = new ArrayList();
            ksession.setGlobal("list3", list3);
            Cheesery cheesery = new Cheesery();
            Cheese stilton = new Cheese("stilton", 12);
            Cheese cheddar = new Cheese("cheddar", 15);
            cheesery.addCheese(stilton);
            cheesery.addCheese(cheddar);
            ksession.setGlobal("cheesery", (Object)cheesery);
            ksession.insert((Object)cheesery);
            Person p = new Person("stilton");
            ksession.insert((Object)p);
            ksession.fireAllRules();
            ksession.fireAllRules();
            Assertions.assertThat((int)((List)ksession.getGlobal("list1")).size()).isEqualTo(2);
            Assertions.assertThat(((List)ksession.getGlobal("list1")).get(0)).isEqualTo((Object)cheddar);
            Assertions.assertThat(((List)ksession.getGlobal("list1")).get(1)).isEqualTo((Object)stilton);
            Assertions.assertThat((int)((List)ksession.getGlobal("list2")).size()).isEqualTo(2);
            Assertions.assertThat(((List)ksession.getGlobal("list2")).get(0)).isEqualTo((Object)cheddar);
            Assertions.assertThat(((List)ksession.getGlobal("list2")).get(1)).isEqualTo((Object)stilton);
            Assertions.assertThat((int)((List)ksession.getGlobal("list3")).size()).isEqualTo(1);
            Assertions.assertThat(((List)ksession.getGlobal("list3")).get(0)).isEqualTo((Object)stilton);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testFromWithParams() {
        String drl = "package org.drools.compiler.integrationtests.operators;\n \nimport " + ToListFunction.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n\nglobal ToListFunction testObject;\nglobal java.util.List list;\nglobal java.lang.Object globalObject;\n\nrule \"test from\"\n    when\n        $person : Person()\n        $object : Object() from testObject.toList(globalObject, $person, \"literal\", 42, [ $person : globalObject, \"key1\" : [ \"key2\" : \"value2\"]], [$person, 42, [\"x\", \"y\"]])\n    then\n        list.add( $object );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            Object globalObject = new Object();
            ksession.setGlobal("list", list);
            ksession.setGlobal("testObject", (Object)new ToListFunction());
            ksession.setGlobal("globalObject", globalObject);
            Person bob = new Person("bob");
            ksession.insert((Object)bob);
            ksession.fireAllRules();
            Assertions.assertThat((int)((List)ksession.getGlobal("list")).size()).isEqualTo(6);
            List array = (List)((List)ksession.getGlobal("list")).get(0);
            Assertions.assertThat((int)array.size()).isEqualTo(3);
            Person p = (Person)array.get(0);
            Assertions.assertThat((Object)bob).isEqualTo((Object)p);
            Assertions.assertThat(array.get(1)).isEqualTo((Object)42);
            List nested = (List)array.get(2);
            Assertions.assertThat(nested.get(0)).isEqualTo((Object)"x");
            Assertions.assertThat(nested.get(1)).isEqualTo((Object)"y");
            Map map = (Map)((List)ksession.getGlobal("list")).get(1);
            Assertions.assertThat((int)map.keySet().size()).isEqualTo(2);
            Assertions.assertThat((boolean)map.keySet().contains(bob)).isTrue();
            Assertions.assertThat(map.get(bob)).isEqualTo(globalObject);
            Assertions.assertThat((boolean)map.keySet().contains("key1")).isTrue();
            Map nestedMap = (Map)map.get("key1");
            Assertions.assertThat((int)nestedMap.keySet().size()).isEqualTo(1);
            Assertions.assertThat((boolean)nestedMap.keySet().contains("key2")).isTrue();
            Assertions.assertThat(nestedMap.get("key2")).isEqualTo((Object)"value2");
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(2)).isEqualTo((Object)42);
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(3)).isEqualTo((Object)"literal");
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(4)).isEqualTo((Object)bob);
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(5)).isEqualTo(globalObject);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testFromWithNewConstructor() {
        String drl = "package org.drools.compiler.integrationtests.operators\n\nimport " + Query.class.getCanonicalName() + ";\nimport " + Storage.class.getCanonicalName() + ";\nimport " + Results.class.getCanonicalName() + ";\n\nrule \"Verify_1\"\n    when\n        content : Storage()\n        results : Results( ) from content.search(new Query(\"test\",\"field\"))\n    then\n        System.out.println( results );\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBaseConfiguration kieBaseConfiguration = this.kieBaseTestConfiguration.getKieBaseConfiguration();
        kieBaseConfiguration.setProperty("drools.lang.level", "DRL5");
        kieContainer.newKieBase(kieBaseConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromDeclarationWithWorkingMemoryLogger() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheesery.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list\nrule \"Test Rule\"\nwhen\n    $cheesery : Cheesery()\n    Cheese( $type : type) from $cheesery.cheeses\nthen\n    list.add( $type );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheesery cheesery = new Cheesery();
            cheesery.addCheese(new Cheese("stilton", 22));
            session.insert((Object)cheesery);
            session.fireAllRules();
            Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)"stilton");
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromArrayIteration() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + DomainObject.class.getCanonicalName() + ";\nimport " + DomainObjectHolder.class.getCanonicalName() + ";\nglobal java.util.List list\n\nrule \"Test Rule\"\nwhen\n    $holder : DomainObjectHolder()\n    $object : DomainObject( $message : message) from $holder.objects;\nthen\n    list.add( $message );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            session.insert((Object)new DomainObjectHolder());
            session.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"Message3");
            Assertions.assertThat(list.get(1)).isEqualTo((Object)"Message2");
            Assertions.assertThat(list.get(2)).isEqualTo((Object)"Message1");
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromExprFollowedByNot() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Pet.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule \"Rule 1\"\n    when\n        p : Person ($var: pet )\n        Pet () from $var\n        not Pet ()\n    then\n       list.add( p );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p = new Person();
            p.setPet(new Pet(Pet.PetType.PARROT));
            ksession.insert((Object)p);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isSameAs((Object)p);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromNestedAccessors() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Order.class.getCanonicalName() + ";\nimport " + OrderItem.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule \"test from nested accessors\"\nwhen\n    $oi : OrderItem( seq == 1 )\n    $os : Order.OrderStatus() from $oi.order.status\nthen\n    results.add( $os );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Order order1 = new Order(11, "Bob");
            OrderItem item11 = new OrderItem(order1, 1);
            OrderItem item12 = new OrderItem(order1, 2);
            order1.addItem(item11);
            order1.addItem(item12);
            ksession.insert((Object)order1);
            ksession.insert((Object)item11);
            ksession.insert((Object)item12);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isSameAs((Object)order1.getStatus());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromNodeWithMultipleBetas() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Address.class.getCanonicalName() + ";\nrule R1 when\n   $p : Person( $name : name, $addresses : addresses )\n   $c : Cheese( $type: type == $name )\n   $a : Address( street == $type, city == $name ) from $addresses\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("x");
            p.addAddress(new Address("x", 1, "x"));
            p.addAddress(new Address("y", 2, "y"));
            ksession.insert((Object)p);
            ksession.insert((Object)new Cheese("x"));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testFromWithStrictModeOn() {
        String drl = "import java.util.Map;\ndialect \"mvel\"\nrule \"LowerCaseFrom\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\n   $lowerValue : String() from $valOne.toLowerCase()\nthen\n   System.out.println( $valOne.toLowerCase() );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"import java.util.Map;\ndialect \"mvel\"\nrule \"LowerCaseFrom\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\n   $lowerValue : String() from $valOne.toLowerCase()\nthen\n   System.out.println( $valOne.toLowerCase() );\nend\n"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    @Test
    public void testJavaImplicitWithFrom() {
        this.testDialectWithFrom("java");
    }

    @Test
    public void testMVELImplicitWithFrom() {
        this.testDialectWithFrom("mvel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDialectWithFrom(String dialect) {
        String drl = "package org.drools.compiler.test \nimport java.util.List \nglobal java.util.List list \nglobal java.util.List list2 \nrule \"show\" dialect \"" + dialect + "\" \nwhen  \n    $m : List( eval( size == 0 ) ) from [list] \nthen \n    list2.add('r1'); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.setGlobal("list2", list);
            ksession.fireAllRules();
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"r1");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleFroms() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport java.util.List;\nimport " + Cheesery.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal Cheesery cheesery;\nglobal java.util.List results;\n\nrule MyRule\n    dialect \"java\"\nwhen\n    $i : List() from collect(Cheese() from cheesery.getCheeses())\n    $k : List() from collect(Cheese() from cheesery.getCheeses())\nthen\n    results.add( $i );\n    results.add( $k );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheesery cheesery = new Cheesery();
            cheesery.addCheese(new Cheese("stilton", 15));
            cheesery.addCheese(new Cheese("brie", 10));
            ksession.setGlobal("cheesery", (Object)cheesery);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((int)((List)results.get(0)).size()).isEqualTo(2);
            Assertions.assertThat((int)((List)results.get(1)).size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNetworkBuildErrorAcrossEntryPointsAndFroms() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list\nrule rule1\nwhen\n         Cheese() from entry-point \"testep\"\n    $p : Person() from list\nthen \n  list.add( \"rule1\" ) ;\n  insert( $p );\nend\nrule rule2\nwhen\n  $p : Person() \nthen \n  list.add( \"rule2\" ) ;\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            EntryPoint ep = ksession.getEntryPoint("testep");
            ArrayList<Person> list = new ArrayList<Person>();
            ksession.setGlobal("list", list);
            list.add(new Person("darth"));
            ep.insert((Object)new Cheese("cheddar"));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testUpdateFromCollect() {
        String drl = "import " + List.class.getCanonicalName() + ";\nimport " + ClassWithValues.class.getCanonicalName() + ";\nrule R when\n      $cwvs: List(size > 0) from collect (ClassWithValues(values.size == 0))\n      $values: List(size > 0) from collect (String())\n    then\n      \n      for (ClassWithValues cwv: (List<ClassWithValues>)$cwvs) {\n        cwv.add(\"not in memory\");\n        ((List<String>)$values).forEach(cwv::add);\n        update(cwv);\n      }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new ClassWithValues());
        ksession.insert((Object)"test");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testJoinAndFrom() {
        this.runKSessionWithAgendaGroup(this.RULE_HEAD + "rule R1\nagenda-group \"group2\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $s : String(this == \"ABC\")\n    then\nend\nrule R2\nsalience -70\nagenda-group \"group1\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $p2 : Person ( age < 2 ) from $p1\n    then\n       list.add( $p2.getName() );\nend\nrule R3\nagenda-group \"group1\"\nsalience -30\nno-loop true\n    when\n        $p : Person ( age == 1 )\n    then\n       modify($p){setAge(10)};\nend\n");
    }

    @Test
    public void testFromAndJoin() {
        this.runKSessionWithAgendaGroup(this.RULE_HEAD + "rule R2\nsalience -70\nagenda-group \"group1\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $p2 : Person ( age < 2 ) from $p1\n    then\n       list.add( $p2.getName() );\nend\nrule R3\nagenda-group \"group1\"\nsalience -30\nno-loop true\n    when\n        $p : Person ( age == 1 )\n    then\n       modify($p){setAge(10)};\nend\nrule R1\nagenda-group \"group2\"\nno-loop true\n    when\n        $p1 : Person ( )\n        $s : String(this == \"ABC\")\n    then\nend\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runKSessionWithAgendaGroup(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"from-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p = new Person("John", 1);
            ksession.insert((Object)p);
            ksession.fireAllRules();
            ksession.getAgenda().getAgendaGroup("group1").setFocus();
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    public static class ClassWithValues {
        private List<String> values = new ArrayList<String>();

        public void add(String value) {
            this.values.add(value);
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    public static class Query {
        public Query(String pattern, String column) {
        }
    }

    public static class Storage {
        public Results search(Query query) {
            return new Results();
        }
    }

    public static class Results {
        public int getResultsCount() {
            return 1;
        }
    }

    public static class ToListFunction {
        public List toList(Object object1, Object object2, String object3, int integer, Map map, List inputList) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(object1);
            list.add(object2);
            list.add(object3);
            list.add(integer);
            list.add(map);
            list.add(inputList);
            return list;
        }
    }

    public static class Container3 {
        private final Integer wrapped;

        public Container3(Integer wrapped) {
            this.wrapped = wrapped;
        }

        public Integer getSingleValue() {
            return this.wrapped;
        }
    }

    public static class CustomInteger
    extends AtomicInteger
    implements CustomIntegerMarker {
        public CustomInteger(int initialValue) {
            super(initialValue);
        }
    }

    public static interface CustomIntegerMarker {
    }

    public static class Container2b {
        private final AtomicInteger wrapped;

        public Container2b(AtomicInteger wrapped) {
            this.wrapped = wrapped;
        }

        public AtomicInteger getSingleValue() {
            return this.wrapped;
        }
    }

    public static class Container2 {
        private final Number wrapped;

        public Container2(Number wrapped) {
            this.wrapped = wrapped;
        }

        public Number getSingleValue() {
            return this.wrapped;
        }
    }

    public static class ListsContainer {
        public List<String> getList1() {
            return Arrays.asList("a", "bb", "ccc");
        }

        public List<String> getList2() {
            return Arrays.asList("1", "22", "333");
        }

        public Number getSingleValue() {
            return 1;
        }
    }
}

