/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.rule.builder.XpathAnalysis;
import org.junit.Test;

public class XpathAnalysisTest {
    @Test
    public void testEmptyInput() {
        String xpath = "";
        XpathAnalysis result = XpathAnalysis.analyze((String)"");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath has to start with '/'.", new Object[0])).isEqualTo(true);
        Assertions.assertThat((String)result.getError()).isNotNull();
        Assertions.assertThat((boolean)result.iterator().hasNext()).isEqualTo(false);
    }

    @Test
    public void testNotAnXPath() {
        String xpath = "someAttribute";
        XpathAnalysis result = XpathAnalysis.analyze((String)"someAttribute");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath has to start with '/'.", new Object[0])).isEqualTo(true);
        Assertions.assertThat((String)result.getError()).isNotNull();
        Assertions.assertThat((boolean)result.iterator().hasNext()).isEqualTo(false);
    }

    @Test
    public void testEmptyXPath() {
        String xpath = "/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The empty XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testEmptyNonReactiveXPath() {
        String xpath = "?/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"?/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The empty XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, true, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testAttribute() {
        String xpath = "/address";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testAttributeIterate() {
        String xpath = "/address/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testAttributeDereferenceDot() {
        String xpath = "/address.";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", false, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testAttributeDereferenceMixed() {
        String xpath = "/address.street/name";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street/name");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testAttributeDereferenceMixedIterate() {
        String xpath = "/address.street/name/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street/name/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testRelativePathInCondition() {
        String xpath = "/address.street[../city == \"The City\"]/name/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.street[../city == \"The City\"]/name/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", false, false, new ArrayList<String>(Arrays.asList("../city == \"The City\"")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("name", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testUnicode() {
        String xpath = "/address.uli\u010dka[name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9']/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address.uli\u010dka[name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9']/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("uli\u010dka", false, false, new ArrayList<String>(Arrays.asList("name == '\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed\u00e9'")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testIndex() {
        String xpath = "/address[0]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address[0]");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, 0, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testIndexIterate() {
        String xpath = "/address[0]/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address[0]/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, 0, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testCondition() {
        String xpath = "/address/street[name == \"Elm\"]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\"]");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"")), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testThreeConditions() {
        String xpath = "/address/street[name == \"Elm\", length <= 10, code == \"Something, \\\"and\\\" other thing\"]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\", length <= 10, code == \"Something, \\\"and\\\" other thing\"]");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"", "length <= 10", "code == \"Something, \\\"and\\\" other thing\"")), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testConditionIterate() {
        String xpath = "/address/street[name == \"Elm\"]/";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street[name == \"Elm\"]/");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name == \"Elm\"")), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("", true, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testBasicCast() {
        String xpath = "/address/street#MyStreetType[name.value == \"Elm\"].city";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street#MyStreetType[name.value == \"Elm\"].city");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name.value == \"Elm\"")), "MyStreetType", -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("city", false, false, new ArrayList(), null, -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    public void testComplexCast() {
        String xpath = "/address/street#MyStreetType[name.value == \"Elm\"].city#MyCityMoreSpecificType[ value ]";
        XpathAnalysis result = XpathAnalysis.analyze((String)"/address/street#MyStreetType[name.value == \"Elm\"].city#MyCityMoreSpecificType[ value ]");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.hasError()).as("The XPath should be valid.", new Object[0])).isEqualTo(false);
        Assertions.assertThat((String)result.getError()).isNull();
        Iterator<XpathAnalysis.XpathPart> iterator = this.getNonEmptyIterator(result);
        this.verifyXpathPart(new XpathAnalysis.XpathPart("address", true, false, new ArrayList(), null, -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("street", true, false, new ArrayList<String>(Arrays.asList("name.value == \"Elm\"")), "MyStreetType", -1, 0), iterator.next());
        this.verifyXpathPart(new XpathAnalysis.XpathPart("city", false, false, new ArrayList<String>(Arrays.asList("value")), "MyCityMoreSpecificType", -1, 0), iterator.next());
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    private Iterator<XpathAnalysis.XpathPart> getNonEmptyIterator(XpathAnalysis analysis) {
        Iterator iterator = analysis.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(true);
        return iterator;
    }

    private void verifyXpathPart(XpathAnalysis.XpathPart expected, XpathAnalysis.XpathPart actual) {
        if (expected == null) {
            Assertions.assertThat((Object)actual).isNull();
        } else {
            Assertions.assertThat((Object)actual).isNotNull();
        }
        Assertions.assertThat((String)actual.getField()).isEqualTo(expected.getField());
        Assertions.assertThat((boolean)actual.isIterate()).isEqualTo(expected.isIterate());
        Assertions.assertThat((boolean)actual.isLazy()).isEqualTo(expected.isLazy());
        Assertions.assertThat((String)actual.getInlineCast()).isEqualTo(expected.getInlineCast());
        Assertions.assertThat((int)actual.getIndex()).isEqualTo(expected.getIndex());
        Assertions.assertThat((Object[])actual.getConstraints().toArray()).isEqualTo((Object)expected.getConstraints().toArray());
    }
}

