/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.extractors;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ConcreteChild;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.InterfaceChild;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestAbstractImpl;
import org.drools.core.util.asm.TestBean;
import org.drools.core.util.asm.TestInterface;
import org.drools.core.util.asm.TestInterfaceImpl;
import org.drools.mvel.accessors.ClassFieldAccessor;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.accessors.ClassFieldReader;
import org.junit.Before;
import org.junit.Test;

public class ClassFieldAccessorTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testBasic() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        ClassFieldReader ext = this.store.getReader(TestBean.class, "blah");
        Assertions.assertThat((boolean)((Boolean)ext.getValue(null, (Object)obj))).isEqualTo(false);
        ClassFieldReader ext2 = this.store.getReader(TestBean.class, "fooBar");
        Assertions.assertThat((Object)ext2.getValue(null, (Object)obj)).isEqualTo((Object)"fooBar");
        ClassFieldReader ext3 = this.store.getReader(TestBean.class, "objArray");
        Assertions.assertThat((Object)ext3.getValue(null, (Object)obj)).isEqualTo((Object)objArray);
    }

    @Test
    public void testInterface() throws Exception {
        TestInterfaceImpl obj = new TestInterfaceImpl();
        ClassFieldReader ext = this.store.getReader(TestInterface.class, "something");
        Assertions.assertThat((String)((String)ext.getValue(null, (Object)obj))).isEqualTo("foo");
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestAbstract.class, "something");
        TestAbstractImpl obj = new TestAbstractImpl();
        Assertions.assertThat((String)((String)ext.getValue(null, (Object)obj))).isEqualTo("foo");
    }

    @Test
    public void testInherited() throws Exception {
        ClassFieldReader ext = this.store.getReader(BeanInherit.class, "text");
        BeanInherit obj = new BeanInherit();
        Assertions.assertThat((String)((String)ext.getValue(null, (Object)obj))).isEqualTo("hola");
    }

    @Test
    public void testMultipleInterfaces() throws Exception {
        ConcreteChild obj = new ConcreteChild();
        ClassFieldReader ext = this.store.getReader(InterfaceChild.class, "foo");
        Assertions.assertThat((int)((Number)ext.getValue(null, (Object)obj)).intValue()).isEqualTo(42);
    }

    @Test
    public void testLong() throws Exception {
        ClassFieldReader ext = this.store.getReader(TestBean.class, "longField");
        TestBean bean = new TestBean();
        Assertions.assertThat((long)((Number)ext.getValue(null, (Object)bean)).longValue()).isEqualTo(424242L);
    }

    @Test
    public void testNonExistentField() throws Exception {
        Object[] objArray = new Object[1];
        TestBean obj = new TestBean();
        obj.setBlah(false);
        obj.setSomething("no");
        obj.setObjArray(objArray);
        ClassFieldReader ext = this.store.getReader(TestBean.class, "xyz");
        Assertions.assertThat((Object)ext).isNull();
    }

    @Test
    public void testBuildFieldAccessor() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr");
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr");
            String testString1 = "TestAttr1";
            String testString2 = "TestAttr2";
            TestClass instance = new TestClass();
            instance.setIntAttr(10);
            instance.setStrAttr(testString1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)intAccessor.getValue((Object)instance))).as("Error reading int attr", new Object[0])).isEqualTo(10);
            ((ObjectAssert)Assertions.assertThat((Object)strAccessor.getValue((Object)instance)).as("Error reading String attr", new Object[0])).isEqualTo((Object)testString1);
            intAccessor.setValue((Object)instance, (Object)new Integer(50));
            strAccessor.setValue((Object)instance, (Object)testString2);
            ((AbstractIntegerAssert)Assertions.assertThat((int)instance.getIntAttr()).as("Error setting int attr", new Object[0])).isEqualTo(50);
            ((AbstractStringAssert)Assertions.assertThat((String)instance.getStrAttr()).as("Error setting String attr", new Object[0])).isEqualTo(testString2);
            ((ObjectAssert)Assertions.assertThat((Object)strAccessor.getValue((Object)instance)).as("Error reading String attr", new Object[0])).isEqualTo((Object)testString2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    @Test
    public void testNullOnPrimitives() {
        try {
            ClassFieldAccessor intAccessor = this.store.getAccessor(TestClass.class, "intAttr");
            ClassFieldAccessor strAccessor = this.store.getAccessor(TestClass.class, "strAttr");
            ClassFieldAccessor byteAccessor = this.store.getAccessor(TestClass.class, "byteAttr");
            ClassFieldAccessor booleanAccessor = this.store.getAccessor(TestClass.class, "booleanAttr");
            ClassFieldAccessor charAccessor = this.store.getAccessor(TestClass.class, "charAttr");
            ClassFieldAccessor doubleAccessor = this.store.getAccessor(TestClass.class, "doubleAttr");
            ClassFieldAccessor floatAccessor = this.store.getAccessor(TestClass.class, "floatAttr");
            ClassFieldAccessor longAccessor = this.store.getAccessor(TestClass.class, "longAttr");
            ClassFieldAccessor shortAccessor = this.store.getAccessor(TestClass.class, "shortAttr");
            String testString1 = "TestAttr1";
            TestClass instance = new TestClass();
            instance.setIntAttr(25);
            instance.setStrAttr(testString1);
            instance.setByteAttr((byte)10);
            instance.setBooleanAttr(true);
            instance.setCharAttr('x');
            instance.setDoubleAttr(10.5);
            instance.setFloatAttr(40.3f);
            instance.setLongAttr(43L);
            instance.setShortAttr((short)20);
            intAccessor.setValue((Object)instance, null);
            strAccessor.setValue((Object)instance, null);
            byteAccessor.setValue((Object)instance, null);
            booleanAccessor.setValue((Object)instance, null);
            charAccessor.setValue((Object)instance, null);
            doubleAccessor.setValue((Object)instance, null);
            floatAccessor.setValue((Object)instance, null);
            longAccessor.setValue((Object)instance, null);
            shortAccessor.setValue((Object)instance, null);
            ((AbstractIntegerAssert)Assertions.assertThat((int)instance.getIntAttr()).as("Error setting attr", new Object[0])).isEqualTo(0);
            ((AbstractStringAssert)Assertions.assertThat((String)instance.getStrAttr()).as("Error setting attr", new Object[0])).isNull();
            ((AbstractByteAssert)Assertions.assertThat((byte)instance.getByteAttr()).as("Error setting attr", new Object[0])).isEqualTo((byte)0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)instance.isBooleanAttr()).as("Error setting attr", new Object[0])).isEqualTo(false);
            ((AbstractCharacterAssert)Assertions.assertThat((char)instance.getCharAttr()).as("Error setting attr", new Object[0])).isEqualTo('\u0000');
            ((AbstractDoubleAssert)Assertions.assertThat((double)instance.getDoubleAttr()).as("Error setting attr", new Object[0])).isCloseTo(0.0, Assertions.within((Double)0.1));
            ((AbstractFloatAssert)Assertions.assertThat((float)instance.getFloatAttr()).as("Error setting attr", new Object[0])).isCloseTo(0.0f, Assertions.within((Float)Float.valueOf(0.1f)));
            ((AbstractLongAssert)Assertions.assertThat((long)instance.getLongAttr()).as("Error setting attr", new Object[0])).isEqualTo(0L);
            ((AbstractShortAssert)Assertions.assertThat((short)instance.getShortAttr()).as("Error setting attr", new Object[0])).isEqualTo((short)0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)intAccessor.getValue((Object)instance))).as("Error reading int attr", new Object[0])).isEqualTo(0);
            ((ObjectAssert)Assertions.assertThat((Object)strAccessor.getValue((Object)instance)).as("Error reading String attr", new Object[0])).isNull();
            ((AbstractByteAssert)Assertions.assertThat((byte)((Byte)byteAccessor.getValue((Object)instance))).as("Error reading attr", new Object[0])).isEqualTo((byte)0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Boolean)booleanAccessor.getValue((Object)instance))).as("Error reading attr", new Object[0])).isEqualTo(false);
            ((AbstractCharacterAssert)Assertions.assertThat((char)((Character)charAccessor.getValue((Object)instance)).charValue()).as("Error reading attr", new Object[0])).isEqualTo('\u0000');
            ((AbstractDoubleAssert)Assertions.assertThat((double)((Double)doubleAccessor.getValue((Object)instance))).as("Error reading attr", new Object[0])).isCloseTo(0.0, Assertions.within((Double)0.1));
            ((AbstractFloatAssert)Assertions.assertThat((float)((Float)floatAccessor.getValue((Object)instance)).floatValue()).as("Error reading attr", new Object[0])).isCloseTo(0.0f, Assertions.within((Float)Float.valueOf(0.1f)));
            ((AbstractLongAssert)Assertions.assertThat((long)((Long)longAccessor.getValue((Object)instance))).as("Error reading attr", new Object[0])).isEqualTo(0L);
            ((AbstractShortAssert)Assertions.assertThat((short)((Short)shortAccessor.getValue((Object)instance))).as("Error reading attr", new Object[0])).isEqualTo((short)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("No exception is supposed to be generated when creating field accessor: " + e));
        }
    }

    public static class TestClass {
        private int intAttr;
        private String strAttr;
        private byte byteAttr;
        private boolean booleanAttr;
        private char charAttr;
        private double doubleAttr;
        private float floatAttr;
        private long longAttr;
        private short shortAttr;

        public int getIntAttr() {
            return this.intAttr;
        }

        public void setIntAttr(int intAttr) {
            this.intAttr = intAttr;
        }

        public String getStrAttr() {
            return this.strAttr;
        }

        public void setStrAttr(String strAttr) {
            this.strAttr = strAttr;
        }

        public boolean isBooleanAttr() {
            return this.booleanAttr;
        }

        public void setBooleanAttr(boolean booleanAttr) {
            this.booleanAttr = booleanAttr;
        }

        public byte getByteAttr() {
            return this.byteAttr;
        }

        public void setByteAttr(byte byteAttr) {
            this.byteAttr = byteAttr;
        }

        public char getCharAttr() {
            return this.charAttr;
        }

        public void setCharAttr(char charAttr) {
            this.charAttr = charAttr;
        }

        public double getDoubleAttr() {
            return this.doubleAttr;
        }

        public void setDoubleAttr(double doubleAttr) {
            this.doubleAttr = doubleAttr;
        }

        public float getFloatAttr() {
            return this.floatAttr;
        }

        public void setFloatAttr(float floatAttr) {
            this.floatAttr = floatAttr;
        }

        public long getLongAttr() {
            return this.longAttr;
        }

        public void setLongAttr(long longAttr) {
            this.longAttr = longAttr;
        }

        public short getShortAttr() {
            return this.shortAttr;
        }

        public void setShortAttr(short shortAttr) {
            this.shortAttr = shortAttr;
        }
    }
}

