/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class EnableAuditLogCommandTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private String auditFileDir = "target";
    private String auditFileName = "EnableAuditLogCommandTest";

    public EnableAuditLogCommandTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @After
    public void cleanUp() {
        File file = new File(this.auditFileDir + File.separator + this.auditFileName + ".log");
        if (file.exists()) {
            file.delete();
        }
    }

    @Test
    public void testEnableAuditLogCommand() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.mvel.integrationtests \n";
        str = (String)str + "import " + Cheese.class.getCanonicalName() + " \n";
        str = (String)str + "rule StringRule \n";
        str = (String)str + " when \n";
        str = (String)str + " $c : Cheese() \n";
        str = (String)str + " then \n";
        str = (String)str + " System.out.println($c); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession kSession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newEnableAuditLog((String)this.auditFileDir, (String)this.auditFileName));
        commands.add(CommandFactory.newInsert((Object)new Cheese()));
        commands.add(CommandFactory.newFireAllRules());
        kSession.execute((Command)CommandFactory.newBatchExecution(commands));
        kSession.dispose();
        File file = new File(this.auditFileDir + File.separator + this.auditFileName + ".log");
        Assertions.assertThat((boolean)file.exists()).isTrue();
    }
}

