/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.expr.MVELDebugHandler;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.mvel2.MVELRuntime;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;

@RunWith(value=Parameterized.class)
public class HelloWorldTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public HelloWorldTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testHelloWorld() throws Exception {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorld");
        ksession.getAgendaEventListeners().size();
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
    }

    @Test
    public void testHelloWorldDebug() throws Exception {
        final HashSet knownVariables = new HashSet();
        MVELRuntime.resetDebugger();
        MVELDebugHandler.setDebugMode((boolean)true);
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("onBreak");
                for (String var : frame.getFactory().getKnownVariables()) {
                    knownVariables.add(var);
                }
                return 0;
            }
        });
        String source = "org.drools.integrationtests.Rule_Hello_World";
        MVELRuntime.registerBreakpoint((String)source, (int)1);
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorldDebug");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
        Assertions.assertThat((int)knownVariables.size()).isEqualTo(6);
        Assertions.assertThat((boolean)knownVariables.contains("drools")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("myMessage")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("rule")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("kcontext")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("this")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("m")).isTrue();
        Assertions.assertThat((boolean)knownVariables.contains("myMessage")).isTrue();
    }

    private KieBase readKnowledgeBase() throws Exception {
        return KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"Sample.drl"});
    }
}

