/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NullSafeDereferencingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NullSafeDereferencingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testNullSafeBinding() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( $streetName : address!.street ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        ksession.dispose();
    }

    @Test
    public void testNullSafeNullComparison() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( address!.street == null ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testNullSafeNullComparison2() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n $street : String()\n Person( address!.street == $street ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        ksession.insert((Object)"Main Street");
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testNullSafeWithMethod() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n $street : String()\n Person( getAddress()!.street == $street ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        ksession.insert((Object)"Main Street");
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testNullSafeNullComparisonReverse() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( \"Main Street\".equalsIgnoreCase(address!.street) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testNullSafeNullComparisonReverseComplex() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( \"Main\".equalsIgnoreCase(address!.street!.substring(0, address!.street!.indexOf(' '))) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testDoubleNullSafe() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( address!.street!.length > 15 ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Person alex = new Person("Alex", 34);
        alex.setAddress(new Address("The Main Very Big Street"));
        ksession.insert((Object)alex);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testMixedNullSafes() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n $p : Person(  address!.street!.length > 0 && ( address!.street!.length < 15 || > 20 && < 30 )  && address!.zipCode!.length > 0 && address.zipCode == \"12345\"  ) \nthen\n System.out.println( $p ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street", null, "12345"));
        ksession.insert((Object)mark);
        Person edson = new Person("Edson", 34);
        edson.setAddress(new Address(null));
        ksession.insert((Object)edson);
        Person alex = new Person("Alex", 34);
        alex.setAddress(new Address("The Main Verrry Long Street"));
        ksession.insert((Object)alex);
        Person frank = new Person("Frank", 24);
        frank.setAddress(new Address("Long Street number 21", null, "12345"));
        ksession.insert((Object)frank);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        ksession.dispose();
    }

    @Test
    public void testNullSafeMemberOf() {
        String str = "declare A\n    list : java.util.List\nend\n\nrule Init when\nthen\n    insert( new A( java.util.Arrays.asList( \"test\" ) ) );    insert( \"test\" );end\nrule R when\n    $a : A()\n    $s : String( this memberOf $a!.list )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        ksession.dispose();
    }

    @Test
    public void testNullSafeInnerConstraint() {
        String str = "declare Content\n complexContent : Content\n extension : Content\nend\n\ndeclare Context\n ctx : Content\nend\n\nrule \"Complex Type Attribute\"\nwhen\n $con : Content()\n Context( ctx == $con || == $con!.complexContent!.extension )\nthen\n System.out.println( $con ); \nend\n\nrule \"Init\"\nwhen\nthen\n Content ext = new Content();\n Content complex = new Content( new Content( null, ext ), null );\n Content complex2 = new Content( null, null );\n Context ctx = new Context( ext );\n Context ctx2 = new Context( complex2 );\n insert( complex );\n insert( complex2 );\n insert( ctx );\n insert( ctx2 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
        ksession.dispose();
    }

    @Test
    public void testNullSafeNestedAccessors() {
        String str = "package org.drools.test; import " + Person.class.getName() + "; global java.util.List list; rule R1 when  $street : String()  Person( address!.( street == $street, $zip : zipCode ) ) then  list.add( $zip ); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("Mario", 38));
        Person mark = new Person("Mark", 37);
        mark.setAddress(new Address("Main Street", "", "123456"));
        ksession.insert((Object)mark);
        ksession.insert((Object)"Main Street");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
        Assertions.assertThat(list).isEqualTo(Arrays.asList("123456"));
    }
}

