/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.facts.ClassA;
import org.drools.mvel.integrationtests.facts.ClassB;
import org.drools.mvel.integrationtests.facts.InterfaceA;
import org.drools.mvel.integrationtests.facts.InterfaceB;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DeleteTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static Logger logger = LoggerFactory.getLogger(DeleteTest.class);
    private static final String DELETE_TEST_DRL = "org/drools/mvel/integrationtests/session/delete_test.drl";
    private KieSession ksession;

    public DeleteTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Before
    public void setUp() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{DELETE_TEST_DRL});
        this.ksession = kbase.newKieSession();
    }

    @After
    public void tearDown() {
        this.ksession.dispose();
    }

    @Test
    public void deleteFactTest() {
        this.ksession.insert((Object)new org.drools.core.test.model.Person("Petr", 25));
        FactHandle george = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 19));
        QueryResults results = this.ksession.getQueryResults("informationAboutPersons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$countOfPerson")).isEqualTo((Object)2L);
        this.ksession.delete(george);
        results = this.ksession.getQueryResults("informationAboutPersons", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$countOfPerson")).isEqualTo((Object)1L);
    }

    @Test
    public void deleteFactTwiceTest() {
        FactHandle george = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 19));
        QueryResults results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)1L);
        this.ksession.delete(george);
        results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
        this.ksession.delete(george);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteNullFactTest() {
        this.ksession.delete(null);
    }

    @Test
    public void deleteUpdatedFactTest() {
        FactHandle person = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 18));
        this.ksession.update(person, (Object)new org.drools.core.test.model.Person("John", 21));
        QueryResults results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)1L);
        this.ksession.delete(person);
        results = this.ksession.getQueryResults("countPerson", new Object[0]);
        Assertions.assertThat((Iterable)results).isNotEmpty();
        Assertions.assertThat((Object)((QueryResultsRow)results.iterator().next()).get("$personCount")).isEqualTo((Object)0L);
    }

    @Test
    public void deleteUpdatedFactDifferentClassTest() {
        FactHandle fact = this.ksession.insert((Object)new org.drools.core.test.model.Person("George", 18));
        Assertions.assertThat((Collection)this.ksession.getObjects()).hasSize(1);
        Assertions.assertThat(this.ksession.getObjects().iterator().next()).isInstanceOf(org.drools.core.test.model.Person.class);
        this.ksession.update(fact, (Object)new org.drools.core.test.model.Cheese("Cheddar", 50));
        Assertions.assertThat((Collection)this.ksession.getObjects()).hasSize(1);
        Assertions.assertThat(this.ksession.getObjects().iterator().next()).isInstanceOf(org.drools.core.test.model.Cheese.class);
        this.ksession.delete(fact);
        Assertions.assertThat((Collection)this.ksession.getObjects()).isEmpty();
    }

    @Test
    public void testRetractLeftTuple() throws Exception {
        String str = "import " + ClassA.class.getCanonicalName() + ";\nimport " + ClassB.class.getCanonicalName() + ";\nimport " + InterfaceA.class.getCanonicalName() + ";\nimport " + InterfaceB.class.getCanonicalName() + ";\nrule R1 salience 3\nwhen\n   $b : InterfaceB( )\n   $a : ClassA( b == null )\nthen\n   $a.setB( $b );\n   update( $a );\nend\nrule R2 salience 2\nwhen\n   $b : ClassB( id == \"123\" )\n   $a : ClassA( b != null && b.id == $b.id )\nthen\n   $b.setId( \"456\" );\n   update( $b );\nend\nrule R3 salience 1\nwhen\n   InterfaceA( $b : b )\nthen\n   delete( $b );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new ClassA());
        ksession.insert((Object)new ClassB());
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
    }

    @Test
    public void testAssertRetract() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"assert_retract.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person person = new Person("michael", "cheese");
        person.setStatus("start");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        List results = (List)ksession.getGlobal("list");
        for (String result : results) {
            logger.info(result);
        }
        Assertions.assertThat((int)results.size()).isEqualTo(5);
        Assertions.assertThat((boolean)results.contains("first")).isTrue();
        Assertions.assertThat((boolean)results.contains("second")).isTrue();
        Assertions.assertThat((boolean)results.contains("third")).isTrue();
        Assertions.assertThat((boolean)results.contains("fourth")).isTrue();
        Assertions.assertThat((boolean)results.contains("fifth")).isTrue();
    }

    @Test
    public void testEmptyAfterRetractInIndexedMemory() {
        Object str = "";
        str = (String)str + "package org.simple \n";
        str = (String)str + "import org.drools.mvel.compiler.Person\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule xxx dialect 'mvel' \n";
        str = (String)str + "when \n";
        str = (String)str + "  Person( $name : name ) \n";
        str = (String)str + "  $s : String( this == $name) \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add($s); \n";
        str = (String)str + "end  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("ackbar");
        ksession.insert((Object)p);
        ksession.insert((Object)"ackbar");
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"ackbar");
    }

    @Test
    public void testModifyRetractAndModifyInsert() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ModifyRetractInsert.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Person bob = new Person("Bob");
        bob.setStatus("hungry");
        ksession.insert((Object)bob);
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new Cheese());
        ksession.fireAllRules(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("should have fired only once", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testModifyRetractWithFunction() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RetractModifyWithFunction.drl"});
        KieSession ksession = kbase.newKieSession();
        Cheese stilton = new Cheese("stilton", 7);
        Cheese muzzarella = new Cheese("muzzarella", 9);
        int sum = stilton.getPrice() + muzzarella.getPrice();
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        FactHandle muzzarellaHandle = ksession.insert((Object)muzzarella);
        ksession.fireAllRules();
        Assertions.assertThat((int)stilton.getPrice()).isEqualTo(sum);
        Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        Assertions.assertThat((Object)ksession.getObject(stiltonHandle)).isNotNull();
        Assertions.assertThat((Object)ksession.getFactHandle((Object)stilton)).isNotNull();
        Assertions.assertThat((Object)ksession.getObject(muzzarellaHandle)).isNull();
        Assertions.assertThat((Object)ksession.getFactHandle((Object)muzzarella)).isNull();
    }
}

