/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class LocaleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LocaleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatinLocale() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("pt", "BR"));
            KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_LatinLocale.drl"});
            KieSession ksession = kbase.newKieSession();
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheese mycheese = new Cheese("cheddar", 4);
            FactHandle handle = ksession.insert((Object)mycheese);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)results.get(0))).isEqualTo("1");
            mycheese.setPrice(8);
            mycheese.setDoublePrice(8.5);
            ksession.update(handle, (Object)mycheese);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((String)((String)results.get(1))).isEqualTo("3");
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }
}

