/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.incrementalcompilation.AddRemoveTestCases;
import org.drools.compiler.integrationtests.incrementalcompilation.TestUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@Category(value={TurtleTestCategory.class})
public class AddRemoveRulesAdvOperatorsTest {
    @Test
    public void testAddRemoveSameRuleWithContains() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n     list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n     list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n     list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveSameRuleWithContainsSwitchedConstraints() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     java.util.Map(values() contains \"1\") \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     java.util.Map(values() contains \"1\") \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     java.util.Map(values() contains \"1\") \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndExists() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndExistsAtEnd() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndExistsAtBeg() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndExistsInFirstRuleAtBeg() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     exists(String()) \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndExistsInFirstRuleAtEnd() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String()) \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndDoubledExists() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithNotContainsAndExists() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() not contains \"2\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() not contains \"2\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() not contains \"2\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveRuleWithContainsAndNotContainsAndExists() {
        String rule1 = "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end", "R1", "R2", null, this.getFactsContains());
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     java.util.Map(values() not contains \"2\") \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List list \n rule R1 \n when \n     String() \n     java.util.Map(values() contains \"1\") \n then \n list.add('R1'); \n end", "R2", "R1", null, this.getFactsContains());
    }

    @Test
    public void testAddRemoveSameRuleWithMemberOf() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s memberOf memberList) \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s memberOf memberList) \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s memberOf memberList) \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveSameRuleWithMemberOfSwitchedConstraints() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveRuleWithMemberOfAndExists() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveRuleWithMemberOfAndExistsAtEnd() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     exists(String()) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     exists(String()) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     exists(String()) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveRuleWithMemberOfAndExistsAtBeg() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     exists(String()) \n     String() \n     $s: String($s memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveRuleWithMemberOfAndNotExists() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     not(exists(Integer() and Integer())) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test");
    }

    @Test
    public void testAddRemoveRuleWithNotMemberOfAndExists() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s not memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s not memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "fact");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s not memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "fact");
    }

    @Test
    public void testAddRemoveRuleWithMemberOfAndNotMemberOfAndExists() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test", "fact");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     exists(String()) \n     $s: String($s not memberOf memberList) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     $s: String($s memberOf memberList) \n     String() \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test", "fact");
    }

    @Test
    @Ignore
    public void testAddRemoveRuleWithContainsMatchesExists() {
        String rule1 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     exists(String()) \n     String($s memberOf memberList) \n then \n list.add('R1'); \n end";
        String rule2 = "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     String($s memberOf memberList) \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n     exists(String()) \n then\n     list.add('R2'); \n end";
        String memberString = "test";
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     exists(String()) \n     String($s memberOf memberList) \n then \n list.add('R1'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     String($s memberOf memberList) \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n     exists(String()) \n then\n     list.add('R2'); \n end", "R1", "R2", this.getGlobalsMemberOf("test"), "test", "1");
        AddRemoveTestCases.runAllTestCases("package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R2 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     String($s memberOf memberList) \n     java.util.Map(values() contains \"1\") \n     exists(String() and String()) \n     exists(String()) \n then\n     list.add('R2'); \n end", "package com.rules;\n global java.util.List memberList\n global java.util.List list \n rule R1 \n when \n     String() \n     $s: String($s matches \"tes.*\") \n     exists(String()) \n     String($s memberOf memberList) \n then \n list.add('R1'); \n end", "R2", "R1", this.getGlobalsMemberOf("test"), "test", "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveRuleContainsExists3Rules() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend";
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        KieSession kieSession = TestUtil.buildSessionInSteps("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            kieSession.setGlobal("globalInt", (Object)new AtomicInteger(0));
            TestUtil.insertFacts(kieSession, mapFact, 1, "1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2", "R3");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAddRemoveRuleContainsExists3RulesDoubledExists() {
        String rule1 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer() \n    exists( Integer() and Integer() )\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend";
        String rule3 = "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend";
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        KieSession kieSession = TestUtil.buildSessionInSteps("package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R1 \nwhen\n    $s : String()\n    Integer() \n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\nthen\n list.add('R1'); \nend\n");
        try {
            ArrayList resultsList = new ArrayList();
            kieSession.setGlobal("list", resultsList);
            kieSession.setGlobal("globalInt", (Object)new AtomicInteger(0));
            TestUtil.insertFacts(kieSession, mapFact, 1, "1");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R1"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R2 \nwhen \n    $s : String()\n    Integer() \n    exists( Integer() and Integer() )\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and Integer() )\n    String()\nthen \n list.add('R2'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R2"});
            resultsList.clear();
            TestUtil.addRules(kieSession, "package com.rules;global java.util.concurrent.atomic.AtomicInteger globalInt\nglobal java.util.List list\nrule R3 \nwhen \n    $s : String()\n    java.util.Map(values() contains \"1\") \n    exists( Integer() and exists(Integer() and Integer()))\n    String()\nthen \n list.add('R3'); \nend");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).containsOnly((Object[])new String[]{"R3"});
            resultsList.clear();
            TestUtil.removeRules(kieSession, "com.rules", "R1", "R2", "R3");
            kieSession.fireAllRules();
            Assertions.assertThat(resultsList).isEmpty();
        }
        finally {
            kieSession.dispose();
        }
    }

    private Object[] getFactsContains() {
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        return new Object[]{mapFact, 1, 2, "1"};
    }

    private Map<String, Object> getGlobalsMemberOf(String memberString) {
        HashMap<String, Object> globals = new HashMap<String, Object>(1);
        ArrayList<String> memberList = new ArrayList<String>(1);
        memberList.add(memberString);
        globals.put("memberList", memberList);
        return globals;
    }
}

