/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ForAllTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ForAllTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test1P1CFiring1() {
        this.check("age >= 18", 1, new Person("Mario", 45));
    }

    @Test
    public void test1P1CFiring2() {
        this.check("age == 8 || == 45", 1, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiring() {
        this.check("age >= 18", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiringWithAnd() {
        this.check("name == \"Sofia\" && age >= 18", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiringWithParenthesis() {
        this.check("(name == \"Sofia\" && age >= 18)", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiringWithOr() {
        this.check("age >= 18 || name == \"Mario\"", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P1CNotFiringWithParenthesisAndOr() {
        this.check("(name == \"Sofia\" && age >= 18) || name == \"Mario\"", 0, new Person("Sofia", 8));
    }

    @Test
    public void test1P2CFiring() {
        this.check("age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43));
    }

    @Test
    public void test1P2CFiringWithIn() {
        this.check("age >= 18, name in(\"Mario\", \"Mark\")", 1, new Person("Mario", 45), new Person("Mark", 43));
    }

    @Test
    public void test1P2CNotFiring1() {
        this.check("age >= 18, name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Mark", 43), new Person("Edson", 40));
    }

    @Test
    public void test1P2CNotFiring2() {
        this.check("age < 18, name.startsWith(\"M\")", 0, new Person("Sofia", 8));
    }

    @Test
    public void test2P1CFiring() {
        this.check("age >= 18", "name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test2P1CNotFiring() {
        this.check("age >= 1", "name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Sofia", 8));
    }

    @Test
    public void test2P2CFiring() {
        this.check("", "age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43));
    }

    @Test
    public void test2P2CNotFiring1() {
        this.check("", "age >= 18, name.startsWith(\"M\")", 0, new Person("Mario", 45), new Person("Mark", 43), new Person("Edson", 40));
    }

    @Test
    public void test2P3CFiring() {
        this.check("name.length() < 6", "age >= 18, name.startsWith(\"M\")", 1, new Person("Mario", 45), new Person("Mark", 43), new Person("Daniele", 43));
    }

    @Test
    public void testNoFiring() {
        this.check("", "age >= 18", 0, new Object[0]);
    }

    private void check(String constraints1, int expectedFires, Object ... objs) {
        this.check(constraints1, null, expectedFires, objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String constraints1, String constraints2, int expectedFires, Object ... objs) {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\n\nrule R1 when\n    forall(\n       $p: Person( " + constraints1 + " )\n" + (String)(constraints2 != null ? "       Person( this == $p," + constraints2 + " )\n" : "") + "    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            for (Object obj : objs) {
                ksession.insert(obj);
            }
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(expectedFires);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testWithDate() throws Exception {
        String pkg = "org.drools.compiler.integrationtests.operators";
        String drl = "package " + pkg + ";\ndeclare Fact\n    d : java.util.Date\nend\n\nrule \"forall with date\" when\n  forall(Fact(d == \"01-Jan-2020\"))\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
        FactType factType = kbase.getFactType(pkg, "Fact");
        for (int i = 0; i < 3; ++i) {
            Object fact = factType.newInstance();
            factType.set(fact, "d", (Object)df.parse("01-Jan-2020"));
            ksession.insert(fact);
        }
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testWithIndexedAlpha() throws Exception {
        String pkg = "org.drools.compiler.integrationtests.operators";
        String drl = "rule R1 when\n  forall( $s: String() String( this == $s, toString == \"A\" ) )\nthen\nend\nrule R2 when\n  String( toString == \"B\" )\nthen\nend\nrule R3 when\n  String( toString == \"C\" )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession1 = kbase.newKieSession();
        ksession1.insert((Object)"A");
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        KieSession ksession2 = kbase.newKieSession();
        ksession2.insert((Object)"D");
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(0);
    }

    @Test
    public void testForallWithNotEqualConstraint() throws Exception {
        String drl = "rule \"forall with not equal\"\nwhen forall(String(this != \"foo\"))\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new String("bar"));
        ksession.insert((Object)new String("baz"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testForallWithNotEqualConstraintOnDate() throws Exception {
        String drl = "rule \"forall with not equal\"\nwhen forall(java.util.Date(this != \"29-Dec-2019\"))\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Date(0L));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testForallWithEmptyListConstraintCombinedWithOrFiring() throws Exception {
        this.checkForallWithEmptyListConstraintCombinedWithOrFiring(true);
    }

    @Test
    public void testForallWithEmptyListConstraintCombinedWithOrNotFiring() throws Exception {
        this.checkForallWithEmptyListConstraintCombinedWithOrFiring(false);
    }

    private void checkForallWithEmptyListConstraintCombinedWithOrFiring(boolean firing) {
        String drl = "import " + Pojo.class.getCanonicalName() + ";\nrule \"forall with not equal\"\nwhen forall($p : Pojo(y == 1)\n            Pojo(x.empty || x contains 2, z == 3, this == $p))\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Pojo(Collections.emptyList(), 1, 3));
        ksession.insert((Object)new Pojo(Arrays.asList(2), 1, 3));
        ksession.insert((Object)new Pojo(Arrays.asList(3), firing ? 0 : 1, 3));
        ksession.insert((Object)new Pojo(Arrays.asList(2), firing ? 0 : 1, 0));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(firing ? 1 : 0);
    }

    @Test
    public void testForallWithMultipleConstraints() throws Exception {
        this.checkForallWithComplexExpression("value > 1, value < 10");
    }

    @Test
    public void testForallWithAnd() throws Exception {
        this.checkForallWithComplexExpression("value > 1 && value < 10");
    }

    @Test
    public void testForallWithAndInMultipleConstraints() throws Exception {
        this.checkForallWithComplexExpression("value > 1, value > 2 && value < 10");
    }

    @Test
    public void testForallWithOr() throws Exception {
        this.checkForallWithComplexExpression("value < 1 || value > 50");
    }

    @Test
    public void testForallWithIn() throws Exception {
        this.checkForallWithComplexExpression("value in (1, 43)");
    }

    @Test
    public void testForallWithNotIn() throws Exception {
        this.checkForallWithComplexExpression("value not in (1, 42)");
    }

    private void checkForallWithComplexExpression(String expression) throws Exception {
        String drl = "package test\ndeclare Fact\n    tag : String\n    value : int\nend\nrule \"Rule\"\nwhen\nforall (f:Fact(tag == \"X\") Fact(this==f, " + expression + "))\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"forall-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        FactType ft = kbase.getFactType("test", "Fact");
        Object f1 = ft.newInstance();
        ft.set(f1, "tag", (Object)"X");
        ft.set(f1, "value", (Object)42);
        ksession.insert(f1);
        Object f2 = ft.newInstance();
        ft.set(f2, "tag", (Object)"Y");
        ft.set(f2, "value", (Object)42);
        ksession.insert(f2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
    }

    public class Pojo {
        private List<Integer> x = new ArrayList<Integer>();
        private int y;
        private int z;

        public Pojo(List<Integer> x, int y, int z) {
            this.x.addAll(x);
            this.y = y;
            this.z = z;
        }

        public List<Integer> getX() {
            return this.x;
        }

        public void setX(List<Integer> x) {
            this.x.addAll(x);
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public String toString() {
            return "Pojo{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
        }
    }
}

