/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.util.index.AlphaRangeIndex;
import org.drools.kiesession.entrypoints.DisconnectedWorkingMemoryEntryPoint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.ConstraintTestUtil;
import org.drools.mvel.MockBetaNode;
import org.drools.mvel.accessors.ClassFieldAccessorStore;
import org.drools.mvel.model.Cheese;
import org.drools.mvel.model.MockObjectSource;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompositeObjectSinkAdapterTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private CompositeObjectSinkAdapter ad;
    private ReadAccessor extractor;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private final boolean useLambdaConstraint;

    public CompositeObjectSinkAdapterTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Parameterized.Parameters(name="useLambdaConstraint={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        this.buildContext.setRule(new RuleImpl("test"));
        this.ad = new CompositeObjectSinkAdapter();
    }

    @Test
    public void testAddBeta() {
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.sinksAre(new ObjectSink[]{beta});
        this.otherSinksAre(new ObjectSink[]{beta});
        this.hashableSinksAreEmpty();
        this.hashedFieldIndexesAreEmpty();
        this.hashedSinkMapIsEmpty();
    }

    @Test
    public void testAddBetaRemoveBeta() {
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.ad.removeObjectSink((ObjectSink)beta);
        this.sinksAreEmpty();
        this.otherSinksAreEmpty();
    }

    @Test
    public void testAddOneAlphaNotHashable() {
        AlphaNode al = this.createAlphaNode((AlphaNodeFieldConstraint)new PredicateConstraint(null, null));
        this.ad.addObjectSink((ObjectSink)al);
        this.sinksAre(new ObjectSink[]{al});
        this.otherSinksAre(new ObjectSink[]{al});
    }

    @Test
    public void testAddOneAlphaNotHashableRemoveOneAlpha() {
        AlphaNode al = this.createAlphaNode((AlphaNodeFieldConstraint)new PredicateConstraint(null, null));
        this.ad.addObjectSink((ObjectSink)al);
        this.ad.removeObjectSink((ObjectSink)al);
        this.sinksAreEmpty();
        this.otherSinksAreEmpty();
    }

    @Test
    public void testAddOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        this.sinksAre(new ObjectSink[]{al});
        this.otherSinksAreEmpty();
        this.hashedFieldIndexesAre(this.extractor.getIndex());
        this.hashableSinksAre(new ObjectSink[]{al});
    }

    @Test
    public void testAddOneAlphaRemoveOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        this.ad.removeObjectSink((ObjectSink)al);
        this.otherSinksAreEmpty();
        this.hashableSinksAreEmpty();
    }

    @Test
    public void testAddTwoAlphas() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        this.sinksAre(new ObjectSink[]{al, al2});
        this.otherSinksAreEmpty();
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddTwoAlphasAddOneBeta() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.otherSinksAre(new ObjectSink[]{beta});
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddTwoAlphasAddOneBetaRemoveOneBeta() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        MockBetaNode beta = this.createBetaNode();
        this.ad.addObjectSink((ObjectSink)beta);
        this.ad.removeObjectSink((ObjectSink)beta);
        this.otherSinksAreEmpty();
        this.hashableSinksAre(new ObjectSink[]{al, al2});
    }

    @Test
    public void testAddThreeAlphas() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("stinky"));
        this.ad.addObjectSink((ObjectSink)al3);
        this.hashableSinksAreEmpty();
        this.hashedSinkMapIs(al, al2, al3);
    }

    @Test
    public void testAddThreeAlphasRemoveOneAlpha() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("cheddar"));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("stinky"));
        this.ad.addObjectSink((ObjectSink)al3);
        this.ad.removeObjectSink((ObjectSink)al2);
        this.hashableSinksAre(new ObjectSink[]{al, al3});
        this.hashedSinkMapIsEmpty();
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        this.extractor = this.store.getReader(Cheese.class, "charType");
        AlphaNode al = this.createAlphaNode(this.cheeseCharTypeEqualsTo(65));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseCharTypeEqualsTo(66));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseCharTypeEqualsTo(67));
        this.ad.addObjectSink((ObjectSink)al3);
        Assertions.assertThat((Object)((AlphaNode)this.ad.getHashedSinkMap().get(this.keyForCheeseCharType('B')))).isSameAs((Object)al2);
        Assertions.assertThat((Object)((AlphaNode)this.ad.getHashedSinkMap().get(this.keyForCheeseCharType('X')))).isNull();
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        this.extractor = this.store.getReader(Cheese.class, "charObjectType");
        AlphaNode al = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(65));
        this.ad.addObjectSink((ObjectSink)al);
        AlphaNode al2 = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(66));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheeseCharObjectTypeEqualsTo(67));
        this.ad.addObjectSink((ObjectSink)al3);
        Assertions.assertThat((Object)((AlphaNode)this.ad.getHashedSinkMap().get(this.keyForCheeseCharObjectType('B')))).isSameAs((Object)al2);
        Assertions.assertThat((Object)((AlphaNode)this.ad.getHashedSinkMap().get(this.keyForCheeseCharObjectType('X')))).isNull();
    }

    @Test
    public void testAddOneAlphaForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        this.sinksAre(new ObjectSink[]{al1});
        this.otherSinksAreEmpty();
        Assertions.assertThat((List)this.ad.getRangeIndexedFieldIndexes()).isNotNull();
        this.rangeIndexableSinksAre(new ObjectSink[]{al1});
    }

    @Test
    public void testTwoAlphasForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        Assertions.assertThat((Map)this.ad.getRangeIndexMap()).isNull();
        this.rangeIndexableSinksAre(new ObjectSink[]{al1, al2});
    }

    @Test
    public void testThreeAlphasForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        Assertions.assertThat((Map)this.ad.getRangeIndexMap()).isNotNull();
        this.rangeIndexableSinksIsEmpty(new ObjectSink[0]);
    }

    @Test
    public void testAddThreeAlphasRemoveOneAlphaForRanges() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        this.ad.removeObjectSink((ObjectSink)al2);
        this.rangeIndexableSinksAre(new ObjectSink[]{al1, al3});
        Assertions.assertThat((Map)this.ad.getRangeIndexMap()).isNull();
    }

    @Test
    public void testAddThreeAlphasVerifyRangeQuery() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        CompositeObjectSinkAdapter.FieldIndex fieldIndex = (CompositeObjectSinkAdapter.FieldIndex)this.ad.getRangeIndexedFieldIndexes().get(0);
        Cheese cheese = new Cheese();
        cheese.setPrice(25);
        Collection matchingAlphaNodes = ((AlphaRangeIndex)this.ad.getRangeIndexMap().get(fieldIndex)).getMatchingAlphaNodes((Object)cheese);
        Assertions.assertThat((int)matchingAlphaNodes.size()).isEqualTo(2);
        Assertions.assertThat((boolean)matchingAlphaNodes.contains(al1)).isTrue();
        Assertions.assertThat((boolean)matchingAlphaNodes.contains(al2)).isTrue();
        cheese.setPrice(5);
        matchingAlphaNodes = ((AlphaRangeIndex)this.ad.getRangeIndexMap().get(fieldIndex)).getMatchingAlphaNodes((Object)cheese);
        Assertions.assertThat((boolean)matchingAlphaNodes.isEmpty()).isTrue();
    }

    @Test(expected=IllegalStateException.class)
    public void testRangeIndexConflictKey() {
        this.extractor = this.store.getReader(Cheese.class, "price");
        AlphaNode al1 = this.createAlphaNode(this.cheesePriceGreaterThan(10));
        this.ad.addObjectSink((ObjectSink)al1);
        AlphaNode al2 = this.createAlphaNode(this.cheesePriceGreaterThan(20));
        this.ad.addObjectSink((ObjectSink)al2);
        AlphaNode al3 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al3);
        AlphaNode al4 = this.createAlphaNode(this.cheesePriceGreaterThan(30));
        this.ad.addObjectSink((ObjectSink)al4);
    }

    @Test
    public void testPropagationWithNullValue() {
        this.extractor = this.store.getReader(Cheese.class, "type");
        AlphaNode al1 = this.createAlphaNode(this.cheeseTypeEqualsTo("stilton"));
        AlphaNode al2 = this.createAlphaNode(this.cheeseTypeEqualsTo("brie"));
        AlphaNode al3 = this.createAlphaNode(this.cheeseTypeEqualsTo("muzzarela"));
        this.ad.addObjectSink((ObjectSink)al1);
        this.ad.addObjectSink((ObjectSink)al2);
        this.ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (WorkingMemoryEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            this.ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assertions.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    private AlphaNodeFieldConstraint cheeseTypeEqualsTo(String value) {
        return ConstraintTestUtil.createCheeseTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheeseCharTypeEqualsTo(int value) {
        return ConstraintTestUtil.createCheeseCharTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheeseCharObjectTypeEqualsTo(int value) {
        return ConstraintTestUtil.createCheeseCharObjectTypeEqualsConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNodeFieldConstraint cheesePriceGreaterThan(int value) {
        return ConstraintTestUtil.createCheesePriceGreaterConstraint(this.extractor, value, this.useLambdaConstraint);
    }

    private AlphaNode createAlphaNode(AlphaNodeFieldConstraint lit) {
        return new AlphaNode(this.buildContext.getNextNodeId(), lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextNodeId()), this.buildContext);
    }

    private MockBetaNode createBetaNode() {
        return new MockBetaNode(this.buildContext.getNextNodeId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
    }

    private CompositeObjectSinkAdapter.HashKey keyForCheeseCharType(char c) {
        Cheese cheese = new Cheese();
        cheese.setCharType(c);
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(this.extractor.getIndex(), (Object)cheese, this.extractor);
        return hashKey;
    }

    private CompositeObjectSinkAdapter.HashKey keyForCheeseCharObjectType(char c) {
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf(c));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(this.extractor.getIndex(), (Object)cheese, this.extractor);
        return hashKey;
    }

    private void sinksAre(ObjectSink ... objectSinks) {
        Assertions.assertThat((int)this.ad.getSinks().length).isEqualTo(objectSinks.length);
        for (int i = 0; i < objectSinks.length; ++i) {
            Assertions.assertThat((Object)this.ad.getSinks()[i]).isEqualTo((Object)objectSinks[i]);
        }
    }

    private void sinksAreEmpty() {
        Assertions.assertThat((int)this.ad.getSinks().length).isEqualTo(0);
    }

    private void otherSinksAre(ObjectSink ... objectSinks) {
        Assertions.assertThat((int)this.ad.getOtherSinks().size()).isEqualTo(objectSinks.length);
        for (int i = 0; i < objectSinks.length; ++i) {
            Assertions.assertThat(this.ad.getOtherSinks().get(i)).isEqualTo((Object)objectSinks[i]);
        }
    }

    private void otherSinksAreEmpty() {
        Assertions.assertThat((List)this.ad.getOtherSinks()).isNull();
    }

    private void hashableSinksAre(ObjectSink ... objectSinks) {
        Assertions.assertThat((int)this.ad.getHashableSinks().size()).isEqualTo(objectSinks.length);
        for (int i = 0; i < objectSinks.length; ++i) {
            Assertions.assertThat((boolean)this.ad.getHashableSinks().contains(objectSinks[i])).isTrue();
        }
    }

    private void rangeIndexableSinksAre(ObjectSink ... rangeIndexableSinks) {
        Assertions.assertThat((int)this.ad.getRangeIndexableSinks().size()).isEqualTo(rangeIndexableSinks.length);
        for (int i = 0; i < rangeIndexableSinks.length; ++i) {
            Assertions.assertThat((boolean)this.ad.getRangeIndexableSinks().contains(rangeIndexableSinks[i])).isTrue();
        }
    }

    private void rangeIndexableSinksIsEmpty(ObjectSink ... rangeIndexableSinks) {
        Assertions.assertThat((List)this.ad.getRangeIndexableSinks()).isNull();
    }

    private void hashedFieldIndexesAre(Integer ... fieldIndexes) {
        Assertions.assertThat((int)this.ad.getHashedFieldIndexes().size()).isEqualTo(fieldIndexes.length);
        List<Integer> hashedFieldIndexes = Arrays.asList(fieldIndexes);
        for (int i = 0; i < fieldIndexes.length; ++i) {
            Assertions.assertThat((boolean)hashedFieldIndexes.contains(((CompositeObjectSinkAdapter.FieldIndex)this.ad.getHashedFieldIndexes().get(i)).getIndex())).isTrue();
        }
    }

    private void hashedFieldIndexesAreEmpty() {
        Assertions.assertThat((List)this.ad.getHashedFieldIndexes()).isNull();
    }

    private void hashableSinksAreEmpty() {
        Assertions.assertThat((List)this.ad.getHashableSinks()).isNull();
    }

    private void hashedSinkMapIs(AlphaNode ... nodes) {
        Assertions.assertThat((int)this.ad.getHashedSinkMap().size()).isEqualTo(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            Assertions.assertThat((boolean)this.ad.getHashedSinkMap().containsValue(nodes[i])).isTrue();
        }
    }

    private void hashedSinkMapIsEmpty() {
        Assertions.assertThat((Map)this.ad.getHashedSinkMap()).isNull();
    }
}

