/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.EvaluatorRegistry;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AccumulateImportDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BehaviorDescr;
import org.drools.drl.ast.descr.CollectDescr;
import org.drools.drl.ast.descr.EntryPointDeclarationDescr;
import org.drools.drl.ast.descr.EntryPointDescr;
import org.drools.drl.ast.descr.EvalDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ForallDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.FunctionImportDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.OrDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.ast.descr.WindowDeclarationDescr;
import org.drools.drl.parser.DRLFactory;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.lang.DRL6Parser;
import org.drools.drl.parser.lang.DRLParser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class RuleParserTest {
    private DRLParser parser;

    @Before
    public void setUp() throws Exception {
        new EvaluatorRegistry();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testPackage_OneSegment() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo");
        Assertions.assertThat((String)packageName).isEqualTo("foo");
    }

    @Test
    public void testPackage_MultipleSegments() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo.bar.baz;");
        Assertions.assertThat((String)packageName).isEqualTo("foo.bar.baz");
    }

    @Test
    public void testPackage() throws Exception {
        String source = "package foo.bar.baz";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse((Reader)new StringReader("package foo.bar.baz"));
        Assertions.assertThat((boolean)parser.hasErrors()).isFalse();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo.bar.baz");
    }

    @Test
    public void testPackageWithError() throws Exception {
        String source = "package 12 foo.bar.baz";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 foo.bar.baz"));
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo.bar.baz");
    }

    @Test
    public void testPackageWithError2() throws Exception {
        String source = "package 12 12312 231";
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 12312 231"));
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("");
    }

    @Test
    public void testCompilationUnit() throws Exception {
        String source = "package foo; import com.foo.Bar; import com.foo.Baz;";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo; import com.foo.Bar; import com.foo.Baz;");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo");
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(2);
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("com.foo.Bar");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("com.foo.Baz");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length());
    }

    @Test
    public void testFunctionImport() throws Exception {
        String source = "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo");
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(2);
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("foo.bar.*");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("baz.Baz");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length());
        Assertions.assertThat((int)pkg.getFunctionImports().size()).isEqualTo(2);
        impdescr = (ImportDescr)pkg.getFunctionImports().get(0);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("java.lang.Math.max");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length());
        impdescr = (ImportDescr)pkg.getFunctionImports().get(1);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("java.lang.Math.min");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length());
    }

    @Test
    public void testGlobal1() throws Exception {
        String source = "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo.bar.baz");
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(1);
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        Assertions.assertThat((String)impdescr.getTarget()).isEqualTo("com.foo.Bar");
        Assertions.assertThat((int)impdescr.getStartCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()));
        Assertions.assertThat((int)impdescr.getEndCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length());
        Assertions.assertThat((int)pkg.getGlobals().size()).isEqualTo(2);
        GlobalDescr global = (GlobalDescr)pkg.getGlobals().get(0);
        Assertions.assertThat((String)global.getType()).isEqualTo("java.util.List<java.util.Map<String,Integer>>");
        Assertions.assertThat((String)global.getIdentifier()).isEqualTo("aList");
        Assertions.assertThat((int)global.getStartCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()));
        Assertions.assertThat((int)global.getEndCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length());
        global = (GlobalDescr)pkg.getGlobals().get(1);
        Assertions.assertThat((String)global.getType()).isEqualTo("Integer");
        Assertions.assertThat((String)global.getIdentifier()).isEqualTo("aNumber");
        Assertions.assertThat((int)global.getStartCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()));
        Assertions.assertThat((int)global.getEndCharacter()).isEqualTo("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length());
    }

    @Test
    public void testGlobal() throws Exception {
        PackageDescr pack = (PackageDescr)this.parseResource("compilationUnit", "globals.drl");
        Assertions.assertThat((int)pack.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)pack.getImports().size()).isEqualTo(1);
        Assertions.assertThat((int)pack.getGlobals().size()).isEqualTo(2);
        GlobalDescr foo = (GlobalDescr)pack.getGlobals().get(0);
        Assertions.assertThat((String)foo.getType()).isEqualTo("java.lang.String");
        Assertions.assertThat((String)foo.getIdentifier()).isEqualTo("foo");
        GlobalDescr bar = (GlobalDescr)pack.getGlobals().get(1);
        Assertions.assertThat((String)bar.getType()).isEqualTo("java.lang.Integer");
        Assertions.assertThat((String)bar.getIdentifier()).isEqualTo("bar");
    }

    @Test
    public void testFunctionImport2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_FunctionImport.drl");
        Assertions.assertThat((int)pkg.getFunctionImports().size()).isEqualTo(2);
        Assertions.assertThat((String)((FunctionImportDescr)pkg.getFunctionImports().get(0)).getTarget()).isEqualTo("abd.def.x");
        Assertions.assertThat((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getStartCharacter() == -1 ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getEndCharacter() == -1 ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((String)((FunctionImportDescr)pkg.getFunctionImports().get(1)).getTarget()).isEqualTo("qed.wah.*");
        Assertions.assertThat((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getStartCharacter() == -1 ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getEndCharacter() == -1 ? 1 : 0) != 0).isFalse();
    }

    @Test
    public void testFromComplexAcessor() throws Exception {
        String source = "rule \"Invalid customer id\" ruleflow-group \"validate\" lock-on-active true \n when \n     o: Order( ) \n     not( Customer( ) from customerService.getCustomer(o.getCustomerId()) ) \n then \n     System.err.println(\"Invalid customer id found!\"); \n     o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrorMessages().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("Invalid customer id");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        PatternDescr customer = (PatternDescr)not.getDescrs().get(0);
        Assertions.assertThat((String)customer.getObjectType()).isEqualTo("Customer");
        Assertions.assertThat((String)((FromDescr)customer.getSource()).getDataSource().getText()).isEqualTo("customerService.getCustomer(o.getCustomerId())");
    }

    @Test
    public void testFromWithInlineList() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n not( Number( ) from [1, 2, 3] ) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("XYZ");
        PatternDescr number = (PatternDescr)((NotDescr)rule.getLhs().getDescrs().get(1)).getDescrs().get(0);
        Assertions.assertThat((String)((FromDescr)number.getSource()).getDataSource().toString()).isEqualTo("[1, 2, 3]");
    }

    @Test
    public void testFromWithInlineListMethod() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3].sublist(1, 2) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("XYZ");
        Assertions.assertThat((boolean)this.parser.hasErrors()).isFalse();
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)((FromDescr)number.getSource()).getDataSource().toString()).isEqualTo("[1, 2, 3].sublist(1, 2)");
    }

    @Test
    public void testFromWithInlineListIndex() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3][1] \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("XYZ");
        Assertions.assertThat((boolean)this.parser.hasErrors()).isFalse();
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)((FromDescr)number.getSource()).getDataSource().toString()).isEqualTo("[1, 2, 3][1]");
    }

    @Test
    public void testRuleWithoutEnd() throws Exception {
        String source = "rule \"Invalid customer id\" \n when \n o: Order( ) \n then \n System.err.println(\"Invalid customer id found!\"); \n";
        this.parse("compilationUnit", source);
        Assertions.assertThat((boolean)this.parser.hasErrors()).isTrue();
    }

    @Test
    public void testOrWithSpecialBind() throws Exception {
        String source = "rule \"A and (B or C or D)\" \n    when \n        pdo1 : ParametricDataObject( paramID == 101, stringValue == \"1000\" ) and \n        pdo2 :(ParametricDataObject( paramID == 101, stringValue == \"1001\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1002\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1003\" )) \n    then \n        System.out.println( \"Rule: A and (B or C or D) Fired. pdo1: \" + pdo1 +  \" pdo2: \"+ pdo2); \nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(2);
        PatternDescr pdo1 = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)pdo1.getIdentifier()).isEqualTo("pdo1");
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(3);
        for (BaseDescr pdo2 : or.getDescrs()) {
            Assertions.assertThat((String)((PatternDescr)pdo2).getIdentifier()).isEqualTo("pdo2");
        }
    }

    @Test
    public void testCompatibleRestriction() throws Exception {
        String source = "package com.sample  rule test  when  Test( ( text == null || text2 matches \"\" ) )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assertions.assertThat((String)pkg.getName()).isEqualTo("com.sample");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("test");
        ExprConstraintDescr expr = (ExprConstraintDescr)((PatternDescr)rule.getLhs().getDescrs().get(0)).getDescrs().get(0);
        Assertions.assertThat((String)expr.getText()).isEqualTo("( text == null || text2 matches \"\" )");
    }

    @Test
    public void testSimpleConstraint() throws Exception {
        String source = "package com.sample  rule test  when  Cheese( type == 'stilton', price > 10 )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assertions.assertThat((String)pkg.getName()).isEqualTo("com.sample");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("test");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr constraint = (AndDescr)pattern.getConstraint();
        Assertions.assertThat((int)constraint.getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((BaseDescr)constraint.getDescrs().get(0)).toString()).isEqualTo("type == \"stilton\"");
        Assertions.assertThat((String)((BaseDescr)constraint.getDescrs().get(1)).toString()).isEqualTo("price > 10");
    }

    @Test
    public void testStringEscapes() throws Exception {
        String source = "package com.sample  rule test  when  Cheese( type matches \"\\..*\\\\.\" )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        Assertions.assertThat((String)pkg.getName()).isEqualTo("com.sample");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("test");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr constraint = (AndDescr)pattern.getConstraint();
        Assertions.assertThat((int)constraint.getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((String)((BaseDescr)constraint.getDescrs().get(0)).toString()).isEqualTo("type matches \"\\..*\\\\.\"");
    }

    @Test
    public void testDialect() throws Exception {
        String source = "dialect 'mvel'";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect 'mvel'");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        Assertions.assertThat((String)attr.getName()).isEqualTo("dialect");
        Assertions.assertThat((String)attr.getValue()).isEqualTo("mvel");
    }

    @Test
    public void testDialect2() throws Exception {
        String source = "dialect \"mvel\"";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect \"mvel\"");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        Assertions.assertThat((String)attr.getName()).isEqualTo("dialect");
        Assertions.assertThat((String)attr.getValue()).isEqualTo("mvel");
    }

    @Test
    public void testEmptyRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "empty_rule.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("empty");
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assertions.assertThat((Object)rule.getConsequence()).isNotNull();
    }

    @Test
    public void testKeywordCollisions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eol_funny_business.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
    }

    @Test
    public void testTernaryExpression() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "ternary_expression.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        this.assertEqualsIgnoreWhitespace("if (speed > speedLimit ? true : false;) pullEmOver();", (String)rule.getConsequence());
    }

    @Test
    public void testFunctionWithArrays() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "function_arrays.drl");
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        this.assertEqualsIgnoreWhitespace("yourFunction(new String[3] {\"a\",\"b\",\"c\"});", (String)rule.getConsequence());
        FunctionDescr func = (FunctionDescr)pkg.getFunctions().get(0);
        Assertions.assertThat((String)func.getReturnType()).isEqualTo("String[]");
        Assertions.assertThat((String)((String)func.getParameterNames().get(0))).isEqualTo("args[]");
        Assertions.assertThat((String)((String)func.getParameterTypes().get(0))).isEqualTo("String");
    }

    @Test
    public void testAlmostEmptyRule() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "almost_empty_rule.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)pkg).isNotNull();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("almost_empty");
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assertions.assertThat((String)((String)rule.getConsequence()).trim()).isEqualTo("");
    }

    @Test
    public void testQuotedStringNameRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "quoted_string_name_rule.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("quoted string name");
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        Assertions.assertThat((String)((String)rule.getConsequence()).trim()).isEqualTo("");
    }

    @Test
    public void testNoLoop() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "no-loop.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule1");
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("no-loop");
        Assertions.assertThat((String)att.getValue()).isEqualTo("false");
        Assertions.assertThat((String)att.getName()).isEqualTo("no-loop");
    }

    @Test
    public void testAutofocus() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "autofocus.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule1");
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("auto-focus");
        Assertions.assertThat((String)att.getValue()).isEqualTo("true");
        Assertions.assertThat((String)att.getName()).isEqualTo("auto-focus");
    }

    @Test
    public void testRuleFlowGroup() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "ruleflowgroup.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule1");
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("ruleflow-group");
        Assertions.assertThat((String)att.getValue()).isEqualTo("a group");
        Assertions.assertThat((String)att.getName()).isEqualTo("ruleflow-group");
    }

    @Test
    public void testConsequenceWithDeclaration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "declaration-in-consequence.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("myrule");
        String expected = "int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;";
        this.assertEqualsIgnoreWhitespace("int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;", (String)rule.getConsequence());
        Assertions.assertThat((((String)rule.getConsequence()).indexOf("++") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((((String)rule.getConsequence()).indexOf("--") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((((String)rule.getConsequence()).indexOf("+=") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((((String)rule.getConsequence()).indexOf("==") > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testRuleParseLhs() throws Exception {
        String text = "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)((OrDescr)lhs.getDescrs().get(0)).getDescrs().size()).isEqualTo(2);
    }

    @Test
    public void testRuleParseLhsWithStringQuotes() throws Exception {
        String text = "rule X when Person( location==\"atlanta\\\"\") then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person( location==\"atlanta\\\"\") then end\n");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(0);
        Assertions.assertThat((String)constr.getText()).isEqualTo("location==\"atlanta\\\"\"");
    }

    @Test
    public void testRuleParseLhsWithStringQuotes2() throws Exception {
        String text = "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(1);
        Assertions.assertThat((String)constr.getText()).isEqualTo("type == \"s\\tti\\\"lto\\nn\"");
    }

    @Test
    public void testLiteralBoolAndNegativeNumbersRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "literal_bool_and_negative.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((Object)rule.getLhs()).isNotNull();
        this.assertEqualsIgnoreWhitespace("cons();", (String)rule.getConsequence());
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(3);
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr fieldAnd = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("bar == false");
        pattern = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assertions.assertThat((String)fld.getText()).isEqualTo("boo > -42");
        pattern = (PatternDescr)lhs.getDescrs().get(2);
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assertions.assertThat((String)fld.getText()).isEqualTo("boo > -42.42");
    }

    @Test
    public void testChunkWithoutParens() throws Exception {
        String input = "( foo )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assertions.assertThat((String)returnData).isEqualTo("foo");
    }

    @Test
    public void testChunkWithParens() throws Exception {
        String input = "(fnord())";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assertions.assertThat((String)returnData).isEqualTo("fnord()");
    }

    @Test
    public void testChunkWithParensAndQuotedString() throws Exception {
        String input = "( fnord( \"cheese\" ) )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assertions.assertThat((String)returnData).isEqualTo("fnord( \"cheese\" )");
    }

    @Test
    public void testChunkWithRandomCharac5ters() throws Exception {
        String input = "( %*9dkj)";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(37, 60, -1);
        Assertions.assertThat((String)returnData).isEqualTo("%*9dkj");
    }

    @Test
    public void testEmptyPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EmptyPattern.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)ruleDescr.getName()).isEqualTo("simple rule");
        Assertions.assertThat((Object)ruleDescr.getLhs()).isNotNull();
        Assertions.assertThat((int)ruleDescr.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr patternDescr = (PatternDescr)ruleDescr.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)patternDescr.getConstraint().getDescrs().size()).isEqualTo(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testSimpleMethodCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleMethodCallWithFrom.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr method = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)method.getExpression()).isEqualTo("something.doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )");
    }

    @Test
    public void testSimpleFunctionCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleFunctionCallWithFrom.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr func = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)func.getExpression()).isEqualTo("doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )");
    }

    @Test
    public void testSimpleAccessorWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorWithFrom.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)accessor.getExpression()).isEqualTo("something.doIt");
    }

    @Test
    public void testSimpleAccessorAndArgWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorArgWithFrom.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)accessor.getExpression()).isEqualTo("something.doIt[\"key\"]");
    }

    @Test
    public void testComplexChainedAcessor() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_ComplexChainedCallWithFrom.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        Assertions.assertThat((String)accessor.getExpression()).isEqualTo("doIt1( foo,bar,42,\"hello\",[ a : \"b\"], [a, \"b\", 42] ).doIt2(bar, [a, \"b\", 42]).field[\"key\"]");
    }

    @Test
    public void testFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "from.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrorMessages().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("using_from");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(9);
    }

    @Test
    public void testSimpleRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getConsequenceLine()).isEqualTo(22);
        Assertions.assertThat((int)rule.getConsequencePattern()).isEqualTo(2);
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(3);
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getIdentifier()).isEqualTo("foo3");
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)first.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr fieldAnd = (AndDescr)first.getConstraint();
        ExprConstraintDescr constraint = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        Assertions.assertThat((Object)constraint).isNotNull();
        Assertions.assertThat((String)constraint.getExpression()).isEqualTo("a==3");
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)second.getIdentifier()).isEqualTo("foo4");
        Assertions.assertThat((String)second.getObjectType()).isEqualTo("Bar");
        fieldAnd = (AndDescr)second.getConstraint();
        Assertions.assertThat((int)fieldAnd.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr binding = (ExprConstraintDescr)second.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)binding.getExpression()).isEqualTo("a4:a==4");
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assertions.assertThat((String)third.getIdentifier()).isNull();
        Assertions.assertThat((String)third.getObjectType()).isEqualTo("Baz");
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testRestrictionsMultiple() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "restrictions_test.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age > 30 && < 40");
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Vehicle");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(2);
        and = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type == \"sedan\" || == \"wagon\"");
        fld = (ExprConstraintDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age < 3");
    }

    @Test
    public void testLineNumberInAST() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getConsequenceLine()).isEqualTo(22);
        Assertions.assertThat((int)rule.getConsequencePattern()).isEqualTo(2);
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(3);
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getIdentifier()).isEqualTo("foo3");
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)first.getConstraint().getDescrs().size()).isEqualTo(1);
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)second.getIdentifier()).isEqualTo("foo4");
        Assertions.assertThat((String)second.getObjectType()).isEqualTo("Bar");
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assertions.assertThat((String)third.getObjectType()).isEqualTo("Baz");
        Assertions.assertThat((int)first.getLine()).isEqualTo(19);
        Assertions.assertThat((int)second.getLine()).isEqualTo(20);
        Assertions.assertThat((int)third.getLine()).isEqualTo(21);
    }

    @Test
    public void testLineNumberIncludingCommentsInRHS() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_CommentLineNumbersInConsequence.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        String rhs = (String)((RuleDescr)pkg.getRules().get(0)).getConsequence();
        String expected = "\\s*//woot$\\s*first$\\s*$\\s*//$\\s*$\\s*/\\* lala$\\s*$\\s*\\*/$\\s*second$\\s*";
        Assertions.assertThat((boolean)Pattern.compile(expected, 40).matcher(rhs).matches()).isTrue();
    }

    @Test
    public void testLhsSemicolonDelim() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "lhs_semicolon_delim.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(3);
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getIdentifier()).isEqualTo("foo3");
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)first.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((Object)fld).isNotNull();
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("a==3");
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)second.getIdentifier()).isEqualTo("foo4");
        Assertions.assertThat((String)second.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)second.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fieldBindingDescr = (ExprConstraintDescr)second.getDescrs().get(0);
        Assertions.assertThat((String)fieldBindingDescr.getExpression()).isEqualTo("a4:a==4");
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        Assertions.assertThat((String)third.getIdentifier()).isNull();
        Assertions.assertThat((String)third.getObjectType()).isEqualTo("Baz");
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testNotNode() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_not.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((int)not.getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type == \"stilton\"");
    }

    @Test
    public void testNotExistWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_exist_with_brackets.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(2);
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((int)not.getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
        ExistsDescr ex = (ExistsDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((int)ex.getDescrs().size()).isEqualTo(1);
        PatternDescr exPattern = (PatternDescr)ex.getDescrs().get(0);
        Assertions.assertThat((String)exPattern.getObjectType()).isEqualTo("Foo");
    }

    @Test
    public void testSimpleQuery() throws Exception {
        QueryDescr query = (QueryDescr)this.parseResource("query", "simple_query.drl");
        Assertions.assertThat((Object)query).isNotNull();
        Assertions.assertThat((String)query.getName()).isEqualTo("simple_query");
        AndDescr lhs = query.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(3);
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getIdentifier()).isEqualTo("foo3");
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)first.getConstraint().getDescrs().size()).isEqualTo(1);
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        Assertions.assertThat((Object)fld).isNotNull();
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("a==3");
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((String)second.getIdentifier()).isEqualTo("foo4");
        Assertions.assertThat((String)second.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((int)second.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr bindingDescr = (ExprConstraintDescr)second.getDescrs().get(0);
        Assertions.assertThat((String)bindingDescr.getExpression()).isEqualTo("a4:a==4");
    }

    @Test
    public void testQueryRuleMixed() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "query_and_rule.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(4);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("bar");
        QueryDescr query = (QueryDescr)pkg.getRules().get(1);
        Assertions.assertThat((String)query.getName()).isEqualTo("simple_query");
        rule = (RuleDescr)pkg.getRules().get(2);
        Assertions.assertThat((String)rule.getName()).isEqualTo("bar2");
        query = (QueryDescr)pkg.getRules().get(3);
        Assertions.assertThat((String)query.getName()).isEqualTo("simple_query2");
    }

    @Test
    public void testMultipleRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "multiple_rules.drl");
        List rules = pkg.getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(2);
        RuleDescr rule0 = (RuleDescr)rules.get(0);
        Assertions.assertThat((String)rule0.getName()).isEqualTo("Like Stilton");
        RuleDescr rule1 = (RuleDescr)rules.get(1);
        Assertions.assertThat((String)rule1.getName()).isEqualTo("Like Cheddar");
        AndDescr lhs = rule1.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule0.getConsequence());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Cheese");
        lhs = rule1.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule1.getConsequence());
        first = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testExpanderLineSpread() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_spread_lines.dslr"), this.getReader("complex.dsl"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as(parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testExpanderMultipleConstraints() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints.dslr"), this.getReader("multiple_constraints.dsl"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as(parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression()).isEqualTo("age < 42");
        Assertions.assertThat((String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression()).isEqualTo("location==atlanta");
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Bar");
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testExpanderMultipleConstraintsFlush() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL6);
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints_flush.dslr"), this.getReader("multiple_constraints.dsl"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parser.hasErrors()).as(parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression()).isEqualTo("age < 42");
        Assertions.assertThat((String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression()).isEqualTo("location==atlanta");
        Assertions.assertThat((String)((String)rule.getConsequence())).isNotNull();
    }

    @Test
    public void testBasicBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "basic_binding.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((int)cheese.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)cheese.getDescrs().get(0);
        Assertions.assertThat((String)fieldBinding.getExpression()).isEqualTo("$type:type");
    }

    @Test
    public void testBoundVariables() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "bindings.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(2);
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((int)cheese.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)cheese.getDescrs().get(0);
        Assertions.assertThat((String)fieldBinding.getExpression()).isEqualTo("$type : type == \"stilton\"");
        PatternDescr person = (PatternDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((int)person.getDescrs().size()).isEqualTo(2);
        fieldBinding = (ExprConstraintDescr)person.getDescrs().get(0);
        Assertions.assertThat((String)fieldBinding.getExpression()).isEqualTo("$name : name == \"bob\"");
        ExprConstraintDescr fld = (ExprConstraintDescr)person.getDescrs().get(1);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("likes == $type");
    }

    @Test
    public void testOrNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_nesting.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        PatternDescr first = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)first.getObjectType()).isEqualTo("Person");
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        Assertions.assertThat((int)and.getDescrs().size()).isEqualTo(2);
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        Assertions.assertThat((String)left.getObjectType()).isEqualTo("Person");
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)right.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testAndOrRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "and_or_rule.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        AndDescr and = rule.getLhs();
        Assertions.assertThat((int)and.getDescrs().size()).isEqualTo(3);
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)left.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)right.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((int)left.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("name == \"mark\"");
        Assertions.assertThat((int)right.getConstraint().getDescrs().size()).isEqualTo(1);
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type == \"stilton\"");
        OrDescr or = (OrDescr)and.getDescrs().get(2);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        left = (PatternDescr)or.getDescrs().get(0);
        right = (PatternDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)left.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)right.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((int)left.getConstraint().getDescrs().size()).isEqualTo(1);
        fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("name == \"mark\"");
        Assertions.assertThat((int)right.getConstraint().getDescrs().size()).isEqualTo(1);
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type == \"stilton\"");
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" );", (String)rule.getConsequence());
    }

    @Test
    public void testOrWithBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        PatternDescr leftPattern = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)leftPattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)leftPattern.getIdentifier()).isEqualTo("foo");
        PatternDescr rightPattern = (PatternDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)rightPattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)rightPattern.getIdentifier()).isEqualTo("foo");
        PatternDescr cheeseDescr = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)cheeseDescr.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)cheeseDescr.getIdentifier()).isEqualTo(null);
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingComplex() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_complex.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)firstFact.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)firstFact.getIdentifier()).isEqualTo("foo");
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)secondFact.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)secondFact.getConstraint().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((String)secondFact.getIdentifier()).isEqualTo("foo");
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_with_brackets.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)firstFact.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)firstFact.getIdentifier()).isEqualTo("foo");
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)secondFact.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)secondFact.getIdentifier()).isEqualTo("foo");
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testBracketsPrecedence() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "brackets_precedence.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr rootAnd = rule.getLhs();
        Assertions.assertThat((int)rootAnd.getDescrs().size()).isEqualTo(2);
        OrDescr leftOr = (OrDescr)rootAnd.getDescrs().get(0);
        Assertions.assertThat((int)leftOr.getDescrs().size()).isEqualTo(2);
        NotDescr not = (NotDescr)leftOr.getDescrs().get(0);
        PatternDescr foo1 = (PatternDescr)not.getDescrs().get(0);
        Assertions.assertThat((String)foo1.getObjectType()).isEqualTo("Foo");
        PatternDescr foo2 = (PatternDescr)leftOr.getDescrs().get(1);
        Assertions.assertThat((String)foo2.getObjectType()).isEqualTo("Foo");
        OrDescr rightOr = (OrDescr)rootAnd.getDescrs().get(1);
        Assertions.assertThat((int)rightOr.getDescrs().size()).isEqualTo(2);
        PatternDescr shoes = (PatternDescr)rightOr.getDescrs().get(0);
        Assertions.assertThat((String)shoes.getObjectType()).isEqualTo("Shoes");
        PatternDescr butt = (PatternDescr)rightOr.getDescrs().get(1);
        Assertions.assertThat((String)butt.getObjectType()).isEqualTo("Butt");
    }

    @Test
    public void testEvalMultiple() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_multiple.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(4);
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(0);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\") + 5", (String)eval.getContent());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Foo");
    }

    @Test
    public void testWithEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_eval.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(3);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Foo");
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Bar");
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(2);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\")", (String)eval.getContent());
        this.assertEqualsIgnoreWhitespace("Kapow", (String)rule.getConsequence());
    }

    @Test
    public void testWithRetval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_retval.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)col.getConstraint().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((String)col.getObjectType()).isEqualTo("Foo");
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("name== (a + b)");
    }

    @Test
    public void testWithPredicate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_predicate.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr and = (AndDescr)col.getConstraint();
        Assertions.assertThat((int)and.getDescrs().size()).isEqualTo(2);
        ExprConstraintDescr field = (ExprConstraintDescr)col.getDescrs().get(0);
        ExprConstraintDescr pred = (ExprConstraintDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)field.getExpression()).isEqualTo("$age2:age");
        this.assertEqualsIgnoreWhitespace("$age2 == $age1+2", pred.getExpression());
    }

    @Test
    public void testNotWithConstraint() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_with_constraint.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        ExprConstraintDescr fieldBinding = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fieldBinding.getExpression()).isEqualTo("$likes:like");
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        pattern = (PatternDescr)not.getDescrs().get(0);
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type == $likes");
    }

    @Test
    public void testFunctions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "functions.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(2);
        List functions = pkg.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(2);
        FunctionDescr func = (FunctionDescr)functions.get(0);
        Assertions.assertThat((String)func.getName()).isEqualTo("functionA");
        Assertions.assertThat((String)func.getReturnType()).isEqualTo("String");
        Assertions.assertThat((int)func.getParameterNames().size()).isEqualTo(2);
        Assertions.assertThat((int)func.getParameterTypes().size()).isEqualTo(2);
        Assertions.assertThat((int)func.getLine()).isEqualTo(19);
        Assertions.assertThat((int)func.getColumn()).isEqualTo(0);
        Assertions.assertThat((String)((String)func.getParameterTypes().get(0))).isEqualTo("String");
        Assertions.assertThat((String)((String)func.getParameterNames().get(0))).isEqualTo("s");
        Assertions.assertThat((String)((String)func.getParameterTypes().get(1))).isEqualTo("Integer");
        Assertions.assertThat((String)((String)func.getParameterNames().get(1))).isEqualTo("i");
        this.assertEqualsIgnoreWhitespace("foo();", func.getBody());
        func = (FunctionDescr)functions.get(1);
        Assertions.assertThat((String)func.getName()).isEqualTo("functionB");
        this.assertEqualsIgnoreWhitespace("bar();", func.getText());
    }

    @Test
    public void testComment() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "comment.drl");
        Assertions.assertThat((Object)pkg).isNotNull();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("foo.bar");
    }

    @Test
    public void testAttributes() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(6);
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assertions.assertThat((String)at.getName()).isEqualTo("salience");
        Assertions.assertThat((String)at.getValue()).isEqualTo("42");
        at = (AttributeDescr)attrs.get("agenda-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_group");
        at = (AttributeDescr)attrs.get("no-loop");
        Assertions.assertThat((String)at.getName()).isEqualTo("no-loop");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
        at = (AttributeDescr)attrs.get("duration");
        Assertions.assertThat((String)at.getName()).isEqualTo("duration");
        Assertions.assertThat((String)at.getValue()).isEqualTo("42");
        at = (AttributeDescr)attrs.get("activation-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("activation-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_activation_group");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
    }

    @Test
    public void testAttributes2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_attributes2.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        List rules = pkg.getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(3);
        RuleDescr rule = (RuleDescr)rules.get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule1");
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assertions.assertThat((String)at.getName()).isEqualTo("salience");
        Assertions.assertThat((String)at.getValue()).isEqualTo("(42)");
        at = (AttributeDescr)attrs.get("agenda-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_group");
        rule = (RuleDescr)rules.get(1);
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule2");
        attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        at = (AttributeDescr)attrs.get("salience");
        Assertions.assertThat((String)at.getName()).isEqualTo("salience");
        Assertions.assertThat((String)at.getValue()).isEqualTo("(Integer.MIN_VALUE)");
        at = (AttributeDescr)attrs.get("no-loop");
        Assertions.assertThat((String)at.getName()).isEqualTo("no-loop");
        rule = (RuleDescr)rules.get(2);
        Assertions.assertThat((String)rule.getName()).isEqualTo("rule3");
        attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        at = (AttributeDescr)attrs.get("enabled");
        Assertions.assertThat((String)at.getName()).isEqualTo("enabled");
        Assertions.assertThat((String)at.getValue()).isEqualTo("(Boolean.TRUE)");
        at = (AttributeDescr)attrs.get("activation-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("activation-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_activation_group");
    }

    @Test
    public void testAttributeRefract() throws Exception {
        String source = "rule Test refract when Person() then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule Test refract when Person() then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("Test");
        Map attributes = rule.getAttributes();
        Assertions.assertThat((int)attributes.size()).isEqualTo(1);
        AttributeDescr refract = (AttributeDescr)attributes.get("refract");
        Assertions.assertThat((Object)refract).isNotNull();
        Assertions.assertThat((String)refract.getValue()).isEqualTo("true");
    }

    @Test
    public void testEnabledExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_enabled_expression.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(3);
        AttributeDescr at = (AttributeDescr)attrs.get("enabled");
        Assertions.assertThat((String)at.getName()).isEqualTo("enabled");
        Assertions.assertThat((String)at.getValue()).isEqualTo("( 1 + 1 == 2 )");
        at = (AttributeDescr)attrs.get("salience");
        Assertions.assertThat((String)at.getName()).isEqualTo("salience");
        Assertions.assertThat((String)at.getValue()).isEqualTo("( 1+2 )");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
    }

    @Test
    public void testDurationExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_duration_expression.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        AttributeDescr at = (AttributeDescr)attrs.get("duration");
        Assertions.assertThat((String)at.getName()).isEqualTo("duration");
        Assertions.assertThat((String)at.getValue()).isEqualTo("1h30m");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
    }

    @Test
    public void testCalendars() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        Assertions.assertThat((String)at.getName()).isEqualTo("calendars");
        Assertions.assertThat((String)at.getValue()).isEqualTo("[ \"cal1\" ]");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
    }

    @Test
    public void testCalendars2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute2.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(2);
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        Assertions.assertThat((String)at.getName()).isEqualTo("calendars");
        Assertions.assertThat((String)at.getValue()).isEqualTo("[ \"cal 1\", \"cal 2\", \"cal 3\" ]");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
    }

    @Test
    public void testAttributes_alternateSyntax() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes_alt.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        Assertions.assertThat((int)attrs.size()).isEqualTo(6);
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        Assertions.assertThat((String)at.getName()).isEqualTo("salience");
        Assertions.assertThat((String)at.getValue()).isEqualTo("42");
        at = (AttributeDescr)attrs.get("agenda-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_group");
        at = (AttributeDescr)attrs.get("no-loop");
        Assertions.assertThat((String)at.getName()).isEqualTo("no-loop");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
        at = (AttributeDescr)attrs.get("lock-on-active");
        Assertions.assertThat((String)at.getName()).isEqualTo("lock-on-active");
        Assertions.assertThat((String)at.getValue()).isEqualTo("true");
        at = (AttributeDescr)attrs.get("duration");
        Assertions.assertThat((String)at.getName()).isEqualTo("duration");
        Assertions.assertThat((String)at.getValue()).isEqualTo("42");
        at = (AttributeDescr)attrs.get("activation-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("activation-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("my_activation_group");
    }

    @Test
    public void testEnumeration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "enumeration.drl");
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)col.getObjectType()).isEqualTo("Foo");
        Assertions.assertThat((int)col.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("bar == Foo.BAR");
    }

    @Test
    public void testExtraLhsNewline() throws Exception {
        this.parseResource("compilationUnit", "extra_lhs_newline.drl");
    }

    @Test
    public void testSoundsLike() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "soundslike_operator.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pat = (PatternDescr)rule.getLhs().getDescrs().get(0);
        pat.getConstraint();
    }

    @Test
    public void testPackageAttributes() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "package_attributes.drl");
        AttributeDescr at = (AttributeDescr)pkg.getAttributes().get(0);
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("x");
        at = (AttributeDescr)pkg.getAttributes().get(1);
        Assertions.assertThat((String)at.getName()).isEqualTo("dialect");
        Assertions.assertThat((String)at.getValue()).isEqualTo("java");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(2);
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(2);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("bar");
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("x");
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        Assertions.assertThat((String)at.getName()).isEqualTo("dialect");
        Assertions.assertThat((String)at.getValue()).isEqualTo("java");
        rule = (RuleDescr)pkg.getRules().get(1);
        Assertions.assertThat((String)rule.getName()).isEqualTo("baz");
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        Assertions.assertThat((String)at.getName()).isEqualTo("dialect");
        Assertions.assertThat((String)at.getValue()).isEqualTo("mvel");
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        Assertions.assertThat((String)at.getName()).isEqualTo("agenda-group");
        Assertions.assertThat((String)at.getValue()).isEqualTo("x");
    }

    @Test
    public void testStatementOrdering1() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "statement_ordering_1.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(2);
        Assertions.assertThat((String)((RuleDescr)pkg.getRules().get(0)).getName()).isEqualTo("foo");
        Assertions.assertThat((String)((RuleDescr)pkg.getRules().get(1)).getName()).isEqualTo("bar");
        Assertions.assertThat((int)pkg.getFunctions().size()).isEqualTo(2);
        Assertions.assertThat((String)((FunctionDescr)pkg.getFunctions().get(0)).getName()).isEqualTo("cheeseIt");
        Assertions.assertThat((String)((FunctionDescr)pkg.getFunctions().get(1)).getName()).isEqualTo("uncheeseIt");
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(4);
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(0)).getTarget()).isEqualTo("im.one");
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(1)).getTarget()).isEqualTo("im.two");
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(2)).getTarget()).isEqualTo("im.three");
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(3)).getTarget()).isEqualTo("im.four");
    }

    @Test
    public void testRuleNamesStartingWithNumbers() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_names_number_prefix.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(2);
        Assertions.assertThat((String)((RuleDescr)pkg.getRules().get(0)).getName()).isEqualTo("1. Do Stuff!");
        Assertions.assertThat((String)((RuleDescr)pkg.getRules().get(1)).getName()).isEqualTo("2. Do More Stuff!");
    }

    @Test
    public void testEvalWithNewline() throws Exception {
        this.parseResource("compilationUnit", "eval_with_newline.drl");
    }

    @Test
    public void testEndPosition() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EndPosition.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)col.getLine()).isEqualTo(21);
        Assertions.assertThat((int)col.getEndLine()).isEqualTo(23);
    }

    @Test
    public void testQualifiedClassname() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "qualified_classname.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr p = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)p.getObjectType()).isEqualTo("com.cheeseco.Cheese");
    }

    @Test
    public void testAccumulate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        Assertions.assertThat((String)accum.getReverseCode()).isNull();
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        Assertions.assertThat((boolean)accum.isExternalFunction()).isFalse();
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
    }

    @Test
    public void testAccumulateWithBindings() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_bindings.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
    }

    @Test
    public void testCollect() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)outPattern.getSource();
        PatternDescr pattern = collect.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
    }

    @Test
    public void testPredicate2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Foo(eval( $var.equals(\"xyz\") )) then end");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        List constraints = pattern.getConstraint().getDescrs();
        Assertions.assertThat((int)constraints.size()).isEqualTo(1);
        ExprConstraintDescr predicate = (ExprConstraintDescr)constraints.get(0);
        Assertions.assertThat((String)predicate.getExpression()).isEqualTo("eval( $var.equals(\"xyz\") )");
    }

    @Test
    public void testEscapedStrings() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "escaped-string.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        Assertions.assertThat((String)rule.getName()).isEqualTo("test_Quotes");
        String expected = "String s = \"\\\"\\n\\t\\\\\";";
        this.assertEqualsIgnoreWhitespace("String s = \"\\\"\\n\\t\\\\\";", (String)rule.getConsequence());
    }

    @Test
    public void testNestedCEs() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "nested_conditional_elements.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        AndDescr root = rule.getLhs();
        NotDescr not1 = (NotDescr)root.getDescrs().get(0);
        AndDescr and1 = (AndDescr)not1.getDescrs().get(0);
        PatternDescr state = (PatternDescr)and1.getDescrs().get(0);
        NotDescr not2 = (NotDescr)and1.getDescrs().get(1);
        AndDescr and2 = (AndDescr)not2.getDescrs().get(0);
        PatternDescr person = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and2.getDescrs().get(1);
        PatternDescr person2 = (PatternDescr)root.getDescrs().get(1);
        OrDescr or = (OrDescr)root.getDescrs().get(2);
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(0);
        PatternDescr cheese3 = (PatternDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)"State").isEqualTo(state.getObjectType());
        Assertions.assertThat((String)"Person").isEqualTo(person.getObjectType());
        Assertions.assertThat((String)"Cheese").isEqualTo(cheese.getObjectType());
        Assertions.assertThat((String)"Person").isEqualTo(person2.getObjectType());
        Assertions.assertThat((String)"Cheese").isEqualTo(cheese2.getObjectType());
        Assertions.assertThat((String)"Cheese").isEqualTo(cheese3.getObjectType());
    }

    @Test
    public void testForall() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forall.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)forall.getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = forall.getBasePattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        List remaining = forall.getRemainingPatterns();
        Assertions.assertThat((int)remaining.size()).isEqualTo(1);
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testForallWithFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forallwithfrom.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)forall.getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = forall.getBasePattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)((FromDescr)pattern.getSource()).getDataSource().toString()).isEqualTo("$village");
        List remaining = forall.getRemainingPatterns();
        Assertions.assertThat((int)remaining.size()).isEqualTo(1);
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)((FromDescr)cheese.getSource()).getDataSource().toString()).isEqualTo("$cheesery");
    }

    @Test
    public void testMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end")).getLhs();
        Assertions.assertThat((int)descrs.getDescrs().size()).isEqualTo(2);
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fieldConstr.getExpression()).isEqualTo("city memberOf $cities");
    }

    @Test
    public void testNotMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n")).getLhs();
        Assertions.assertThat((int)descrs.getDescrs().size()).isEqualTo(2);
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fieldConstr.getExpression()).isEqualTo("city not memberOf $cities");
    }

    @Test
    public void testInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "in_operator_test.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age > 30 && < 40");
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Vehicle");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(2);
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type in ( \"sedan\", \"wagon\" )");
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age < 3");
    }

    @Test
    public void testNotInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "notin_operator_test.drl");
        Assertions.assertThat((Object)rule).isNotNull();
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        Assertions.assertThat((String)rule.getName()).isEqualTo("simple_rule");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age > 30 && < 40");
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Vehicle");
        Assertions.assertThat((int)pattern.getConstraint().getDescrs().size()).isEqualTo(2);
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("type not in ( \"sedan\", \"wagon\" )");
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        Assertions.assertThat((String)fld.getExpression()).isEqualTo("age < 3");
    }

    @Test
    public void testCheckOrDescr() throws Exception {
        String text = "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        Assertions.assertThat(AndDescr.class).isEqualTo(pattern.getConstraint().getClass());
        Assertions.assertThat(((BaseDescr)pattern.getConstraint().getDescrs().get(0)).getClass()).isEqualTo(ExprConstraintDescr.class);
    }

    @Test
    public void testConstraintAndConnective() throws Exception {
        String text = "rule X when Person( age < 42 && location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 && location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("age < 42 && location==\"atlanta\"");
    }

    @Test
    public void testConstraintOrConnective() throws Exception {
        String text = "rule X when Person( age < 42 || location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 || location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("age < 42 || location==\"atlanta\"");
    }

    @Test
    public void testRestrictions() throws Exception {
        String text = "rule X when Foo( bar > 1 || == 1 ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Foo( bar > 1 || == 1 ) then end\n")).getLhs();
        Assertions.assertThat((int)descrs.getDescrs().size()).isEqualTo(1);
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fieldConstr.getExpression()).isEqualTo("bar > 1 || == 1");
    }

    @Test
    public void testSemicolon() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "semicolon.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools.mvel.compiler");
        Assertions.assertThat((int)pkg.getGlobals().size()).isEqualTo(1);
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(3);
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule1.getLhs().getDescrs().size()).isEqualTo(2);
        RuleDescr query1 = (RuleDescr)pkg.getRules().get(1);
        Assertions.assertThat((int)query1.getLhs().getDescrs().size()).isEqualTo(3);
        RuleDescr rule2 = (RuleDescr)pkg.getRules().get(2);
        Assertions.assertThat((int)rule2.getLhs().getDescrs().size()).isEqualTo(2);
    }

    @Test
    public void testEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_parsing.drl");
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools.mvel.compiler");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule1.getLhs().getDescrs().size()).isEqualTo(1);
    }

    @Test
    public void testAccumulateReverse() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateReverse.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("x--;", accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        Assertions.assertThat((boolean)accum.isExternalFunction()).isFalse();
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
    }

    @Test
    public void testAccumulateExternalFunction() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateExternalFunction.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("$age", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getParams()[0]);
        this.assertEqualsIgnoreWhitespace("average", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getFunction());
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
    }

    @Test
    public void testCollectWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect_with_nested_from.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)out.getSource();
        PatternDescr person = collect.getInputPattern();
        Assertions.assertThat((String)person.getObjectType()).isEqualTo("Person");
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        Assertions.assertThat((String)people.getObjectType()).isEqualTo("People");
    }

    @Test
    public void testAccumulateWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_nested_from.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accumulate = (AccumulateDescr)out.getSource();
        PatternDescr person = accumulate.getInputPattern();
        Assertions.assertThat((String)person.getObjectType()).isEqualTo("Person");
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        Assertions.assertThat((String)people.getObjectType()).isEqualTo("People");
    }

    @Test
    public void testAccumulateMultipleFunctions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateMultipleFunctions.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)out.getObjectType()).isEqualTo("Object");
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        List functions = accum.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(3);
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction()).isEqualTo("average");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind()).isEqualTo("$a1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]).isEqualTo("$price");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction()).isEqualTo("min");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind()).isEqualTo("$m1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]).isEqualTo("$price");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getFunction()).isEqualTo("max");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getBind()).isEqualTo("$M1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getParams()[0]).isEqualTo("$price");
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testAccumulateMnemonic() throws Exception {
        String drl = "package org.drools.mvel.compiler\nrule \"Accumulate 1\"\nwhen\n     acc( Cheese( $price : price ),\n          $a1 : average( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)out.getObjectType()).isEqualTo("Object");
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        List functions = accum.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction()).isEqualTo("average");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind()).isEqualTo("$a1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]).isEqualTo("$price");
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testAccumulateMnemonic2() throws Exception {
        String drl = "package org.drools.mvel.compiler\nrule \"Accumulate 1\"\nwhen\n     Number() from acc( Cheese( $price : price ),\n                        average( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)out.getObjectType()).isEqualTo("Number");
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        List functions = accum.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction()).isEqualTo("average");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]).isEqualTo("$price");
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testImportAccumulate() throws Exception {
        String drl = "package org.drools.mvel.compiler\nimport acc foo.Bar baz\nimport accumulate foo.Bar2 baz2\nrule \"Accumulate 1\"\nwhen\n     acc( Cheese( $price : price ),\n          $v1 : baz( $price ), \n          $v2 : baz2( $price ) )\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", drl);
        Assertions.assertThat((int)pkg.getAccumulateImports().size()).isEqualTo(2);
        AccumulateImportDescr imp = (AccumulateImportDescr)pkg.getAccumulateImports().get(0);
        Assertions.assertThat((String)imp.getTarget()).isEqualTo("foo.Bar");
        Assertions.assertThat((String)imp.getFunctionName()).isEqualTo("baz");
        imp = (AccumulateImportDescr)pkg.getAccumulateImports().get(1);
        Assertions.assertThat((String)imp.getTarget()).isEqualTo("foo.Bar2");
        Assertions.assertThat((String)imp.getFunctionName()).isEqualTo("baz2");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)out.getObjectType()).isEqualTo("Object");
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        List functions = accum.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(2);
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction()).isEqualTo("baz");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind()).isEqualTo("$v1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]).isEqualTo("$price");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction()).isEqualTo("baz2");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind()).isEqualTo("$v2");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]).isEqualTo("$price");
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testAccumulateMultipleFunctionsConstraint() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateMultipleFunctionsConstraint.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)out.getObjectType()).isEqualTo("Object");
        Assertions.assertThat((int)out.getConstraint().getDescrs().size()).isEqualTo(2);
        Assertions.assertThat((String)((BaseDescr)out.getConstraint().getDescrs().get(0)).toString()).isEqualTo("$a1 > 10 && $M1 <= 100");
        Assertions.assertThat((String)((BaseDescr)out.getConstraint().getDescrs().get(1)).toString()).isEqualTo("$m1 == 5");
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        Assertions.assertThat((boolean)accum.isExternalFunction()).isTrue();
        List functions = accum.getFunctions();
        Assertions.assertThat((int)functions.size()).isEqualTo(3);
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getFunction()).isEqualTo("average");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getBind()).isEqualTo("$a1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(0)).getParams()[0]).isEqualTo("$price");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getFunction()).isEqualTo("min");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getBind()).isEqualTo("$m1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(1)).getParams()[0]).isEqualTo("$price");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getFunction()).isEqualTo("max");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getBind()).isEqualTo("$M1");
        Assertions.assertThat((String)((AccumulateDescr.AccumulateFunctionCallDescr)functions.get(2)).getParams()[0]).isEqualTo("$price");
        PatternDescr pattern = accum.getInputPattern();
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testOrCE() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_ce.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(2);
        PatternDescr person = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)person.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)person.getIdentifier()).isEqualTo("$p");
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        PatternDescr cheese1 = (PatternDescr)or.getDescrs().get(0);
        Assertions.assertThat((String)cheese1.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)cheese1.getIdentifier()).isEqualTo("$c");
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(1);
        Assertions.assertThat((String)cheese2.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)cheese2.getIdentifier()).isNull();
    }

    @Test
    public void testRuleSingleLine() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end");
        Assertions.assertThat((String)rule.getName()).isEqualTo("another test");
        Assertions.assertThat((Object)rule.getConsequence()).isEqualTo((Object)"System.out.println(1); ");
    }

    @Test
    public void testRuleTwoLines() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end");
        Assertions.assertThat((String)rule.getName()).isEqualTo("another test");
        Assertions.assertThat((Object)rule.getConsequence()).isEqualTo((Object)"System.out.println(1);\n ");
    }

    @Test
    public void testRuleParseLhs3() throws Exception {
        String text = "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end";
        AndDescr pattern = ((RuleDescr)this.parse("rule", "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end")).getLhs();
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(2);
        NotDescr not = (NotDescr)or.getDescrs().get(0);
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        Assertions.assertThat((int)not.getDescrs().size()).isEqualTo(1);
        PatternDescr person = (PatternDescr)not.getDescrs().get(0);
        Assertions.assertThat((String)person.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((int)and.getDescrs().size()).isEqualTo(3);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(0);
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
        PatternDescr meat = (PatternDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)meat.getObjectType()).isEqualTo("Meat");
        PatternDescr wine = (PatternDescr)and.getDescrs().get(2);
        Assertions.assertThat((String)wine.getObjectType()).isEqualTo("Wine");
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_multi_pattern.drl");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        AndDescr and = (AndDescr)accum.getInput();
        Assertions.assertThat((int)and.getDescrs().size()).isEqualTo(2);
        PatternDescr person = (PatternDescr)and.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(1);
        Assertions.assertThat((String)person.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((String)cheese.getObjectType()).isEqualTo("Cheese");
    }

    @Test
    public void testPluggableOperators() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "pluggable_operators.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(5);
        PatternDescr eventA = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)eventA.getIdentifier()).isEqualTo("$a");
        Assertions.assertThat((String)eventA.getObjectType()).isEqualTo("EventA");
        PatternDescr eventB = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)eventB.getIdentifier()).isEqualTo("$b");
        Assertions.assertThat((String)eventB.getObjectType()).isEqualTo("EventB");
        Assertions.assertThat((int)eventB.getConstraint().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)eventB.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcdB = (ExprConstraintDescr)eventB.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fcdB.getExpression()).isEqualTo("this after[1,10] $a || this not after[15,20] $a");
        PatternDescr eventC = (PatternDescr)rule.getLhs().getDescrs().get(2);
        Assertions.assertThat((String)eventC.getIdentifier()).isEqualTo("$c");
        Assertions.assertThat((String)eventC.getObjectType()).isEqualTo("EventC");
        Assertions.assertThat((int)eventC.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcdC = (ExprConstraintDescr)eventC.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fcdC.getExpression()).isEqualTo("this finishes $b");
        PatternDescr eventD = (PatternDescr)rule.getLhs().getDescrs().get(3);
        Assertions.assertThat((String)eventD.getIdentifier()).isEqualTo("$d");
        Assertions.assertThat((String)eventD.getObjectType()).isEqualTo("EventD");
        Assertions.assertThat((int)eventD.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcdD = (ExprConstraintDescr)eventD.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fcdD.getExpression()).isEqualTo("this not starts $a");
        PatternDescr eventE = (PatternDescr)rule.getLhs().getDescrs().get(4);
        Assertions.assertThat((String)eventE.getIdentifier()).isEqualTo("$e");
        Assertions.assertThat((String)eventE.getObjectType()).isEqualTo("EventE");
        Assertions.assertThat((int)eventE.getConstraint().getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcdE = (ExprConstraintDescr)eventE.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)fcdE.getExpression()).isEqualTo("this not before[1, 10] $b || after[1, 10] $c && this after[1, 5] $d");
    }

    @Test
    public void testRuleMetadata() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Metadata.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((boolean)rule.getAnnotationNames().contains("fooMeta1")).isTrue();
        Assertions.assertThat((Object)rule.getAnnotation("fooMeta1").getValue()).isEqualTo((Object)"barVal1");
        Assertions.assertThat((boolean)rule.getAnnotationNames().contains("fooMeta2")).isTrue();
        Assertions.assertThat((Object)rule.getAnnotation("fooMeta2").getValue()).isEqualTo((Object)"barVal2");
        this.assertEqualsIgnoreWhitespace("System.out.println(\"Consequence\");", (String)rule.getConsequence());
    }

    @Test
    public void testRuleExtends() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Extends.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((rule.getParentName() != null ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)rule.getParentName()).isEqualTo("rule1");
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(1);
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("foo");
        Assertions.assertThat((String)pattern.getIdentifier()).isEqualTo("$foo");
    }

    @Test
    public void testTypeDeclarationWithFields() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "declare_type_with_fields.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        List td = pkg.getTypeDeclarations();
        Assertions.assertThat((int)td.size()).isEqualTo(3);
        TypeDeclarationDescr d = (TypeDeclarationDescr)td.get(0);
        Assertions.assertThat((String)d.getTypeName()).isEqualTo("SomeFact");
        Assertions.assertThat((int)d.getFields().size()).isEqualTo(2);
        Assertions.assertThat((boolean)d.getFields().containsKey("name")).isTrue();
        Assertions.assertThat((boolean)d.getFields().containsKey("age")).isTrue();
        TypeFieldDescr f = (TypeFieldDescr)d.getFields().get("name");
        Assertions.assertThat((String)f.getPattern().getObjectType()).isEqualTo("String");
        f = (TypeFieldDescr)d.getFields().get("age");
        Assertions.assertThat((String)f.getPattern().getObjectType()).isEqualTo("Integer");
        d = (TypeDeclarationDescr)td.get(1);
        Assertions.assertThat((String)d.getTypeName()).isEqualTo("AnotherFact");
        TypeDeclarationDescr type = (TypeDeclarationDescr)td.get(2);
        Assertions.assertThat((String)type.getTypeName()).isEqualTo("Person");
        Assertions.assertThat((Object)type.getAnnotation("role").getValue()).isEqualTo((Object)"fact");
        Assertions.assertThat((Object)type.getAnnotation("doc").getValue("descr")).isEqualTo((Object)"\"Models a person\"");
        Assertions.assertThat((Object)type.getAnnotation("doc").getValue("author")).isEqualTo((Object)"\"Bob\"");
        Assertions.assertThat((Object)type.getAnnotation("doc").getValue("date")).isEqualTo((Object)"Calendar.getInstance().getDate()");
        Assertions.assertThat((int)type.getFields().size()).isEqualTo(2);
        TypeFieldDescr field = (TypeFieldDescr)type.getFields().get("name");
        Assertions.assertThat((String)field.getFieldName()).isEqualTo("name");
        Assertions.assertThat((String)field.getPattern().getObjectType()).isEqualTo("String");
        Assertions.assertThat((String)field.getInitExpr()).isEqualTo("\"John Doe\"");
        Assertions.assertThat((Object)field.getAnnotation("length").getValue("max")).isEqualTo((Object)"50");
        Assertions.assertThat((Object)field.getAnnotation("key")).isNotNull();
        field = (TypeFieldDescr)type.getFields().get("age");
        Assertions.assertThat((String)field.getFieldName()).isEqualTo("age");
        Assertions.assertThat((String)field.getPattern().getObjectType()).isEqualTo("int");
        Assertions.assertThat((String)field.getInitExpr()).isEqualTo("-1");
        Assertions.assertThat((Object)field.getAnnotation("ranged").getValue("min")).isEqualTo((Object)"0");
        Assertions.assertThat((Object)field.getAnnotation("ranged").getValue("max")).isEqualTo((Object)"150");
        Assertions.assertThat((Object)field.getAnnotation("ranged").getValue("unknown")).isEqualTo((Object)"-1");
    }

    @Test
    public void testRuleWithLHSNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_nested_LHS.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("test");
        AndDescr lhs = rule.getLhs();
        Assertions.assertThat((Object)lhs).isNotNull();
        Assertions.assertThat((int)lhs.getDescrs().size()).isEqualTo(2);
        PatternDescr a = (PatternDescr)lhs.getDescrs().get(0);
        Assertions.assertThat((String)a.getObjectType()).isEqualTo("A");
        OrDescr or = (OrDescr)lhs.getDescrs().get(1);
        Assertions.assertThat((int)or.getDescrs().size()).isEqualTo(3);
        AndDescr and1 = (AndDescr)or.getDescrs().get(0);
        Assertions.assertThat((int)and1.getDescrs().size()).isEqualTo(2);
        PatternDescr b = (PatternDescr)and1.getDescrs().get(0);
        PatternDescr c = (PatternDescr)and1.getDescrs().get(1);
        Assertions.assertThat((String)b.getObjectType()).isEqualTo("B");
        Assertions.assertThat((String)c.getObjectType()).isEqualTo("C");
        AndDescr and2 = (AndDescr)or.getDescrs().get(1);
        Assertions.assertThat((int)and2.getDescrs().size()).isEqualTo(2);
        PatternDescr d = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr e = (PatternDescr)and2.getDescrs().get(1);
        Assertions.assertThat((String)d.getObjectType()).isEqualTo("D");
        Assertions.assertThat((String)e.getObjectType()).isEqualTo("E");
        AndDescr and3 = (AndDescr)or.getDescrs().get(2);
        Assertions.assertThat((int)and3.getDescrs().size()).isEqualTo(2);
        PatternDescr f = (PatternDescr)and3.getDescrs().get(0);
        PatternDescr g = (PatternDescr)and3.getDescrs().get(1);
        Assertions.assertThat((String)f.getObjectType()).isEqualTo("F");
        Assertions.assertThat((String)g.getObjectType()).isEqualTo("G");
    }

    @Test
    public void testEntryPoint() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("symbol==\"ACME\"");
        Assertions.assertThat((Object)pattern.getSource()).isNotNull();
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        Assertions.assertThat((String)entry.getEntryId()).isEqualTo("StreamA");
    }

    @Test
    public void testEntryPoint2() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("symbol==\"ACME\"");
        Assertions.assertThat((Object)pattern.getSource()).isNotNull();
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        Assertions.assertThat((String)entry.getEntryId()).isEqualTo("StreamA");
    }

    @Test
    public void testSlidingWindow() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("symbol==\"ACME\"");
        List behaviors = pattern.getBehaviors();
        Assertions.assertThat((List)behaviors).isNotNull();
        Assertions.assertThat((int)behaviors.size()).isEqualTo(1);
        BehaviorDescr descr = (BehaviorDescr)behaviors.get(0);
        Assertions.assertThat((String)descr.getType()).isEqualTo("window");
        Assertions.assertThat((String)descr.getSubType()).isEqualTo("length");
        Assertions.assertThat((String)((String)descr.getParameters().get(0))).isEqualTo("10");
    }

    @Test
    public void testRuleOldSyntax1() throws Exception {
        String source = "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("Test");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        Assertions.assertThat((int)((NotDescr)rule.getLhs().getDescrs().get(0)).getDescrs().size()).isEqualTo(1);
        NotDescr notDescr = (NotDescr)rule.getLhs().getDescrs().get(0);
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isEqualTo("$r");
        Assertions.assertThat((int)patternDescr.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        Assertions.assertThat((String)fieldConstraintDescr.getExpression()).isEqualTo("operator == Operator.EQUAL");
    }

    @Test
    public void testRuleOldSyntax2() throws Exception {
        String source = "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rule.getName()).isEqualTo("Test");
        Assertions.assertThat((int)rule.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr patternDescr = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isEqualTo("$r");
        Assertions.assertThat((int)patternDescr.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        Assertions.assertThat((String)fieldConstraintDescr.getExpression()).isEqualTo("operator == Operator.EQUAL");
    }

    @Test
    public void testTypeWithMetaData() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "type_with_meta.drl");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        List declarations = pkg.getTypeDeclarations();
        Assertions.assertThat((int)declarations.size()).isEqualTo(3);
    }

    @Test
    public void testNullConstraints() throws Exception {
        String text = "rule X when Person( name == null ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( name == null ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(1);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("name == null");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(0);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
    }

    @Test
    public void testPositionalConstraintsOnly() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(2);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("\"Mark\"");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(0);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("42");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(1);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
    }

    @Test
    public void testIsQuery() throws Exception {
        String text = "rule X when ?person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when ?person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((boolean)pattern.isQuery()).isTrue();
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(2);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("\"Mark\"");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(0);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("42");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(1);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
    }

    @Test
    public void testFromFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)pattern.getSource().getText()).isEqualTo("from $cheesery");
        Assertions.assertThat((boolean)pattern.isQuery()).isFalse();
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("person");
        Assertions.assertThat((boolean)pattern.isQuery()).isTrue();
    }

    @Test
    public void testFromWithTernaryFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.parser.hasErrors()).as(this.parser.getErrors().toString(), new Object[0])).isFalse();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Cheese");
        Assertions.assertThat((String)pattern.getSource().getText()).isEqualTo("from (isFull ? $cheesery : $market)");
        Assertions.assertThat((boolean)pattern.isQuery()).isFalse();
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("person");
        Assertions.assertThat((boolean)pattern.isQuery()).isTrue();
    }

    @Test
    public void testMultiValueAnnotationsBackwardCompatibility() throws Exception {
        String text = "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end");
        AnnotationDescr ann = rule.getAnnotation("ann1");
        Assertions.assertThat((Object)ann).isNotNull();
        Assertions.assertThat((Object)ann.getValue()).isEqualTo((Object)"val1, val2");
        ann = rule.getAnnotation("ann2");
        Assertions.assertThat((Object)ann).isNotNull();
        Assertions.assertThat((Object)ann.getValue()).isEqualTo((Object)"\"val1\", \"val2\"");
    }

    @Test
    public void testPositionalsAndNamedConstraints() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(3);
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("\"Mark\"");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(0);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("42");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(1);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.POSITIONAL);
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(2);
        Assertions.assertThat((String)fcd.getExpression()).isEqualTo("location == \"atlanta\"");
        Assertions.assertThat((int)fcd.getPosition()).isEqualTo(2);
        Assertions.assertThat((Comparable)fcd.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
    }

    @Test
    public void testUnificationBinding() throws Exception {
        String text = "rule X when $p := Person( $name := name, $loc : location ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when $p := Person( $name := name, $loc : location ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getIdentifier()).isEqualTo("$p");
        Assertions.assertThat((boolean)pattern.isUnification()).isTrue();
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(2);
        ExprConstraintDescr bindingDescr = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)bindingDescr.getExpression()).isEqualTo("$name := name");
        bindingDescr = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assertions.assertThat((String)bindingDescr.getExpression()).isEqualTo("$loc : location");
    }

    @Test
    public void testBigLiterals() throws Exception {
        String text = "rule X when Primitives( bigInteger == (10I),                         bigDecimal == (10B),                         bigInteger < 50I,                         bigDecimal < 50B ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Primitives( bigInteger == (10I),                         bigDecimal == (10B),                         bigInteger < 50I,                         bigDecimal < 50B ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((int)pattern.getDescrs().size()).isEqualTo(4);
        ExprConstraintDescr ecd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        Assertions.assertThat((String)ecd.getExpression()).isEqualTo("bigInteger == (10I)");
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        Assertions.assertThat((String)ecd.getExpression()).isEqualTo("bigDecimal == (10B)");
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(2);
        Assertions.assertThat((String)ecd.getExpression()).isEqualTo("bigInteger < 50I");
        ecd = (ExprConstraintDescr)pattern.getDescrs().get(3);
        Assertions.assertThat((String)ecd.getExpression()).isEqualTo("bigDecimal < 50B");
    }

    @Test
    public void testBindingComposite() throws Exception {
        String text = "rule X when Person( $name : name == \"Bob\" || $loc : location == \"Montreal\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( $name : name == \"Bob\" || $loc : location == \"Montreal\" ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((boolean)pattern.isUnification()).isFalse();
        List constraints = pattern.getDescrs();
        Assertions.assertThat((int)constraints.size()).isEqualTo(1);
        Assertions.assertThat((String)((ExprConstraintDescr)constraints.get(0)).getExpression()).isEqualTo("$name : name == \"Bob\" || $loc : location == \"Montreal\"");
    }

    @Test
    public void testBindingCompositeWithMethods() throws Exception {
        String text = "rule X when Person( $name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( $name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\" ) then end")).getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        Assertions.assertThat((boolean)pattern.isUnification()).isFalse();
        List constraints = pattern.getDescrs();
        Assertions.assertThat((int)constraints.size()).isEqualTo(1);
        Assertions.assertThat((String)((ExprConstraintDescr)constraints.get(0)).getExpression()).isEqualTo("$name : name.toUpperCase() == \"Bob\" || $loc : location[0].city == \"Montreal\"");
    }

    @Test
    public void testPluggableOperators2() throws Exception {
        String text = "rule \"tt\"\n    dialect \"mvel\"\nwhen\n    exists (TelephoneCall( this finishes [1m] \"25-May-2011\" ))\nthen\nend";
        PatternDescr pattern = (PatternDescr)((ExistsDescr)((RuleDescr)this.parse("rule", "rule \"tt\"\n    dialect \"mvel\"\nwhen\n    exists (TelephoneCall( this finishes [1m] \"25-May-2011\" ))\nthen\nend")).getLhs().getDescrs().get(0)).getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("TelephoneCall");
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)constr.getText()).isEqualTo("this finishes [1m] \"25-May-2011\"");
    }

    @Test
    public void testInlineEval() throws Exception {
        String text = "rule \"inline eval\"\nwhen\n    Person( eval( name.startsWith(\"b\") && name.finishesWith(\"b\")) )\nthen\nend";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule \"inline eval\"\nwhen\n    Person( eval( name.startsWith(\"b\") && name.finishesWith(\"b\")) )\nthen\nend")).getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("Person");
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)constr.getText()).isEqualTo("eval( name.startsWith(\"b\") && name.finishesWith(\"b\"))");
    }

    @Test
    public void testInfinityLiteral() throws Exception {
        String text = "rule \"infinity\"\nwhen\n    StockTick( this after[-*,*] $another )\nthen\nend";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule \"infinity\"\nwhen\n    StockTick( this after[-*,*] $another )\nthen\nend")).getLhs().getDescrs().get(0);
        Assertions.assertThat((String)pattern.getObjectType()).isEqualTo("StockTick");
        ExprConstraintDescr constr = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        Assertions.assertThat((String)constr.getText()).isEqualTo("this after[-*,*] $another");
    }

    @Test
    public void testEntryPointDeclaration() throws Exception {
        String text = "package org.drools\ndeclare entry-point eventStream\n    @source(\"jndi://queues/events\")\n    @foo( true )\nend";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\ndeclare entry-point eventStream\n    @source(\"jndi://queues/events\")\n    @foo( true )\nend");
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools");
        Assertions.assertThat((int)pkg.getEntryPointDeclarations().size()).isEqualTo(1);
        EntryPointDeclarationDescr epd = (EntryPointDeclarationDescr)pkg.getEntryPointDeclarations().iterator().next();
        Assertions.assertThat((String)epd.getEntryPointId()).isEqualTo("eventStream");
        Assertions.assertThat((int)epd.getAnnotations().size()).isEqualTo(2);
        Assertions.assertThat((Object)epd.getAnnotation("source").getValue()).isEqualTo((Object)"\"jndi://queues/events\"");
        Assertions.assertThat((Object)epd.getAnnotation("foo").getValue()).isEqualTo((Object)"true");
    }

    @Test
    public void testWindowDeclaration() throws Exception {
        String text = "package org.drools\ndeclare window Ticks\n    @doc(\"last 10 stock ticks\")\n    $s : StockTick( source == \"NYSE\" )\n        over window:length( 10, $s.symbol )\n        from entry-point stStream\nend";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\ndeclare window Ticks\n    @doc(\"last 10 stock ticks\")\n    $s : StockTick( source == \"NYSE\" )\n        over window:length( 10, $s.symbol )\n        from entry-point stStream\nend");
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools");
        Assertions.assertThat((int)pkg.getWindowDeclarations().size()).isEqualTo(1);
        WindowDeclarationDescr wdd = (WindowDeclarationDescr)pkg.getWindowDeclarations().iterator().next();
        Assertions.assertThat((String)wdd.getName()).isEqualTo("Ticks");
        Assertions.assertThat((int)wdd.getAnnotations().size()).isEqualTo(1);
        Assertions.assertThat((Object)wdd.getAnnotation("doc").getValue()).isEqualTo((Object)"\"last 10 stock ticks\"");
        PatternDescr pd = wdd.getPattern();
        Assertions.assertThat((Object)pd).isNotNull();
        Assertions.assertThat((String)pd.getIdentifier()).isEqualTo("$s");
        Assertions.assertThat((String)pd.getObjectType()).isEqualTo("StockTick");
        Assertions.assertThat((String)pd.getSource().getText()).isEqualTo("stStream");
        Assertions.assertThat((int)pd.getBehaviors().size()).isEqualTo(1);
        BehaviorDescr bd = (BehaviorDescr)pd.getBehaviors().get(0);
        Assertions.assertThat((String)bd.getType()).isEqualTo("window");
        Assertions.assertThat((String)bd.getSubType()).isEqualTo("length");
        Assertions.assertThat((int)bd.getParameters().size()).isEqualTo(2);
        Assertions.assertThat((String)((String)bd.getParameters().get(0))).isEqualTo("10");
        Assertions.assertThat((String)((String)bd.getParameters().get(1))).isEqualTo("$s.symbol");
    }

    @Test
    public void testWindowUsage() throws Exception {
        String text = "package org.drools\nrule X\nwhen\n    StockTick() from window Y\nthen\nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package org.drools\nrule X\nwhen\n    StockTick() from window Y\nthen\nend\n");
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools");
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        RuleDescr rd = (RuleDescr)pkg.getRules().get(0);
        Assertions.assertThat((String)rd.getName()).isEqualTo("X");
        Assertions.assertThat((int)rd.getLhs().getDescrs().size()).isEqualTo(1);
        PatternDescr pd = (PatternDescr)rd.getLhs().getDescrs().get(0);
        Assertions.assertThat((Object)pd).isNotNull();
        Assertions.assertThat((String)pd.getObjectType()).isEqualTo("StockTick");
        Assertions.assertThat((String)pd.getSource().getText()).isEqualTo("Y");
    }

    private Object parse(String parserRuleName, String text) throws Exception {
        return this.execParser(parserRuleName, (CharStream)new ANTLRStringStream(text));
    }

    private Object parseResource(String parserRuleName, String name) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(parserRuleName, text.toString());
    }

    public Object execParser(String testRuleName, CharStream charStream) {
        try {
            this.createParser(charStream);
            Method ruleName = null;
            Object[] params = null;
            for (Method method : DRL6Parser.class.getMethods()) {
                if (!method.getName().equals(testRuleName)) continue;
                ruleName = method;
                Class<?>[] parameterTypes = method.getParameterTypes();
                params = new Object[parameterTypes.length];
            }
            Object ruleReturn = ruleName.invoke((Object)this.parser, params);
            if (this.parser.hasErrors()) {
                System.out.println(this.parser.getErrorMessages());
            }
            return ruleReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
            return null;
        }
    }

    private void createParser(CharStream charStream) {
        this.parser = DRLFactory.buildParser((CharStream)charStream, (LanguageLevelOption)LanguageLevelOption.DRL6);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)actual);
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }
}

