/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.net.URL;
import java.net.URLClassLoader;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;

public class KieRepositoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadKjarFromClasspath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/kie-project-simple-1.0.0.jar")});
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kieRepository = ks.getRepository();
            ReleaseId releaseId = ks.newReleaseId("org.test", "kie-project-simple", "1.0.0");
            KieModule kieModule = kieRepository.getKieModule(releaseId);
            Assertions.assertThat((Object)kieModule).isNotNull();
            Assertions.assertThat((Comparable)kieModule.getReleaseId()).isEqualTo((Object)releaseId);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryLoadNotExistingKjarFromClasspath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/kie-project-simple-1.0.0.jar")});
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kieRepository = ks.getRepository();
            ReleaseId releaseId = ks.newReleaseId("org.test", "kie-project-simple", "1.0.1");
            KieModule kieModule = kieRepository.getKieModule(releaseId);
            Assertions.assertThat((Object)kieModule).isNull();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadingNotAKJar() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/only-jar-pojo-not-kjar-no-kmodule-1.0.0.jar")});
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kieRepository = ks.getRepository();
            ReleaseId releaseId = ks.newReleaseId("org.test", "only-jar-pojo-not-kjar-no-kmodule", "1.0.0");
            KieModule kieModule = kieRepository.getKieModule(releaseId);
            Assertions.assertThat((Object)kieModule).isNull();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

