/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.dsl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.lang.dsl.DSLMapping;
import org.drools.drl.parser.lang.dsl.DSLMappingEntry;
import org.drools.drl.parser.lang.dsl.DSLTokenizedMappingFile;
import org.drools.drl.parser.lang.dsl.DefaultDSLMapping;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.junit.Test;

public class DSLMappingEntryTest {
    private static final String lookbehind = "(?:(?<=^)|(?<=\\W))";
    private static final String NL = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSLMappingEntry createEntry(String inputKey, String inputValue) throws IOException {
        DSLMappingEntry entry;
        block4: {
            String mapping = "[condition][]" + inputKey + "=" + inputValue;
            entry = null;
            try (StringReader dsl = new StringReader(mapping);){
                DSLTokenizedMappingFile parser = new DSLTokenizedMappingFile();
                if (parser.parseAndLoad((Reader)dsl)) {
                    entry = (DSLMappingEntry)parser.getMapping().getEntries().get(0);
                    break block4;
                }
                throw new RuntimeException("Error parsing entry: " + mapping + ": " + parser.getErrors().toString());
            }
        }
        return entry;
    }

    @Test
    public void testPatternCalculation() throws IOException {
        String inputKey = "The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}";
        String inputValue = "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )";
        String expectedKeyP = "(?:(?<=^)|(?<=\\W))The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$";
        String expectedValP = "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )";
        DSLMappingEntry entry = this.createEntry("The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}", "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )");
        Assertions.assertThat((String)entry.getMappingKey()).isEqualTo("The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}");
        Assertions.assertThat((String)entry.getKeyPattern().pattern()).isEqualTo("(?:(?<=^)|(?<=\\W))The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$");
        Assertions.assertThat((String)entry.getMappingValue()).isEqualTo("Customer( name == \"{name}\", surname == \"{surname}\", money > $money )");
        Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("Customer( name == \"{name}\", surname == \"{surname}\", money > $money )");
    }

    @Test
    public void testPatternCalculation2() throws IOException {
        String inputKey = "-name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(?:(?<=^)|(?<=\\W))-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "name == \"{name}\"";
        DSLMappingEntry entry = this.createEntry("-name is {name}", "name == \"{name}\"");
        Assertions.assertThat((String)entry.getMappingKey()).isEqualTo("-name is {name}");
        Assertions.assertThat((String)entry.getKeyPattern().pattern()).isEqualTo("(?:(?<=^)|(?<=\\W))-\\s*name\\s+is\\s+(.*?)$");
        Assertions.assertThat((String)entry.getMappingValue()).isEqualTo("name == \"{name}\"");
        Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("name == \"{name}\"");
    }

    @Test
    public void testPatternCalculation3() throws IOException {
        String inputKey = "- name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(?:(?<=^)|(?<=\\W))-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "name == \"{name}\"";
        DSLMappingEntry entry = this.createEntry("- name is {name}", "name == \"{name}\"");
        Assertions.assertThat((String)entry.getMappingKey()).isEqualTo("- name is {name}");
        ((AbstractStringAssert)Assertions.assertThat((String)entry.getKeyPattern().pattern()).as(entry.getKeyPattern().pattern(), new Object[0])).isEqualTo("(?:(?<=^)|(?<=\\W))-\\s*name\\s+is\\s+(.*?)$");
        Assertions.assertThat((String)entry.getMappingValue()).isEqualTo("name == \"{name}\"");
        Assertions.assertThat((String)entry.getValuePattern()).isEqualTo("name == \"{name}\"");
    }

    private DSLMappingEntry setupEntry() throws IOException {
        String inputKey = "String is \"{value}\"";
        String inputValue = "SomeFact(value==\"{value}\")";
        return this.createEntry("String is \"{value}\"", "SomeFact(value==\"{value}\")");
    }

    private DefaultExpander makeExpander(DSLMappingEntry ... entries) {
        DefaultExpander expander = new DefaultExpander();
        DefaultDSLMapping mapping = new DefaultDSLMapping();
        for (DSLMappingEntry entry : entries) {
            mapping.addEntry(entry);
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("result");
        options.add("when");
        options.add("steps");
        mapping.setOptions(options);
        expander.addDSLMapping((DSLMapping)mapping);
        return expander;
    }

    @Test
    public void testExpandSpaces() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        DefaultExpander ex = this.makeExpander(entry);
        String[] strs = new String[]{"0_sp", " 1_sp", "   3_sp", "0_sp_1 ", "0_sp_3   ", "0_sp 1_sp 2_sp", "   3_sp   3_sp 1_sp 1_sp_2  "};
        StringBuilder sb = new StringBuilder("rule x\nwhen\n");
        for (String str : strs) {
            sb.append("String is \"" + str + "\"" + NL);
        }
        sb.append("then\nend\n");
        String dslr = sb.toString();
        String drl = ex.expand(dslr);
        for (String str : strs) {
            Assertions.assertThat((boolean)drl.contains("\"" + str + "\"")).isTrue();
        }
    }

    @Test
    public void testExpandWithDots() throws IOException {
        DSLMappingEntry entry1 = this.createEntry("- {prop} is not {val} ", "{prop} != {val}");
        DSLMappingEntry entry2 = this.createEntry("- {prop} is {val} ", "{prop} == {val}");
        DSLMappingEntry entry3 = this.createEntry("- {prop} is_not {val} ", "{prop} != {val}");
        DefaultExpander ex = this.makeExpander(entry1, entry2, entry3);
        StringBuilder sb = new StringBuilder("rule x\n").append("when\n");
        sb.append("> Foo()").append(NL);
        sb.append("- type1 is ClientServiceType.TypeGOLD").append(NL);
        sb.append("- type2 is_not ClientServiceType.TypeGOLD").append(NL);
        sb.append("- type3 is not ClientServiceType.TypeGOLD").append(NL);
        sb.append("then\n").append("end\n");
        String dslr = sb.toString();
        String drl = ex.expand(dslr);
        System.out.println(dslr);
        System.out.println(drl);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)drl.contains("type1 == ClientServiceType.TypeGOLD")).as("failure type1", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)drl.contains("type2 != ClientServiceType.TypeGOLD")).as("failure type2", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)drl.contains("type3 != ClientServiceType.TypeGOLD")).as("failure type3", new Object[0])).isTrue();
    }

    @Test
    public void testExpandWithBrackets() throws IOException {
        DSLMappingEntry entry1 = this.createEntry("attr {attr_name} is in \\[ {values} \\]", "{attr_name} in ( {values} )");
        DSLMappingEntry entry2 = this.createEntry("((H|h)e|(S|s)he) \\(is\\) (a|an) $xx {attribute} (man|woman)", "Person( attribute == \"{attribute}\" )");
        DSLMappingEntry entry3 = this.createEntry("DSL sentence with {key1} {key2}", "Sentence( {key1} == {key2} )");
        DSLMappingEntry entry4 = this.createEntry("When the credit rating is {rating:ENUM:Applicant.creditRating}", "applicant:Applicant(credit=={rating})");
        DSLMappingEntry entry5 = this.createEntry("When the credit rating is {rating:regex:\\d{3}}", "applicant:Applicant(credit=={rating})");
        Assertions.assertThat((String)entry5.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))When\\s+the\\s+credit\\s+rating\\s+is\\s+(\\d{3})(?=\\W|$)");
        Assertions.assertThat((String)entry5.getValuePattern()).isEqualTo("applicant:Applicant(credit=={rating})");
        DSLMappingEntry entry6 = this.createEntry("This is a sentence with line breaks", "Cheese\\n(price == 10)");
        Assertions.assertThat((String)entry6.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))This\\s+is\\s+a\\s+sentence\\s+with\\s+line\\s+breaks(?=\\W|$)");
        Assertions.assertThat((String)entry6.getValuePattern()).isEqualTo("Cheese\n(price == 10)");
        DSLMappingEntry entry7 = this.createEntry("Bedingung-\\#19-MKM4", "eval ( $p.getTempVal(\"\\#UML-ATZ-1\") < $p.getZvUmlStfr() )");
        Assertions.assertThat((String)entry7.getKeyPattern().toString()).isEqualTo("(?:(?<=^)|(?<=\\W))Bedingung-#19-MKM4(?=\\W|$)");
        Assertions.assertThat((String)entry7.getValuePattern()).isEqualTo("eval ( $p.getTempVal(\"#UML-ATZ-1\") < $p.getZvUmlStfr() )");
        DefaultExpander ex = this.makeExpander(entry1, entry2, entry3, entry4, entry5, entry6, entry7);
        StringBuilder sb = new StringBuilder("rule x\n").append("when\n");
        sb.append("attr name is in [ 'Edson', 'Bob' ]").append(NL);
        sb.append("he (is) a $xx handsome man").append(NL);
        sb.append("DSL sentence with mykey myvalue").append(NL);
        sb.append("When the credit rating is AA").append(NL);
        sb.append("When the credit rating is 555").append(NL);
        sb.append("This is a sentence with line breaks").append(NL);
        sb.append("Bedingung-#19-MKM4").append(NL);
        sb.append("then\nend\n");
        String dslr = sb.toString();
        String drl = ex.expand(dslr);
        for (String exp : new String[]{"name in ( 'Edson', 'Bob' )", "Person( attribute == \"handsome\" )", "Sentence( mykey == myvalue )", "applicant:Applicant(credit==555)", "Cheese\n(price == 10)", "eval ( $p.getTempVal(\"#UML-ATZ-1\") < $p.getZvUmlStfr() )"}) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)drl.contains(exp)).as("failed to expand to: " + exp, new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateWithTilde() throws IOException {
        try {
            DSLMappingEntry dSLMappingEntry = this.createEntry("the benefit HAS an EXACT message of {ALLMSG}", "$benefit :Map(this['ALLMSG'] matches \"(?i).*~{ALLMSG}~.*\") from $benefits");
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }
}

