/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.testframework;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.testframework.DumbFact;
import org.junit.Test;
import org.mvel2.MVEL;

public class FactPopulatorTest {
    @Test
    public void testMVELPopulate() throws Exception {
        Object q = MVEL.eval((String)("new " + DumbFact.class.getName() + "()"));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("obj", q);
        m.put("val", "mike");
        MVEL.eval((String)"obj.name = val", m);
        m = new HashMap();
        m.put("obj", q);
        m.put("val", "42");
        MVEL.eval((String)"obj.age = val", m);
        m = new HashMap();
        m.put("obj", q);
        m.put("val", "44");
        MVEL.eval((String)"obj.number = val", m);
        DumbFact d = (DumbFact)q;
        Assertions.assertThat((String)d.getName()).isEqualTo("mike");
        Assertions.assertThat((int)d.getAge()).isEqualTo(42);
        Assertions.assertThat((Long)d.getNumber()).isEqualTo((Object)new Long(44L));
    }

    @Test
    public void testMVELFactChecker() throws Exception {
        final DumbFact d = new DumbFact();
        d.setAge(42);
        HashMap m = new HashMap(){
            {
                this.put("d", d);
                this.put("val", "42");
            }
        };
        Assertions.assertThat((Boolean)MVEL.evalToBoolean((String)"d.age == val", (Map)m)).isTrue();
    }
}

