/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class LinkingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public LinkingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSubNetworkSharing() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   B() \n";
        str = (String)str + "   C() \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        str = (String)str + "rule rule2 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() ) \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        str = (String)str + "rule rule3 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() and X() ) \n";
        str = (String)str + "   E() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(3);
        ExistsNode existsNode2 = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        ExistsNode existsNode3 = (ExistsNode)liaNode.getSinkPropagator().getSinks()[2];
        JoinNode joinNodeB = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)LinkingTest.getObjectTypeNode(kbase, B.class)).isSameAs((Object)joinNodeB.getRightInput());
        JoinNode joinNodeC = (JoinNode)joinNodeB.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)LinkingTest.getObjectTypeNode(kbase, C.class)).isSameAs((Object)joinNodeC.getRightInput());
        Assertions.assertThat((int)joinNodeC.getSinkPropagator().size()).isEqualTo(2);
        JoinNode joinNodeD = (JoinNode)joinNodeC.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)LinkingTest.getObjectTypeNode(kbase, X.class)).isSameAs((Object)joinNodeD.getRightInput());
        Assertions.assertThat((int)joinNodeD.getSinkPropagator().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RightInputAdapterNode)joinNodeC.getSinkPropagator().getSinks()[1]).getObjectSinkPropagator().getSinks()[0]).isSameAs((Object)existsNode2);
        Assertions.assertThat((Object)((RightInputAdapterNode)joinNodeD.getSinkPropagator().getSinks()[1]).getObjectSinkPropagator().getSinks()[0]).isSameAs((Object)existsNode3);
    }

    @Test
    public void testSubNetworkSharingMemories() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   B() \n";
        str = (String)str + "   C() \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        str = (String)str + "rule rule2 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() ) \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        str = (String)str + "rule rule3 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() and X() ) \n";
        str = (String)str + "   E() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNodeA = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        ExistsNode existsNode2 = (ExistsNode)liaNodeA.getSinkPropagator().getSinks()[1];
        ExistsNode existsNode3 = (ExistsNode)liaNodeA.getSinkPropagator().getSinks()[2];
        JoinNode joinNodeB = (JoinNode)liaNodeA.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeC = (JoinNode)joinNodeB.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeD1 = (JoinNode)joinNodeC.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeD2 = (JoinNode)existsNode2.getSinkPropagator().getSinks()[0];
        JoinNode joinNodeE = (JoinNode)existsNode3.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn1 = (RuleTerminalNode)joinNodeD1.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn2 = (RuleTerminalNode)joinNodeD2.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn3 = (RuleTerminalNode)joinNodeE.getSinkPropagator().getSinks()[0];
        FactHandle fha = wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.flushPropagations();
        Object bm = null;
        LeftInputAdapterNode.LiaNodeMemory liam = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNodeA);
        BetaMemory bm1 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeB);
        BetaMemory bm2 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeC);
        BetaMemory bm3 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeD1);
        Assertions.assertThat((long)liam.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm1.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm2.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)bm3.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((Object)bm1.getSegmentMemory()).isNotSameAs((Object)liam.getSegmentMemory());
        Assertions.assertThat((Object)bm2.getSegmentMemory()).isSameAs((Object)bm1.getSegmentMemory());
        Assertions.assertThat((Object)bm3.getSegmentMemory()).isNotSameAs((Object)bm2.getSegmentMemory());
        BetaMemory bm4 = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode2);
        BetaMemory bm5 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeD2);
        Assertions.assertThat((long)bm4.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm5.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((Object)bm5.getSegmentMemory()).isSameAs((Object)bm4.getSegmentMemory());
        PathMemory rs1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        PathMemory rs2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        PathMemory rs3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        Assertions.assertThat((boolean)rs1.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rs2.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rs3.isRuleLinked()).isFalse();
        wm.insert((Object)new E());
        wm.flushPropagations();
        BetaMemory bm6 = (BetaMemory)wm.getNodeMemory((MemoryFactory)existsNode3);
        BetaMemory bm7 = (BetaMemory)wm.getNodeMemory((MemoryFactory)joinNodeE);
        Assertions.assertThat((long)bm6.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bm7.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((Object)bm7.getSegmentMemory()).isSameAs((Object)bm6.getSegmentMemory());
        Assertions.assertThat((boolean)rs1.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rs2.isRuleLinked()).isTrue();
        Assertions.assertThat((boolean)rs3.isRuleLinked()).isTrue();
        wm.retract(fha);
        wm.fireAllRules();
        Assertions.assertThat((boolean)rs1.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rs2.isRuleLinked()).isFalse();
        Assertions.assertThat((boolean)rs3.isRuleLinked()).isFalse();
    }

    @Test
    public void testSubNetworkRiaLinking() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   B() \n";
        str = (String)str + "   exists( C() and X() ) \n";
        str = (String)str + "   E() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(1);
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)bNode.getSinkPropagator().size()).isEqualTo(2);
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)dNode.getSinkPropagator().size()).isEqualTo(1);
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode eNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)eNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)exists1n, (ReteEvaluator)wm);
        BetaMemory existsBm = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists1n);
        Assertions.assertThat((long)existsBm.getSegmentMemory().getLinkedNodeMask()).isEqualTo(0L);
        FactHandle fhc = wm.insert((Object)new C());
        FactHandle fhd = wm.insert((Object)new X());
        wm.flushPropagations();
        Assertions.assertThat((long)existsBm.getSegmentMemory().getLinkedNodeMask()).isEqualTo(1L);
        wm.retract(fhd);
        wm.flushPropagations();
        Assertions.assertThat((long)existsBm.getSegmentMemory().getLinkedNodeMask()).isEqualTo(0L);
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        wm.insert((Object)new A());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        wm.insert((Object)new B());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        wm.insert((Object)new E());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        wm.insert((Object)new X());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isTrue();
        wm.retract(fhc);
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isTrue();
    }

    @Test
    public void testNonReactiveSubNetworkInShareMasks() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() ) \n";
        str = (String)str + "   exists( eval(1==1) ) \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(2);
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        EvalConditionNode evalNode = (EvalConditionNode)exists1n.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)exists1n.getSinkPropagator().getSinks()[1];
        JoinNode dNode = (JoinNode)exists2n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)dNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((int)pmem.getSegmentMemories().length).isEqualTo(3);
        Assertions.assertThat((long)pmem.getAllLinkedMaskTest()).isEqualTo(7L);
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)dNode);
        Assertions.assertThat((Object)bm.getSegmentMemory()).isNull();
        wm.insert((Object)new X());
        wm.flushPropagations();
        Assertions.assertThat((long)bm.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(2L);
    }

    @Test
    public void testNonReactiveSubNetworkOwnSegmentMasks() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() ) \n";
        str = (String)str + "   exists( eval(1==1) ) \n";
        str = (String)str + "   X() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        str = (String)str + "rule rule2 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   exists( B() and C() ) \n";
        str = (String)str + "   exists( eval(1==1) ) \n";
        str = (String)str + "   E() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(2);
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)liaNode.getSinkPropagator().getSinks()[1];
        EvalConditionNode evalNode = (EvalConditionNode)exists1n.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)exists1n.getSinkPropagator().getSinks()[1];
        JoinNode dNode = (JoinNode)exists2n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)dNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((int)pmem.getSegmentMemories().length).isEqualTo(4);
        Assertions.assertThat((long)pmem.getAllLinkedMaskTest()).isEqualTo(11L);
        RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)exists1n.getRightInput());
        Assertions.assertThat((long)riaMem.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(2L);
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        Assertions.assertThat((int)riaMem.getRiaPathMemory().getSegmentMemories().length).isEqualTo(2);
        riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)exists2n.getRightInput());
        Assertions.assertThat((long)riaMem.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(0L);
    }

    @Test
    public void testNestedSubNetwork() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   B() \n";
        str = (String)str + "   exists( C() and X() and exists( E() and F() ) ) \n";
        str = (String)str + "   G() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(1);
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)bNode.getSinkPropagator().size()).isEqualTo(2);
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)dNode.getSinkPropagator().size()).isEqualTo(2);
        ExistsNode exists2n = (ExistsNode)dNode.getSinkPropagator().getSinks()[1];
        JoinNode eNode = (JoinNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode fNode = (JoinNode)eNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)fNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)riaNode2.getObjectSinkPropagator().getSinks()[0]).isEqualTo((Object)exists2n);
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)exists2n.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)riaNode1.getObjectSinkPropagator().getSinks()[0]).isEqualTo((Object)exists1n);
        JoinNode gNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)gNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.insert((Object)new F());
        wm.insert((Object)new G());
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        FactHandle fhE1 = wm.insert((Object)new E());
        FactHandle fhE2 = wm.insert((Object)new E());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isTrue();
        wm.retract(fhE1);
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isTrue();
        wm.retract(fhE2);
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
    }

    @Test
    public void testNestedSubNetworkMasks() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   B() \n";
        str = (String)str + "   exists( C() and X() and exists( E() and F() ) ) \n";
        str = (String)str + "   G() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists1n = (ExistsNode)bNode.getSinkPropagator().getSinks()[1];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        JoinNode dNode = (JoinNode)cNode.getSinkPropagator().getSinks()[0];
        ExistsNode exists2n = (ExistsNode)dNode.getSinkPropagator().getSinks()[1];
        JoinNode eNode = (JoinNode)dNode.getSinkPropagator().getSinks()[0];
        JoinNode fNode = (JoinNode)eNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode2 = (RightInputAdapterNode)fNode.getSinkPropagator().getSinks()[0];
        RightInputAdapterNode riaNode1 = (RightInputAdapterNode)exists2n.getSinkPropagator().getSinks()[0];
        JoinNode gNode = (JoinNode)exists1n.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)gNode.getSinkPropagator().getSinks()[0];
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        wm.insert((Object)new C());
        wm.insert((Object)new X());
        wm.insert((Object)new G());
        wm.flushPropagations();
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        BetaMemory bMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        BetaMemory exists1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists1n);
        BetaMemory cMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        BetaMemory dMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)dNode);
        BetaMemory exists2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)exists2n);
        BetaMemory eMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)eNode);
        BetaMemory fMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)fNode);
        BetaMemory gMem = (BetaMemory)wm.getNodeMemory((MemoryFactory)gNode);
        RightInputAdapterNode.RiaNodeMemory riaMem1 = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)riaNode1);
        RightInputAdapterNode.RiaNodeMemory riaMem2 = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)riaNode2);
        PathMemory rs = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        Assertions.assertThat((Object)bMem.getSegmentMemory()).isSameAs((Object)liaMem.getSegmentMemory());
        Assertions.assertThat((Object)exists1Mem.getSegmentMemory()).isNotSameAs((Object)bMem.getSegmentMemory());
        Assertions.assertThat((Object)gMem.getSegmentMemory()).isSameAs((Object)exists1Mem.getSegmentMemory());
        Assertions.assertThat((int)rs.getSegmentMemories().length).isEqualTo(2);
        Assertions.assertThat((long)rs.getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)rs.getLinkedSegmentMask()).isEqualTo(1L);
        Assertions.assertThat((long)liaMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)liaMem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)bMem.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)exists1Mem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)exists1Mem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)gMem.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((Object)cMem.getSegmentMemory()).isSameAs((Object)dMem.getSegmentMemory());
        Assertions.assertThat((Object)dMem.getSegmentMemory()).isNotSameAs((Object)exists2Mem.getSegmentMemory());
        Assertions.assertThat((int)riaMem1.getRiaPathMemory().getSegmentMemories().length).isEqualTo(3);
        Assertions.assertThat((Object)riaMem1.getRiaPathMemory().getSegmentMemories()[0]).isEqualTo(null);
        Assertions.assertThat((Object)riaMem1.getRiaPathMemory().getSegmentMemories()[1]).isEqualTo((Object)dMem.getSegmentMemory());
        Assertions.assertThat((int)dMem.getSegmentMemory().getPathMemories().size()).isEqualTo(1);
        Assertions.assertThat((Object)((PathMemory)cMem.getSegmentMemory().getPathMemories().get(0))).isSameAs((Object)riaMem1.getRiaPathMemory());
        Assertions.assertThat((long)cMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)cMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((long)cMem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)dMem.getNodePosMaskBit()).isEqualTo(2L);
        Assertions.assertThat((long)exists2Mem.getNodePosMaskBit()).isEqualTo(0L);
        FactHandle fhE1 = wm.insert((Object)new E());
        FactHandle fhF1 = wm.insert((Object)new F());
        wm.flushPropagations();
        Assertions.assertThat((long)exists2Mem.getNodePosMaskBit()).isEqualTo(1L);
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(6L);
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(6L);
        wm.delete(fhE1);
        wm.delete(fhF1);
        wm.flushPropagations();
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(2L);
        Assertions.assertThat((Object)eMem.getSegmentMemory()).isNotNull();
        Assertions.assertThat((Object)eMem.getSegmentMemory()).isSameAs((Object)fMem.getSegmentMemory());
        Assertions.assertThat((int)riaMem2.getRiaPathMemory().getSegmentMemories().length).isEqualTo(3);
        Assertions.assertThat((Object)riaMem2.getRiaPathMemory().getSegmentMemories()[0]).isEqualTo(null);
        Assertions.assertThat((Object)riaMem2.getRiaPathMemory().getSegmentMemories()[1]).isEqualTo(null);
        Assertions.assertThat((Object)riaMem2.getRiaPathMemory().getSegmentMemories()[2]).isEqualTo((Object)fMem.getSegmentMemory());
        Assertions.assertThat((Object)((PathMemory)eMem.getSegmentMemory().getPathMemories().get(0))).isSameAs((Object)riaMem2.getRiaPathMemory());
        Assertions.assertThat((long)eMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)eMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(0L);
        Assertions.assertThat((long)riaMem2.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(4L);
        Assertions.assertThat((long)riaMem2.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(0L);
        fhE1 = wm.insert((Object)new E());
        wm.insert((Object)new F());
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isTrue();
        Assertions.assertThat((long)rs.getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)rs.getLinkedSegmentMask()).isEqualTo(3L);
        Assertions.assertThat((long)cMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)cMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(6L);
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(6L);
        Assertions.assertThat((long)eMem.getSegmentMemory().getAllLinkedMaskTest()).isEqualTo(3L);
        Assertions.assertThat((long)eMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((long)riaMem2.getRiaPathMemory().getAllLinkedMaskTest()).isEqualTo(4L);
        Assertions.assertThat((long)riaMem2.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(4L);
        wm.delete(fhE1);
        wm.flushPropagations();
        Assertions.assertThat((boolean)rs.isRuleLinked()).isFalse();
        Assertions.assertThat((long)cMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((long)riaMem1.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(2L);
        Assertions.assertThat((long)eMem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(2L);
        Assertions.assertThat((long)riaMem2.getRiaPathMemory().getLinkedSegmentMask()).isEqualTo(0L);
    }

    @Test
    public void testJoinNodes() throws Exception {
        int i;
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   $b : B() \n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( $a.getValue() + \":\"+ $b.getValue() + \":\" + $c.getValue() ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, B.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, C.class);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new B(i));
        }
        for (i = 0; i < 29; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.flushPropagations();
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        BetaMemory bmem = (BetaMemory)wm.getNodeMemory((MemoryFactory)bNode);
        BetaMemory cmem = (BetaMemory)wm.getNodeMemory((MemoryFactory)cNode);
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst())).isNotNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext().getStagedNext()).isNotNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst()).getStagedNext().getStagedNext().getStagedNext()).isNull();
        wm.fireAllRules();
        Assertions.assertThat((Object)((LeftTuple)amem.getSegmentMemory().getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((Object)((RightTuple)bmem.getStagedRightTuples().getInsertFirst())).isNull();
        Assertions.assertThat((Object)((RightTuple)cmem.getStagedRightTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(261);
        Assertions.assertThat((boolean)list.contains("2:2:14")).isTrue();
        Assertions.assertThat((boolean)list.contains("1:0:6")).isTrue();
        Assertions.assertThat((boolean)list.contains("0:1:1")).isTrue();
        Assertions.assertThat((boolean)list.contains("2:2:14")).isTrue();
        Assertions.assertThat((boolean)list.contains("0:0:25")).isTrue();
    }

    @Test
    public void testExistsNodes1() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   exists A() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh = wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        wm.retract(fh);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testExistsNodes2() throws Exception {
        int i;
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   exists B() \n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        FactHandle fh = wm.insert((Object)new B(1));
        for (int i2 = 0; i2 < 3; ++i2) {
            wm.insert((Object)new C(i2));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(9);
        wm.retract(fh);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(9);
    }

    @Test
    public void testNotNodeUnlinksWithNoConstriants() {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   not B() \n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        NotNode bNode = (NotNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)cNode, (ReteEvaluator)wm);
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(2L);
        FactHandle fha = wm.insert((Object)new A());
        FactHandle fhb = wm.insert((Object)new B());
        FactHandle fhc = wm.insert((Object)new C());
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(5L);
        wm.retract(fhb);
        wm.flushPropagations();
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(7L);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        for (int i = 0; i < 5; ++i) {
            handles.add(wm.insert((Object)new B()));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(5L);
        for (FactHandle fh : handles) {
            wm.retract(fh);
        }
        wm.flushPropagations();
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(7L);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testNotNodeDoesNotUnlinksWithConstriants() {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   not B( value == $a.value ) \n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        LeftInputAdapterNode aNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        NotNode bNode = (NotNode)aNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)bNode.getSinkPropagator().getSinks()[0];
        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)cNode, (ReteEvaluator)wm);
        LeftInputAdapterNode.LiaNodeMemory amem = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)aNode);
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(2L);
        FactHandle fha = wm.insert((Object)new A());
        FactHandle fhb = wm.insert((Object)new B(1));
        FactHandle fhc = wm.insert((Object)new C());
        wm.flushPropagations();
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(7L);
        wm.retract(fhb);
        wm.flushPropagations();
        Assertions.assertThat((long)amem.getSegmentMemory().getLinkedNodeMask()).isEqualTo(7L);
    }

    @Test
    public void testNotNodes1() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   not A() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh = wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        wm.retract(fh);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testNotNodes2() throws Exception {
        int i;
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   not B() \n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(9);
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 3; ++i) {
            wm.insert((Object)new A(i));
        }
        FactHandle fh = wm.insert((Object)new B(1));
        for (int i2 = 0; i2 < 3; ++i2) {
            wm.insert((Object)new C(i2));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        wm.retract(fh);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(9);
    }

    @Test
    public void testNotNodeMasksWithConstraints() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   not( B( value == $a.value ) ) \n";
        str = (String)str + "   C() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(1);
        wm.insert((Object)new A());
        wm.flushPropagations();
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)notNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((int)pmem.getSegmentMemories().length).isEqualTo(1);
        Assertions.assertThat((long)pmem.getAllLinkedMaskTest()).isEqualTo(1L);
        SegmentMemory sm = pmem.getSegmentMemories()[0];
        Assertions.assertThat((long)sm.getAllLinkedMaskTest()).isEqualTo(5L);
        Assertions.assertThat((long)sm.getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((boolean)sm.isSegmentLinked()).isFalse();
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isFalse();
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assertions.assertThat((long)sm.getLinkedNodeMask()).isEqualTo(7L);
        Assertions.assertThat((boolean)sm.isSegmentLinked()).isTrue();
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isTrue();
    }

    @Test
    public void testNotNodeMasksWithoutConstraints() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   not( B( ) ) \n";
        str = (String)str + "   C() \n";
        str = (String)str + "then \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode node = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)liaNode.getSinkPropagator().size()).isEqualTo(1);
        wm.insert((Object)new A());
        wm.flushPropagations();
        NotNode notNode = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode cNode = (JoinNode)notNode.getSinkPropagator().getSinks()[0];
        RuleTerminalNode rtn = (RuleTerminalNode)cNode.getSinkPropagator().getSinks()[0];
        PathMemory pmem = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn);
        Assertions.assertThat((int)pmem.getSegmentMemories().length).isEqualTo(1);
        Assertions.assertThat((long)pmem.getAllLinkedMaskTest()).isEqualTo(1L);
        SegmentMemory sm = pmem.getSegmentMemories()[0];
        Assertions.assertThat((long)sm.getAllLinkedMaskTest()).isEqualTo(7L);
        Assertions.assertThat((long)sm.getLinkedNodeMask()).isEqualTo(3L);
        Assertions.assertThat((boolean)sm.isSegmentLinked()).isFalse();
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isFalse();
        wm.insert((Object)new C());
        wm.flushPropagations();
        Assertions.assertThat((long)sm.getLinkedNodeMask()).isEqualTo(7L);
        Assertions.assertThat((boolean)sm.isSegmentLinked()).isTrue();
        Assertions.assertThat((boolean)pmem.isRuleLinked()).isTrue();
    }

    @Test
    public void testForallNodes() throws Exception {
        int i;
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   forall( B() )\n";
        str = (String)str + "   $c : C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        for (i = 0; i < 2; ++i) {
            wm.insert((Object)new A(i));
        }
        for (i = 0; i < 27; ++i) {
            wm.insert((Object)new B(1));
        }
        for (i = 0; i < 2; ++i) {
            wm.insert((Object)new C(i));
        }
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
    }

    @Test
    public void testAccumulateNodes1() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   accumulate( $a : A(); $l : collectList( $a ) ) \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( $l.size() ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        wm = kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh1 = wm.insert((Object)new A(1));
        FactHandle fh2 = wm.insert((Object)new A(2));
        FactHandle fh3 = wm.insert((Object)new A(3));
        FactHandle fh4 = wm.insert((Object)new A(4));
        wm.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
    }

    @Test
    public void testAccumulateNodes2() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   A() \n";
        str = (String)str + "   accumulate( $a : B(); $l : collectList( $a ) ) \n";
        str = (String)str + "   C() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( $l.size() ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        list = new ArrayList();
        wm.setGlobal("list", list);
        FactHandle fh1 = wm.insert((Object)new B(1));
        FactHandle fh2 = wm.insert((Object)new B(2));
        FactHandle fh3 = wm.insert((Object)new B(3));
        FactHandle fh4 = wm.insert((Object)new B(4));
        FactHandle fha = wm.insert((Object)new A(1));
        FactHandle fhc = wm.insert((Object)new C(1));
        wm.fireAllRules();
        Assertions.assertThat(list.get(0)).isEqualTo((Object)4);
    }

    @Test
    public void testSubnetwork() throws Exception {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   exists ( B() and C() ) \n";
        str = (String)str + "   $e : X() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        for (int i = 0; i < 28; ++i) {
            wm.insert((Object)new C());
        }
        wm.insert((Object)new X());
        wm.flushPropagations();
        InternalAgenda agenda = wm.getAgenda();
        InternalAgendaGroup group = agenda.getAgendaGroupsManager().getNextFocus();
        AgendaItem item = (AgendaItem)group.remove();
        RuleExecutor ruleExecutor = ((RuleAgendaItem)item).getRuleExecutor();
        int count = ruleExecutor.evaluateNetworkAndFire((ReteEvaluator)wm, null, 0, -1);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testNestedSubnetwork() throws Exception {
        int i;
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "import " + F.class.getCanonicalName() + "\n";
        str = (String)str + "import " + G.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 when \n";
        str = (String)str + "   $a : A() \n";
        str = (String)str + "   exists ( B() and exists( C() and X() ) and E() ) \n";
        str = (String)str + "   $f : F() \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add( 'x' ); \n";
        str = (String)str + "end \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        ObjectTypeNode aotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode botn = LinkingTest.getObjectTypeNode(kbase, A.class);
        ObjectTypeNode cotn = LinkingTest.getObjectTypeNode(kbase, A.class);
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A());
        wm.insert((Object)new B());
        for (i = 0; i < 28; ++i) {
            wm.insert((Object)new C());
        }
        for (i = 0; i < 29; ++i) {
            wm.insert((Object)new X());
        }
        wm.insert((Object)new E());
        wm.insert((Object)new F());
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    public static ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((RuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }

    public static class G {
        private int value;

        public G() {
        }

        public G(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class F {
        private int value;

        public F() {
        }

        public F(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class E {
        private int value;

        public E() {
        }

        public E(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class X {
        private int value;

        public X() {
        }

        public X(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class C {
        private int value;

        public C() {
        }

        public C(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class B {
        private int value;

        public B() {
        }

        public B(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class A {
        private int value;

        public A() {
        }

        public A(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

