/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.drools.core.common.EventFactHandle;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Results;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

@RunWith(value=Parameterized.class)
public class StrictAnnotationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public StrictAnnotationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testUnknownAnnotation() {
        String str = "package org.simple \n@Xyz rule yyy \nwhen \n  $s : String()\nthen \nend  \n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str).writeKModuleXML(ks.newKieModuleModel().setConfigurationProperty("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString()).toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        Assertions.assertThat((int)results.getMessages().size()).isEqualTo(1);
    }

    @Test
    public void testImportedAnnotation() {
        String str = "package org.simple \nimport " + Xyz.class.getCanonicalName() + " \n@Xyz rule yyy \nwhen \n  $s : String()\nthen \nend  \n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str).writeKModuleXML(ks.newKieModuleModel().setConfigurationProperty("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString()).toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        Assertions.assertThat((int)results.getMessages().size()).isEqualTo(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEagerEvaluation() {
        String str = "package org.simple \n@Propagation(EAGER) rule xxx \nwhen \n  $s : String()\nthen \nend  \n@Propagation(EAGER) rule yyy \nwhen \n  $s : String()\nthen \nend  \n";
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession(conf, null);
        try {
            final ArrayList list = new ArrayList();
            DefaultAgendaEventListener agendaEventListener = new DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    list.add("activated");
                }
            };
            ksession.addEventListener((AgendaEventListener)agendaEventListener);
            ksession.insert((Object)"test");
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatch() {
        String str = "package com.sample;\nimport " + MyClass.class.getCanonicalName() + ";\nrule R1 when\n    @Watch( \"!value\" ) $m : MyClass( value < 10 )\nthen \n    modify( $m ) { setValue( $m.getValue()+1 ) };\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            MyClass myClass = new MyClass("test", 1);
            ksession.insert((Object)myClass);
            ksession.fireAllRules();
            Assertions.assertThat((int)myClass.getValue()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testStirctWatchWithoutQuotes() {
        String str = "package com.sample;\nimport " + MyClass.class.getCanonicalName() + ";\nrule R1 when\n    @Watch( !value ) $m : MyClass( value < 10 )\nthen \n    modify( $m ) { setValue( $m.getValue()+1 ) };\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str).writeKModuleXML(ks.newKieModuleModel().setConfigurationProperty("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString()).toXML());
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Results results = kieBuilder.getResults();
        Assertions.assertThat((int)results.getMessages().size()).isEqualTo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplictPositionalArguments() throws InstantiationException, IllegalAccessException {
        String str = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    @Position(1) name : String \n    @Position(0) age : int \nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString());
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{str});
        FactType factType = kieBase.getFactType("org.test", "Person");
        Object instance = factType.newInstance();
        factType.set(instance, "name", (Object)"Mark");
        factType.set(instance, "age", (Object)37);
        ArrayList names = new ArrayList();
        KieSession ksession = kieBase.newKieSession();
        try {
            ksession.setGlobal("names", names);
            ksession.insert(instance);
            ksession.fireAllRules();
            Assertions.assertThat((int)names.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)names.get(0))).isEqualTo("Mark");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavaSqlTimestamp() {
        String str = "package " + Message.class.getPackage().getName() + "\n@Role( Role.Type.EVENT ) @Timestamp( \"startTime\" ) @Duration( \"duration\" )\ndeclare " + Message.class.getCanonicalName() + "\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            Message msg = new Message();
            msg.setStartTime(new Timestamp(10000L));
            msg.setDuration(1000L);
            EventFactHandle efh = (EventFactHandle)ksession.insert((Object)msg);
            Assertions.assertThat((long)efh.getStartTimestamp()).isEqualTo(10000L);
            Assertions.assertThat((long)efh.getDuration()).isEqualTo(1000L);
        }
        finally {
            ksession.dispose();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Xyz {
    }

    public static class Message {
        private Properties properties;
        private Timestamp timestamp;
        private Long duration;

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Timestamp getStartTime() {
            return this.timestamp;
        }

        public void setStartTime(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }
    }

    @PropertyReactive
    public static class MyClass {
        private String name;
        private int value;

        public MyClass(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

