/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class TemporalOperatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TemporalOperatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testAfterWithLocalDateTime() {
        this.checkTemporalConstraint("localDateTime after $t1.localDateTime");
    }

    @Test
    public void testAfterWithZonedDateTime() {
        this.checkTemporalConstraint("zonedDateTime after $t1.zonedDateTime");
    }

    @Test
    public void testAfterWithDate() {
        this.checkTemporalConstraint("date after $t1.date");
    }

    @Test
    public void testAfterWithDateUsingOr() {
        this.checkTemporalConstraint("date == null || date after $t1.date");
    }

    @Test
    public void testAfterMixDateAndLocaldateTime() {
        this.checkTemporalConstraint("date after $t1.localDateTime");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTemporalConstraint(String constraint) {
        String str = "import " + TimestampedObject.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  $t1 : TimestampedObject()\n  $t2 : TimestampedObject( " + constraint + " )\nthen\n  list.add($t2.getName());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            TimestampedObject t1 = new TimestampedObject("t1", LocalDateTime.now());
            TimestampedObject t2 = new TimestampedObject("t2", LocalDateTime.now().plusHours(1L));
            ksession.insert((Object)t1);
            ksession.insert((Object)t2);
            ksession.fireAllRules();
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo(t2.getName());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testCompareMaxLocalDates() {
        this.checkMaxDate("localDate == LocalDate.MAX");
    }

    @Test
    public void testCompareTimeAndMaxLocalDates() {
        this.checkMaxDate("localDateTime == LocalDate.MAX");
    }

    @Test
    public void testCompareLocalDatesAndMaxTime() {
        this.checkMaxDate("localDate == LocalDateTime.MAX");
    }

    @Test
    public void testCompareMaxLocalDateTimes() {
        this.checkMaxDate("localDateTime == LocalDateTime.MAX");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMaxDate(String constraint) {
        String str = "import " + TimestampedObject.class.getCanonicalName() + ";\nimport " + LocalDate.class.getCanonicalName() + ";\nimport " + LocalDateTime.class.getCanonicalName() + ";\nrule R when\n  $t1 : TimestampedObject(" + constraint + ")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            TimestampedObject t1 = new TimestampedObject("t1", LocalDateTime.now());
            ksession.insert((Object)t1);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testAfterWithConstant() {
        this.checkConstantTemporalConstraint("date after \"01-Jan-1970\"");
    }

    @Test
    public void testAfterWithConstantUsingOR() {
        this.checkConstantTemporalConstraint("date == null || date after \"01-Jan-1970\"");
    }

    @Test
    public void testAfterWithLocalDateTimeUsingOr() {
        this.checkConstantTemporalConstraint("localDateTime == null || localDateTime after \"01-Jan-1970\"");
    }

    @Test
    public void testAfterWithLocalDateTimeWithLiteral() {
        this.checkConstantTemporalConstraint("localDateTime after \"01-Jan-1970\"");
    }

    @Test
    public void testDateAfterWithLiteral() {
        this.checkConstantTemporalConstraint("date after \"01-Jan-1970\"");
    }

    @Test
    public void testAfterWithLocalDateWithLiteral() {
        this.checkConstantTemporalConstraint("localDate after \"01-Jan-1970\"");
    }

    @Test
    public void testComparisonWithLocalDateTimeAndLiteral() {
        this.checkConstantTemporalConstraint("localDate > \"01-Jan-1970\"");
    }

    @Test
    public void testComparisonWithLocalDate() {
        this.checkConstantTemporalConstraint("localDate > org.drools.mvel.integrationtests.TemporalOperatorTest.parseDateAsLocal(\"01-Jan-1970\")");
    }

    @Test
    public void testComparisonWithLocalDateAndLiteral() {
        this.checkConstantTemporalConstraint("localDateTime > \"01-Jan-1970\"");
    }

    @Test
    public void testComparisonWithLocalDateTime() {
        this.checkConstantTemporalConstraint("localDateTime > org.drools.mvel.integrationtests.TemporalOperatorTest.parseTimeAsLocal(\"01-Jan-1970\")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConstantTemporalConstraint(String constraint) {
        String str = "import " + TimestampedObject.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n  $t1 : TimestampedObject( " + constraint + " )\nthen\n  list.add($t1.getName());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            TimestampedObject t1 = new TimestampedObject("t1", LocalDateTime.now());
            ksession.insert((Object)t1);
            ksession.fireAllRules();
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo(t1.getName());
        }
        finally {
            ksession.dispose();
        }
    }

    public static LocalDate parseDateAsLocal(String droolsDate) {
        if (droolsDate == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("dd-MMM-yyyy", Locale.UK).parse(droolsDate).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static LocalDateTime parseTimeAsLocal(String droolsDate) {
        if (droolsDate == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("dd-MMM-yyyy", Locale.UK).parse(droolsDate).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static class TimestampedObject {
        private final String name;
        private final LocalDateTime localDateTime;

        public TimestampedObject(String name, LocalDateTime time) {
            this.name = name;
            this.localDateTime = time;
        }

        public String getName() {
            return this.name;
        }

        public LocalDateTime getLocalDateTime() {
            return this.localDateTime;
        }

        public LocalDate getLocalDate() {
            return this.localDateTime.toLocalDate();
        }

        public ZonedDateTime getZonedDateTime() {
            return this.localDateTime.atZone(ZoneId.systemDefault());
        }

        public Date getDate() {
            return Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
    }
}

