/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.AbstractCepEspTest;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.util.TimeIntervalParser;
import org.drools.kiesession.audit.WorkingMemoryFileLogger;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.testcoverage.common.model.OrderEvent;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.model.StockTickEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.SerializationHelper;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.testcoverage.common.util.TimeUtil;
import org.drools.util.DateUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class CepEspTest
extends AbstractCepEspTest {
    public CepEspTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testComplexTimestamp() {
        String drl = "package " + Message.class.getPackage().getName() + "\ndeclare " + Message.class.getCanonicalName() + "\n   @role( event ) \n   @timestamp( getProperties().get( 'timestamp' ) - 1 ) \n   @duration( getProperties().get( 'duration' ) + 1 ) \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Message msg = new Message();
            Properties props = new Properties();
            props.put("timestamp", (Object)99);
            props.put("duration", (Object)52);
            msg.setProperties(props);
            EventFactHandle efh = (EventFactHandle)ksession.insert((Object)msg);
            Assertions.assertThat((long)efh.getStartTimestamp()).isEqualTo(98L);
            Assertions.assertThat((long)efh.getDuration()).isEqualTo(53L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testJavaSqlTimestamp() {
        String drl = "package " + Message.class.getPackage().getName() + "\ndeclare " + Message.class.getCanonicalName() + "\n   @role( event ) \n   @timestamp( startTime ) \n   @duration( duration )\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Message msg = new Message();
            msg.setStartTime(new Timestamp(10000L));
            msg.setDuration(1000L);
            EventFactHandle efh = (EventFactHandle)ksession.insert((Object)msg);
            Assertions.assertThat((long)efh.getStartTimestamp()).isEqualTo(10000L);
            Assertions.assertThat((long)efh.getDuration()).isEqualTo(1000L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventAssertion() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleEventAssertion.drl"});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            clock.advanceTime(30L, TimeUnit.SECONDS);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            clock.advanceTime(20L, TimeUnit.SECONDS);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            session.fireAllRules();
            Assertions.assertThat((int)((List)session.getGlobal("results")).size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAnnotatedEventAssertion() {
        String drl = "package org.drools.compiler.test;\n\nimport " + StockTickEvent.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\nrule \"Check event\"\nwhen\n    $st : StockTickEvent( company == \"ACME\" )\nthen\n    results.add( $st );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTickEvent tick1 = new StockTickEvent(1L, "DROO", 50.0, 10000L);
            StockTickEvent tick2 = new StockTickEvent(2L, "ACME", 10.0, 10010L);
            StockTickEvent tick3 = new StockTickEvent(3L, "ACME", 10.0, 10100L);
            StockTickEvent tick4 = new StockTickEvent(4L, "DROO", 50.0, 11000L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            clock.advanceTime(30L, TimeUnit.SECONDS);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            clock.advanceTime(20L, TimeUnit.SECONDS);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            session.fireAllRules();
            Assertions.assertThat((int)((List)session.getGlobal("results")).size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPackageSerializationWithEvents() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleEventAssertion.drl"});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((Object)((StockTick)results.get(0))).isEqualTo((Object)tick2);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventAssertionWithDuration() {
        String drl = "package org.drools.compiler\n\nimport " + StockTick.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\ndeclare StockTick \n    @role( event )\n    @duration( duration )\n    @timestamp( time )\nend\n\nrule \"Check event\"\nwhen\n    $st : StockTick( company == \"ACME\" )\nthen\n    results.add( $st );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            EventFactHandle eh1 = (EventFactHandle)handle1;
            EventFactHandle eh2 = (EventFactHandle)handle2;
            EventFactHandle eh3 = (EventFactHandle)handle3;
            EventFactHandle eh4 = (EventFactHandle)handle4;
            Assertions.assertThat((long)eh1.getStartTimestamp()).isEqualTo(tick1.getTime());
            Assertions.assertThat((long)eh2.getStartTimestamp()).isEqualTo(tick2.getTime());
            Assertions.assertThat((long)eh3.getStartTimestamp()).isEqualTo(tick3.getTime());
            Assertions.assertThat((long)eh4.getStartTimestamp()).isEqualTo(tick4.getTime());
            Assertions.assertThat((long)eh1.getDuration()).isEqualTo(tick1.getDuration());
            Assertions.assertThat((long)eh2.getDuration()).isEqualTo(tick2.getDuration());
            Assertions.assertThat((long)eh3.getDuration()).isEqualTo(tick3.getDuration());
            Assertions.assertThat((long)eh4.getDuration()).isEqualTo(tick4.getDuration());
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventAssertionWithDateTimestamp() {
        String drl = "package org.drools.compiler\n\nimport " + StockTick.class.getCanonicalName() + ";\n\nglobal java.util.List results;\n\ndeclare StockTick \n    @role( event )\n    @timestamp( dateTimestamp )\nend\n\nrule \"Check event\"\nwhen\n    $st : StockTick( company == \"ACME\" )\nthen\n    results.add( $st );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            EventFactHandle eh1 = (EventFactHandle)handle1;
            EventFactHandle eh2 = (EventFactHandle)handle2;
            EventFactHandle eh3 = (EventFactHandle)handle3;
            EventFactHandle eh4 = (EventFactHandle)handle4;
            Assertions.assertThat((long)eh1.getStartTimestamp()).isEqualTo(tick1.getTime());
            Assertions.assertThat((long)eh2.getStartTimestamp()).isEqualTo(tick2.getTime());
            Assertions.assertThat((long)eh3.getStartTimestamp()).isEqualTo(tick3.getTime());
            Assertions.assertThat((long)eh4.getStartTimestamp()).isEqualTo(tick4.getTime());
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testEventExpiration() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List results;\n\ndeclare StockTick \n    @role( event )\n    @timestamp( dateTimestamp )\n    @expires( 1h30m )\nend\n\nrule \"Check event\"\nwhen\n    $st : StockTick( company == \"ACME\" )\nthen\n    results.add( $st );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        TypeDeclaration factType = ((RuleBase)kbase).getTypeDeclaration(StockTick.class);
        Assertions.assertThat((long)factType.getExpirationOffset()).isEqualTo(TimeIntervalParser.parse((String)"1h30m")[0]);
    }

    @Test(timeout=10000L)
    public void testEventExpiration2() {
        this.testEventExpiration("15m", "15m");
    }

    @Test(timeout=10000L)
    public void testEventExpiration3() {
        this.testEventExpiration("5m", "5m");
    }

    private void testEventExpiration(String afterBoundary, String windowTime) {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List results;\n\ndeclare StockTick \n    @role( event )\n    @timestamp( dateTimestamp )\n    // this will override individual rule requirements\n    @expires( 10m )\nend\n\nrule \"Check event\"\nwhen\n    $st1 : StockTick( company == \"ACME\" )\n    $st2 : StockTick( company == \"RHT\", this after[0," + afterBoundary + "] $st1 )\nthen\n    results.add( $st1 );\nend\n\nrule \"Check event2\"\nwhen\n    $st1 : StockTick( company == \"RHT\" ) over window:time( " + windowTime + " )\nthen\n    results.add( $st1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Map objectTypeNodes = ((RuleBase)kbase).getRete().getObjectTypeNodes(EntryPointId.DEFAULT);
        ObjectTypeNode node = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(StockTick.class));
        Assertions.assertThat((Object)node).isNotNull();
        Assertions.assertThat((long)node.getExpirationOffset()).isEqualTo(TimeIntervalParser.parse((String)"10m")[0] + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventExpiration4() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List results;\n\ndeclare StockTick \n    @role( event )\n    @expires( 10s )\nend\n\nrule \"TestEventReceived\"\nno-loop\nwhen\n   $st1 : StockTick( company == \"ACME\" ) over window:time( 10s ) from entry-point \"Event Stream\"\nthen\n   results.add( $st1 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            EntryPoint eventStream = ksession.getEntryPoint("Event Stream");
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            EventFactHandle handle1 = (EventFactHandle)eventStream.insert((Object)new StockTick(1L, "ACME", 50.0, System.currentTimeMillis(), 3L));
            ksession.fireAllRules();
            clock.advanceTime(11L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((boolean)handle1.isExpired()).isTrue();
            Assertions.assertThat((boolean)ksession.getFactHandles().contains(handle1)).isFalse();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTimeRelationalOperators() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_TimeRelationalOperators.drl"});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)wm.getSessionClock();
            clock.setStartupTime(1000L);
            ArrayList results_coincides = new ArrayList();
            ArrayList results_before = new ArrayList();
            ArrayList results_after = new ArrayList();
            ArrayList results_meets = new ArrayList();
            ArrayList results_met_by = new ArrayList();
            ArrayList results_overlaps = new ArrayList();
            ArrayList results_overlapped_by = new ArrayList();
            ArrayList results_during = new ArrayList();
            ArrayList results_includes = new ArrayList();
            ArrayList results_starts = new ArrayList();
            ArrayList results_started_by = new ArrayList();
            ArrayList results_finishes = new ArrayList();
            ArrayList results_finished_by = new ArrayList();
            wm.setGlobal("results_coincides", results_coincides);
            wm.setGlobal("results_before", results_before);
            wm.setGlobal("results_after", results_after);
            wm.setGlobal("results_meets", results_meets);
            wm.setGlobal("results_met_by", results_met_by);
            wm.setGlobal("results_overlaps", results_overlaps);
            wm.setGlobal("results_overlapped_by", results_overlapped_by);
            wm.setGlobal("results_during", results_during);
            wm.setGlobal("results_includes", results_includes);
            wm.setGlobal("results_starts", results_starts);
            wm.setGlobal("results_started_by", results_started_by);
            wm.setGlobal("results_finishes", results_finishes);
            wm.setGlobal("results_finished_by", results_finished_by);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
            StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
            InternalFactHandle handle5 = (InternalFactHandle)wm.insert((Object)tick5);
            clock.advanceTime(1L, TimeUnit.MILLISECONDS);
            InternalFactHandle handle6 = (InternalFactHandle)wm.insert((Object)tick6);
            InternalFactHandle handle7 = (InternalFactHandle)wm.insert((Object)tick7);
            clock.advanceTime(2L, TimeUnit.MILLISECONDS);
            InternalFactHandle handle8 = (InternalFactHandle)wm.insert((Object)tick8);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((Object)handle5).isNotNull();
            Assertions.assertThat((Object)handle6).isNotNull();
            Assertions.assertThat((Object)handle7).isNotNull();
            Assertions.assertThat((Object)handle8).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle6.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle7.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle8.isEvent()).isTrue();
            wm.fireAllRules();
            Assertions.assertThat((int)results_coincides.size()).isEqualTo(1);
            Assertions.assertThat(results_coincides.get(0)).isEqualTo((Object)tick5);
            Assertions.assertThat((int)results_before.size()).isEqualTo(1);
            Assertions.assertThat(results_before.get(0)).isEqualTo((Object)tick2);
            Assertions.assertThat((int)results_after.size()).isEqualTo(1);
            Assertions.assertThat(results_after.get(0)).isEqualTo((Object)tick3);
            Assertions.assertThat((int)results_meets.size()).isEqualTo(1);
            Assertions.assertThat(results_meets.get(0)).isEqualTo((Object)tick3);
            Assertions.assertThat((int)results_met_by.size()).isEqualTo(1);
            Assertions.assertThat(results_met_by.get(0)).isEqualTo((Object)tick2);
            Assertions.assertThat((int)results_met_by.size()).isEqualTo(1);
            Assertions.assertThat(results_met_by.get(0)).isEqualTo((Object)tick2);
            Assertions.assertThat((int)results_overlaps.size()).isEqualTo(1);
            Assertions.assertThat(results_overlaps.get(0)).isEqualTo((Object)tick4);
            Assertions.assertThat((int)results_overlapped_by.size()).isEqualTo(1);
            Assertions.assertThat(results_overlapped_by.get(0)).isEqualTo((Object)tick8);
            Assertions.assertThat((int)results_during.size()).isEqualTo(1);
            Assertions.assertThat(results_during.get(0)).isEqualTo((Object)tick6);
            Assertions.assertThat((int)results_includes.size()).isEqualTo(1);
            Assertions.assertThat(results_includes.get(0)).isEqualTo((Object)tick4);
            Assertions.assertThat((int)results_starts.size()).isEqualTo(1);
            Assertions.assertThat(results_starts.get(0)).isEqualTo((Object)tick6);
            Assertions.assertThat((int)results_started_by.size()).isEqualTo(1);
            Assertions.assertThat(results_started_by.get(0)).isEqualTo((Object)tick7);
            Assertions.assertThat((int)results_finishes.size()).isEqualTo(1);
            Assertions.assertThat(results_finishes.get(0)).isEqualTo((Object)tick8);
            Assertions.assertThat((int)results_finished_by.size()).isEqualTo(1);
            Assertions.assertThat(results_finished_by.get(0)).isEqualTo((Object)tick7);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testBeforeOperator() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_BeforeOperator.drl"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(1000L);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
            StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            ksession.insert((Object)tick1);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick2);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick3);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick4);
            ksession.insert((Object)tick5);
            clock.advanceTime(1L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick6);
            ksession.insert((Object)tick7);
            clock.advanceTime(2L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick8);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            StockTick[] stocks = (StockTick[])list.get(0);
            Assertions.assertThat((Object)stocks[0]).isSameAs((Object)tick4);
            Assertions.assertThat((Object)stocks[1]).isSameAs((Object)tick2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMetByOperator() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_MetByOperator.drl"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(1000L);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
            StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
            StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
            ksession.insert((Object)tick1);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick2);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick3);
            clock.advanceTime(4L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick4);
            ksession.insert((Object)tick5);
            clock.advanceTime(1L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick6);
            ksession.insert((Object)tick7);
            clock.advanceTime(2L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick8);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            StockTick[] stocks = (StockTick[])list.get(0);
            Assertions.assertThat((Object)stocks[0]).isSameAs((Object)tick1);
            Assertions.assertThat((Object)stocks[1]).isSameAs((Object)tick2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testComplexOperator() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_ComplexOperator.drl"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(1000L);
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 0L, 3L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 4L, 3L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 8L, 3L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 12L, 5L);
            StockTick tick5 = new StockTick(5L, "ACME", 10.0, 12L, 5L);
            StockTick tick6 = new StockTick(6L, "ACME", 10.0, 13L, 3L);
            StockTick tick7 = new StockTick(7L, "ACME", 10.0, 13L, 5L);
            StockTick tick8 = new StockTick(8L, "ACME", 10.0, 15L, 3L);
            ksession.insert((Object)tick1);
            ksession.insert((Object)tick2);
            ksession.insert((Object)tick3);
            ksession.insert((Object)tick4);
            ksession.insert((Object)tick5);
            ksession.insert((Object)tick6);
            ksession.insert((Object)tick7);
            ksession.insert((Object)tick8);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            StockTick[] stocks = (StockTick[])list.get(0);
            Assertions.assertThat((Object)stocks[0]).isSameAs((Object)tick4);
            Assertions.assertThat((Object)stocks[1]).isSameAs((Object)tick2);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=10000L)
    public void testAfterOnArbitraryDates() {
        this.testArbitraryDates("org/drools/compiler/integrationtests/test_CEP_AfterOperatorDates.drl", 100000L, 104000L);
    }

    @Test(timeout=10000L)
    public void testBeforeOnArbitraryDates() {
        this.testArbitraryDates("org/drools/compiler/integrationtests/test_CEP_BeforeOperatorDates.drl", 104000L, 100000L);
    }

    @Test(timeout=10000L)
    public void testCoincidesOnArbitraryDates() {
        this.testArbitraryDates("org/drools/compiler/integrationtests/test_CEP_CoincidesOperatorDates.drl", 100000L, 100050L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testArbitraryDates(String drlClasspathResource, long tick1Time, long tick2Time) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlClasspathResource});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, tick1Time, 3L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, tick2Time, 3L);
            InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
            InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(4);
            Assertions.assertThat(results.get(0)).isEqualTo((Object)tick1);
            Assertions.assertThat(results.get(1)).isEqualTo((Object)tick2);
            Assertions.assertThat(results.get(2)).isEqualTo((Object)tick1);
            Assertions.assertThat(results.get(3)).isEqualTo((Object)tick2);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSimpleTimeWindow() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleTimeWindow.drl"});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
            clock.advanceTime(5L, TimeUnit.SECONDS);
            EventFactHandle handle1 = (EventFactHandle)wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
            Assertions.assertThat((long)handle1.getStartTimestamp()).isEqualTo(5000L);
            Assertions.assertThat((long)handle1.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(70);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            EventFactHandle handle2 = (EventFactHandle)wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
            Assertions.assertThat((long)handle2.getStartTimestamp()).isEqualTo(15000L);
            Assertions.assertThat((long)handle2.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((int)((Number)results.get(1)).intValue()).isEqualTo(65);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            EventFactHandle handle3 = (EventFactHandle)wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
            Assertions.assertThat((long)handle3.getStartTimestamp()).isEqualTo(25000L);
            Assertions.assertThat((long)handle3.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            Assertions.assertThat((int)((Number)results.get(2)).intValue()).isEqualTo(60);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            EventFactHandle handle4 = (EventFactHandle)wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
            Assertions.assertThat((long)handle4.getStartTimestamp()).isEqualTo(35000L);
            Assertions.assertThat((long)handle4.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            EventFactHandle handle5 = (EventFactHandle)wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
            Assertions.assertThat((long)handle5.getStartTimestamp()).isEqualTo(45000L);
            Assertions.assertThat((long)handle5.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            EventFactHandle handle6 = (EventFactHandle)wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
            Assertions.assertThat((long)handle6.getStartTimestamp()).isEqualTo(55000L);
            Assertions.assertThat((long)handle6.getDuration()).isEqualTo(0L);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(4);
            Assertions.assertThat((int)((Number)results.get(3)).intValue()).isEqualTo(70);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSimpleLengthWindow() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleLengthWindow.drl"});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(70);
            wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((int)((Number)results.get(1)).intValue()).isEqualTo(65);
            wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            Assertions.assertThat((int)((Number)results.get(2)).intValue()).isEqualTo(60);
            wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(4);
            Assertions.assertThat((int)((Number)results.get(3)).intValue()).isEqualTo(70);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDelayingNot() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List results;\n\ndeclare StockTick\n    @role( event )\nend\n\nrule \"Delaying Not\"\nwhen\n    $s1: StockTick( $symbol : company, $price : price )\n    not( StockTick( company == $symbol, price > $price, this after[ 1s, 10s ] $s1 ) )\nthen\n    results.add( $s1 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            RuleImpl rule = (RuleImpl)kbase.getRule("org.drools.compiler", "Delaying Not");
            Assertions.assertThat((long)((DurationTimer)rule.getTimer()).getDuration()).isEqualTo(10000L);
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
            clock.advanceTime(10L, TimeUnit.SECONDS);
            StockTick st1O = new StockTick(1L, "DROO", 100.0, clock.getCurrentTime());
            wm.insert((Object)st1O);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(0);
            clock.advanceTime(5L, TimeUnit.SECONDS);
            wm.insert((Object)new StockTick(1L, "DROO", 80.0, clock.getCurrentTime()));
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(0);
            wm.fireAllRules();
            clock.advanceTime(6L, TimeUnit.SECONDS);
            wm.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat(results.get(0)).isEqualTo((Object)st1O);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSimpleLengthWindowWithQueue() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleLengthWindow.drl"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new OrderEvent("1", "customer A", 80.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.insert((Object)new OrderEvent("2", "customer A", 70.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.insert((Object)new OrderEvent("3", "customer A", 60.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.insert((Object)new OrderEvent("4", "customer A", 50.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(60);
            ksession.insert((Object)new OrderEvent("5", "customer A", 10.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            ksession.insert((Object)new OrderEvent("6", "customer A", 90.0));
            ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat((int)((Number)results.get(1)).intValue()).isEqualTo(50);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDelayingNot2() {
        String drl = "package org.drools.compiler\ndeclare A @role(event) symbol : String end\ndeclare B @role(event) symbol : String end\nrule Setup when\nthen\n    insert( new A() );\nend\nrule X\nwhen\n    $a : A() and not( B( this after $a ) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\ndeclare A @role(event) symbol : String end\ndeclare B @role(event) symbol : String end\nrule Setup when\nthen\n    insert( new A() );\nend\nrule X\nwhen\n    $a : A() and not( B( this after $a ) )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDelayingNotWithPreEpochClock() {
        String drl = "package org.drools.compiler\ndeclare A @role(event) symbol : String end\ndeclare B @role(event) symbol : String end\nrule Setup when\nthen\n    insert( new A() );\nend\nrule X\nwhen\n    $a : A() and not( B( this after $a ) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\ndeclare A @role(event) symbol : String end\ndeclare B @role(event) symbol : String end\nrule Setup when\nthen\n    insert( new A() );\nend\nrule X\nwhen\n    $a : A() and not( B( this after $a ) )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            Calendar ts = Calendar.getInstance();
            ts.set(1900, 1, 1);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(ts.getTimeInMillis(), TimeUnit.MILLISECONDS);
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIdleTime() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleEventAssertion.drl"});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(0L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(10000L);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(0L);
            clock.advanceTime(15L, TimeUnit.SECONDS);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(15000L);
            clock.advanceTime(15L, TimeUnit.SECONDS);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(30000L);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(0L);
            clock.advanceTime(20L, TimeUnit.SECONDS);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)handle1).isNotNull();
            Assertions.assertThat((Object)handle2).isNotNull();
            Assertions.assertThat((Object)handle3).isNotNull();
            Assertions.assertThat((Object)handle4).isNotNull();
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(10000L);
            session.fireAllRules();
            Assertions.assertThat((long)((InternalWorkingMemory)session).getIdleTime()).isEqualTo(0L);
            Assertions.assertThat((int)((List)session.getGlobal("results")).size()).isEqualTo(2);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIdleTimeAndTimeToNextJob() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_SimpleTimeWindow.drl"});
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((WorkingMemory)wm);
            File testTmpDir = new File("target/test-tmp/");
            testTmpDir.mkdirs();
            logger.setFileName("target/test-tmp/testIdleTimeAndTimeToNextJob-audit");
            try {
                ArrayList results = new ArrayList();
                wm.setGlobal("results", results);
                SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
                clock.advanceTime(5L, TimeUnit.SECONDS);
                Assertions.assertThat((long)wm.getTimeToNextJob()).isEqualTo(-1L);
                wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
                wm.fireAllRules();
                Assertions.assertThat((long)wm.getIdleTime()).isEqualTo(0L);
                Assertions.assertThat((long)wm.getTimeToNextJob()).isEqualTo(30000L);
                wm.fireAllRules();
                Assertions.assertThat((int)results.size()).isEqualTo(1);
                Assertions.assertThat((int)((Number)results.get(0)).intValue()).isEqualTo(70);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                Assertions.assertThat((long)wm.getTimeToNextJob()).isEqualTo(20000L);
                wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
                wm.fireAllRules();
                Assertions.assertThat((int)results.size()).isEqualTo(2);
                Assertions.assertThat((int)((Number)results.get(1)).intValue()).isEqualTo(65);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                Assertions.assertThat((long)wm.getTimeToNextJob()).isEqualTo(10000L);
                wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
                wm.fireAllRules();
                Assertions.assertThat((int)results.size()).isEqualTo(3);
                Assertions.assertThat((int)((Number)results.get(2)).intValue()).isEqualTo(60);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                Assertions.assertThat((long)wm.getIdleTime()).isEqualTo(0L);
                wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
                wm.fireAllRules();
                Assertions.assertThat((int)results.size()).isEqualTo(3);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
                Assertions.assertThat((long)wm.getIdleTime()).isEqualTo(0L);
                wm.fireAllRules();
                Assertions.assertThat((int)results.size()).isEqualTo(3);
            }
            finally {
                logger.writeToDisk();
            }
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCollectWithWindows() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_CEP_CollectWithWindows.drl"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((KieRuntimeEventManager)ksession);
            File testTmpDir = new File("target/test-tmp/");
            testTmpDir.mkdirs();
            logger.setFileName("target/test-tmp/testCollectWithWindows-audit");
            ArrayList timeResults = new ArrayList();
            ArrayList lengthResults = new ArrayList();
            ksession.setGlobal("timeResults", timeResults);
            ksession.setGlobal("lengthResults", lengthResults);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            try {
                clock.advanceTime(5L, TimeUnit.SECONDS);
                ksession.insert((Object)new OrderEvent("1", "customer A", 70.0));
                ksession.fireAllRules();
                Assertions.assertThat((int)timeResults.size()).isEqualTo(1);
                Assertions.assertThat((int)((Number)timeResults.get(0)).intValue()).isEqualTo(1);
                Assertions.assertThat((int)lengthResults.size()).isEqualTo(1);
                Assertions.assertThat((int)((Number)lengthResults.get(0)).intValue()).isEqualTo(1);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                ksession.insert((Object)new OrderEvent("2", "customer A", 60.0));
                ksession.fireAllRules();
                Assertions.assertThat((int)timeResults.size()).isEqualTo(2);
                Assertions.assertThat((int)((Number)timeResults.get(1)).intValue()).isEqualTo(2);
                Assertions.assertThat((int)lengthResults.size()).isEqualTo(2);
                Assertions.assertThat((int)((Number)lengthResults.get(1)).intValue()).isEqualTo(2);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                ksession.insert((Object)new OrderEvent("3", "customer A", 50.0));
                ksession.fireAllRules();
                Assertions.assertThat((int)timeResults.size()).isEqualTo(3);
                Assertions.assertThat((int)((Number)timeResults.get(2)).intValue()).isEqualTo(3);
                Assertions.assertThat((int)lengthResults.size()).isEqualTo(3);
                Assertions.assertThat((int)((Number)lengthResults.get(2)).intValue()).isEqualTo(3);
                clock.advanceTime(10L, TimeUnit.SECONDS);
                ksession.insert((Object)new OrderEvent("4", "customer A", 25.0));
                ksession.fireAllRules();
                Assertions.assertThat((int)timeResults.size()).isEqualTo(4);
                Assertions.assertThat((int)((Number)timeResults.get(3)).intValue()).isEqualTo(3);
                Assertions.assertThat((int)lengthResults.size()).isEqualTo(4);
                Assertions.assertThat((int)((Number)lengthResults.get(3)).intValue()).isEqualTo(3);
                clock.advanceTime(5L, TimeUnit.SECONDS);
                ksession.insert((Object)new OrderEvent("5", "customer A", 70.0));
                ksession.fireAllRules();
                Assertions.assertThat((int)timeResults.size()).isEqualTo(5);
                Assertions.assertThat((int)((Number)timeResults.get(4)).intValue()).isEqualTo(4);
                Assertions.assertThat((int)lengthResults.size()).isEqualTo(5);
                Assertions.assertThat((int)((Number)lengthResults.get(4)).intValue()).isEqualTo(3);
            }
            finally {
                logger.writeToDisk();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testPseudoSchedulerRemoveJobTest() {
        String drl = "import " + CepEspTest.class.getName() + ".A\ndeclare A\n    @role( event )\nend\nrule A\nwhen\n   $a : A()\n   not A(this after [1s,10s] $a)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            FactHandle h = ksession.insert((Object)new A());
            ksession.delete(h);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventDeclarationForInterfaces() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + "\ndeclare StockTick \n    @role( event )\n    @timestamp( dateTimestamp )\nend\n\nrule \"Check event\"\nwhen\n    $st : StockTick( company == \"ACME\" )\nthen\n    // no-op\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
            StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
            StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
            StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
            InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
            InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
            InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
            InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
            Assertions.assertThat((boolean)handle1.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle2.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle3.isEvent()).isTrue();
            Assertions.assertThat((boolean)handle4.isEvent()).isTrue();
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTemporalOperators() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick \n    @role( event )\n    @timestamp( time )\nend\n\nrule \"2 operators\"\nwhen\n    $a : StockTick( company == \"A\" )\n    not( StockTick( company == \"B\", this after[0,20s] $a ) )\n    not( StockTick( company == \"C\", this after[0,20s] $a ) )\nthen\n    // do something\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new StockTick(1L, "A", 10.0, 1000L));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTemporalOperators2() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare StockTick \n    @role( event )\nend\n\nrule \"2 operators\"\nwhen\n    $a : StockTick( ) from entry-point \"X\"\n    $b : StockTick( this after[1s,10s] $a ) from entry-point \"X\"\nthen\n    list.add( new StockTick[] { $a, $b } );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            EntryPoint ep = ksession.getEntryPoint("X");
            clock.advanceTime(1000L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(1L, "A", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(2L, "B", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(3L, "B", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTemporalOperatorsInfinity() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getCanonicalName() + ";\nglobal java.util.List list;\n\ndeclare StockTick \n    @role( event )\nend\n\nrule \"infinity\"\nwhen\n    $a : StockTick( ) from entry-point \"X\"\n    $b : StockTick( this after[5s,*] $a ) from entry-point \"X\"\nthen\n    list.add( $a );\n    list.add( $b );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            EntryPoint ep = ksession.getEntryPoint("X");
            clock.advanceTime(1000L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(1L, "A", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(2L, "B", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            ep.insert((Object)new StockTick(3L, "B", 10.0, clock.getCurrentTime()));
            clock.advanceTime(8L, TimeUnit.SECONDS);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleSlidingWindows() {
        String drl = "declare A\n    @role( event )\n    id : int\nend\ndeclare B\n    @role( event )\n    id : int\nend\nrule launch\nwhen\nthen\n    insert( new A( 1 ) );\n    insert( new A( 2 ) );\n    insert( new B( 1 ) );\n    insert( new A( 3 ) );\n    insert( new B( 2 ) );\nend\nrule \"ab\" \nwhen\n    A( $a : id ) over window:length( 1 )\n    B( $b : id ) over window:length( 1 )\nthen\n    System.out.println(\"AB: ( \"+$a+\", \"+$b+\" )\");\nend\nrule \"ba\" salience 10\nwhen\n    B( $b : id ) over window:length( 1 )\n    A( $a : id ) over window:length( 1 )\nthen\n    System.out.println(\"BA: ( \"+$b+\", \"+$a+\" )\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare A\n    @role( event )\n    id : int\nend\ndeclare B\n    @role( event )\n    id : int\nend\nrule launch\nwhen\nthen\n    insert( new A( 1 ) );\n    insert( new A( 2 ) );\n    insert( new B( 1 ) );\n    insert( new A( 3 ) );\n    insert( new B( 2 ) );\nend\nrule \"ab\" \nwhen\n    A( $a : id ) over window:length( 1 )\n    B( $b : id ) over window:length( 1 )\nthen\n    System.out.println(\"AB: ( \"+$a+\", \"+$b+\" )\");\nend\nrule \"ba\" salience 10\nwhen\n    B( $b : id ) over window:length( 1 )\n    A( $a : id ) over window:length( 1 )\nthen\n    System.out.println(\"BA: ( \"+$b+\", \"+$a+\" )\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            ksession.fireAllRules();
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            List values = captor.getAllValues();
            Match act = ((AfterMatchFiredEvent)values.get(0)).getMatch();
            Assertions.assertThat((String)act.getRule().getName()).isEqualTo("launch");
            act = ((AfterMatchFiredEvent)values.get(1)).getMatch();
            Assertions.assertThat((String)act.getRule().getName()).isEqualTo("ba");
            Assertions.assertThat((int)((Number)act.getDeclarationValue("$a")).intValue()).isEqualTo(3);
            Assertions.assertThat((int)((Number)act.getDeclarationValue("$b")).intValue()).isEqualTo(2);
            act = ((AfterMatchFiredEvent)values.get(2)).getMatch();
            Assertions.assertThat((String)act.getRule().getName()).isEqualTo("ab");
            Assertions.assertThat((int)((Number)act.getDeclarationValue("$a")).intValue()).isEqualTo(3);
            Assertions.assertThat((int)((Number)act.getDeclarationValue("$b")).intValue()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSalienceWithEventsPseudoClock() {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getName() + "\ndeclare StockTick\n        @role ( event )\nend\nrule R1 salience 1000\n    when\n        $s1 : StockTick( company == 'RHT' )\n        $s2 : StockTick( company == 'ACME', this after[0s,1m] $s1 )\n    then\nend\nrule R2 salience 1000\n    when\n        $s1 : StockTick( company == 'RHT' )\n        not StockTick( company == 'ACME', this after[0s,1m] $s1 )\n    then\nend\nrule R3 salience 100\n    when\n        $s2 : StockTick( company == 'ACME' )\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(1000000L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new StockTick(2L, "RHT", 10.0, 1000L));
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new StockTick(3L, "RHT", 10.0, 1000L));
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new StockTick(4L, "ACME", 10.0, 1000L));
            clock.advanceTime(5L, TimeUnit.SECONDS);
            int rulesFired = ksession.fireAllRules();
            Assertions.assertThat((int)rulesFired).isEqualTo(4);
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            List aafe = captor.getAllValues();
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(1)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(2)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(3)).getMatch().getRule().getName()).isEqualTo("R3");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSalienceWithEventsRealtimeClock() throws InterruptedException {
        String drl = "package org.drools.compiler\nimport " + StockTick.class.getName() + "\ndeclare StockTick\n        @role ( event )\nend\nrule R1 salience 1000\n    when\n        $s1 : StockTick( company == 'RHT' )\n        $s2 : StockTick( company == 'ACME', this after[0s,1m] $s1 )\n    then\nend\nrule R2 salience 1000\n    when\n        $s1 : StockTick( company == 'RHT' )\n        not StockTick( company == 'ACME', this after[0s,1m] $s1 )\n    then\nend\nrule R3 salience 100\n    when\n        $s2 : StockTick( company == 'ACME' )\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(ael);
            ksession.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            ksession.insert((Object)new StockTick(2L, "RHT", 10.0, 1000L));
            ksession.insert((Object)new StockTick(3L, "RHT", 10.0, 1000L));
            Thread.sleep(2000L);
            ksession.insert((Object)new StockTick(4L, "ACME", 10.0, 1000L));
            Thread.sleep(1000L);
            int rulesFired = ksession.fireAllRules();
            Assertions.assertThat((int)rulesFired).isEqualTo(4);
            ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
            List aafe = captor.getAllValues();
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(1)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(2)).getMatch().getRule().getName()).isEqualTo("R1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)aafe.get(3)).getMatch().getRule().getName()).isEqualTo("R3");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testExpireEventOnEndTimestamp() {
        String drl = "package org.drools.compiler;\nimport " + StockTick.class.getName() + "\nglobal java.util.List resultsAfter;\n\ndeclare StockTick\n    @role( event )\n    @duration( duration )\nend\n\nrule \"after[60,80]\"\nwhen\n$a : StockTick( company == \"DROO\" )\n$b : StockTick( company == \"ACME\", this after[60,80] $a )\nthen\n       resultsAfter.add( $b );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            ArrayList resultsAfter = new ArrayList();
            ksession.setGlobal("resultsAfter", resultsAfter);
            ksession.insert((Object)new StockTick(1L, "DROO", 0.0, 0L, 30L));
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)new StockTick(2L, "ACME", 0.0, 0L, 20L));
            ksession.fireAllRules();
            Assertions.assertThat((int)resultsAfter.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventExpirationDuringAccumulate() throws Exception {
        String drl = "package org.drools.integrationtests\n\nimport java.util.List;\n\ndeclare Stock\n    @role( event )\n    @expires( 1s ) // setting to a large value causes the test to pass\n    name : String\n    value : Double\nend\n\nrule \"collect events\"\nwhen\n    stocks := List()\n        from accumulate( $zeroStock : Stock( value == 0.0 );\n                         collectList( $zeroStock ) )\nthen\n    // empty consequence\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.integrationtests\n\nimport java.util.List;\n\ndeclare Stock\n    @role( event )\n    @expires( 1s ) // setting to a large value causes the test to pass\n    name : String\n    value : Double\nend\n\nrule \"collect events\"\nwhen\n    stocks := List()\n        from accumulate( $zeroStock : Stock( value == 0.0 );\n                         collectList( $zeroStock ) )\nthen\n    // empty consequence\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            StockFactory stockFactory = new StockFactory(kbase);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                Future<?> sessionFuture = executor.submit(() -> ((KieSession)ksession).fireUntilHalt());
                try {
                    for (int iteration = 0; iteration < 100; ++iteration) {
                        this.populateSessionWithStocks(ksession, stockFactory);
                    }
                    Thread.sleep(2000L);
                }
                finally {
                    ksession.halt();
                    sessionFuture.get();
                    ksession.dispose();
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    private void populateSessionWithStocks(KieSession ksession, StockFactory stockFactory) {
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST1", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST2", 1.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST3", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST4", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST5", 0.0));
        clock.advanceTime(1L, TimeUnit.SECONDS);
        ksession.insert(stockFactory.createStock("ST6", 1.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testEventExpirationInSlidingWindow() throws Exception {
        String drl = "package org.drools.integrationtests\n\ndeclare Stock\n    @role( event )\n    name : String\n    value : Double\nend\n\nrule \"collect time window contents\"\nwhen\n    Stock( value == 0.0 ) over window:time(2s)\nthen\n    // empty consequence\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.integrationtests\n\ndeclare Stock\n    @role( event )\n    name : String\n    value : Double\nend\n\nrule \"collect time window contents\"\nwhen\n    Stock( value == 0.0 ) over window:time(2s)\nthen\n    // empty consequence\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        StockFactory stockFactory = new StockFactory(kbase);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> sessionFuture = executor.submit(() -> ((KieSession)ksession).fireUntilHalt());
            try {
                for (int iteration = 0; iteration < 100; ++iteration) {
                    this.populateSessionWithStocks(ksession, stockFactory);
                }
                Thread.sleep(2000L);
            }
            finally {
                ksession.halt();
                sessionFuture.get();
                ksession.dispose();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSlidingWindowsAccumulateExternalJoin() {
        String drl = "package testing2;\n\nimport java.util.*;\nimport " + StockTick.class.getCanonicalName() + "\nglobal List list;\ndeclare StockTick\n @role( event )\n @duration( duration )\nend\n\nrule test\nwhen\n $primary : StockTick( $name : company ) over window:length(1)\n accumulate (  $tick : StockTick( company == $name ) ,  $num : count( $tick ) )\nthen\n list.add( $num.intValue() ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            int seq = 0;
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new StockTick((long)seq++, "AAA", 10.0, 10L));
            ksession.fireAllRules();
            Assertions.assertThat(Collections.singletonList(1)).isEqualTo(list);
            ksession.insert((Object)new StockTick((long)seq++, "AAA", 15.0, 10L));
            ksession.fireAllRules();
            Assertions.assertThat(Arrays.asList(1, 2)).isEqualTo(list);
            ksession.insert((Object)new StockTick((long)seq++, "CCC", 10.0, 10L));
            ksession.fireAllRules();
            Assertions.assertThat(Arrays.asList(1, 2, 1)).isEqualTo(list);
            ksession.insert((Object)new StockTick((long)seq++, "DDD", 13.0, 20L));
            ksession.fireAllRules();
            Assertions.assertThat(Arrays.asList(1, 2, 1, 1)).isEqualTo(list);
            ksession.insert((Object)new StockTick((long)seq, "AAA", 11.0, 20L));
            ksession.fireAllRules();
            Assertions.assertThat(Arrays.asList(1, 2, 1, 1, 3)).isEqualTo(list);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTimeAndLengthWindowConflict() {
        String drl = "package org.drools.compiler;\nimport java.util.List\nimport " + OrderEvent.class.getCanonicalName() + "\n\nglobal List timeResults;\nglobal List lengthResults;\n\ndeclare OrderEvent\n @role( event )\nend\n\nrule \"collect with time window\"\nwhen\n $list : List( empty == false ) from collect(\n $o : OrderEvent() over window:time(30s) )\nthen\n timeResults.add( $list.size() );\nend\n\nrule \"collect with length window\"\nwhen\n accumulate (\n $o : OrderEvent( $tot : total ) over window:length(3), $avg : average( $tot ) )\nthen\n lengthResults.add( $avg );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList timeResults = new ArrayList();
            ArrayList lengthResults = new ArrayList();
            ksession.setGlobal("timeResults", timeResults);
            ksession.setGlobal("lengthResults", lengthResults);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("1", "customer A", 70.0));
            ksession.fireAllRules();
            System.out.println(lengthResults);
            Assertions.assertThat((boolean)lengthResults.contains(70.0)).isTrue();
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("2", "customer A", 60.0));
            ksession.fireAllRules();
            System.out.println(lengthResults);
            Assertions.assertThat((boolean)lengthResults.contains(65.0)).isTrue();
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("3", "customer A", 50.0));
            ksession.fireAllRules();
            System.out.println(lengthResults);
            Assertions.assertThat((boolean)lengthResults.contains(60.0)).isTrue();
            clock.advanceTime(60L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("4", "customer A", 25.0));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testTimeStampOnNonExistingField() {
        String drl = "package org.drools.compiler;\nimport " + StockTick.class.getCanonicalName() + ";\ndeclare StockTick\n @role( event )\n @timestamp( nonExistingField ) \nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTimeWindowWithPastEvents() {
        String drl = "package org.drools.compiler;\nimport java.util.List\nimport " + StockTick.class.getCanonicalName() + ";\n\nglobal List timeResults;\n\ndeclare StockTick\n @role( event )\n @timestamp( time ) \nend\n\nrule \"collect with time window\"\nwhen\n accumulate(\n $o : StockTick() over window:time(10ms), $tot : count( $o ); $tot > 0 )\nthen\n timeResults.add( $tot );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList timeResults = new ArrayList();
            ksession.setGlobal("timeResults", timeResults);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            int count = 0;
            StockTick tick1 = new StockTick((long)count++, "X", 0.0, 1L);
            StockTick tick2 = new StockTick((long)count++, "X", 0.0, 3L);
            StockTick tick3 = new StockTick((long)count++, "X", 0.0, 7L);
            StockTick tick4 = new StockTick((long)count++, "X", 0.0, 9L);
            StockTick tick5 = new StockTick((long)count, "X", 0.0, 15L);
            clock.advanceTime(30L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)tick1);
            ksession.insert((Object)tick2);
            ksession.insert((Object)tick3);
            ksession.insert((Object)tick4);
            ksession.insert((Object)tick5);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)timeResults.isEmpty()).isTrue();
            clock.advanceTime(0L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)timeResults.isEmpty()).isTrue();
            clock.advanceTime(3L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)timeResults.isEmpty()).isTrue();
            clock.advanceTime(10L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)timeResults.isEmpty()).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeakingActivationsWithDetachedExpiredNonCancelling() throws Exception {
        String drl = "package org.drools;\n\nimport java.util.List\n\nglobal List list; \ndeclare Motion\n    @role( event )\n    @expires( 10ms )\n    @timestamp( timestamp )\n    timestamp : long\nend\n\ndeclare Recording\nend\n\nrule Init salience 1000 when\n    $l : Long() \nthen\n    insert( new Motion( $l ) ); \nend\nrule \"StartRecording\" when\n   $mot : Motion()\n   not Recording()\n then\n   list.add( $mot ); \n    insert(new Recording());\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools;\n\nimport java.util.List\n\nglobal List list; \ndeclare Motion\n    @role( event )\n    @expires( 10ms )\n    @timestamp( timestamp )\n    timestamp : long\nend\n\ndeclare Recording\nend\n\nrule Init salience 1000 when\n    $l : Long() \nthen\n    insert( new Motion( $l ) ); \nend\nrule \"StartRecording\" when\n   $mot : Motion()\n   not Recording()\n then\n   list.add( $mot ); \n    insert(new Recording());\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1000L);
            ksession.insert((Object)1001L);
            ksession.insert((Object)1002L);
            Thread.sleep(1000L);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testTwoWindowsInsideCEAndOut() {
        String drl = "package org.drools.compiler;\nimport java.util.List\nimport " + OrderEvent.class.getCanonicalName() + ";\n\nglobal List timeResults;\n\ndeclare " + OrderEvent.class.getCanonicalName() + "\n @role( event )\nend\n\nrule \"r1\"\nwhen\n    $o1 : OrderEvent() over window:length(3) \n        accumulate(  $o2 : OrderEvent() over window:length(3);\n                     $avg : average( $o2.getTotal() ) )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession wm = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
            wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
            wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
            wm.insert((Object)new OrderEvent("4", "customer A", 40.0));
            wm.insert((Object)new OrderEvent("5", "customer A", 30.0));
            wm.insert((Object)new OrderEvent("6", "customer A", 20.0));
            wm.insert((Object)new OrderEvent("7", "customer A", 10.0));
            wm.fireAllRules();
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateEventThroughEntryPoint() {
        String drl = "import " + TestEvent.class.getCanonicalName() + "\n\ndeclare TestEvent\n    @role( event )\n    @expires( 4s )\nend\n\nrule \"TestEventReceived\"\n    no-loop\n    when\n        $event : TestEvent ( name != null ) over window:time( 4s ) from entry-point EventStream\n    then\n        // insert( new Message( $event.getValue().toString() ) );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            EntryPoint entryPoint = kieSession.getEntryPoint("EventStream");
            TestEvent event = new TestEvent("testEvent1");
            FactHandle handle = entryPoint.insert((Object)event);
            TestEvent event2 = new TestEvent("testEvent2");
            entryPoint.update(handle, (Object)event2);
            Assertions.assertThat((boolean)entryPoint.getObjects().contains(event)).isFalse();
            Assertions.assertThat((boolean)entryPoint.getObjects().contains(event2)).isTrue();
            Assertions.assertThat((Object)event2).isEqualTo(entryPoint.getObject(handle));
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamModeWithSubnetwork() {
        String drl = "package org.drools.compiler.integrationtests\n\ndeclare Event\n  @role(event)\n  name : String\nend\n\nglobal java.util.List list\n\nrule \"firstRule\"\n\n    when\n        not (\n            $e : Event() over window:length(3)\n            and Event( this == $e ) // test pass when you comment this line\n        )\n    then\n        list.add(\"firstRule\");\n\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests\n\ndeclare Event\n  @role(event)\n  name : String\nend\n\nglobal java.util.List list\n\nrule \"firstRule\"\n\n    when\n        not (\n            $e : Event() over window:length(3)\n            and Event( this == $e ) // test pass when you comment this line\n        )\n    then\n        list.add(\"firstRule\");\n\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventTimestamp() {
        String drl = "\nimport " + Event.class.getCanonicalName() + "; \nglobal java.util.List list; \nglobal org.kie.api.time.SessionPseudoClock clock; \ndeclare Event \n @role( event )\n @timestamp( time ) \n @expires( 10000000 ) \nend \nrule \"inform about E1\"\nwhen\n $event1 : Event( type == 1 )\n //there is an event (T2) with value 0 between 0,2m after doorClosed\n $event2: Event( type == 2, value == 1, this after [0, 1200ms] $event1, $timestamp : time )\n //there is no newer event (T2) within the timeframe\n not Event( type == 2, this after [0, 1200ms] $event1, time > $timestamp ) \nthen\n list.add( clock.getCurrentTime() ); \n end\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ksession.setGlobal("clock", (Object)clock);
            ksession.insert((Object)new Event(1, -1, clock.getCurrentTime()));
            clock.advanceTime(600L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
            clock.advanceTime(300L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 1, clock.getCurrentTime()));
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
            clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.isEmpty()).isFalse();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Long time = (Long)list.get(0);
            Assertions.assertThat((time > 1000L && time < 1500L ? 1 : 0) != 0).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventTimestamp2() {
        String drl = "\nimport " + Event.class.getCanonicalName() + ";\nglobal java.util.List list; \nglobal org.kie.api.time.SessionPseudoClock clock; \ndeclare Event \n @role( event )\n @timestamp( time ) \n @expires( 10000000 ) \nend \nrule \"inform about E1\"\nwhen\n $event0 : Event( type == 0 )\n $event1 : Event( type == 1 )\n $event2: Event( type == 2 )\n not Event( type == 3, this after [0, 1000ms] $event1 ) \nthen\n list.add( clock.getCurrentTime() ); \n end\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ksession.setGlobal("clock", (Object)clock);
            ksession.insert((Object)new Event(0, 0, clock.getCurrentTime()));
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)new Event(1, 0, clock.getCurrentTime()));
            clock.advanceTime(600L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
            clock.advanceTime(600L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)new Event(3, 0, clock.getCurrentTime()));
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.isEmpty()).isFalse();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            long time = (Long)list.get(0);
            Assertions.assertThat((long)time).isEqualTo(1300L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyInStreamMode() {
        String drl = "import " + SimpleFact.class.getCanonicalName() + ";\nglobal java.util.List list;\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"MyRule\"\nwhen\n    $f : SimpleFact( status == \"NOK\" )\nthen\n    list.add(\"Firing\");    $f.setStatus(\"OK\");\n    update ($f);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SimpleFact fact = new SimpleFact("id1");
            ksession.insert((Object)fact);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)fact.getStatus()).isEqualTo("OK");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectAfterRetract() {
        String drl = "import " + SimpleFact.class.getCanonicalName() + ";\nimport java.util.List;\nglobal List list;\n\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"Retract facts if 2 or more\" salience 1000\nwhen\n    $facts : List( size >= 2 ) from collect( SimpleFact() )\nthen\n    for (Object f: new java.util.LinkedList($facts)) {\n        System.out.println(\"Retracting \"+f);\n        retract(f);\n    }\nend\n\nrule \"Still facts in WM\"\nwhen\n    $facts : List( size != 0 ) from collect( SimpleFact() )\nthen\n    list.add( $facts.size() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new SimpleFact("id1"));
            ksession.insert((Object)new SimpleFact("id2"));
            ksession.insert((Object)new SimpleFact("id3"));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectAfterUpdate() {
        String drl = "import " + SimpleFact.class.getCanonicalName() + ";\nimport java.util.List;\n\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"Rule1\"\n    when\n        event : SimpleFact( status == \"NOK\" )\n        list: List(size < 4) from collect( SimpleFact(this != event, status==\"1\") )\n    then\n        event.setStatus(\"1\");\n        update(event);\n    end\n\nrule \"Rule2\"\n    when\n        event : SimpleFact( status == \"NOK\" )\n        list: List(size >= 4) from collect( SimpleFact(this != event, status==\"1\") )\n    then\n        for (Object ev2: new java.util.LinkedList(list)) retract(ev2);\n        event.setStatus(\"2\");\n        update(event);\n    end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            for (int i = 0; i < 4; ++i) {
                ksession.insert((Object)new SimpleFact("id" + i));
            }
            ksession.fireAllRules();
            ((AbstractLongAssert)Assertions.assertThat((long)ksession.getFactCount()).as("all events should be in WM", new Object[0])).isEqualTo(4L);
            ksession.insert((Object)new SimpleFact("last"));
            ksession.fireAllRules();
            ((AbstractLongAssert)Assertions.assertThat((long)ksession.getFactCount()).as("only one event should be still in WM", new Object[0])).isEqualTo(1L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testExpirationAtHighRates() {
        String drl = "package droolsfusioneval\nglobal java.util.List list; \nimport " + ProbeEvent.class.getCanonicalName() + ";\nimport " + ProbeCounter.class.getCanonicalName() + ";\n\ndeclare ProbeEvent\n    @role (event)\n    @expires(1ms)\nend\n\nrule \"Probe rule\"\nwhen\n    $pe : ProbeEvent () from entry-point ep01\n    $pc : ProbeCounter ()\nthen\n   list.add( $pe.getValue() ); \n    $pc.addValue ();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        EntryPoint ep01 = session.getEntryPoint("ep01");
        new Thread(() -> ((KieSession)session).fireUntilHalt()).start();
        try {
            int eventLimit = 5000;
            ProbeCounter pc = new ProbeCounter();
            long myTotal = 0L;
            try {
                session.insert((Object)pc);
                for (int i = 0; i < 5000; ++i) {
                    ep01.insert((Object)new ProbeEvent(i));
                    ++myTotal;
                }
                Thread.sleep(2500L);
            }
            catch (Throwable t) {
                Assertions.fail((String)t.getMessage());
            }
            Assertions.assertThat((long)myTotal).isEqualTo(5000L);
            Assertions.assertThat((int)list.size()).isEqualTo(5000);
            Assertions.assertThat((int)session.getEntryPoint("ep01").getObjects().size()).isEqualTo(0);
        }
        finally {
            session.halt();
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void AfterOperatorInCEPQueryTest() {
        String drl = "package org.drools;\nimport " + StockTick.class.getCanonicalName() + ";\n\ndeclare StockTick\n    @role( event )\nend\n\nquery EventsBeforeNineSeconds\n   $event : StockTick() from entry-point EStream\n   $result : StockTick ( this after [0s, 9s] $event) from entry-point EventStream\nend\n\nquery EventsBeforeNineteenSeconds\n   $event : StockTick() from entry-point EStream\n   $result : StockTick ( this after [0s, 19s] $event) from entry-point EventStream\nend\n\nquery EventsBeforeHundredSeconds\n   $event : StockTick() from entry-point EStream\n   $result : StockTick ( this after [0s, 100s] $event) from entry-point EventStream\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            EntryPoint ePoint = ksession.getEntryPoint("EStream");
            EntryPoint entryPoint = ksession.getEntryPoint("EventStream");
            ePoint.insert((Object)new StockTick(0L, "zero", 0.0, 0L));
            entryPoint.insert((Object)new StockTick(1L, "one", 0.0, 0L));
            clock.advanceTime(10L, TimeUnit.SECONDS);
            entryPoint.insert((Object)new StockTick(2L, "two", 0.0, 0L));
            clock.advanceTime(10L, TimeUnit.SECONDS);
            entryPoint.insert((Object)new StockTick(3L, "three", 0.0, 0L));
            QueryResults results = ksession.getQueryResults("EventsBeforeNineSeconds", new Object[0]);
            Assertions.assertThat((int)results.size()).isEqualTo(0);
            results = ksession.getQueryResults("EventsBeforeNineteenSeconds", new Object[0]);
            Assertions.assertThat((int)results.size()).isEqualTo(0);
            results = ksession.getQueryResults("EventsBeforeHundredSeconds", new Object[0]);
            Assertions.assertThat((int)results.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromWithEvents() {
        String drl = "\n\npackage org.drools.test\nglobal java.util.List list; \n\ndeclare MyEvent\n@role(event)\n@timestamp( stamp )\nid : int\nstamp : long\nend\n\ndeclare MyBean\nid : int\nevent : MyEvent\nend\n\nrule \"Init\"\nwhen\nthen\nMyEvent ev = new MyEvent( 1, 1000 );\nMyBean bin = new MyBean( 99, ev );\nMyEvent ev2 = new MyEvent( 2, 2000 );\n\ndrools.getWorkingMemory().getEntryPoint( \"X\" ).insert( ev2 );\ninsert( bin );\nend\n\nrule \"Check\"\nwhen\n$e2 : MyEvent( id == 2 ) from entry-point \"X\" \n$b1 : MyBean( id == 99, $ev : event )\nMyEvent( this before $e2 ) from $ev\nthen\nSystem.out.println( \"Success\" );\nlist.add( 1 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"\n\npackage org.drools.test\nglobal java.util.List list; \n\ndeclare MyEvent\n@role(event)\n@timestamp( stamp )\nid : int\nstamp : long\nend\n\ndeclare MyBean\nid : int\nevent : MyEvent\nend\n\nrule \"Init\"\nwhen\nthen\nMyEvent ev = new MyEvent( 1, 1000 );\nMyBean bin = new MyBean( 99, ev );\nMyEvent ev2 = new MyEvent( 2, 2000 );\n\ndrools.getWorkingMemory().getEntryPoint( \"X\" ).insert( ev2 );\ninsert( bin );\nend\n\nrule \"Check\"\nwhen\n$e2 : MyEvent( id == 2 ) from entry-point \"X\" \n$b1 : MyBean( id == 99, $ev : event )\nMyEvent( this before $e2 ) from $ev\nthen\nSystem.out.println( \"Success\" );\nlist.add( 1 ); \nend\n"});
        KieSession ks = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList(1);
            ks.setGlobal("list", list);
            ks.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Collections.singletonList(1));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializationWithTrackableTimerJob() throws InterruptedException {
        String drl = "package org.drools.test;\nimport " + StockTick.class.getCanonicalName() + "; \nglobal java.util.List list;\n\ndeclare StockTick\n  @role( event )\n  @expires( 1s )\nend\n\nrule \"One\"\nwhen\n  StockTick( $id : seq, company == \"AAA\" ) over window:time( 1s )\nthen\n  list.add( $id ); \nend\n\nrule \"Two\"\nwhen\n  StockTick( $id : seq, company == \"BBB\" ) \nthen\n  System.out.println( $id ); \n  list.add( $id );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ks = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ks.insert((Object)new StockTick(2L, "BBB", 1.0, 0L));
            Thread.sleep(1100L);
            try {
                ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            ks.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
            ArrayList list = new ArrayList();
            ks.setGlobal("list", list);
            ks.fireAllRules();
            ks.insert((Object)new StockTick(3L, "BBB", 1.0, 0L));
            ks.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list).isEqualTo(Arrays.asList(2L, 3L));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializationWithTrackableTimerJobShortExpiration() {
        String drl = "package org.drools.test;\nimport " + StockTick.class.getCanonicalName() + "; \nglobal java.util.List list;\n\ndeclare StockTick\n  @role( event )\n  @expires( 1ms )\nend\nrule \"Two\"\nwhen\n  StockTick( $id : seq, company == \"BBB\" ) \nthen\n  System.out.println( $id ); \n  list.add( $id );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ks = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ks.insert((Object)new StockTick(2L, "BBB", 1.0, 0L));
            try {
                ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializationWithExpiringEventAndAccumulate() throws InterruptedException {
        String drl = "package org.drools.test;\nimport " + StockTick.class.getCanonicalName() + "; \nglobal java.util.List list;\n\ndeclare StockTick\n  @role( event )\n  @expires( 1s )\nend\n\nrule R\nwhen\n  accumulate ( StockTick( company == \"BBB\", $p : price),               $sum : sum( $p );              $sum > 0 )\nthen\n  list.add( $sum ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        try {
            ks.insert((Object)new StockTick(1L, "BBB", 1.0, 0L));
            Thread.sleep(1000L);
            ks.insert((Object)new StockTick(2L, "BBB", 2.0, 0L));
            Thread.sleep(100L);
            try {
                ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            ArrayList list = new ArrayList();
            ks.setGlobal("list", list);
            ks.fireAllRules();
            ks.insert((Object)new StockTick(3L, "BBB", 3.0, 0L));
            ks.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list).isEqualTo(Arrays.asList(2.0, 5.0));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeserializationWithCompositeTrigger() {
        String drl = "package org.drools.test;\nimport " + StockTick.class.getCanonicalName() + "; \nglobal java.util.List list;\n\ndeclare StockTick\n  @role( event )\n  @expires( 1s )\nend\n\nrule \"One\"\nwhen\n  $event : StockTick( )\n  not StockTick( company == \"BBB\", this after[0,96h] $event )\n  not StockTick( company == \"CCC\", this after[0,96h] $event )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSessionConfiguration kieSessionConfiguration = KieSessionTestConfiguration.STATEFUL_REALTIME.getKieSessionConfiguration();
        kieSessionConfiguration.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        KieSession ks = kbase.newKieSession(kieSessionConfiguration, null);
        try {
            ks.insert((Object)new StockTick(2L, "AAA", 1.0, 0L));
            try {
                ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWindowExpireActionDeserialization() throws InterruptedException {
        String drl = "package org.drools.test;\nimport " + StockTick.class.getCanonicalName() + "; \nglobal java.util.List list; \n\ndeclare StockTick\n  @role( event )\nend\n\nrule \"One\"\nwhen\n  StockTick( $id : seq, company == \"BBB\" ) over window:time( 1s )\nthen\n  list.add( $id );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ks = kbase.newKieSession();
        try {
            ks.insert((Object)new StockTick(2L, "BBB", 1.0, 0L));
            Thread.sleep(1500L);
            try {
                ks = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ks, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            ArrayList list = new ArrayList();
            ks.setGlobal("list", list);
            ks.fireAllRules();
            ks.insert((Object)new StockTick(3L, "BBB", 1.0, 0L));
            ks.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list).isEqualTo(Collections.singletonList(3L));
        }
        finally {
            ks.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateFiring1() {
        String drl = "package org.test;\nimport " + StockTick.class.getCanonicalName() + ";\n global java.util.List list \ndeclare StockTick @role(event) end \nrule \"slidingTimeCount\"\nwhen\n  accumulate ( $e: StockTick() over window:time(300ms) from entry-point SensorEventStream,               $n : count( $e );              $n > 0 )\nthen\n  list.add( $n ); \n  System.out.println( \"Events in last 3 seconds: \" + $n );\nend\nrule \"timerRuleAfterAllEvents\"\n        timer ( int: 2s )\nwhen\n        $room : String( )\nthen\n  list.add( -1 ); \n  System.out.println(\"2sec after room was modified\");\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            EntryPoint sensorEventStream = ksession.getEntryPoint("SensorEventStream");
            ksession.insert((Object)"Go");
            for (int i = 2; i < 8; ++i) {
                StockTick event = new StockTick((long)(i - 1), "XXX", 1.0, 0L);
                sensorEventStream.insert((Object)event);
                ksession.fireAllRules();
                clock.advanceTime(105L, TimeUnit.MILLISECONDS);
            }
            clock.advanceTime(4000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(1L, 2L, 3L, 3L, 3L, 3L, -1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPastEventExipration() {
        String drl = "package org.test;\nimport " + StockTick.class.getCanonicalName() + ";\n global java.util.List list; \ndeclare StockTick @role(event) @timestamp( time ) @expires( 200ms ) end \nrule \"slidingTimeCount\"\nwhen\n  accumulate ( $e: StockTick() over window:length(10), $n : count($e) )\nthen\n  list.add( $n ); \n  System.out.println( \"Events in last X seconds: \" + $n );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            long now = 0L;
            StockTick event1 = new StockTick(1L, "XXX", 1.0, 0L);
            StockTick event2 = new StockTick(2L, "XXX", 1.0, 240L);
            StockTick event3 = new StockTick(2L, "XXX", 1.0, 380L);
            StockTick event4 = new StockTick(2L, "XXX", 1.0, 500L);
            ksession.insert((Object)event1);
            ksession.insert((Object)event2);
            ksession.insert((Object)event3);
            ksession.insert((Object)event4);
            clock.advanceTime(220L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            clock.advanceTime(400L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(3L, 1L));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventStreamWithEPsAndDefaultPseudo() {
        String drl = "\nimport java.util.*;\nimport " + MyEvent.class.getCanonicalName() + ";\ndeclare MyEvent\n    @role(event)\n    @timestamp(timestamp)\nend\n\nglobal java.util.List list; \nrule \"over 0.3s\"\nsalience 1 \n    when\n        $list: List() from collect(MyEvent() over window:time(300ms))\n    then\n        System.out.println(\"Rule: with in 0.3s --> \" + $list);\n        list.add( 'r1:' + $list.size() ); \nend\n\nrule \"over 1s\"\nsalience 2 \n    when\n        $list: List() from collect(MyEvent() over window:time(1s))\n    then\n        System.out.println(\"Rule: with in 1s --> \" + $list);\n        list.add( 'r2:' + $list.size() ); \nend\n\nrule \"over 3s\"\nsalience 3 \n    when\n        $list: List() from collect(MyEvent() over window:time(3s))\n    then\n        System.out.println(\"Rule: with in 3s --> \" + $list);\n        list.add( 'r3:' + $list.size() ); \nend\n\nrule \"over 0.3s ep\"\nsalience 4 \n    when\n        $list: List() from collect(MyEvent() over window:time(300ms) from entry-point \"stream\")\n    then\n        System.out.println(\"Rule: with in 0.3s use ep --> \" + $list);\n        list.add( 'r4:' + $list.size() ); \nend\n\nrule \"over 1s ep\"\nsalience 5 \n    when\n        $list: List() from collect(MyEvent() over window:time(1s) from entry-point \"stream\")\n    then\n        System.out.println(\"Rule: with in 1s use ep --> \" + $list);\n        list.add( 'r5:' + $list.size() ); \nend\n\nrule \"over 3s ep\"\nsalience 6 \n    when\n        $list: List() from collect(MyEvent() over window:time(3s) from entry-point \"stream\")\n    then\n        System.out.println(\"Rule: with in 3s use ep --> \" + $list);\n        list.add( 'r6:' + $list.size() ); \nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            list.clear();
            for (int j = 0; j < 5; ++j) {
                clock.advanceTime(500L, TimeUnit.MILLISECONDS);
                ksession.insert((Object)new MyEvent(clock.getCurrentTime()));
                ksession.getEntryPoint("stream").insert((Object)new MyEvent(clock.getCurrentTime()));
                clock.advanceTime(500L, TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                System.out.println(list);
                switch (j) {
                    case 0: {
                        Assertions.assertThat(list).isEqualTo(Arrays.asList("r6:1", "r5:1", "r3:1", "r2:1"));
                        break;
                    }
                    case 1: {
                        Assertions.assertThat(list).isEqualTo(Arrays.asList("r6:2", "r5:1", "r3:2", "r2:1"));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Assertions.assertThat(list).isEqualTo(Arrays.asList("r6:3", "r5:1", "r3:3", "r2:1"));
                        break;
                    }
                    default: {
                        Assertions.fail((String)"Unexpected condition");
                    }
                }
                list.clear();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpirationOnModification() {
        String drl = "\nimport java.util.*;\nglobal List list; declare SomeEvent\n    @role( event )\n    @expires( 200ms )\n  done : boolean = false \nend\nrule Count \n  no-loop \n     when         $ev : SomeEvent( done == false  )         accumulate ( SomeEvent() over window:time( 10s ),                     $num : count( 1 ) )\n    then\n        modify ( $ev ) { setDone( true ); }         list.add( $num ); \nend\nrule Init \n    when\n      $s : String()     then\n      retract( $s );       insert( new SomeEvent() ); end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"\nimport java.util.*;\nglobal List list; declare SomeEvent\n    @role( event )\n    @expires( 200ms )\n  done : boolean = false \nend\nrule Count \n  no-loop \n     when         $ev : SomeEvent( done == false  )         accumulate ( SomeEvent() over window:time( 10s ),                     $num : count( 1 ) )\n    then\n        modify ( $ev ) { setDone( true ); }         list.add( $num ); \nend\nrule Init \n    when\n      $s : String()     then\n      retract( $s );       insert( new SomeEvent() ); end\n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            clock.advanceTime(100L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            clock.advanceTime(500L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)"go");
            ksession.fireAllRules();
            Assertions.assertThat(list).isEqualTo(Arrays.asList(1L, 2L, 1L));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testTemporalEvaluatorsWithEventsFromNode() {
        String drl = "\nimport java.util.*; global List list; declare Delivery   @role( event ) @timestamp( effectiveDate )   effectiveDate : Date   configs : List end declare Config   @role( event ) @timestamp( todate )   todate : Date end rule Control when   $dpo: Delivery()   $gCfg: Config( todate == null || this after[ 0d ] $dpo ) from $dpo.configs then   list.add( 0 ); end rule Init when then   Delivery dpo = new Delivery( new Date(), new ArrayList() );   Config gCfg = new Config();       gCfg.setTodate( new Date( new Date().getTime() + 1000 ) );   dpo.getConfigs().add( gCfg );     insert( dpo ); end ";
        this.testTemporalEvaluators("\nimport java.util.*; global List list; declare Delivery   @role( event ) @timestamp( effectiveDate )   effectiveDate : Date   configs : List end declare Config   @role( event ) @timestamp( todate )   todate : Date end rule Control when   $dpo: Delivery()   $gCfg: Config( todate == null || this after[ 0d ] $dpo ) from $dpo.configs then   list.add( 0 ); end rule Init when then   Delivery dpo = new Delivery( new Date(), new ArrayList() );   Config gCfg = new Config();       gCfg.setTodate( new Date( new Date().getTime() + 1000 ) );   dpo.getConfigs().add( gCfg );     insert( dpo ); end ");
    }

    @Test
    public void testTemporalEvaluatorsUsingRawDateFields() {
        String drl = "\nimport java.util.*; global List list; declare Delivery   effectiveDate : Date end declare Config   todate : Date end rule Control when   $dpo: Delivery( $eff : effectiveDate )   $gCfg: Config( todate == null || todate after[ 0d ] $eff ) then   list.add( 0 ); end rule Init when then   Delivery dpo = new Delivery( new Date( 1000 ) );   Config gCfg = new Config();       gCfg.setTodate( new Date( 2000 ) );     insert( dpo );   insert( gCfg ); end ";
        this.testTemporalEvaluators("\nimport java.util.*; global List list; declare Delivery   effectiveDate : Date end declare Config   todate : Date end rule Control when   $dpo: Delivery( $eff : effectiveDate )   $gCfg: Config( todate == null || todate after[ 0d ] $eff ) then   list.add( 0 ); end rule Init when then   Delivery dpo = new Delivery( new Date( 1000 ) );   Config gCfg = new Config();       gCfg.setTodate( new Date( 2000 ) );     insert( dpo );   insert( gCfg ); end ");
    }

    @Test
    public void testTemporalEvaluatorsUsingRawDateFieldsFromFrom() {
        String drl = "\nimport java.util.*; global List list; declare Delivery   effectiveDate : Date end declare Config   todate : Date end rule Control when   $dpo: Delivery( $eff : effectiveDate ) from new Delivery( new Date( 1000 ) )   $gCfg: Config( todate == null || todate after[ 0d ] $eff ) from new Config( new Date( 2000 ) ) then   list.add( 0 ); end ";
        this.testTemporalEvaluators("\nimport java.util.*; global List list; declare Delivery   effectiveDate : Date end declare Config   todate : Date end rule Control when   $dpo: Delivery( $eff : effectiveDate ) from new Delivery( new Date( 1000 ) )   $gCfg: Config( todate == null || todate after[ 0d ] $eff ) from new Config( new Date( 2000 ) ) then   list.add( 0 ); end ");
    }

    @Test
    public void testTemporalEvaluatorsUsingSelfDates() {
        String drl = "\nimport java.util.*; global List list; declare Delivery   thisDate : Date   thatDate : Date end rule Init when then insert( new Delivery( new Date( 1000 ), new Date( 200 ) ) ); end rule Control when   Delivery( thisDate == null || thisDate after[ 0d ] thatDate ) then   list.add( 0 ); end ";
        this.testTemporalEvaluators("\nimport java.util.*; global List list; declare Delivery   thisDate : Date   thatDate : Date end rule Init when then insert( new Delivery( new Date( 1000 ), new Date( 200 ) ) ); end rule Control when   Delivery( thisDate == null || thisDate after[ 0d ] thatDate ) then   list.add( 0 ); end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTemporalEvaluators(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Assertions.assertThat((Object)ksession).isNotNull();
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventOffsetExpirationOverflow() {
        String drl = "\nimport java.util.*; declare LongLastingEvent \n @role( event ) @timestamp( start )  @duration( duration )       start : long       duration : long end \nrule Insert   when   then       insert( new LongLastingEvent( 100, Long.MAX_VALUE ) );   end   rule Collect \nwhen\n accumulate( $x: LongLastingEvent() over window:time(1h), $num : count($x) ) \nthen end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"\nimport java.util.*; declare LongLastingEvent \n @role( event ) @timestamp( start )  @duration( duration )       start : long       duration : long end \nrule Insert   when   then       insert( new LongLastingEvent( 100, Long.MAX_VALUE ) );   end   rule Collect \nwhen\n accumulate( $x: LongLastingEvent() over window:time(1h), $num : count($x) ) \nthen end "});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ksession.fireAllRules();
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiredEventModification() {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\nimport java.util.Date\n\ndeclare OtherFact\n    @role( event )\nend\n\ndeclare SimpleEvent\n    @role( event )\n    @expires( 1h )\n    @timestamp( dateEvt )\nend\n\n\nrule R no-loop\n    when\n        $e : SimpleEvent()\n        not OtherFact( this after[1ms, 1h] $e )\n    then\n        modify($e) {setCode(\"code2\")};\n    end\n ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(System.currentTimeMillis());
            SimpleEvent event = new SimpleEvent("code1");
            event.setDateEvt(System.currentTimeMillis() - 0x6DDD00L);
            ksession.insert((Object)event);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporalOperatorWithConstant() {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\nimport java.util.Date\nglobal java.util.List list\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( dateEvt )\nend\n\nrule R \n    when\n        $e : SimpleEvent( this after \"01-Jan-2014\"  )\n    then\n        list.add(\"1\");\n    end\n ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SimpleEvent event = new SimpleEvent("code1", DateUtils.parseDate((String)"18-Mar-2014").getTime());
            ksession.insert((Object)event);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporalOperatorWithConstantAndJoin() {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\nimport java.util.Date\nglobal java.util.List list\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( dateEvt )\nend\n\nrule R \n    when\n        $e1 : SimpleEvent( this after \"01-Jan-2014\"  )\n        $e2 : SimpleEvent( this after $e1 ) \n    then\n        list.add(\"1\");\n    end\n ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            SimpleEvent event1 = new SimpleEvent("code1", DateUtils.parseDate((String)"18-Mar-2014").getTime());
            ksession.insert((Object)event1);
            SimpleEvent event2 = new SimpleEvent("code2", DateUtils.parseDate((String)"19-Mar-2014").getTime());
            ksession.insert((Object)event2);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicSalienceInStreamMode() {
        String drl = "import java.util.concurrent.atomic.AtomicInteger;\n\nglobal AtomicInteger salience1\nglobal AtomicInteger salience2\nglobal java.util.List list\n\ndeclare Integer\n @role(event)\nend\n\nrule R1\nsalience salience1.get()\nwhen\n $i : Integer()\nthen\n retract($i);\n salience1.decrementAndGet();\n list.add(1);\nend \n\nrule R2\nsalience salience2.get()\nwhen\n $i : Integer()\nthen\n retract($i);\n salience2.decrementAndGet();\n list.add(2);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.concurrent.atomic.AtomicInteger;\n\nglobal AtomicInteger salience1\nglobal AtomicInteger salience2\nglobal java.util.List list\n\ndeclare Integer\n @role(event)\nend\n\nrule R1\nsalience salience1.get()\nwhen\n $i : Integer()\nthen\n retract($i);\n salience1.decrementAndGet();\n list.add(1);\nend \n\nrule R2\nsalience salience2.get()\nwhen\n $i : Integer()\nthen\n retract($i);\n salience2.decrementAndGet();\n list.add(2);\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.setGlobal("salience1", (Object)new AtomicInteger(9));
            ksession.setGlobal("salience2", (Object)new AtomicInteger(10));
            for (int i = 0; i < 10; ++i) {
                ksession.insert((Object)i);
                ksession.fireAllRules();
            }
            Assertions.assertThat(Arrays.asList(2, 1, 2, 1, 2, 1, 2, 1, 2, 1)).isEqualTo(list);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2NotsWithTemporalConstraints() {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\nimport java.util.Date\n\ndeclare OtherFact\n    @role( event )\nend\n\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( dateEvt )\nend\n\n\nrule R\n    when\n        $e : SimpleEvent()\n        not OtherFact( this after[0, 1h] $e )\n        not OtherFact( this after[0, 1h] $e )\n    then\n        $e.setCode(\"code2\");\n    end\n ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(System.currentTimeMillis());
            SimpleEvent event = new SimpleEvent("code1");
            event.setDateEvt(System.currentTimeMillis() - 0x6DDD00L);
            ksession.insert((Object)event);
            ksession.fireAllRules();
            Assertions.assertThat((String)event.getCode()).isEqualTo("code2");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetractFromWindow() {
        String drl = "import " + StockTick.class.getCanonicalName() + ";\n declare StockTick\n @role( event )\nend\nrule R1 when\n    $i: Integer()\n    $s: StockTick( price > 10 )\nthen\n    modify($s) { setPrice(8) };\nend\nrule R2 when\n    $s: StockTick( price > 15 ) over window:length(1)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)42);
            ksession.insert((Object)new StockTick(1L, "DROOLS", 20.0));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCEPNamedCons() {
        String drl = "package org.drools global java.util.List list; declare  Msg     @role( event )    sender : String  @key end rule Init when   $s : String() then   System.out.println( 'Msg ' + $s );   insert( new Msg( $s ) ); end rule 'Expect_Test_Rule Fulfill' when     $trigger : Msg( 'John' ; )     Msg( 'Peter' ; this after[0,100000ms] $trigger )     do[fulfill] then   System.out.println( 'Expectation fulfilled' );   list.add( 1 ); then[fulfill]   System.out.println( 'insert fulf fact' );   list.add( 2 ); end rule 'Expect_Test_Rule Violation' when     $trigger : Msg( 'John' ; ) do[asap]    not Msg( 'Peter' ; this after[0,100000ms] $trigger )     do[viol]  \nthen   System.out.println( 'Expectation violated' );   list.add( -1 ); then[viol]   System.out.println( 'insert viol fact' );   list.add( -2 ); then[asap]   System.out.println( 'Did it anyway' );   list.add( 0 ); end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools global java.util.List list; declare  Msg     @role( event )    sender : String  @key end rule Init when   $s : String() then   System.out.println( 'Msg ' + $s );   insert( new Msg( $s ) ); end rule 'Expect_Test_Rule Fulfill' when     $trigger : Msg( 'John' ; )     Msg( 'Peter' ; this after[0,100000ms] $trigger )     do[fulfill] then   System.out.println( 'Expectation fulfilled' );   list.add( 1 ); then[fulfill]   System.out.println( 'insert fulf fact' );   list.add( 2 ); end rule 'Expect_Test_Rule Violation' when     $trigger : Msg( 'John' ; ) do[asap]    not Msg( 'Peter' ; this after[0,100000ms] $trigger )     do[viol]  \nthen   System.out.println( 'Expectation violated' );   list.add( -1 ); then[viol]   System.out.println( 'insert viol fact' );   list.add( -2 ); then[asap]   System.out.println( 'Did it anyway' );   list.add( 0 ); end "});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"John");
            ksession.fireAllRules();
            ((PseudoClockScheduler)ksession.getSessionClock()).advanceTime(10L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)"Peter");
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.contains(0)).isTrue();
            Assertions.assertThat((boolean)list.contains(1)).isTrue();
            Assertions.assertThat((boolean)list.contains(2)).isTrue();
            Assertions.assertThat((boolean)list.contains(-1)).isFalse();
            Assertions.assertThat((boolean)list.contains(-2)).isFalse();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCEPNamedConsTimers() {
        String drl = "package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   System.out.println( 'Msg ' + $s );   insert( new Msg( $s ) ); end rule 'Viol' when     $trigger : Msg( 'John' ; )     not Msg( 'Peter' ; this after[0, 100ms] $trigger ) do[viol]then   list.add( 0 ); then[viol]   list.add( -2 ); end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   System.out.println( 'Msg ' + $s );   insert( new Msg( $s ) ); end rule 'Viol' when     $trigger : Msg( 'John' ; )     not Msg( 'Peter' ; this after[0, 100ms] $trigger ) do[viol]then   list.add( 0 ); then[viol]   list.add( -2 ); end "});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"John");
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.isEmpty()).isTrue();
            ((PseudoClockScheduler)ksession.getSessionClock()).advanceTime(1000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.contains(-2)).isTrue();
            Assertions.assertThat((boolean)list.contains(0)).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void test2TimersWithNamedCons() {
        String drl = "package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   insert( new Msg( $s ) ); end rule 'Viol' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) do[t1]\n    not Msg( 'Charles' ; this after[0, 200ms] $trigger )\nthen\n  list.add( 0 );\nthen[t1]\n  list.add( 1 );\nend\n";
        this.test2Timers("package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   insert( new Msg( $s ) ); end rule 'Viol' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) do[t1]\n    not Msg( 'Charles' ; this after[0, 200ms] $trigger )\nthen\n  list.add( 0 );\nthen[t1]\n  list.add( 1 );\nend\n");
    }

    @Test
    public void test2TimersWith2Rules() {
        String drl = "package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   insert( new Msg( $s ) ); end rule 'Viol1' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) \n    not Msg( 'Charles' ; this after[0, 200ms] $trigger )\nthen\n  list.add( 0 );\nend\nrule 'Viol2' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) \nthen\n  list.add( 1 );\nend\n";
        this.test2Timers("package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init when   $s : String() then   insert( new Msg( $s ) ); end rule 'Viol1' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) \n    not Msg( 'Charles' ; this after[0, 200ms] $trigger )\nthen\n  list.add( 0 );\nend\nrule 'Viol2' when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) \nthen\n  list.add( 1 );\nend\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test2Timers(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"Alice");
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.isEmpty()).isTrue();
            ((PseudoClockScheduler)ksession.getSessionClock()).advanceTime(150L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCEPWith2NamedConsAndEagerRule() {
        String drl = "package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init1 when   $s : String() then   insert( new Msg( $s ) ); end rule Init2 when   Msg( 'Alice' ; )\nthen   insert( 42 ); end rule 'Viol' @Propagation(EAGER) when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) do[t1]    Integer( ) do[t2]\nthen\n  list.add( 0 );\nthen[t1]\n  list.add( 1 );\nthen[t2]\n  list.add( 2 );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools global java.util.List list; declare  Msg     @role( event )     sender : String  @key end rule Init1 when   $s : String() then   insert( new Msg( $s ) ); end rule Init2 when   Msg( 'Alice' ; )\nthen   insert( 42 ); end rule 'Viol' @Propagation(EAGER) when     $trigger : Msg( 'Alice' ; )\n    not Msg( 'Bob' ; this after[0, 100ms] $trigger ) do[t1]    Integer( ) do[t2]\nthen\n  list.add( 0 );\nthen[t1]\n  list.add( 1 );\nthen[t2]\n  list.add( 2 );\nend\n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"Alice");
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.isEmpty()).isTrue();
            ((PseudoClockScheduler)ksession.getSessionClock()).advanceTime(150L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(3);
            Assertions.assertThat((boolean)list.contains(0)).isTrue();
            Assertions.assertThat((boolean)list.contains(1)).isTrue();
            Assertions.assertThat((boolean)list.contains(2)).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireLogicalEvent() {
        String drl = "package org.drools; declare Foo   @role(event)   @expires(10ms) end rule In when then   insertLogical( new Foo() ); end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools; declare Foo   @role(event)   @expires(10ms) end rule In when then   insertLogical( new Foo() ); end "});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ksession.fireAllRules();
            ((PseudoClockScheduler)ksession.getSessionClock()).advanceTime(1L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
            Assertions.assertThat((int)TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)ksession).getEqualityKeyMap().size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationWithEventInPast() {
        String drl = "import " + Event1.class.getCanonicalName() + "\ndeclare Event1\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 3h )\nend\n\nrule R\n    when\n       $evt: Event1()\n       not Event1(this != $evt, this after[0, 1h] $evt)\n    then\n       System.out.println($evt.getCode());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ksession.insert((Object)new Event1("id1", 0L));
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.advanceTime(2L, TimeUnit.HOURS);
            ksession.fireAllRules();
            ksession.insert((Object)new Event1("id2", 0L));
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseMapAsEvent() {
        String drl = "import java.util.Map\n declare Map \n  @role(event)\nend\nrule \"sliding window time map\" \nwhen \n   $m:Map()\n   accumulate(Map() over window:time( 1m ); $count:count(); $count>1 )\nthen \n    System.out.println(\"alarm!!!!\");  \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.Map\n declare Map \n  @role(event)\nend\nrule \"sliding window time map\" \nwhen \n   $m:Map()\n   accumulate(Map() over window:time( 1m ); $count:count(); $count>1 )\nthen \n    System.out.println(\"alarm!!!!\");  \nend \n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ksession.insert(new HashMap());
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisconnectedEventFactHandle() {
        String drl = "declare String \n  @role(event)\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare String \n  @role(event)\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            DefaultFactHandle helloHandle = (DefaultFactHandle)ksession.insert((Object)"hello");
            DefaultFactHandle goodbyeHandle = (DefaultFactHandle)ksession.insert((Object)"goodbye");
            DefaultFactHandle key = DefaultFactHandle.createFromExternalFormat((String)helloHandle.toExternalForm());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)(key instanceof EventFactHandle)).as("FactHandle not deserialized as EventFactHandle", new Object[0])).isTrue();
            Assertions.assertThat((Object)ksession.getObject((FactHandle)key)).isEqualTo((Object)"hello");
            key = DefaultFactHandle.createFromExternalFormat((String)goodbyeHandle.toExternalForm());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)(key instanceof EventFactHandle)).as("FactHandle not deserialized as EventFactHandle", new Object[0])).isTrue();
            Assertions.assertThat((Object)ksession.getObject((FactHandle)key)).isEqualTo((Object)"goodbye");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testEventWithShortExpiration() throws InterruptedException {
        String drl = "declare String\n  @expires( 1ms )\n  @role( event )\nend\n\nrule R when\n  String( )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare String\n  @expires( 1ms )\n  @role( event )\nend\n\nrule R when\n  String( )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"test");
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            TimeUtil.sleepMillis((long)2L);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            while (ksession.getObjects().size() != 0) {
                TimeUtil.sleepMillis((long)30L);
                Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteExpiredEvent() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\ndeclare StockTick\n    @role( event )\nend\n\nrule \"TestEventReceived\"\nno-loop\nwhen\n  $st1 : StockTick( company == \"ACME\" )\n  not ( StockTick( this != $st1, this after[0s, 1s] $st1) )\nthen\n  delete($st1);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            EventFactHandle handle1 = (EventFactHandle)ksession.insert((Object)new StockTick(1L, "ACME", 50.0));
            ksession.fireAllRules();
            clock.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)handle1.isExpired()).isTrue();
            Assertions.assertThat((boolean)ksession.getFactHandles().contains(handle1)).isFalse();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteExpiredEventWithTimestampAndEqualityKey() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\ndeclare StockTick\n    @role( event )\n    @timestamp( time )\nend\n\nrule \"TestEventReceived\"\nwhen\n  $st1 : StockTick( company == \"ACME\" )\n  not ( StockTick( this != $st1, this after[0s, 1s] $st1) )\nthen\n  delete($st1);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.setStartupTime(5000L);
            EventFactHandle handle1 = (EventFactHandle)ksession.insert((Object)new StockTick(1L, "ACME", 50.0, 0L));
            clock.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)handle1.isExpired()).isTrue();
            Assertions.assertThat((boolean)ksession.getFactHandles().contains(handle1)).isFalse();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationWithWindowLength() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list\ndeclare StockTick\n    @role( event )\nend\n\nrule ReportLastEvent when\n    $e : StockTick() over window:length(1)\nthen\n    list.add($e.getCompany());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new StockTick(1L, "ACME", 50.0));
            ksession.insert((Object)new StockTick(2L, "DROO", 50.0));
            ksession.insert((Object)new StockTick(3L, "JBPM", 50.0));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("JBPM");
            try {
                ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationWithWindowLengthAndLiaSharing() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list\ndeclare StockTick\n    @role( event )\nend\n\nrule ReportLastEvent when\n    $e : StockTick() over window:length(1)\nthen\n    list.add($e.getCompany());\nend\n\nrule ReportEventInserted when\n   $e : StockTick()\nthen\n   System.out.println(\"Event Insert : \" + $e);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new StockTick(1L, "ACME", 50.0));
            ksession.insert((Object)new StockTick(2L, "DROO", 50.0));
            ksession.insert((Object)new StockTick(3L, "JBPM", 50.0));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("JBPM");
            try {
                ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializationBeforeFireWithWindowLength() {
        String drl = "import " + StockTick.class.getCanonicalName() + "\nglobal java.util.List list\ndeclare StockTick\n    @role( event )\nend\n\nrule ReportLastEvent when\n    $e : StockTick() over window:length(1)\nthen\n    list.add($e.getCompany());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new StockTick(1L, "ACME", 50.0));
            ksession.insert((Object)new StockTick(2L, "DROO", 50.0));
            ksession.insert((Object)new StockTick(3L, "JBPM", 50.0));
            try {
                ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("JBPM");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubclassWithLongerExpirationThanSuper() {
        String drl = "import " + SuperClass.class.getCanonicalName() + "\nimport " + SubClass.class.getCanonicalName() + "\n\nrule R1 when\n    $e : SuperClass()\nthen\nend\nrule R2 when\n    $e : SubClass()\n    not SubClass(this != $e)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            EventFactHandle handle1 = (EventFactHandle)ksession.insert((Object)new SubClass());
            ksession.fireAllRules();
            clock.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)handle1.isExpired()).isFalse();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)handle1.isExpired()).isTrue();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubclassWithLongerExpirationThanSuperWithSerialization() {
        String drl = "import " + SuperClass.class.getCanonicalName() + "\nimport " + SubClass.class.getCanonicalName() + "\n\nrule R1 when\n    $e : SuperClass()\nthen\nend\nrule R2 when\n    $e : SubClass()\n    not SubClass(this != $e)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            EventFactHandle handle1 = (EventFactHandle)ksession.insert((Object)new SubClass());
            ksession.fireAllRules();
            clock.advanceTime(15L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)handle1.isExpired()).isFalse();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(1);
            try {
                ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
            clock = (PseudoClockScheduler)ksession.getSessionClock();
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporalOperatorWithGlobal() {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\nglobal java.util.List list;\nglobal " + SimpleEvent.class.getCanonicalName() + " baseEvent;\n\ndeclare SimpleEvent\n    @role( event )\n    @timestamp( dateEvt )\nend\n\nrule R \n    when\n        $e : SimpleEvent( dateEvt before[10s] baseEvent.dateEvt )\n    then\n        list.add(\"1\");\n    end\n ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.setGlobal("baseEvent", (Object)new SimpleEvent("1", 15000L));
            SimpleEvent event1 = new SimpleEvent("1", 0L);
            ksession.insert((Object)event1);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNoExpirationWithNot() {
        this.checkNoExpiration("$s: SimpleEvent ()\nnot SimpleEvent (this != $s, this after[0, 30s] $s)\n");
    }

    @Test
    public void testNoExpirationWithSlidingWindow() {
        this.checkNoExpiration("SimpleEvent( ) over window:time(30s)\n");
    }

    @Test
    public void testNoExpirationWithNoTemporalConstraint() {
        this.checkNoExpiration("SimpleEvent( )\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNoExpiration(String lhs) {
        String drl = "import " + SimpleEvent.class.getCanonicalName() + "\ndeclare SimpleEvent\n    @role( event )\n    @expires( -1 )\n    @timestamp( dateEvt )\nend\n\nrule R when\n" + lhs + "then\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
            SimpleEvent event1 = new SimpleEvent("1", 0L);
            ksession.insert((Object)event1);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
            clock.advanceTime(60000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelActivationWithExpiredEvent() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R\n    timer (int: 0 1; start=$startTime, repeat-limit=0 )\n    when\n       $event: MyEvent ($startTime : timestamp)\n       $counter : AtomicInteger(get() > 0)\n    then\n        System.out.println(\"RG_TEST_TIMER WITH \" + $event + \" AND \" + $counter);\n        modify($counter){\n            decrementAndGet()\n        }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            long now = System.currentTimeMillis();
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(now - 10000L);
            AtomicInteger counter = new AtomicInteger(1);
            MyEvent event1 = new MyEvent(now - 8000L);
            MyEvent event2 = new MyEvent(now - 7000L);
            MyEvent event3 = new MyEvent(now - 6000L);
            ksession.insert((Object)counter);
            ksession.insert((Object)event1);
            ksession.insert((Object)event2);
            ksession.insert((Object)event3);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
            sessionClock.advanceTime(10000L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRightTupleExpiration() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\nglobal AtomicInteger counter;\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R when\n       String()\n       MyEvent()\n       Boolean()\n       Integer()\n    then\n       counter.incrementAndGet();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(0L);
            AtomicInteger counter = new AtomicInteger(0);
            ksession.setGlobal("counter", (Object)counter);
            ksession.insert((Object)"test");
            ksession.insert((Object)true);
            ksession.insert((Object)new MyEvent(0L));
            ksession.insert((Object)new MyEvent(15L));
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
            sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)1);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftTupleExpiration() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\nglobal AtomicInteger counter;\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R when\n       MyEvent()\n       Boolean()\n       Integer()\n    then\n       counter.incrementAndGet();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(0L);
            AtomicInteger counter = new AtomicInteger(0);
            ksession.setGlobal("counter", (Object)counter);
            ksession.insert((Object)true);
            ksession.insert((Object)new MyEvent(0L));
            ksession.insert((Object)new MyEvent(15L));
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
            sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
            ksession.insert((Object)1);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeftTupleExpirationWithNot() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\nglobal AtomicInteger counter;\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R when\n       MyEvent()\n       Boolean()\n       not Integer()\n    then\n       counter.incrementAndGet();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(0L);
            AtomicInteger counter = new AtomicInteger(0);
            ksession.setGlobal("counter", (Object)counter);
            ksession.insert((Object)true);
            FactHandle iFh = ksession.insert((Object)1);
            ksession.insert((Object)new MyEvent(0L));
            ksession.insert((Object)new MyEvent(15L));
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
            sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
            ksession.delete(iFh);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireLogicallyInsertedEvent() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R when\n  $e : MyEvent()\nthen\n  insertLogical($e.toString());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(0L);
            ksession.insert((Object)new MyEvent(0L));
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
            sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiredEventWithPendingActivations() throws Exception {
        String drl = "package org.drools.drools_usage_pZB7GRxZp64;\n\ndeclare time_Var\n    @role( event )\n    @expires( 1s )\n    value : Long\nend\n\ndeclare ExpiringEvent_Var\n    @role( event )\n    @expires( 10s )\n    value : Double\nend\n\ndeclare window ExpiringEvent_Window1 ExpiringEvent_Var() over window:length(1) end\n\nrule \"Expring variable - Init\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        not ExpiringEvent_Var()\n\n    then\n        System.out.println($now + \" : Init\");\n        insert(new ExpiringEvent_Var(0.0));\nend\n\nrule \"Expiring variable - Rule 1\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        ExpiringEvent_Var(this before $t, $previousValue : Value < 1.0) from window ExpiringEvent_Window1\n\n    then\n        System.out.println($now + \" : Rule 1\");\n        insert(new ExpiringEvent_Var(1.0));\n\nend\n\nrule \"Expiring variable - Rule 2\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        ExpiringEvent_Var(this before $t, $previousValue : Value) from window ExpiringEvent_Window1\n\n    then\n        System.out.println($now + \" : Rule 2\");\n        insert(new ExpiringEvent_Var($previousValue));\n\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.drools_usage_pZB7GRxZp64;\n\ndeclare time_Var\n    @role( event )\n    @expires( 1s )\n    value : Long\nend\n\ndeclare ExpiringEvent_Var\n    @role( event )\n    @expires( 10s )\n    value : Double\nend\n\ndeclare window ExpiringEvent_Window1 ExpiringEvent_Var() over window:length(1) end\n\nrule \"Expring variable - Init\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        not ExpiringEvent_Var()\n\n    then\n        System.out.println($now + \" : Init\");\n        insert(new ExpiringEvent_Var(0.0));\nend\n\nrule \"Expiring variable - Rule 1\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        ExpiringEvent_Var(this before $t, $previousValue : Value < 1.0) from window ExpiringEvent_Window1\n\n    then\n        System.out.println($now + \" : Rule 1\");\n        insert(new ExpiringEvent_Var(1.0));\n\nend\n\nrule \"Expiring variable - Rule 2\"\nactivation-group \"ExpiringEvent\"\n    when\n        $t : time_Var($now : Value != null) over window:length(1)\n\n        ExpiringEvent_Var(this before $t, $previousValue : Value) from window ExpiringEvent_Window1\n\n    then\n        System.out.println($now + \" : Rule 2\");\n        insert(new ExpiringEvent_Var($previousValue));\n\nend"});
        KieSession session = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
            FactType time_VarType = kbase.getFactType("org.drools.drools_usage_pZB7GRxZp64", "time_Var");
            clock.advanceTime(1472057509000L, TimeUnit.MILLISECONDS);
            Object time_Var = time_VarType.newInstance();
            time_VarType.set(time_Var, "value", (Object)1472057509000L);
            session.insert(time_Var);
            session.fireAllRules();
            for (int i = 0; i < 10; ++i) {
                clock.advanceTime(1L, TimeUnit.SECONDS);
                Object time_VarP1 = time_VarType.newInstance();
                time_VarType.set(time_VarP1, "value", (Object)clock.getCurrentTime());
                session.insert(time_VarP1);
                session.fireAllRules();
            }
            clock.advanceTime(1L, TimeUnit.SECONDS);
            session.fireAllRules();
            clock.advanceTime(1L, TimeUnit.HOURS);
            Object time_VarP1 = time_VarType.newInstance();
            time_VarType.set(time_VarP1, "value", (Object)clock.getCurrentTime());
            session.insert(time_VarP1);
            session.fireAllRules();
            clock.advanceTime(1L, TimeUnit.HOURS);
            Object time_VarP2 = time_VarType.newInstance();
            time_VarType.set(time_VarP2, "value", (Object)clock.getCurrentTime());
            session.insert(time_VarP2);
            session.fireAllRules();
            clock.advanceTime(1L, TimeUnit.HOURS);
            session.fireAllRules();
            for (Object o : session.getFactHandles()) {
                if (!(o instanceof EventFactHandle)) continue;
                EventFactHandle eventFactHandle = (EventFactHandle)o;
                Assertions.assertThat((boolean)eventFactHandle.isExpired()).isFalse();
            }
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimerWithMillisPrecision() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R\n    timer (int: 0 1; start=$startTime, repeat-limit=0 )\n    when\n       $event: MyEvent ($startTime : timestamp)\n       $counter : AtomicInteger(get() > 0)\n    then\n        System.out.println(\"RG_TEST_TIMER WITH \" + $event + \" AND \" + $counter);\n        modify($counter){\n            decrementAndGet()\n        }\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            long now = 1000L;
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(990L);
            AtomicInteger counter = new AtomicInteger(1);
            MyEvent event1 = new MyEvent(992L);
            MyEvent event2 = new MyEvent(993L);
            MyEvent event3 = new MyEvent(994L);
            ksession.insert((Object)counter);
            ksession.insert((Object)event1);
            ksession.insert((Object)event2);
            ksession.insert((Object)event3);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
            sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSerializationDeserliaizationWithRectractedExpireFact() {
        String drl = "package " + TestEvent.class.getPackage().getName() + "\ndeclare " + TestEvent.class.getCanonicalName() + "\n   @role( event ) \n   @expires( 60d ) \nend\nrule \"retract test rule\"\nsalience 10 \nwhen\n   $e : TestEvent() over window:length(1)\nthen\n   delete($e);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        StatefulKnowledgeSession kieSessionDeserialized = null;
        try {
            ksession.insert((Object)new TestEvent("test1"));
            ksession.fireAllRules();
            try {
                kieSessionDeserialized = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
            }
        }
        catch (Throwable throwable) {
            ksession.dispose();
            Assertions.assertThat(kieSessionDeserialized).isNotNull();
            kieSessionDeserialized.insert((Object)new TestEvent("test2"));
            kieSessionDeserialized.fireAllRules();
            throw throwable;
        }
        ksession.dispose();
        Assertions.assertThat((Object)kieSessionDeserialized).isNotNull();
        kieSessionDeserialized.insert((Object)new TestEvent("test2"));
        kieSessionDeserialized.fireAllRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConflictingRightTuplesUpdate() {
        String drl = "declare Integer @role(event) end\nrule R when\n    Integer()\n    not String()\n\nthen end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare Integer @role(event) end\nrule R when\n    Integer()\n    not String()\n\nthen end"});
        KieSession kieSession = kbase.newKieSession();
        try {
            FactHandle fhA = kieSession.insert((Object)"A");
            FactHandle fhB = kieSession.insert((Object)"B");
            FactHandle fh1 = kieSession.insert((Object)1);
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
            kieSession.delete(fh1);
            kieSession.update(fhA, (Object)"A");
            kieSession.update(fhB, (Object)"B");
            kieSession.insert((Object)2);
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyEventOverWindow() {
        String drl = "import " + AtomicBoolean.class.getCanonicalName() + "\ndeclare AtomicBoolean @role(event) end\nglobal java.util.List list;\nrule R1 when\n    $event : AtomicBoolean(!get())\n    String()\nthen\n    retract($event);\n    list.add(\"R1\");\nend\n\nrule R2 when\n    $b : AtomicBoolean() over window:length(10)\n    not String()\nthen\n    modify($b) { set(true) }\n    insert(\"check\");\n    list.add(\"R2\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new AtomicBoolean(false));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("R2");
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpirationOnAfter() {
        String drl = "declare String @role( event ) end\ndeclare Integer @role( event ) end\n\nrule R when\n    $s: String()\n    $i: Integer(this after[0,10s] $s)\nthen\n    System.out.println(\"fired\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare String @role( event ) end\ndeclare Integer @role( event ) end\n\nrule R when\n    $s: String()\n    $i: Integer(this after[0,10s] $s)\nthen\n    System.out.println(\"fired\");\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            ksession.insert((Object)"test");
            ksession.insert((Object)1);
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(2L);
            ksession.fireAllRules();
            sessionClock.advanceTime(11L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpirationOnBefore() {
        String drl = "declare String @role( event ) end\ndeclare Integer @role( event ) end\n\nrule R when\n    $s: String()\n    $i: Integer(this before[0,10s] $s)\nthen\n    System.out.println(\"fired\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare String @role( event ) end\ndeclare Integer @role( event ) end\n\nrule R when\n    $s: String()\n    $i: Integer(this before[0,10s] $s)\nthen\n    System.out.println(\"fired\");\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            ksession.insert((Object)1);
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
            ksession.fireAllRules();
            sessionClock.advanceTime(11L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFireExpiredEventOnInactiveGroup() {
        String drl = "global java.util.List list;\ndeclare String  @role(event) @expires( 6d ) end\ndeclare Integer @role(event) @expires( 3d ) end\n\nrule \"RG_1\"\n    agenda-group \"rf-grp1\"\n    when\n        $event: Integer()\n        not String(this after [1ms, 48h] $event)\n    then\n      System.out.println(\"RG_1 fired\");\n      retract($event);\n      list.add(\"RG_1\");\nend\n\nrule \"RG_2\"\n    agenda-group \"rf-grp1\"\n    when\n        $event: String()\n        not Integer(this after [1ms, 144h] $event)\n    then\n      System.out.println(\"RG_2 fired\");\n      list.add(\"RG_2\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;\ndeclare String  @role(event) @expires( 6d ) end\ndeclare Integer @role(event) @expires( 3d ) end\n\nrule \"RG_1\"\n    agenda-group \"rf-grp1\"\n    when\n        $event: Integer()\n        not String(this after [1ms, 48h] $event)\n    then\n      System.out.println(\"RG_1 fired\");\n      retract($event);\n      list.add(\"RG_1\");\nend\n\nrule \"RG_2\"\n    agenda-group \"rf-grp1\"\n    when\n        $event: String()\n        not Integer(this after [1ms, 144h] $event)\n    then\n      System.out.println(\"RG_2 fired\");\n      list.add(\"RG_2\");\nend\n"});
        KieSession kieSession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            kieSession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                    if (event.getAgendaGroup().getName().equals("rf-grp0")) {
                        event.getKieRuntime().getAgenda().getAgendaGroup("rf-grp1").setFocus();
                    }
                }
            });
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)kieSession.getSessionClock();
            kieSession.insert((Object)"DummyEvent");
            kieSession.insert((Object)1);
            kieSession.getAgenda().getAgendaGroup("rf-grp0").setFocus();
            kieSession.fireAllRules();
            Assertions.assertThat((long)kieSession.getFactCount()).isEqualTo(2L);
            sessionClock.advanceTime(145L, TimeUnit.HOURS);
            kieSession.getAgenda().getAgendaGroup("rf-grp0").setFocus();
            kieSession.fireAllRules();
            ((AbstractLongAssert)Assertions.assertThat((long)kieSession.getFactCount()).as("Expiration occured => no more fact in WM", new Object[0])).isEqualTo(0L);
            ((AbstractLongAssert)Assertions.assertThat((long)list.stream().filter(r -> r.equals("RG_1")).count()).as("RG_1 should fire once", new Object[0])).isEqualTo(1L);
            ((AbstractLongAssert)Assertions.assertThat((long)list.stream().filter(r -> r.equals("RG_2")).count()).as("RG_2 should fire once", new Object[0])).isEqualTo(1L);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireUnusedDeclaredTypeEvent() {
        String drl = "declare String @role( event ) @expires( 1s ) end\n\nrule R when\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare String @role( event ) @expires( 1s ) end\n\nrule R when\nthen\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            ksession.insert((Object)"test");
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(1L);
            sessionClock.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireUnusedDeclaredTypeClass() {
        String drl = "rule R when\nthen\n  System.out.println(\"fired\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R when\nthen\n  System.out.println(\"fired\");\nend\n"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            ksession.insert((Object)new EventWithoutRule());
            ksession.fireAllRules();
            sessionClock.advanceTime(2L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((long)ksession.getFactCount()).isEqualTo(0L);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOfDeserializedJob() {
        String drl = "import " + EventA.class.getCanonicalName() + "\nimport java.util.Date\nglobal java.util.List list\ndeclare EventA\n\t@role(event)\n\t@timestamp(timestamp)\nend\nrule test\n when\n  \t$event : EventA(value == 1)\n   not(EventA(value == 1, this after [1ms,4m] $event))\n then\n   list.add(\"Fired \"+ $event);\nend\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kieBase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            ArrayList list = new ArrayList();
            ArrayList<EventA> events = new ArrayList<EventA>();
            events.add(new EventA("2010-01-01 02:00:00", 0));
            events.add(new EventA("2010-01-01 03:00:00", 1));
            events.add(new EventA("2010-01-01 03:01:00", 0));
            events.add(new EventA("2010-01-01 03:02:00", 1));
            events.add(new EventA("2010-01-01 03:03:00", 0));
            events.add(new EventA("2010-01-01 03:04:00", 0));
            events.add(new EventA("2010-01-01 03:05:00", 0));
            events.add(new EventA("2010-01-01 03:06:00", 0));
            events.add(new EventA("2010-01-01 03:07:00", 0));
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            clock.advanceTime(((EventA)events.get(0)).getTimestamp().getTime(), TimeUnit.MILLISECONDS);
            byte[] serializedSession = null;
            try {
                Marshaller marshaller = KieServices.Factory.get().getMarshallers().newMarshaller(kieBase);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                marshaller.marshall((OutputStream)baos, ksession);
                serializedSession = baos.toByteArray();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            for (EventA current : events) {
                long currTime;
                KieSession ksession2 = null;
                Marshaller marshaller = KieServices.Factory.get().getMarshallers().newMarshaller(kieBase);
                System.out.println("1) " + current);
                try {
                    Assertions.assertThat((byte[])serializedSession).isNotNull();
                    ByteArrayInputStream bais = new ByteArrayInputStream(serializedSession);
                    ksession2 = marshaller.unmarshall((InputStream)bais, ksession.getSessionConfiguration(), null);
                    ksession2.setGlobal("list", list);
                    clock = (SessionPseudoClock)ksession2.getSessionClock();
                    bais.close();
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                    Assertions.fail((String)e.getMessage());
                }
                System.out.println("2) " + current);
                long nextTime = current.getTimestamp().getTime();
                for (currTime = clock.getCurrentTime(); currTime <= nextTime - 1000L; currTime += 1000L) {
                    clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
                    ksession2.fireAllRules();
                }
                long diff = nextTime - currTime;
                if (diff > 0L) {
                    clock.advanceTime(diff, TimeUnit.MILLISECONDS);
                }
                System.out.println("3) " + current);
                ksession2.insert((Object)current);
                ksession2.fireAllRules();
                System.out.println("4) " + current);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    marshaller.marshall((OutputStream)baos, ksession2);
                    serializedSession = baos.toByteArray();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    Assertions.fail((String)e2.getMessage());
                }
                ksession2.dispose();
                System.out.println("5) " + current);
            }
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("Fired EventA at 2010-01-01 03:02:00");
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testInvalidWindowPredicate() {
        String drl = "declare A\n    @role( event )\n    id : int\nend\nrule \"ab\" \nwhen\n    A( $a : id ) over window:len( 1 )\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"declare A\n    @role( event )\n    id : int\nend\nrule \"ab\" \nwhen\n    A( $a : id ) over window:len( 1 )\nthen\nend"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertLogicalNoExpires() {
        String drl = "import " + ExpiringEventD.class.getCanonicalName() + "\nrule Insert when then    insertLogical( new ExpiringEventD() ); end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertyReactiveWithDurationOnRule() {
        String drl = "package org.drools.test  declare Bean    @PropertyReactive    label : String    active : boolean end   rule Init when then    insert( new Bean( \"aaa\", true ) ); end  rule Close   duration (100) when     $b : Bean( label == \"aaa\" )   then     modify( $b ) {         setActive( false );     }  end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test  declare Bean    @PropertyReactive    label : String    active : boolean end   rule Init when then    insert( new Bean( \"aaa\", true ) ); end  rule Close   duration (100) when     $b : Bean( label == \"aaa\" )   then     modify( $b ) {         setActive( false );     }  end "});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            ((SessionPseudoClock)ksession.getSessionClock()).advanceTime(200L, TimeUnit.MILLISECONDS);
            Assertions.assertThat((int)ksession.fireAllRules(10)).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNPERiaPathMemWithEvent() {
        String drl = "package org.drools  declare  Reading      @role( event )     value : Double  @key end rule Init when then insert( new Reading( 14.5) ); end rule Test when     $trigger : Reading( $value : value  )       not(         Number( doubleValue > 10.0 ) from $value  )     do[viol]   then then[viol] end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools  declare  Reading      @role( event )     value : Double  @key end rule Init when then insert( new Reading( 14.5) ); end rule Test when     $trigger : Reading( $value : value  )       not(         Number( doubleValue > 10.0 ) from $value  )     do[viol]   then then[viol] end "});
        KieSession ksession = kbase.newKieSession();
        try {
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectExpiredEvent() {
        String drl = "import java.util.Collection\ndeclare Integer @role( event ) @expires( 3h ) end\ndeclare Long @role( event ) @expires( 3h ) end\n rule SAME when\n  $i: Integer()\n  Long( intValue == $i )\nthen\n  System.out.println(\"SAME\");\nend\nrule COLLECT when\n  Collection(size > 2) from collect (Number())\nthen\n  System.out.println(\"COLLECT\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.Collection\ndeclare Integer @role( event ) @expires( 3h ) end\ndeclare Long @role( event ) @expires( 3h ) end\n rule SAME when\n  $i: Integer()\n  Long( intValue == $i )\nthen\n  System.out.println(\"SAME\");\nend\nrule COLLECT when\n  Collection(size > 2) from collect (Number())\nthen\n  System.out.println(\"COLLECT\");\nend"});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
            ksession.insert((Object)1);
            clock.advanceTime(2L, TimeUnit.HOURS);
            ksession.insert((Object)2L);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            clock.advanceTime(2L, TimeUnit.HOURS);
            ksession.insert((Object)1L);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testSlidingWindowExpire() throws InterruptedException {
        String drl = "package org.drools.compiler\nimport " + EventA.class.getCanonicalName() + "\ndeclare EventA\n@role(event)\n@timestamp(timestamp)\nend\nrule 'delete outside of window' when\n   $fact : EventA( )\n   not( EventA( this == $fact ) over window:time( 8s ) )\nthen\n    retract($fact);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        FactHandle fh1 = ksession.insert((Object)new EventA(new Date(6000L), 1));
        ksession.fireAllRules();
        FactHandle fh2 = ksession.insert((Object)new EventA(new Date(4000L), 2));
        ksession.fireAllRules();
        FactHandle fh3 = ksession.insert((Object)new EventA(new Date(2000L), 3));
        ksession.fireAllRules();
        ksession.delete(fh3);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(2);
        clock.advanceTime(30L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
    }

    @Role(value=Role.Type.EVENT)
    public static class ExpiringEventD {
    }

    public static class EventA
    implements Serializable {
        private final String time;
        private final int value;
        private final Date timestamp;
        private static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public EventA(String time, int value) {
            this.time = time;
            this.value = value;
            this.timestamp = EventA.parseDate(time);
        }

        public EventA(Date timestamp, int value) {
            this.time = timestamp.toString();
            this.value = value;
            this.timestamp = timestamp;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "EventA at " + this.time;
        }

        private static Date parseDate(String input) {
            Date d = null;
            try {
                d = dateFormatter.parse(input);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return d;
        }
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="1s")
    public class EventWithoutRule {
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="20s")
    public static class SubClass
    extends SuperClass {
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="10s")
    public static class SuperClass
    implements Serializable {
    }

    public static class Event1
    implements Serializable {
        private final String code;
        private final long timestamp;

        public Event1(String code, long timestamp) {
            this.code = code;
            this.timestamp = timestamp;
        }

        public String getCode() {
            return this.code;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "Event1{code='" + this.code + "', timestamp=" + this.timestamp + "}";
        }
    }

    public static class SimpleEvent {
        private String code;
        private Long dateEvt;

        public SimpleEvent(String aCode) {
            this.code = aCode;
            this.dateEvt = System.currentTimeMillis();
        }

        public SimpleEvent(String aCode, Long dateEvt) {
            this.code = aCode;
            this.dateEvt = dateEvt;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Long getDateEvt() {
            return this.dateEvt;
        }

        public void setDateEvt(Long dateEvt) {
            this.dateEvt = dateEvt;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (code=" + this.code + ")";
        }
    }

    public static class SynthEvent {
        private final long id;
        private final Date timestamp;

        public SynthEvent(long id) {
            this.id = id;
            this.timestamp = new Date();
        }

        public long getId() {
            return this.id;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }

    public static class MyEvent {
        private long timestamp;

        public MyEvent(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return "MyEvent{timestamp=" + this.timestamp + "}";
        }
    }

    public static class ProbeCounter {
        private long total = 0L;

        public void setTotal(long total) {
            this.total = total;
        }

        public long getTotal() {
            return this.total;
        }

        public void addValue() {
            ++this.total;
        }
    }

    public static class ProbeEvent {
        private int value = 1;

        public int getValue() {
            return this.value;
        }

        public ProbeEvent(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProbeEvent that = (ProbeEvent)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "ProbeEvent{value=" + this.value + "}";
        }
    }

    public static class SimpleFact {
        private String status = "NOK";
        private final String id;

        public SimpleFact(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String s) {
            this.status = s;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (id=" + this.id + ", status=" + this.status + ")";
        }
    }

    public static class Event {
        private int type;
        private int value;
        private long time;

        public Event(int type, int value, long time) {
            this.type = type;
            this.value = value;
            this.time = time;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String toString() {
            return "Event{type=" + this.type + ", value=" + this.value + ", time=" + this.time % 10000L + "}";
        }
    }

    public static class TestEvent
    implements Serializable {
        private final String name;

        public TestEvent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format("TestEvent[name=%s]", this.name);
        }
    }

    private static class StockFactory {
        private static final String DRL_PACKAGE_NAME = "org.drools.integrationtests";
        private static final String DRL_FACT_NAME = "Stock";
        private final KieBase kbase;

        public StockFactory(KieBase kbase) {
            this.kbase = kbase;
        }

        public Object createStock(String name, Double value) {
            try {
                return this.createDRLStock(name, value);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to create Stock instance defined in DRL", e);
            }
        }

        private Object createDRLStock(String name, Double value) throws IllegalAccessException, InstantiationException {
            FactType stockType = this.kbase.getFactType(DRL_PACKAGE_NAME, DRL_FACT_NAME);
            Object stock = stockType.newInstance();
            stockType.set(stock, "name", (Object)name);
            stockType.set(stock, "value", (Object)value);
            return stock;
        }
    }

    public static class Message {
        private Properties properties;
        private Timestamp timestamp;
        private Long duration;

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Timestamp getStartTime() {
            return this.timestamp;
        }

        public void setStartTime(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }
    }

    public static class A
    implements Serializable {
    }
}

