/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ImmutableFactsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ImmutableFactsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_IMMUTABLE});
        parameters.add(new Object[]{KieBaseTestConfiguration.CLOUD_IDENTITY_IMMUTABLE_MODEL_PATTERN});
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaConstraint() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    String()\n    Person( name.startsWith(\"M\") )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"immutable-facts-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("Edson");
            FactHandle fh = ksession.insert((Object)p);
            ksession.insert((Object)new Person("Mark"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            Collection persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(1);
            Assertions.assertThat((String)((Person)persons.iterator().next()).getName()).isEqualTo("Mark");
            ksession.insert((Object)"test");
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            p.setName("Sofia");
            ksession.update(fh, (Object)p);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(1);
            p.setName("Mario");
            ksession.update(fh, (Object)p);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBetaConstraint() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $s: String()\n    Person( name.startsWith($s) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"immutable-facts-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person("Edson");
            FactHandle fh = ksession.insert((Object)p);
            ksession.insert((Object)new Person("Mark"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            Collection persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(2);
            ksession.insert((Object)"M");
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            p.setName("Sofia");
            ksession.update(fh, (Object)p);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(2);
            p.setName("Mario");
            ksession.update(fh, (Object)p);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            persons = ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class));
            Assertions.assertThat((int)persons.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }
}

