/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.Tuple;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class RemoveRuleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RemoveRuleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testRemoveBigRule() {
        String str = "package org.drools.compiler.test\n\ndeclare SimpleFact\n   patientSpaceId : String\n   block : int\nend\n\ndeclare SimpleMembership\n   patientSpaceId : String\n   listId : String\nend\n\ndeclare SimplePatient\n   spaceId : String\nend\n\nrule \"RTR - 47146 retract\"\nagenda-group \"list membership\"\nwhen\n   $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId, ( listId != null && listId == \"47146\" ) )\n   not ( $patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null && spaceId == $listMembershipPatientSpaceIdRoot ) \n       and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 1 )\n         ) or (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 2 )\n         ) or (           SimpleFact( patientSpaceId  == $patientSpaceIdRoot, block == 3 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 4 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 5 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 6 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 7 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 8 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 9 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 10 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 11 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 12 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 13 )\n         ) or ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 14 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 15 )\n         ) ) or ( (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 16 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 17 )\n         ) ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 18 )\n           ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 19 )\n         ) ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 20 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 21 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 22 )\n         ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 23 )\n         ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 24 )\n     ) ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 25 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 26 )\n     ) ) )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "test-remove-big-rule", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test\n\ndeclare SimpleFact\n   patientSpaceId : String\n   block : int\nend\n\ndeclare SimpleMembership\n   patientSpaceId : String\n   listId : String\nend\n\ndeclare SimplePatient\n   spaceId : String\nend\n\nrule \"RTR - 47146 retract\"\nagenda-group \"list membership\"\nwhen\n   $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId, ( listId != null && listId == \"47146\" ) )\n   not ( $patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null && spaceId == $listMembershipPatientSpaceIdRoot ) \n       and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 1 )\n         ) or (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 2 )\n         ) or (           SimpleFact( patientSpaceId  == $patientSpaceIdRoot, block == 3 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 4 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 5 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 6 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 7 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 8 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 9 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 10 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 11 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 12 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 13 )\n         ) or ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 14 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 15 )\n         ) ) or ( (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 16 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 17 )\n         ) ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 18 )\n           ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 19 )\n         ) ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 20 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 21 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 22 )\n         ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 23 )\n         ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 24 )\n     ) ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 25 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 26 )\n     ) ) )\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kc.getKieBase();
        ReleaseId releaseId2 = KieServices.get().newReleaseId("org.kie", "test-remove-big-rule", "1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId2);
        EntryPointNode epn = (EntryPointNode)kbase.getRete().getEntryPointNodes().values().iterator().next();
        for (ObjectTypeNode otn : epn.getObjectTypeNodes().values()) {
            Object[] sinks = otn.getObjectSinkPropagator().getSinks();
            if (sinks.length <= 0) continue;
            Assertions.fail((String)(otn + " has sinks " + Arrays.toString(sinks)));
        }
    }

    @Test
    public void testRemoveRuleWithFromNode() {
        String str = "package org.drools.compiler;\nimport " + Person.class.getCanonicalName() + ";\nimport " + Address.class.getCanonicalName() + ";\nrule R1 when\n   not( Person( name == \"Mark\" ));\nthen\nend\nrule R2 when\n   $p: Person( name == \"Mark\" );\n   not( Address() from $p.getAddresses() );\nthen\nend\n";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-remove-rule-with-from-node", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieBase kbase = kieContainer.getKieBase();
        Assertions.assertThat((int)kbase.getKiePackage("org.drools.compiler").getRules().size()).isEqualTo(2);
        kbase.removeRule("org.drools.compiler", "R2");
        Assertions.assertThat((int)kbase.getKiePackage("org.drools.compiler").getRules().size()).isEqualTo(1);
    }

    @Test
    public void testRuleRemovalWithJoinedRootPattern() {
        Object str = "";
        str = (String)str + "package org.drools.compiler \n";
        str = (String)str + "import " + Person.class.getCanonicalName() + ";\n";
        str = (String)str + "import " + Cheese.class.getCanonicalName() + ";\n";
        str = (String)str + "rule rule1 \n";
        str = (String)str + "when \n";
        str = (String)str + "  String() \n";
        str = (String)str + "  Person() \n";
        str = (String)str + "then \n";
        str = (String)str + "end  \n";
        str = (String)str + "rule rule2 \n";
        str = (String)str + "when \n";
        str = (String)str + "  String() \n";
        str = (String)str + "  Cheese() \n";
        str = (String)str + "then \n";
        str = (String)str + "end  \n";
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId("org.kie", "test-remove-rule-with-joined-root-pattern", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        DefaultFactHandle handle = (DefaultFactHandle)ksession.insert((Object)"hello");
        ksession.fireAllRules();
        LeftTuple leftTuple = handle.getFirstLeftTuple();
        Assertions.assertThat((Object)leftTuple).isNotNull();
        Assertions.assertThat((Object)leftTuple.getPeer()).isNotNull();
        kbase.removeRule("org.drools.compiler", "rule2");
        leftTuple = handle.getFirstLeftTuple();
        Assertions.assertThat((Object)leftTuple).isNotNull();
        Assertions.assertThat((Object)((Tuple)leftTuple.getHandleNext())).isNull();
    }

    @Test
    public void testRemoveAccumulateRule() {
        String str = "package org.drools.compiler.test\n\nrule Acc no-loop\nwhen\n    accumulate(\n            String( $l : length, this == \"test\" );\n            $max : max( $l ))\nthen end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = KieServices.get().newReleaseId("org.kie", "test-remove-acc-rule", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test\n\nrule Acc no-loop\nwhen\n    accumulate(\n            String( $l : length, this == \"test\" );\n            $max : max( $l ))\nthen end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)kc.getKieBase();
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)"xxx");
        ReleaseId releaseId2 = KieServices.get().newReleaseId("org.kie", "test-remove-acc-rule", "1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId2);
        EntryPointNode epn = (EntryPointNode)kbase.getRete().getEntryPointNodes().values().iterator().next();
        for (ObjectTypeNode otn : epn.getObjectTypeNodes().values()) {
            Object[] sinks = otn.getObjectSinkPropagator().getSinks();
            if (sinks.length <= 0) continue;
            Assertions.fail((String)(otn + " has sinks " + Arrays.toString(sinks)));
        }
    }
}

