/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.ParserError;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.memorycompiler.JavaConfiguration;

public class ParserTest {
    @Test
    public void testErrorLineNumbers() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"errors_in_rule.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBuilderError[] errors = (KnowledgeBuilderError[])kbuilder.getErrors().toArray((Object[])new KnowledgeBuilderError[0]);
        Assertions.assertThat((int)errors.length).isEqualTo(3);
        DescrBuildError stiltonError = (DescrBuildError)errors[0];
        Assertions.assertThat((boolean)stiltonError.getMessage().contains("Stilton")).isTrue();
        Assertions.assertThat((Object)stiltonError.getDescr()).isNotNull();
        Assertions.assertThat((stiltonError.getLine() != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)stiltonError.getDescr().getLine()).isEqualTo(stiltonError.getLine());
        Assertions.assertThat((int)stiltonError.getLine()).isEqualTo(26);
        DescrBuildError poisonError = (DescrBuildError)errors[1];
        Assertions.assertThat((boolean)poisonError.getMessage().contains("Poison")).isTrue();
        Assertions.assertThat((int)poisonError.getLine()).isEqualTo(28);
        KnowledgeBuilderConfigurationImpl cfg = new KnowledgeBuilderConfigurationImpl();
        JavaConfiguration javaConf = (JavaConfiguration)cfg.getDialectConfiguration("java");
        switch (javaConf.getCompiler()) {
            case NATIVE: {
                Assertions.assertThat((boolean)errors[2].getMessage().contains("illegal")).isTrue();
                break;
            }
            case ECLIPSE: {
                Assertions.assertThat((boolean)errors[2].getMessage().contains("add")).isTrue();
                break;
            }
            default: {
                Assertions.fail((String)"Unknown compiler used");
            }
        }
        DescrBuildError rhsError = (DescrBuildError)errors[2];
        Assertions.assertThat((rhsError.getLine() >= 23 && rhsError.getLine() <= 32 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testErrorsParser() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        Assertions.assertThat((int)parser.getErrors().size()).isEqualTo(0);
        parser.parse((Reader)new InputStreamReader(this.getClass().getResourceAsStream("errors_parser_multiple.drl")));
        Assertions.assertThat((boolean)parser.hasErrors()).isTrue();
        Assertions.assertThat((parser.getErrors().size() > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)(parser.getErrors().get(0) instanceof ParserError)).isTrue();
        ParserError first = (ParserError)parser.getErrors().get(0);
        Assertions.assertThat((first.getMessage() != null ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)first.getMessage().equals("")).isFalse();
    }
}

