/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.mvel.integrationtests.concurrency.AbstractConcurrentTest;
import org.drools.mvel.integrationtests.facts.CategoryTypeEnum;
import org.drools.mvel.integrationtests.facts.Product;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnumEvaluationConcurrentSessionsTest
extends AbstractConcurrentTest {
    private static final Integer NUMBER_OF_THREADS = 10;
    private static final Integer NUMBER_OF_REPETITIONS = 1;

    @Parameterized.Parameters(name="Enforced jitting={0}, Share KieBase={1}, KieBase type={2}")
    public static List<Object[]> getTestParameters() {
        List<Boolean[]> baseParams = Arrays.asList({false, false}, {true, false}, {false, true}, {true, true});
        Collection kbParams = TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Boolean[] baseParam : baseParams) {
            for (Object[] kbParam : kbParams) {
                if (baseParam[0].booleanValue() && ((KieBaseTestConfiguration)kbParam[0]).isExecutableModel()) continue;
                params.add(new Object[]{baseParam[0], baseParam[1], kbParam[0]});
            }
        }
        return params;
    }

    public EnumEvaluationConcurrentSessionsTest(boolean enforcedJitting, boolean sharedKieBase, KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(enforcedJitting, false, sharedKieBase, false, kieBaseTestConfiguration);
    }

    @Test(timeout=40000L)
    public void testEnum2() throws InterruptedException {
        String drl1 = "import " + Product.class.getCanonicalName() + ";\nimport " + CategoryTypeEnum.class.getCanonicalName() + ";\nrule R1 when\n  $s : String( this == \"odd\" )\n  $p : Product( id != \"test\", categoryAsEnum == CategoryTypeEnum.ODD, firings not contains \"R1\" )\nthen\n  $p.getFirings().add(\"R1\");\n  $p.appendDescription($s);\n  update($p);\nend\n";
        String drl2 = "import " + Product.class.getCanonicalName() + ";\nimport " + CategoryTypeEnum.class.getCanonicalName() + ";\nrule R2 when\n  $s : String( this == \"pair\" )\n  $p : Product( id != \"test\", categoryAsEnum == CategoryTypeEnum.PAIR, firings not contains \"R2\" )\nthen\n  $p.getFirings().add(\"R2\");\n  $p.appendDescription($s);\n  update($p);end\n";
        this.parallelTest(NUMBER_OF_REPETITIONS, NUMBER_OF_THREADS, (kieSession, counter) -> {
            int i;
            Product[] products = new Product[10];
            boolean pair = counter % 2 == 0;
            String pairString = pair ? "pair" : "odd";
            for (i = 0; i < 10; ++i) {
                products[i] = new Product("" + i, pairString);
            }
            kieSession.insert((Object)pairString);
            for (i = 0; i < 10; ++i) {
                kieSession.insert((Object)products[i]);
            }
            kieSession.fireAllRules();
            for (i = 0; i < 10; ++i) {
                if (products[i].getCategory().equals(pairString) && !products[i].getCategory().equals(products[i].getDescription())) {
                    return false;
                }
                if (products[i].getCategory().equals(pairString) || products[i].getDescription().isEmpty()) continue;
                return false;
            }
            return true;
        }, null, null, drl1, drl2);
    }
}

