/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.integrationtests.phreak.A;
import org.drools.mvel.integrationtests.phreak.B;
import org.drools.mvel.integrationtests.phreak.C;
import org.drools.mvel.integrationtests.phreak.E;
import org.drools.mvel.integrationtests.phreak.X;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

@RunWith(value=Parameterized.class)
public class RemoveRuleTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RemoveRuleTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testPopulatedSingleRuleNoSharing() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        kbase.addPackages(this.buildKnowledgePackage("r1", "   A() B() C(object == 2) X() E()\n"));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNotNull();
        wm.fireAllRules();
        BetaMemory bMem = (BetaMemory)sm.getNodeMemories().get(1);
        Assertions.assertThat((int)bMem.getLeftTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((int)bMem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory eMem = (BetaMemory)sm.getNodeMemories().get(4);
        Assertions.assertThat((int)eMem.getLeftTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((int)eMem.getRightTupleMemory().size()).isEqualTo(1);
        NodeMemories nms = wm.getNodeMemories();
        Assertions.assertThat((int)this.countNodeMemories(nms)).isEqualTo(12);
        Assertions.assertThat((Object)((LeftTuple)sm.getStagedLeftTuples().getInsertFirst())).isNull();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        kbase.removeRule("org.kie", "r1");
        Assertions.assertThat((int)this.countNodeMemories(nms)).isEqualTo(6);
    }

    @Test
    public void testPopulatedSingleRuleNoSharingWithSubnetworkAtStart() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.insert((Object)new C(2));
        wm.fireAllRules();
        kbase.addPackages(this.buildKnowledgePackage("r1", "   A() not( B() and C() ) X() E()\n"));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((Match)list.get(0)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((String)((Match)list.get(1)).getRule().getName()).isEqualTo("r1");
        kbase.removeRule("org.kie", "r1");
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    private int countNodeMemories(NodeMemories nms) {
        int count = 0;
        for (int i = 0; i < nms.length(); ++i) {
            if (nms.peekNodeMemory(i) == null) continue;
            System.out.println(nms.peekNodeMemory(i));
            ++count;
        }
        return count;
    }

    @Test
    public void testPopulatedRuleMidwayShare() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(7);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B() C(2;) X() E()\n"));
        wm.fireAllRules();
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)bNode.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        kbase1.removeRule("org.kie", "r2");
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(10);
        Assertions.assertThat((Object)((SegmentMemory)sm.getFirst())).isNull();
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm);
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((String)((Match)list.get(6)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((int)list.size()).isEqualTo(7);
    }

    @Test
    public void testPopulatedRuleWithEvals() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   a:A() B() eval(1==1) eval(1==1) C(1;) \n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new C(2));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(7);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a:A() B() eval(1==1) eval(1==1) C(2;) \n"));
        wm.fireAllRules();
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode bNode = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e1 = (EvalConditionNode)bNode.getSinkPropagator().getFirstLeftTupleSink();
        EvalConditionNode e2 = (EvalConditionNode)e1.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c1Node = (JoinNode)e2.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode c2Node = (JoinNode)e2.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)c1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory c2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c2Node);
        SegmentMemory c2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)c2Mem.getSegmentMemory()).isSameAs((Object)c2Smem);
        Assertions.assertThat((int)c2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)c2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        kbase1.removeRule("org.kie", "r2");
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(8);
        Assertions.assertThat((Object)((SegmentMemory)sm.getFirst())).isNull();
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm);
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((String)((Match)list.get(6)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((int)list.size()).isEqualTo(7);
    }

    @Test
    public void testPopulatedSharedLiaNode() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B(1;) C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new A(3));
        wm.insert((Object)new B(1));
        wm.insert((Object)new B(2));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(7);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A() B(2;) C() X() E()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(17);
        ObjectTypeNode aotn = this.getObjectTypeNode((KieBase)kbase1, A.class);
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)aotn.getObjectSinkPropagator().getSinks()[0];
        JoinNode b1Node = (JoinNode)liaNode.getSinkPropagator().getFirstLeftTupleSink();
        JoinNode b2Node = (JoinNode)liaNode.getSinkPropagator().getLastLeftTupleSink();
        JoinNode c1Node = (JoinNode)b1Node.getSinkPropagator().getLastLeftTupleSink();
        LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)wm.getNodeMemory((MemoryFactory)liaNode);
        SegmentMemory sm = lm.getSegmentMemory();
        BetaMemory b1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)b1Node);
        Assertions.assertThat((Object)b1Mem.getSegmentMemory()).isSameAs((Object)sm.getFirst());
        Assertions.assertThat((int)b1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)b1Mem.getRightTupleMemory().size()).isEqualTo(1);
        BetaMemory b2Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)b2Node);
        SegmentMemory b2Smem = ((SegmentMemory)sm.getFirst()).getNext();
        Assertions.assertThat((Object)b2Mem.getSegmentMemory()).isSameAs((Object)b2Smem);
        Assertions.assertThat((int)b2Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)b2Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        BetaMemory c1Mem = (BetaMemory)wm.getNodeMemory((MemoryFactory)c1Node);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)b1Mem.getSegmentMemory());
        Assertions.assertThat((Object)b2Mem.getSegmentMemory()).isNotSameAs((Object)b1Mem.getSegmentMemory());
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(17);
        kbase1.removeRule("org.kie", "r2");
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(12);
        Assertions.assertThat((Object)b1Mem.getSegmentMemory()).isSameAs((Object)sm);
        Assertions.assertThat((Object)c1Mem.getSegmentMemory()).isSameAs((Object)sm);
        Assertions.assertThat((Object)((SegmentMemory)sm.getFirst())).isNull();
        Assertions.assertThat((int)b1Mem.getLeftTupleMemory().size()).isEqualTo(3);
        Assertions.assertThat((int)b1Mem.getRightTupleMemory().size()).isEqualTo(1);
        Assertions.assertThat((Object)b2Mem.getSegmentMemory()).isSameAs((Object)b2Smem);
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((String)((Match)list.get(6)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((int)list.size()).isEqualTo(7);
    }

    @Test
    public void testPopulatedSharedLiaNodeNoBeta() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        A a1 = new A(1);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)a1);
        A a2 = new A(2);
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)a2);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   a : A()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        kbase1.removeRule("org.kie", "r1");
        kbase1.removeRule("org.kie", "r2");
        list.clear();
        Assertions.assertThat((Object)fh1.getFirstLeftTuple()).isNull();
        Assertions.assertThat((Object)fh2.getFirstLeftTuple()).isNull();
        wm.update((FactHandle)fh1, (Object)a1);
        wm.update((FactHandle)fh2, (Object)a2);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    @Test
    public void testAlphaTerminalNodesDontShareWithLian() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", " A(1;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;) B(1;) C(1;)\n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        PathMemory pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        PathMemory pmem2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        Assertions.assertThat((int)pmem1.getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
        Assertions.assertThat((int)pmem2.getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
    }

    @Test
    public void testPopulatedSharedToRtn() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A() B() C() X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new A(2));
        wm.insert((Object)new B(1));
        wm.insert((Object)new C(1));
        wm.insert((Object)new X(1));
        wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(7);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A() B() C() X() E()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(8);
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        PathMemory pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        PathMemory pmem2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        SegmentMemory[] smems1 = pmem1.getSegmentMemories();
        SegmentMemory[] smems2 = pmem2.getSegmentMemories();
        Assertions.assertThat((int)smems1.length).isEqualTo(2);
        Assertions.assertThat((int)smems2.length).isEqualTo(2);
        Assertions.assertThat((Object)smems2[0]).isSameAs((Object)smems1[0]);
        Assertions.assertThat((Object)smems2[1]).isNotSameAs((Object)smems1[1]);
        SegmentMemory sm = smems1[0];
        Assertions.assertThat((Object)((SegmentMemory)sm.getFirst())).isEqualTo((Object)smems1[1]);
        JoinNode eNode1 = (JoinNode)rtn1.getLeftTupleSource();
        JoinNode eNode2 = (JoinNode)rtn2.getLeftTupleSource();
        Assertions.assertThat((Object)eNode2).isSameAs((Object)eNode1);
        pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        kbase1.removeRule("org.kie", "r2");
        System.out.println("---");
        Assertions.assertThat((int)this.countNodeMemories(wm.getNodeMemories())).isEqualTo(7);
        Assertions.assertThat((Object)((SegmentMemory)sm.getFirst())).isNull();
        pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        smems1 = pmem1.getSegmentMemories();
        Assertions.assertThat((int)smems1.length).isEqualTo(1);
        Assertions.assertThat((Object)smems1[0]).isSameAs((Object)sm);
        wm.insert((Object)new A(1));
        wm.fireAllRules();
        Assertions.assertThat((String)((Match)list.get(4)).getRule().getName()).isEqualTo("r1");
        Assertions.assertThat((int)list.size()).isEqualTo(5);
    }

    @Test
    public void testPopulatedMultipleSharesRemoveFirst() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        kbase1.removeRule("org.kie", "r1");
        list.clear();
        RemoveRuleTest.update10Facts(wm, fh1, fh2, fh3, fh4, fh5, fh6, fh7, fh8, fh9, fh10);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }

    @Test
    public void testPopulatedMultipleSharesRemoveMid() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        kbase1.removeRule("org.kie", "r2");
        list.clear();
        RemoveRuleTest.update10Facts(wm, fh1, fh2, fh3, fh4, fh5, fh6, fh7, fh8, fh9, fh10);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }

    @Test
    public void testPopulatedMultipleSharesRemoveLast() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) X() E()\n");
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        InternalFactHandle fh1 = (InternalFactHandle)wm.insert((Object)new A(1));
        InternalFactHandle fh2 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh3 = (InternalFactHandle)wm.insert((Object)new A(2));
        InternalFactHandle fh4 = (InternalFactHandle)wm.insert((Object)new A(3));
        InternalFactHandle fh5 = (InternalFactHandle)wm.insert((Object)new B(1));
        InternalFactHandle fh6 = (InternalFactHandle)wm.insert((Object)new B(2));
        InternalFactHandle fh7 = (InternalFactHandle)wm.insert((Object)new C(1));
        InternalFactHandle fh8 = (InternalFactHandle)wm.insert((Object)new C(2));
        InternalFactHandle fh9 = (InternalFactHandle)wm.insert((Object)new X(1));
        InternalFactHandle fh10 = (InternalFactHandle)wm.insert((Object)new E(1));
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        PathMemory pmem1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        Assertions.assertThat((int)pmem1.getSegmentMemories().length).isEqualTo(1);
        this.assertSegmentMemory(pmem1, 0, 127, 127, 127);
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(2;) X() E()\n"));
        list.clear();
        RemoveRuleTest.update10Facts(wm, fh1, fh2, fh3, fh4, fh5, fh6, fh7, fh8, fh9, fh10);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r1", kbase1);
        PathMemory pmem2 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn2);
        Assertions.assertThat((int)pmem1.getSegmentMemories().length).isEqualTo(2);
        this.assertSegmentMemory(pmem1, 0, 15, 15, 15);
        this.assertSegmentMemory(pmem1, 1, 7, 7, 7);
        Assertions.assertThat((int)pmem2.getSegmentMemories().length).isEqualTo(2);
        this.assertSegmentMemory(pmem2, 0, 15, 15, 15);
        this.assertSegmentMemory(pmem2, 1, 7, 7, 7);
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(3;) B(1;) B(2;) C(2;) X() E()\n"));
        list.clear();
        RemoveRuleTest.update10Facts(wm, fh1, fh2, fh3, fh4, fh5, fh6, fh7, fh8, fh9, fh10);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", kbase1);
        PathMemory pmem3 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn3);
        Assertions.assertThat((int)pmem1.getSegmentMemories().length).isEqualTo(3);
        this.assertSegmentMemory(pmem1, 0, 1, 1, 1);
        this.assertSegmentMemory(pmem1, 1, 7, 7, 7);
        this.assertSegmentMemory(pmem1, 2, 7, 7, 7);
        Assertions.assertThat((int)pmem2.getSegmentMemories().length).isEqualTo(3);
        this.assertSegmentMemory(pmem2, 0, 1, 1, 1);
        this.assertSegmentMemory(pmem2, 1, 7, 7, 7);
        this.assertSegmentMemory(pmem2, 2, 7, 7, 7);
        Assertions.assertThat((int)pmem3.getSegmentMemories().length).isEqualTo(2);
        this.assertSegmentMemory(pmem3, 0, 1, 1, 1);
        this.assertSegmentMemory(pmem3, 1, 63, 63, 63);
        kbase1.removeRule("org.kie", "r3");
        list.clear();
        RemoveRuleTest.update10Facts(wm, fh1, fh2, fh3, fh4, fh5, fh6, fh7, fh8, fh9, fh10);
        wm.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat((int)pmem1.getSegmentMemories().length).isEqualTo(2);
        this.assertSegmentMemory(pmem1, 0, 15, 15, 15);
        this.assertSegmentMemory(pmem1, 1, 7, 7, 7);
        Assertions.assertThat((int)pmem2.getSegmentMemories().length).isEqualTo(2);
        this.assertSegmentMemory(pmem2, 0, 15, 15, 15);
        this.assertSegmentMemory(pmem2, 1, 7, 7, 7);
    }

    private void assertSegmentMemory(PathMemory pmem, int segmentPos, int linkedMask, int dirtyMask, int allMask) {
        Assertions.assertThat((long)pmem.getSegmentMemories()[segmentPos].getLinkedNodeMask()).isEqualTo((long)linkedMask);
        Assertions.assertThat((long)pmem.getSegmentMemories()[segmentPos].getDirtyNodeMask()).isEqualTo((long)dirtyMask);
        Assertions.assertThat((long)pmem.getSegmentMemories()[segmentPos].getAllLinkedMaskTest()).isEqualTo((long)allMask);
    }

    private static void update10Facts(InternalWorkingMemory wm, InternalFactHandle fh1, InternalFactHandle fh2, InternalFactHandle fh3, InternalFactHandle fh4, InternalFactHandle fh5, InternalFactHandle fh6, InternalFactHandle fh7, InternalFactHandle fh8, InternalFactHandle fh9, InternalFactHandle fh10) {
        wm.update((FactHandle)fh1, fh1.getObject());
        wm.update((FactHandle)fh2, fh2.getObject());
        wm.update((FactHandle)fh3, fh3.getObject());
        wm.update((FactHandle)fh4, fh4.getObject());
        wm.update((FactHandle)fh5, fh5.getObject());
        wm.update((FactHandle)fh6, fh6.getObject());
        wm.update((FactHandle)fh7, fh7.getObject());
        wm.update((FactHandle)fh8, fh8.getObject());
        wm.update((FactHandle)fh9, fh9.getObject());
        wm.update((FactHandle)fh10, fh10.getObject());
    }

    @Test
    public void testPathMemorySizeAfterSegmentMerge() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;) B(1;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)\n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new A(1));
        wm.insert((Object)new B(1));
        wm.fireAllRules();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn2)).getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
        kbase1.removeRule("org.kie", "r2");
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getSegmentMemories().length).isEqualTo(1);
    }

    @Test
    public void testPathMemorySizeAfterSegmentMergeNonInitialized() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;) B(1;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)\n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn2)).getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
        kbase1.removeRule("org.kie", "r2");
        Assertions.assertThat((int)((PathMemory)wm.getNodeMemory((MemoryFactory)rtn1)).getPathEndNode().getSegmentPrototypes().length).isEqualTo(1);
    }

    @Test
    public void testSplitTwoBeforeCreatedSegment() throws Exception {
        InternalKnowledgeBase kbase1 = this.buildKnowledgeBase("r1", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n");
        kbase1.addPackages(this.buildKnowledgePackage("r2", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;) E(1;) E(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r3", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) X(1;) X(2;)\n"));
        kbase1.addPackages(this.buildKnowledgePackage("r4", "   A(1;)  A(2;) B(1;) B(2;) C(1;) C(2;) \n"));
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase1.newKieSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.insert((Object)new E(1));
        wm.insert((Object)new E(2));
        wm.flushPropagations();
        RuleTerminalNode rtn1 = this.getRtn("org.kie.r1", kbase1);
        RuleTerminalNode rtn2 = this.getRtn("org.kie.r2", kbase1);
        RuleTerminalNode rtn3 = this.getRtn("org.kie.r3", kbase1);
        RuleTerminalNode rtn4 = this.getRtn("org.kie.r4", kbase1);
        PathMemory pm1 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn1);
        SegmentMemory[] smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(4);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[3]).isNull();
        SegmentMemory sm = smems[2];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(2);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(4L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(4L);
        kbase1.addPackages(this.buildKnowledgePackage("r5", "   A(1;)  A(2;) B(1;) B(2;) \n"));
        smems = pm1.getSegmentMemories();
        Assertions.assertThat((int)smems.length).isEqualTo(5);
        Assertions.assertThat((Object)smems[0]).isNull();
        Assertions.assertThat((Object)smems[1]).isNull();
        Assertions.assertThat((Object)smems[2]).isNull();
        sm = smems[3];
        Assertions.assertThat((int)sm.getPos()).isEqualTo(3);
        Assertions.assertThat((long)sm.getSegmentPosMaskBit()).isEqualTo(8L);
        Assertions.assertThat((long)pm1.getLinkedSegmentMask()).isEqualTo(8L);
        RuleTerminalNode rtn5 = this.getRtn("org.kie.r5", kbase1);
        PathMemory pm5 = (PathMemory)wm.getNodeMemory((MemoryFactory)rtn5);
        Assertions.assertThat((int)pm5.getPathEndNode().getSegmentPrototypes().length).isEqualTo(2);
    }

    private RuleTerminalNode getRtn(String ruleName, InternalKnowledgeBase kbase) {
        return (RuleTerminalNode)kbase.getReteooBuilder().getTerminalNodes(ruleName)[0];
    }

    private String buildKnowledgePackageDrl(String ruleName, String rule) {
        Object str = "";
        str = (String)str + "package org.kie \n";
        str = (String)str + "import " + A.class.getCanonicalName() + "\n";
        str = (String)str + "import " + B.class.getCanonicalName() + "\n";
        str = (String)str + "import " + C.class.getCanonicalName() + "\n";
        str = (String)str + "import " + X.class.getCanonicalName() + "\n";
        str = (String)str + "import " + E.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule " + ruleName + "  when \n";
        str = (String)str + rule;
        str = (String)str + "then \n";
        str = (String)str + " list.add( kcontext.getMatch() );\n";
        str = (String)str + "end \n";
        return str;
    }

    private String addRule(String ruleName, String rule) {
        Object str = "";
        str = (String)str + "rule " + ruleName + "  when \n";
        str = (String)str + rule;
        str = (String)str + "then \n";
        str = (String)str + " list.add( kcontext.getMatch() );\n";
        str = (String)str + "end \n";
        return str;
    }

    private InternalKnowledgeBase buildKnowledgeBase(String ruleName, String rule) {
        return (InternalKnowledgeBase)KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)});
    }

    private Collection<KiePackage> buildKnowledgePackage(String ruleName, String rule) {
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"tmp", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.buildKnowledgePackageDrl(ruleName, rule)}).getKiePackages();
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> nodeClass) {
        List nodes = ((RuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != nodeClass) continue;
            return n;
        }
        return null;
    }
}

