/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContext;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleMemory;
import org.drools.mvel.integrationtests.phreak.Scenario;
import org.drools.mvel.integrationtests.phreak.StagedBuilder;

public class RightMemory {
    private Scenario scenario;

    public RightMemory(Scenario scenario, Object ... objects) {
        this.scenario = scenario;
        scenario.getRightMemory().addAll(this.getRightTuples(objects));
    }

    public List<RightTuple> getRightTuples(Object ... objects) {
        BetaNode node = this.scenario.getBetaNode();
        BetaMemory bm = this.scenario.getBm();
        TupleMemory rtm = bm.getRightTupleMemory();
        InternalWorkingMemory wm = this.scenario.getWorkingMemory();
        if (objects == null) {
            objects = new Object[]{};
        }
        ArrayList<RightTuple> rightTuples = new ArrayList<RightTuple>();
        for (Object object : objects) {
            InternalFactHandle fh = (InternalFactHandle)wm.insert(object);
            RightTupleImpl expectedRightTuple = new RightTupleImpl(fh, (RightTupleSink)node);
            expectedRightTuple.setPropagationContext((PropagationContext)new PhreakPropagationContext());
            rightTuples.add((RightTuple)expectedRightTuple);
        }
        this.scenario.setTestRightMemory(true);
        return rightTuples;
    }

    public StagedBuilder result() {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, null);
        this.scenario.setExpectedResultBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder preStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPreStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public StagedBuilder postStaged(SegmentMemory sm) {
        StagedBuilder stagedBuilder = new StagedBuilder(this.scenario, sm);
        this.scenario.addPostStagedBuilder(stagedBuilder);
        return stagedBuilder;
    }

    public Scenario run() {
        return this.scenario.run();
    }
}

