/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.definition.rule.Rule;

@RunWith(value=Parameterized.class)
public class AnnotationsCepTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AnnotationsCepTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testRuleAnnotation() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Person.class.getCanonicalName() + "; \nrule X\n    @author(\"John Doe\")\n    @output(Hello World!)\n    @value( 10 + 10 )\n    @alt( \"Hello \"+\"World!\" )\nwhen\n    Person()\nthen\nend";
        this.kieBaseTestConfiguration.setAdditionalKieBaseOptions(new KieBaseOption[]{MBeansOption.ENABLED});
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-cep-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Rule rule = kbase.getRule("org.drools.compiler.integrationtests", "X");
        Assertions.assertThat(rule.getMetaData().get("author")).isEqualTo((Object)"John Doe");
        Assertions.assertThat(rule.getMetaData().get("output")).isEqualTo((Object)"Hello World!");
        Assertions.assertThat((int)((Number)rule.getMetaData().get("value")).intValue()).isEqualTo(20);
        Assertions.assertThat(rule.getMetaData().get("alt")).isEqualTo((Object)"Hello World!");
    }

    @Test
    public void testRuleAnnotation2() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Person.class.getCanonicalName() + "; \nrule X\n    @alt(\" \\\"<- these are supposed to be the only quotes ->\\\" \")\nwhen\n    Person()\nthen\nend";
        this.kieBaseTestConfiguration.setAdditionalKieBaseOptions(new KieBaseOption[]{MBeansOption.ENABLED});
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-cep-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Rule rule = kbase.getRule("org.drools.compiler.integrationtests", "X");
        Assertions.assertThat(rule.getMetaData().get("alt")).isEqualTo((Object)" \"<- these are supposed to be the only quotes ->\" ");
    }
}

