/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.AnnotationsTest;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.Pattern;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.rule.Rule;

@RunWith(value=Parameterized.class)
public class AnnotationsOnPatternTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AnnotationsOnPatternTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testAnnotationWithUnknownProperty() {
        String drl = "package org.drools.test; import " + Outer.class.getName().replace("$", ".") + "; import " + Inner.class.getName().replace("$", ".") + "; rule Foo when   String() @Outer( missing = 3 ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).hasSize(1);
    }

    @Test
    public void testAnnotationWithUnknownClass() {
        String drl = "package org.drools.test; import " + Outer.class.getName().replace("$", ".") + "; rule Foo when   String() @Outer( klass = Foo.class ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).hasSize(1);
    }

    @Test
    public void testAnnotationWithQualifiandClass() {
        String drl = "package org.drools.test; import " + Outer.class.getName().replace("$", ".") + "; rule Foo when   String() @Outer( klass = String.class, klasses = { String.class, Integer.class } ) then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Pattern p = (Pattern)((RuleImpl)kbase.getRule("org.drools.test", "Foo")).getLhs().getChildren().get(0);
        AnnotationDefinition adef = (AnnotationDefinition)p.getAnnotations().get(Outer.class.getName().replace("$", "."));
        Assertions.assertThat((Object)adef.getPropertyValue("klass")).isEqualTo(String.class);
        Assertions.assertThat(Arrays.asList((Class[])adef.getPropertyValue("klasses"))).isEqualTo(Arrays.asList(String.class, Integer.class));
        Assertions.assertThat((Object)adef).isNotNull();
    }

    @Test
    public void testNestedAnnotations() {
        String drl = "package org.drools.test; import " + Outer.class.getName().replace("$", ".") + "; import " + Inner.class.getName().replace("$", ".") + "; rule Foo when   String() @Outer( value = @Inner( text = \"world\" ) ) then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Pattern p = (Pattern)((RuleImpl)kbase.getRule("org.drools.test", "Foo")).getLhs().getChildren().get(0);
        Map defs = p.getAnnotations();
        Assertions.assertThat((int)defs.size()).isEqualTo(1);
        AnnotationDefinition outer = (AnnotationDefinition)defs.get(Outer.class.getName().replace("$", "."));
        Assertions.assertThat((Object)outer).isNotNull();
        Object val = outer.getPropertyValue("value");
        Assertions.assertThat((Object)val).isNotNull();
        Assertions.assertThat((boolean)(val instanceof AnnotationDefinition)).isTrue();
        AnnotationDefinition inner = (AnnotationDefinition)val;
        Assertions.assertThat((Object)inner.getPropertyValue("text")).isEqualTo((Object)"world");
    }

    @Test
    public void testNestedAnnotationsWithMultiplicity() {
        String drl = "package org.drools.test; import " + Outer.class.getName().replace("$", ".") + "; import " + Inner.class.getName().replace("$", ".") + "; rule Foo when   String() @Outer( values = { @Inner( text = \"hello\" ), @Inner( text = \"world\" ) } ) then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Pattern p = (Pattern)((RuleImpl)kbase.getRule("org.drools.test", "Foo")).getLhs().getChildren().get(0);
        Map defs = p.getAnnotations();
        Assertions.assertThat((int)defs.size()).isEqualTo(1);
        AnnotationDefinition outer = (AnnotationDefinition)defs.get(Outer.class.getName().replace("$", "."));
        Assertions.assertThat((Object)outer).isNotNull();
        Object val = outer.getPropertyValue("values");
        Assertions.assertThat((Object)val).isNotNull();
        Assertions.assertThat((boolean)(val instanceof AnnotationDefinition[])).isTrue();
    }

    @Test
    public void testRuleAnnotations() {
        String drl = "package org.drools.test; import " + Inner.class.getName().replace("$", ".") + "; rule Foo @Inner( text=\"a\", test=\"b\" ) when then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Rule rule = kbase.getRule("org.drools.test", "Foo");
        Assertions.assertThat((boolean)rule.getMetaData().containsKey(Inner.class.getName().replace("$", "."))).isTrue();
        Object obj = rule.getMetaData().get(Inner.class.getName().replace("$", "."));
        Assertions.assertThat(obj).isNotNull();
        Assertions.assertThat((boolean)(obj instanceof Map)).isTrue();
        Assertions.assertThat(((Map)obj).get("test")).isEqualTo((Object)"b");
        Assertions.assertThat(((Map)obj).get("text")).isEqualTo((Object)"a");
    }

    @Test
    public void testTypedSimpleArrays() {
        String drl = "package org.drools.test; import " + AnnotationsTest.Simple.class.getName().replace("$", ".") + "; rule Foo when   String() @Simple( numbers = { 1, 2, 3 } ) then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Pattern p = (Pattern)((RuleImpl)kbase.getRule("org.drools.test", "Foo")).getLhs().getChildren().get(0);
        Map defs = p.getAnnotations();
        Assertions.assertThat((int)defs.size()).isEqualTo(1);
        AnnotationDefinition simple = (AnnotationDefinition)defs.get(AnnotationsTest.Simple.class.getName().replace("$", "."));
        Assertions.assertThat((Object)simple).isNotNull();
        Object val = simple.getPropertyValue("numbers");
        Assertions.assertThat((boolean)(val instanceof int[])).isTrue();
    }

    @Test
    public void testCollectAnnotationsParsingAndBuilding() {
        String packageName = "org.drools.compiler.integrationtests";
        String drl = "package org.drools.compiler.integrationtests;  dialect 'mvel'  import java.util.Collection; import " + Inner.class.getCanonicalName() + ";  rule \"test collect with annotation\"     when         Collection() from collect (             String() @Inner         )     then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        RuleImpl rule = (RuleImpl)kbase.getRule("org.drools.compiler.integrationtests", "test collect with annotation");
        List nested = ((Pattern)rule.getLhs().getChildren().get(0)).getSource().getNestedElements();
        Assertions.assertThat((int)nested.size()).isEqualTo(1);
        Map annotations = ((Pattern)nested.get(0)).getAnnotations();
        Assertions.assertThat((int)annotations.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)annotations.keySet().iterator().next())).isNotNull();
    }

    public static @interface Outer {
        public Inner value();

        public Inner[] values() default {};

        public Class klass() default Object.class;

        public Class[] klasses() default {};

        public int test();
    }

    public static @interface Inner {
        public String text() default "hello";

        public String test() default "world";
    }
}

