/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.core.ClassObjectFilter;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.util.DroolsTestUtil;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Result;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class IncrementalCompilationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String DECLARES_DRL = "package org.drools.example.api.kiedeclare;\ndeclare Message\nname : String\ntext : String\nend \n";
    private static final String RULES1_DRL = "package org.drools.example.api.kiemodulemodel;\nimport org.drools.example.api.kiedeclare.*;\nrule rule6 when \n    $m : Message(text == \"What's the problem?\") \nthen\n    delete( $m );\n    insert( new Message(\"HAL\", \"reply 1\" ) ); \nend \n";
    private static final String RULES2_DRL = "package org.drools.example.api.kiemodulemodel;\nimport org.drools.example.api.kiedeclare.*;\nrule rule6 when \n    $m : Message(text == \"What's the problem?\") \nthen\n    delete( $m );\n    insert( new Message(\"HAL\", \"reply 2\" ) ); \nend \n";

    public IncrementalCompilationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testLoadOrderAfterRuleRemoval() {
        String header = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\n";
        String drl1 = "rule R1 when\n   $m : Message( message == \"Hello World1\" )\nthen\nend\n";
        String drl2 = "rule R2 when\n   $m : Message( message == \"Hello World2\" )\nthen\nend\n";
        String drl3 = "rule R3 when\n   $m : Message( message == \"Hello World3\" )\nthen\nend\n";
        String drl4 = "rule R4 when\n   $m : Message( message == \"Hello World4\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{header});
        KieContainer kc = ks.newKieContainer(releaseId1);
        this.createAndDeployAndTest(kc, "2", header, "rule R1 when\n   $m : Message( message == \"Hello World1\" )\nthen\nend\nrule R2 when\n   $m : Message( message == \"Hello World2\" )\nthen\nend\nrule R3 when\n   $m : Message( message == \"Hello World3\" )\nthen\nend\n", "R1", "R2", "R3");
        this.createAndDeployAndTest(kc, "3", header, "rule R1 when\n   $m : Message( message == \"Hello World1\" )\nthen\nend\nrule R3 when\n   $m : Message( message == \"Hello World3\" )\nthen\nend\n", "R1", "R3");
        this.createAndDeployAndTest(kc, "4", header, "rule R2 when\n   $m : Message( message == \"Hello World2\" )\nthen\nend\nrule R1 when\n   $m : Message( message == \"Hello World1\" )\nthen\nend\nrule R4 when\n   $m : Message( message == \"Hello World4\" )\nthen\nend\n", "R2", "R1", "R4");
        this.createAndDeployAndTest(kc, "5", header, "rule R2 when\n   $m : Message( message == \"Hello World2\" )\nthen\nend\nrule R1 when\n   $m : Message( message == \"Hello World1\" )\nthen\nend\n", "R2", "R1");
        this.createAndDeployAndTest(kc, "6", header, "", new String[0]);
        this.createAndDeployAndTest(kc, "7", header, "rule R3 when\n   $m : Message( message == \"Hello World3\" )\nthen\nend\n", "R3");
    }

    private void createAndDeployAndTest(KieContainer kc, String version, String header, String drls, String ... ruleNames) {
        if (ruleNames == null) {
            ruleNames = new String[]{};
        }
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", version);
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{header + drls});
        kc.updateToVersion(releaseId1);
        KiePackage kpkg = kc.getKieBase().getKiePackage("org.drools.compiler");
        Assertions.assertThat((int)kpkg.getRules().size()).isEqualTo(ruleNames.length);
        Map rules = DroolsTestUtil.rulestoMap((Collection)kpkg.getRules());
        int i = 0;
        for (String ruleName : ruleNames) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)((RuleImpl)rules.get(ruleName)).getLoadOrder()).as(ruleName, new Object[0])).isEqualTo(i++);
        }
    }

    @Test
    public void testKJarUpgrade() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_2});
        kc.updateToVersion(releaseId2);
        ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testKJarUpgradeSameSession() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_2});
        kc.updateToVersion(releaseId2);
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(3);
    }

    @Test
    public void testDeletedFile() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieContainer kieContainer2 = ks.newKieContainer(releaseId1);
        KieSession ksession = kieContainer.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-delete", "1.0.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{null, drl2});
        kieContainer.updateToVersion(releaseId2);
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession = kieContainer.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        KieSession ksession2 = kieContainer2.newKieSession();
        ksession2.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIncrementalCompilationWithAddedError() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1).write("src/main/resources/r2.drl", drl2_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSession ksession = kieContainer.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)results.getRemovedMessages().size()).isEqualTo(0);
        kieContainer.updateToVersion(ks.getRepository().getDefaultReleaseId());
        ksession = kieContainer.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testIncrementalCompilationWithRemovedError() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1).write("src/main/resources/r2.drl", drl2_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)results.getRemovedMessages().size()).isEqualTo(1);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSession ksession = kieContainer.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIncrementalCompilationAddErrorThenRemoveError() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2_1);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults removeResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)removeResults.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)removeResults.getRemovedMessages().size()).isEqualTo(1);
    }

    @Test
    public void testIncrementalCompilationAddErrorThenRemoveIt() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : NonExistentClass()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(1);
        kfs.write("src/main/resources/r2.drl", drl2_1);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults removeResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)removeResults.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)removeResults.getRemovedMessages().size()).isEqualTo(1);
    }

    @Test
    public void testIncrementalCompilationWithDuplicatedRule() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r2_1.drl", drl2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2_1.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2_2.drl", drl2);
        IncrementalResults removeResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2_2.drl"}).build();
        Assertions.assertThat((int)removeResults.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)removeResults.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testIncrementalCompilationWithDuplicatedRuleInSameDRL() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((boolean)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()).isFalse();
    }

    @Test
    public void testIncrementalCompilationAddErrorBuildAllMessages() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2_1);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)addResults.getRemovedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)ks.newKieBuilder(kfs).buildAll().getResults().getMessages().size()).isEqualTo(1);
    }

    @Test
    public void testIncrementalCompilationAddErrorThenEmptyWithoutError() {
        String drl1 = "Smurf";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", "Smurf");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(2);
        kfs.write("src/main/resources/r2.drl", "");
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults1.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2);
        IncrementalResults addResults2 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults2.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults2.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testRuleRemoval() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "rule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl3 = "rule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1 + "rule R2 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\nrule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KiePackage kpkg = kc.getKieBase().getKiePackage("org.drools.compiler");
        Assertions.assertThat((int)kpkg.getRules().size()).isEqualTo(3);
        Map rules = DroolsTestUtil.rulestoMap((Collection)kpkg.getRules());
        Assertions.assertThat((Object)((Rule)rules.get("R1"))).isNotNull();
        Assertions.assertThat((Object)((Rule)rules.get("R2"))).isNotNull();
        Assertions.assertThat((Object)((Rule)rules.get("R3"))).isNotNull();
        RuleTerminalNode rtn1_1 = (RuleTerminalNode)((RuleBase)kc.getKieBase()).getReteooBuilder().getTerminalNodes("org.drools.compiler.R1")[0];
        RuleTerminalNode rtn3_1 = (RuleTerminalNode)((RuleBase)kc.getKieBase()).getReteooBuilder().getTerminalNodes("org.drools.compiler.R3")[0];
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1 + "rule R3 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n"});
        kc.updateToVersion(releaseId2);
        RuleBase rb_2 = (RuleBase)kc.getKieBase();
        RuleTerminalNode rtn1_2 = (RuleTerminalNode)rb_2.getReteooBuilder().getTerminalNodes("org.drools.compiler.R1")[0];
        RuleTerminalNode rtn3_2 = (RuleTerminalNode)rb_2.getReteooBuilder().getTerminalNodes("org.drools.compiler.R3")[0];
        Assertions.assertThat((Object[])rb_2.getReteooBuilder().getTerminalNodes("org.drools.compiler.R2")).isNull();
        Assertions.assertThat((Object)rtn3_2).isSameAs((Object)rtn3_1);
        Assertions.assertThat((Object)rtn1_2).isSameAs((Object)rtn1_1);
        kpkg = kc.getKieBase().getKiePackage("org.drools.compiler");
        Assertions.assertThat((int)kpkg.getRules().size()).isEqualTo(2);
        rules = DroolsTestUtil.rulestoMap((Collection)kpkg.getRules());
        Assertions.assertThat((Object)((Rule)rules.get("R1"))).isNotNull();
        Assertions.assertThat((Object)((Rule)rules.get("R2"))).isNull();
        Assertions.assertThat((Object)((Rule)rules.get("R3"))).isNotNull();
    }

    @Test
    public void testIncrementalCompilationWithSnapshots() {
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.0-SNAPSHOT");
        this.testIncrementalCompilation(releaseId, releaseId, false);
    }

    @Test
    public void testIncrementalCompilationWithFixedVersions() {
        ReleaseId releaseId1 = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.1");
        ReleaseId releaseId2 = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.2");
        this.testIncrementalCompilation(releaseId1, releaseId2, false);
    }

    @Test
    public void testIncrementalCompilationWithDeclaredType() {
        ReleaseId releaseId1 = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.1");
        ReleaseId releaseId2 = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.2");
        this.testIncrementalCompilation(releaseId1, releaseId2, true);
    }

    private void testIncrementalCompilation(ReleaseId releaseId1, ReleaseId releaseId2, boolean useDeclaredType) {
        String drl1 = "package org.drools.compiler\nglobal java.util.List list\nrule R0 when then list.add( \"000\" ); end \nrule R1 when\n $s : String() then\n list.add( \"a\" + $s );end\n";
        String drl2 = useDeclaredType ? "package org.drools.compiler\nglobal java.util.List list\ndeclare StringWrapper\n s : String\nend\nrule RInit when\n $s : String() \nthen\n insert( new StringWrapper( $s ) );end\nrule R2 when\n $s : StringWrapper() \nthen\n list.add( \"b\" + $s.getS() );end\n" : "package org.drools.compiler\nglobal java.util.List list\nrule R2 when\n $s : String() \nthen\n list.add( \"b\" + $s );end\n";
        KieServices ks = KieServices.Factory.get();
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list\nrule R0 when then list.add( \"000\" ); end \nrule R1 when\n $s : String() then\n list.add( \"a\" + $s );end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Foo");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("000", "aFoo"))).isTrue();
        list.clear();
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list\nrule R0 when then list.add( \"000\" ); end \nrule R1 when\n $s : String() then\n list.add( \"a\" + $s );end\n", drl2});
        Results updateResults = kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
        ksession.insert((Object)"Bar");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("bBar", "bFoo", "aBar"))).isTrue();
    }

    @Test
    public void testIncrementalCompilationWithRedeclares() {
        String drl1 = "package org.drools.compiler\nglobal java.util.List list\ndeclare Fooz id : int end \nrule R0 when then insert( new Fooz( 1 ) ); end \n";
        String drl2 = "package org.drools.compiler\nglobal java.util.List list\ndeclare Fooz id : int end \ndeclare Barz end \nrule R2 when then insert( new Fooz( 2 ) ); end \nrule R1 when\n $f : Fooz() then\n list.add( $f.getId() ); System.out.println( \"Foo in \" + $f + \" >> \" + System.identityHashCode( $f.getClass() ) ); \nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list\ndeclare Fooz id : int end \nrule R0 when then insert( new Fooz( 1 ) ); end \n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler\nglobal java.util.List list\ndeclare Fooz id : int end \nrule R0 when then insert( new Fooz( 1 ) ); end \n", "package org.drools.compiler\nglobal java.util.List list\ndeclare Fooz id : int end \ndeclare Barz end \nrule R2 when then insert( new Fooz( 2 ) ); end \nrule R1 when\n $f : Fooz() then\n list.add( $f.getId() ); System.out.println( \"Foo in \" + $f + \" >> \" + System.identityHashCode( $f.getClass() ) ); \nend\n"});
        Results updateResults = kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test
    public void testIncrementalCompilationWithAmbiguousRedeclares() {
        String drl1 = "package domestic; import foreign.*; declare foreign.Score     id       : String end ";
        String drl2 = "\npackage domestic; import foreign.*; declare foreign.Score     id       : String end\ndeclare Score     value : double end ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "foo", "1.0-SNAPSHOT");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package domestic; import foreign.*; declare foreign.Score     id       : String end ")).setResourceType(ResourceType.DRL).setSourcePath("drl1.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        ksession.fireAllRules();
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("\npackage domestic; import foreign.*; declare foreign.Score     id       : String end\ndeclare Score     value : double end ")).setResourceType(ResourceType.DRL).setSourcePath("drl2.drl"));
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).incrementalBuild();
        System.out.println(results.getAddedMessages());
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Results updateResults = kc.updateToVersion(id);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
    }

    @Test
    public void testIncrementalCompilationWithModuleOverride() {
        String drl1 = "package org.test.compiler; global java.util.List list; rule A when $s : String() then System.out.println( 'AAA' + $s ); list.add( 'A' + $s ); end ";
        String drl2 = "package totally.unrelated.pack; global java.util.List list; rule B when $s : String() then System.out.println( 'BBB' + $s ); list.add( 'B' + $s ); end ";
        String drl3 = "package totally.unrelated.pack; global java.util.List list; rule C when $s : String() then System.out.println( 'CCC' + $s ); list.add( 'C' + $s ); end ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "foo", "1.0-SNAPSHOT");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test.compiler; global java.util.List list; rule A when $s : String() then System.out.println( 'AAA' + $s ); list.add( 'A' + $s ); end ")).setResourceType(ResourceType.DRL).setSourcePath("drl1.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"X");
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains("AX")).isTrue();
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id);
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package totally.unrelated.pack; global java.util.List list; rule B when $s : String() then System.out.println( 'BBB' + $s ); list.add( 'B' + $s ); end ")).setResourceType(ResourceType.DRL).setSourcePath("drla.drl"));
        kieBuilder2.buildAll(DrlProject.class);
        KieContainer kc2 = ks.newKieContainer(id);
        KieSession ksession2 = kc2.newKieSession();
        ksession2.setGlobal("list", list);
        ksession2.insert((Object)"X");
        ksession2.fireAllRules();
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package totally.unrelated.pack; global java.util.List list; rule C when $s : String() then System.out.println( 'CCC' + $s ); list.add( 'C' + $s ); end ")).setResourceType(ResourceType.DRL).setSourcePath("drlb.drl"));
        IncrementalResults results = ((InternalKieBuilder)kieBuilder2).incrementalBuild();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        kc2.updateToVersion(id);
        ksession2.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList("AX", "BX", "CX"));
    }

    @Test
    public void testIncrementalCompilationWithMissingKSession() {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.kie</groupId>\n  <artifactId>test</artifactId>\n  <version>1.0</version>\n  <packaging>jar</packaging>\n  <name>test</name>\n</project>";
        String kmodule = "<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<kbase name=\"kbase\" includes=\"nonExistent\"/>\n</kmodule>";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( nonExistentField == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("pom.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <modelVersion>4.0.0</modelVersion>\n  <groupId>org.kie</groupId>\n  <artifactId>test</artifactId>\n  <version>1.0</version>\n  <packaging>jar</packaging>\n  <name>test</name>\n</project>").write("src/main/resources/META-INF/kmodule.xml", "<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<kbase name=\"kbase\" includes=\"nonExistent\"/>\n</kmodule>").write("src/main/resources/r2.drl", drl2_1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)results.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testIncrementalCompilationWithIncludes() {
        String drl1 = "global java.util.List list\nrule R1 when\n $s : String() then\n list.add( \"a\" + $s );end\n";
        String drl2 = "global java.util.List list\nrule R1 when\n $s : String() then\n list.add( \"b\" + $s );end\n";
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.test", "test", "1.0.0");
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").addPackage("org.pkg1");
        kieBaseModel1.newKieSessionModel("KSession1");
        KieBaseModel kieBaseModel2 = kproj.newKieBaseModel("KBase2").addPackage("org.pkg2").addInclude("KBase1");
        kieBaseModel2.newKieSessionModel("KSession2");
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId).write("src/main/resources/KBase1/org/pkg1/r1.drl", "global java.util.List list\nrule R1 when\n $s : String() then\n list.add( \"a\" + $s );end\n").writeKModuleXML(kproj.toXML());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages().size()).isEqualTo(0);
        KieContainer kc = ks.newKieContainer(releaseId);
        KieSession ksession = kc.newKieSession("KSession2");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Foo");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("aFoo");
        list.clear();
        kfs.delete(new String[]{"src/main/resources/KBase1/org/pkg1/r1.drl"});
        kfs.write("src/main/resources/KBase1/org/pkg1/r2.drl", "global java.util.List list\nrule R1 when\n $s : String() then\n list.add( \"b\" + $s );end\n");
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).incrementalBuild();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Results updateResults = kc.updateToVersion(releaseId);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
        ksession.insert((Object)"Bar");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("bBar", "bFoo"))).isTrue();
    }

    @Test
    public void testIncrementalCompilationWithInvalidDRL() {
        String drl1 = "Smurf";
        String drl2_1 = "package org.drools.compiler\nrule R2\nwhen\n   $m : NonExistentClass()\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2\nwhen\n   $m : Message()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/r1.drl", "Smurf");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Results results1 = kieBuilder.getResults();
        Assertions.assertThat((int)results1.getMessages().size()).isEqualTo(2);
        kfs.write("src/main/resources/r2.drl", "package org.drools.compiler\nrule R2\nwhen\n   $m : NonExistentClass()\nthen\nend\n");
        IncrementalResults results2 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results2.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)results2.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", drl2_2);
        IncrementalResults results3 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results3.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)results3.getRemovedMessages().size()).isEqualTo(1);
        kfs.delete(new String[]{"src/main/resources/r1.drl"});
        IncrementalResults results4 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl"}).build();
        Assertions.assertThat((int)results4.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)results4.getRemovedMessages().size()).isEqualTo(2);
    }

    @Test
    public void testKJarUpgradeSameSessionAddingGlobal() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.lang.String foo\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.lang.String foo\nrule R2_2 when\n   $m : Message( message == foo )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_2});
        kc.updateToVersion(releaseId2);
        ksession.setGlobal("foo", (Object)"Hello World");
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testKJarUpgradeWithDSL() {
        String dsl = "[when][]There is a Message=Message()\n[when][]-with message \"{factId}\"=message==\"{factId}\"\n\n[then][]Print \"{message}\"=System.out.println(\"{message}\");\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule \"bla\"\nwhen\n\tThere is a Message\t   \n\t-with message \"Hi Universe\"\nthen\n\tPrint \"Found a Message Hi Universe.\"\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule \"bla\"\nwhen\n\tThere is a Message\t   \n\t-with message \"Hello World\"\nthen\n\tPrint \"Found a Message Hello World.\"\nend\n";
        KieServices ks = KieServices.Factory.get();
        Resource dslResource = KieUtil.getResource((String)"[when][]There is a Message=Message()\n[when][]-with message \"{factId}\"=message==\"{factId}\"\n\n[then][]Print \"{message}\"=System.out.println(\"{message}\");\n", (String)"src/main/resources/rulesDsl.dsl");
        Resource drlResource2_1 = KieUtil.getResource((String)drl2_1, (String)"src/main/resources/rules1.rdslr");
        Resource drlResource2_2 = KieUtil.getResource((String)drl2_2, (String)"src/main/resources/rules2.rdslr");
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{dslResource, drlResource2_1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ksession.dispose();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{dslResource, drlResource2_2});
        kc.updateToVersion(releaseId2);
        ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="this test takes too long and cannot be emulated with a pseudo clock")
    public void testIncrementalCompilationWithFireUntilHalt() {
        String drl1 = this.getCronRule(3) + this.getCronRule(6);
        String drl2 = this.getCronRule(8) + this.getCronRule(10) + this.getCronRule(5);
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        try {
            new Thread(() -> ((KieSession)kieSession).fireUntilHalt()).start();
            ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1.1.0");
            KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
            Results results = kc.updateToVersion(releaseId2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)results.hasMessages(new Message.Level[]{Message.Level.ERROR})).as("Errors detected on updateToVersion: " + results.getMessages(new Message.Level[]{Message.Level.ERROR}), new Object[0])).isFalse();
        }
        finally {
            kieSession.halt();
        }
    }

    private String getCronRule(int seconds) {
        return "rule R" + seconds + " timer (cron: */" + seconds + " * * * * ?) when then System.out.println('Hey there, I print every " + seconds + " seconds'); end\n";
    }

    @Test
    public void testKJarUpgradeSameSessionRemovingGlobal() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.lang.String foo\nglobal java.lang.String bar\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.lang.String foo\nglobal java.lang.String baz\nrule R2 when\n   $m : Message( )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.setGlobal("foo", (Object)"foo");
        ksession.setGlobal("bar", (Object)"bar");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        ksession.setGlobal("baz", (Object)"baz");
        Globals globals = ksession.getGlobals();
        Assertions.assertThat((int)globals.getGlobalKeys().size()).isEqualTo(2);
        Assertions.assertThat((Object)ksession.getGlobal("foo")).isEqualTo((Object)"foo");
        Assertions.assertThat((Object)ksession.getGlobal("bar")).isNull();
        Assertions.assertThat((Object)ksession.getGlobal("baz")).isEqualTo((Object)"baz");
    }

    @Test
    public void testUpdateVersionWithKSessionLogger() {
        String drl1 = "import java.util.List\nimport java.util.ArrayList\n\nrule \"Test1\"\n\nwhen\n   $a : Integer()\nthen\n   insert(new ArrayList());\nend\n";
        String drl2 = "rule \"Test2\"\nwhen\n   $b : List()\n then\n   $b.isEmpty();\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATELESS_REALTIME, new HashMap(), (String[])new String[]{"import java.util.List\nimport java.util.ArrayList\n\nrule \"Test1\"\n\nwhen\n   $a : Integer()\nthen\n   insert(new ArrayList());\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        StatelessKieSession statelessKieSession = kc.newStatelessKieSession();
        KieRuntimeLogger kieRuntimeLogger = ks.getLoggers().newConsoleLogger((KieRuntimeEventManager)statelessKieSession);
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add(CommandFactory.newInsertElements(new ArrayList()));
        FireAllRulesCommand fireAllRulesCommand = (FireAllRulesCommand)CommandFactory.newFireAllRules();
        cmds.add(fireAllRulesCommand);
        cmds.add(CommandFactory.newGetObjects((String)"returnedObjects"));
        BatchExecutionCommand batchExecutionCommand = CommandFactory.newBatchExecution(cmds);
        statelessKieSession.execute((Command)batchExecutionCommand);
        kieRuntimeLogger.close();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieSessionTestConfiguration)KieSessionTestConfiguration.STATELESS_REALTIME, new HashMap(), (String[])new String[]{"import java.util.List\nimport java.util.ArrayList\n\nrule \"Test1\"\n\nwhen\n   $a : Integer()\nthen\n   insert(new ArrayList());\nend\nrule \"Test2\"\nwhen\n   $b : List()\n then\n   $b.isEmpty();\nend"});
        kc.updateToVersion(releaseId2);
    }

    @Test
    public void testChangeParentRule() {
        String drl1 = "global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 3 )\nthen\nend";
        String drl2 = "global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 2 )\nthen\nend";
        String drl3 = "global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 5 )\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 3 )\nthen\nend"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)4);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 2 )\nthen\nend"});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list;rule B extends A when\n    $s : String()\nthen\n    list.add( $s );\nend\n\nrule A when\n    $i : Integer( this > 5 )\nthen\nend"});
        kc.updateToVersion(releaseId3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    @Test
    public void testRuleRemovalAfterUpdate() {
        String drl = "rule Rule1\n  when\n    Integer()\n    String()\n    Long()\n    not (Double())\n  then \nend\n\nrule Rule2\n  when\n    Integer()\n    String()\n  then \nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)"test");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule Rule1\n  when\n    Integer()\n    String()\n    Long()\n    not (Double())\n  then \nend\n\nrule Rule2\n  when\n    Integer()\n    String()\n  then \nend"});
        kc.updateToVersion(releaseId2);
        FactHandle handle = ksession.insert((Object)1);
        ksession.fireAllRules();
        ksession.update(handle, (Object)1);
        ksession.fireAllRules();
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId3);
    }

    @Test
    public void testIncrementalTypeDeclarationOnInterface() {
        String drl1 = "import " + KieService.class.getCanonicalName() + "\nrule A when\n    KieService( )\nthen\nend";
        String drl2 = "import " + KieService.class.getCanonicalName() + "\ndeclare Service @role( event ) end\nrule A when\n    KieService( )\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
    }

    @Test
    public void testNonHashablePropertyWithIncrementalCompilation() {
        String drl1 = "rule \"HelloGreetingService\"\n    when\n        $name : String(this == \"first\")\n    then\n        System.out.println(String.format(\"Hello %s!\", $name));\nend\nrule \"CiaoGreetingService\"\n    when\n        $name : String(this == \"second\")\n    then\n        System.out.println(String.format(\"Ciao %s!\", $name));\nend\n";
        String drl2 = "rule \"HelloGreetingService\"\n    when\n        $name : String(this == \"first\")\n    then\n        System.out.println(String.format(\"Modified Hello %s!\", $name));\nend\nrule \"CiaoGreetingService\"\n    when\n        $name : String(this == \"second\")\n    then\n        System.out.println(String.format(\"Modified Ciao %s!\", $name));\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule \"HelloGreetingService\"\n    when\n        $name : String(this == \"first\")\n    then\n        System.out.println(String.format(\"Hello %s!\", $name));\nend\nrule \"CiaoGreetingService\"\n    when\n        $name : String(this == \"second\")\n    then\n        System.out.println(String.format(\"Ciao %s!\", $name));\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule \"HelloGreetingService\"\n    when\n        $name : String(this == \"first\")\n    then\n        System.out.println(String.format(\"Modified Hello %s!\", $name));\nend\nrule \"CiaoGreetingService\"\n    when\n        $name : String(this == \"second\")\n    then\n        System.out.println(String.format(\"Modified Ciao %s!\", $name));\nend\n"});
        kc.updateToVersion(releaseId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentKJarDeployment() throws Exception {
        int parallelThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            for (Callable<Boolean> s : Deployer.getDeployer(10, this.kieBaseTestConfiguration)) {
                ecs.submit(s);
            }
            for (int i = 0; i < 10; ++i) {
                Assertions.assertThat((Boolean)((Boolean)ecs.take().get())).isTrue();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testSegmentSplitOnIncrementalCompilation() {
        String drl = "import " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nrule R1 when\n  $s : String()  Person( name == $s ) \nthen\n  list.add(\"R1\");\nend\nrule R2 when\n  $s : String()  Person( name == $s ) \nthen\n  list.add(\"R2\");\nend\nrule R3 when\n  $s : String()  Person( name != $s ) \nthen\n  list.add(\"R3\");\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        kc.updateToVersion(releaseId1);
        ksession.insert((Object)new Person("John", 26));
        ksession.insert((Object)"John");
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        kc.updateToVersion(releaseId2);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("R1", "R2"))).isTrue();
    }

    @Test
    public void testSegmentMergeOnRuleRemovalWithNotExistingSegment() {
        String drl1 = "rule R1 when\n    $i : Integer()\n    $s : String( length == $i )\nthen\nend\nrule R2 when\n    $i : Integer()\n    $l : Long( this > $i )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    $i : Integer()\n    $s : String( length == $i )\nthen\nend\nrule R2 when\n    $i : Integer()\n    $l : Long( this > $i )\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        kc.updateToVersion(releaseId1);
        ksession.insert((Object)"Test");
        ksession.insert((Object)4L);
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId2);
    }

    @Test
    public void testRemoveRuleWithRia() {
        String drl1 = "import " + List.class.getCanonicalName() + "\nrule R when\n    $list : List()\n    exists Integer( this == 1 ) from $list\n    exists Integer( this == 2 ) from $list\nthen \nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId2);
        Rete rete = ((InternalKnowledgeBase)ksession.getKieBase()).getRete();
        EntryPointNode entryPointNode = (EntryPointNode)rete.getEntryPointNodes().values().iterator().next();
        for (ObjectTypeNode otns : entryPointNode.getObjectTypeNodes().values()) {
            Assertions.assertThat((int)otns.getObjectSinkPropagator().getSinks().length).isEqualTo(0);
        }
    }

    @Test
    public void testRetractLogicalAssertedObjectOnRuleRemoval() {
        String drl1 = "rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found1\" );end\n";
        String drl2 = "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found2\" );end\n";
        String drl3 = "package org.drools.compiler\nrule R3 when\n    exists( Integer() )\nthen\n    insertLogical( \"found3\");end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found1\" );end\n", "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found2\" );end\n", "package org.drools.compiler\nrule R3 when\n    exists( Integer() )\nthen\n    insertLogical( \"found3\");end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)4);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(3);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found1\" );end\n", "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found2\" );end\n"});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(2);
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.3");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found1\" );end\n"});
        kc.updateToVersion(releaseId3);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(1);
        ReleaseId releaseId4 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.4");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId4, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId4);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(0);
    }

    @Test
    public void testRetractLogicalAssertedObjectOnRuleRemovalWithSameObject() {
        String drl1 = "rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n";
        String drl2 = "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n";
        String drl3 = "package org.drools.compiler\nrule R3 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\");end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n", "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n", "package org.drools.compiler\nrule R3 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\");end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)4);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(1);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n", "package org.drools.compiler\nrule R2 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n"});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(1);
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.3");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    exists( Integer() )\nthen\n    insertLogical( \"found\" );end\n"});
        kc.updateToVersion(releaseId3);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(1);
        ReleaseId releaseId4 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.4");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId4, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        kc.updateToVersion(releaseId4);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(String.class)).size()).isEqualTo(0);
    }

    @Test
    public void testUpdateWithNewDrlAndChangeInOldOne() {
        String drl1 = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule1")).isTrue();
        drl1 = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\nObject()\nthen\nlist.add( drools.getRule().getName() );\nend\n";
        String drl2 = "package org.kie.test\nglobal java.util.List list\nrule rule2\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, "package org.kie.test\nglobal java.util.List list\nrule rule2\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n"});
        kc.updateToVersion(releaseId2);
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("rule2")).isTrue();
    }

    @Test
    public void testIncrementalCompilationWithEagerRules() {
        String drl1 = "rule R1 when\nthen\n  insert(\"test\");\nend\n\nrule R2\nno-loop true\nwhen\nthen\n  insert(1);\nend\n";
        String drl2 = "rule R3\nno-loop true\nwhen\nthen\n  insert(1);\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\nthen\n  insert(\"test\");\nend\n\nrule R2\nno-loop true\nwhen\nthen\n  insert(1);\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R3\nno-loop true\nwhen\nthen\n  insert(1);\nend\n"});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
    }

    @Test
    public void testMultipleIncrementalCompilationWithExistentialRules() {
        ArrayList<String> drls = new ArrayList<String>();
        drls.add(this.getExistenzialRule("R0", "> 10"));
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])drls.toArray(new String[0]));
        KieContainer kc = ks.newKieContainer(releaseId);
        KieSession ksession = kc.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(0);
        for (int i = 1; i < 11; ++i) {
            ReleaseId newReleaseId = ks.newReleaseId("org.kie", "test-upgrade", "1.1." + i);
            drls.add(this.getExistenzialRule("R" + i, "< 10"));
            KieUtil.getKieModuleFromDrls((ReleaseId)newReleaseId, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])drls.toArray(new String[0]));
            kc.updateToVersion(newReleaseId);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(i);
        }
    }

    private String getExistenzialRule(String rulename, String condition) {
        return "global java.util.concurrent.atomic.AtomicInteger counter\nrule " + rulename + " when\n  exists (Integer( this " + condition + ") )\nthen\n  counter.incrementAndGet();\nend";
    }

    @Test
    public void testRuleRemovalWithOR() {
        String drl1 = "rule R1 when\n    $s : String()\n\t (Integer(this == $s.length) or Long(this == $s.length))\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n    $s : String()\n\t (Integer(this == $s.length) or Long(this == $s.length))\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        try {
            kc.updateToVersion(releaseId2);
        }
        catch (Exception e) {
            Assertions.fail((String)("Incremental update should succeed, but failed with " + e.getLocalizedMessage()));
        }
        ksession.fireAllRules();
    }

    @Test
    public void testSplitAfterQuery() {
        String drl1 = "global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 + $i );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n";
        String drl2 = "global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r1 when    foo( $i ; )    Integer( this == 10 ) then    System.out.println(\"10 \" + $i);   list.add( 10 + $i );\nend\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 + $i );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 + $i );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)20);
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list; query foo( Integer $i )    $i := Integer( this < 10 ) end\n\nrule r1 when    foo( $i ; )    Integer( this == 10 ) then    System.out.println(\"10 \" + $i);   list.add( 10 + $i );\nend\nrule r2 when    foo( $i; )    Integer( this == 20 ) then    System.out.println(\"20 \" + $i);   list.add( 20 + $i );\nend\nrule r3 when    $i : Integer( this == 1 ) then    System.out.println($i);   update( kcontext.getKieRuntime().getFactHandle( $i ), $i + 1 );end\n\n"});
        kc.updateToVersion(releaseId2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Integer)list.get(0))).isEqualTo(21);
        Assertions.assertThat((int)((Integer)list.get(1))).isEqualTo(22);
    }

    @Test
    public void testGetFactTypeOnIncrementalUpdate() throws Exception {
        String drl1 = "package org.mytest\ndeclare Person\n   name : String\n   age : Integer\nend\n\nrule R when Person(age > 30) then end\n";
        String drl2 = "package org.mytest\ndeclare Person\n   name : String\n   age : Integer\n   address : String\nend\n\nrule R when Person(age > 40) then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.mytest\ndeclare Person\n   name : String\n   age : Integer\nend\n\nrule R when Person(age > 30) then end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kbase = kc.getKieBase();
        FactType ftype = kbase.getFactType("org.mytest", "Person");
        Assertions.assertThat((Object)ftype.getField("name")).isNotNull();
        Assertions.assertThat((Object)ftype.getField("age")).isNotNull();
        Object fact = ftype.newInstance();
        ftype.set(fact, "name", (Object)"me");
        ftype.set(fact, "age", (Object)42);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.mytest\ndeclare Person\n   name : String\n   age : Integer\n   address : String\nend\n\nrule R when Person(age > 40) then end\n"});
        kc.updateToVersion(releaseId2);
        ftype = kbase.getFactType("org.mytest", "Person");
        Assertions.assertThat((Object)ftype.getField("name")).isNotNull();
        Assertions.assertThat((Object)ftype.getField("age")).isNotNull();
        Assertions.assertThat((Object)ftype.getField("address")).isNotNull();
        fact = ftype.newInstance();
        ftype.set(fact, "name", (Object)"me again");
        ftype.set(fact, "age", (Object)43);
        ftype.set(fact, "address", (Object)"World");
    }

    @Test
    public void testRuleRemovalWithSubnetworkAndOR() {
        String drl1 = "global java.util.concurrent.atomic.AtomicInteger globalInt\nrule R1 when\n    $s : String()\n\t (or exists Integer(this == 1)\n\t     exists Integer(this == 2) )\n\t exists Integer() from globalInt.get()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.concurrent.atomic.AtomicInteger globalInt\nrule R1 when\n    $s : String()\n\t (or exists Integer(this == 1)\n\t     exists Integer(this == 2) )\n\t exists Integer() from globalInt.get()\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.setGlobal("globalInt", (Object)new AtomicInteger(0));
        ksession.insert((Object)1);
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[0]);
        try {
            kc.updateToVersion(releaseId2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Incremental update should succeed, but failed with " + e.getLocalizedMessage()));
        }
        ksession.fireAllRules();
    }

    @Test
    public void testIncrementalCompilationWithClassFieldReader() {
        String personSrc = "package org.test;import java.util.ArrayList;import java.util.List;public class Person {    private String name;    private List<String> addresses = new ArrayList<String>();    public Person() {}    public Person(final String name) { this.name = name; }    public List<String> getAddresses() { return addresses; }    public void setAddresses(List<String> addresses) { this.addresses = addresses; }    public void addAddress(String address) { this.addresses.add(address); }    public String getName() { return this.name; }    public void setName(final String name) { this.name = name; }}";
        String drl1 = "package org.drools.compiler\nimport org.test.Person;\nimport " + Address.class.getCanonicalName() + ";\nrule R0 salience 100 when\n String()then\n Person person = new Person(\"John\"); person.addAddress(\"A street\"); insert(person);end\nrule R1 when\n $p : Person($addresses : addresses)  $a : Address() from $addresses then\nend\n";
        String drl2 = drl1 + " ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "myTest", "1.0.0");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.write("src/main/java/org/test/Person.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;import java.util.ArrayList;import java.util.List;public class Person {    private String name;    private List<String> addresses = new ArrayList<String>();    public Person() {}    public Person(final String name) { this.name = name; }    public List<String> getAddresses() { return addresses; }    public void setAddresses(List<String> addresses) { this.addresses = addresses; }    public void addAddress(String address) { this.addresses.add(address); }    public String getName() { return this.name; }    public void setName(final String name) { this.name = name; }}")));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader(drl1)).setResourceType(ResourceType.DRL).setSourcePath("drl1.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader(drl2)).setResourceType(ResourceType.DRL).setSourcePath("drl1.drl"));
        ((InternalKieBuilder)kieBuilder).incrementalBuild();
        ksession.insert((Object)"start");
        ksession.fireAllRules();
    }

    @Test
    public void testIncrementalCompilationRemovingParentRule() {
        String drl1 = "package org.drools.compiler\nrule R1 when\n   $s : String()\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nrule R2 extends R1 when\n   $i : Integer()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", "package org.drools.compiler\nrule R1 when\n   $s : String()\nthen\nend\n").write("src/main/resources/r2.drl", "package org.drools.compiler\nrule R2 extends R1 when\n   $i : Integer()\nthen\nend\n");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSession ksession = kieContainer.newKieSession();
        ksession.insert((Object)"test");
        ksession.insert((Object)1);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        kfs.delete(new String[]{"src/main/resources/r1.drl"});
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl", "src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)results.getRemovedMessages().size()).isEqualTo(0);
        kieContainer.updateToVersion(ks.getRepository().getDefaultReleaseId());
        ksession = kieContainer.newKieSession();
        ksession.insert((Object)"test");
        ksession.insert((Object)1);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIncrementalCompilationChangeParentRule() {
        String drl1_1 = "rule R1 when\n   $s : String( this == \"s1\" )\nthen\nend\n";
        String drl1_2 = "rule R1 when\n   $s : String( this == \"s2\" )\nthen\nend\n";
        String drl2 = "rule R2 extends R1 when\n   $i : Integer()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-extends", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n   $s : String( this == \"s1\" )\nthen\nend\nrule R2 extends R1 when\n   $i : Integer()\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)1);
        ksession.insert((Object)"s2");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-extends", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n   $s : String( this == \"s2\" )\nthen\nend\nrule R2 extends R1 when\n   $i : Integer()\nthen\nend\n"});
        kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIncrementalCompilationChangeParentRuleInDifferentFile() {
        String drl1_1 = "rule R1 when\n   $s : String( this == \"s1\" )\nthen\nend\n";
        String drl1_2 = "rule R1 when\n   $s : String( this == \"s2\" )\nthen\nend\n";
        String drl2 = "rule R2 extends R1 when\n   $i : Integer()\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-extends", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n   $s : String( this == \"s1\" )\nthen\nend\n", "rule R2 extends R1 when\n   $i : Integer()\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)1);
        ksession.insert((Object)"s2");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-extends", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n   $s : String( this == \"s2\" )\nthen\nend\n", "rule R2 extends R1 when\n   $i : Integer()\nthen\nend\n"});
        kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testRemovePackageFromKieBaseModel() {
        String drl1 = "global java.util.List list;\nrule R1 when\n  String()\nthen\n  list.add(\"R1\");end\n";
        String drl2 = "global java.util.List list;\nrule R2 when\n  String()\nthen\n  list.add(\"R2\");end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-remove-pkg", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-remove-pkg", "1.1");
        Resource drl1Resource = KieUtil.getResource((String)"global java.util.List list;\nrule R1 when\n  String()\nthen\n  list.add(\"R1\");end\n", (String)"src/main/resources/pkg1/r1.drl");
        Resource drl2Resource = KieUtil.getResource((String)"global java.util.List list;\nrule R2 when\n  String()\nthen\n  list.add(\"R2\");end\n", (String)"src/main/resources/pkg2/r2.drl");
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drl1Resource, drl2Resource});
        KieContainer container = ks.newKieContainer(releaseId1);
        KieSession ksession = container.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("R1", "R2"))).isTrue();
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drl2Resource});
        Results results = container.updateToVersion(releaseId2);
        Assertions.assertThat((int)results.getMessages().size()).isEqualTo(0);
        ksession = container.newKieSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("R2")).isTrue();
    }

    @Test
    public void testAddPackageToKieBaseModel() {
        String drl1 = "global java.util.List list;\nrule R1 when\n  String()\nthen\n  list.add(\"R1\");end\n";
        String drl2 = "global java.util.List list;\nrule R2 when\n  String()\nthen\n  list.add(\"R2\");end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-remove-pkg", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-remove-pkg", "1.1");
        Resource drl1Resource = KieUtil.getResource((String)"global java.util.List list;\nrule R1 when\n  String()\nthen\n  list.add(\"R1\");end\n", (String)"src/main/resources/pkg1/r1.drl");
        Resource drl2Resource = KieUtil.getResource((String)"global java.util.List list;\nrule R2 when\n  String()\nthen\n  list.add(\"R2\");end\n", (String)"src/main/resources/pkg2/r2.drl");
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drl2Resource});
        KieContainer container = ks.newKieContainer(releaseId1);
        KieSession ksession = container.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((boolean)list.contains("R2")).isTrue();
        KieUtil.getKieModuleFromResources((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (Resource[])new Resource[]{drl1Resource, drl2Resource});
        Results results = container.updateToVersion(releaseId2);
        Assertions.assertThat((int)results.getMessages().size()).isEqualTo(0);
        ksession = container.newKieSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("R1", "R2"))).isTrue();
    }

    @Test
    public void testKJarUpgradeWithSpace() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\n import " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 1, 0);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace2() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello World\"  )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 1, 0);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace3() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rs when $s : String() then System.out.println($s); end\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\n  System.out.println($m); \nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rs when $s : String( this == \"x\") then System.out.println($s); end\nrule Rx when\n   $m : Message( message == \"Hello World\"  )\nthen\n  System.out.println($m); \nend\n";
        this.testKJarUpgradeWithSpaceVariant2(drl1, drl2);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace4() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello  World\" )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 0, 1);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace5() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello'  World\" )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == \"Hello' World\" )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello' World", 0, 1);
    }

    @Test
    public void testKJarUpgradeWithSpace_usingSingleQuote() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\n import " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 1, 0);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace2_usingSingleQuote() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello World'  )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 1, 0);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace3_usingSingleQuote() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rs when $s : String() then System.out.println($s); end\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\n  System.out.println($m); \nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rs when $s : String( this == 'x') then System.out.println($s); end\nrule Rx when\n   $m : Message( message == 'Hello World'  )\nthen\n  System.out.println($m); \nend\n";
        this.testKJarUpgradeWithSpaceVariant2(drl1, drl2);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace4_usingSingleQuote() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello  World' )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello World' )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello World", 0, 1);
    }

    @Test
    public void testKJarUpgradeDRLWithSpace5_usingSingleQuote() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello\\'  World' )\nthen\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule Rx when\n   $m : Message( message == 'Hello\\' World' )\nthen\nend\n";
        this.testKJarUpgradeDRLWithSpace(drl1, drl2, "Hello' World", 0, 1);
    }

    private void testKJarUpgradeDRLWithSpace(String drl1, String drl2, String factString, int firstFireCount, int secondFireCount) {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message(factString));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(firstFireCount);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(secondFireCount);
    }

    private void testKJarUpgradeWithSpaceVariant2(String drl1, String drl2) {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        final ArrayList fired = new ArrayList();
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                fired.add(event.getMatch().getRule().getName());
            }
        });
        ksession.insert((Object)new Message("Hello World"));
        ksession.insert((Object)"x");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((boolean)fired.contains("Rs")).isTrue();
        Assertions.assertThat((boolean)fired.contains("Rx")).isTrue();
        fired.clear();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((boolean)fired.contains("Rs")).isTrue();
        Assertions.assertThat((boolean)fired.contains("Rx")).isFalse();
    }

    @Test
    public void testJavaClassRedefinition() {
        String JAVA1 = "package org.test;    public class MyBean {\n        private String firstName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n    }";
        String DRL1 = "package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null )\n    then\n        System.out.println($b);end";
        String INIT_DRL = "package org.test; rule RINIT when eval(true) then insert(new MyBean()); end";
        String INIT_DRL_2 = "package org.test; rule RINIT when eval(1==1) then insert(new MyBean()); end";
        String JAVA2 = "package org.test;    public class MyBean {\n        private String firstName;\n        private String lastName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public MyBean(String firstName, String lastName) { this.firstName = firstName; this.lastName = lastName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n        public String getLastName() { return lastName; }\n        public void setLastName(String lastName) { this.lastName = lastName; }\n    }";
        String DRL2 = "package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null , lastName == null )\n    then\n        System.out.println($b);end";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "myTest", "1.0.0");
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.writeKModuleXML(kproj);
        kfs.write("src/main/java/org/test/MyBean.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyBean {\n        private String firstName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n    }")));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null )\n    then\n        System.out.println($b);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test; rule RINIT when eval(true) then insert(new MyBean()); end")).setResourceType(ResourceType.DRL).setSourcePath("INIT_DRL.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
        ReleaseId id2 = ks.newReleaseId("org.test", "myTest", "2.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id2);
        kfs2.writeKModuleXML(kproj);
        kfs2.write("src/main/java/org/test/MyBean.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyBean {\n        private String firstName;\n        private String lastName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public MyBean(String firstName, String lastName) { this.firstName = firstName; this.lastName = lastName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n        public String getLastName() { return lastName; }\n        public void setLastName(String lastName) { this.lastName = lastName; }\n    }")));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null , lastName == null )\n    then\n        System.out.println($b);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test; rule RINIT when eval(1==1) then insert(new MyBean()); end")).setResourceType(ResourceType.DRL).setSourcePath("INIT_DRL.drl"));
        kieBuilder2.buildAll(DrlProject.class);
        Results updateResults = kc.updateToVersion(id2);
        Assertions.assertThat((boolean)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
    }

    @Test
    public void testJavaClassRedefinitionJoined() {
        String JAVA1 = "package org.test;    public class MyBean {\n        private String firstName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n    }";
        String DRL1 = "package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null )\n        $s : String()\n    then\n        System.out.println($s + \" \" + $b);end";
        String INIT_DRL = "package org.test; rule RINIT when eval(true) then insert(new MyBean()); end";
        String INIT_DRL_2 = "package org.test; rule RINIT when eval(1==1) then insert(new MyBean()); end";
        String JAVA2 = "package org.test;    public class MyBean {\n        private String firstName;\n        private String lastName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public MyBean(String firstName, String lastName) { this.firstName = firstName; this.lastName = lastName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n        public String getLastName() { return lastName; }\n        public void setLastName(String lastName) { this.lastName = lastName; }\n    }";
        String DRL2 = "package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null , lastName == null )\n        $s : String()\n    then\n        System.out.println($s + \" \" + $b);end";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "myTest", "1.0.0");
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.writeKModuleXML(kproj);
        kfs.write("src/main/java/org/test/MyBean.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyBean {\n        private String firstName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n    }")));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null )\n        $s : String()\n    then\n        System.out.println($s + \" \" + $b);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test; rule RINIT when eval(true) then insert(new MyBean()); end")).setResourceType(ResourceType.DRL).setSourcePath("INIT_DRL.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)"This string joins with");
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
        ReleaseId id2 = ks.newReleaseId("org.test", "myTest", "2.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id2);
        kfs2.writeKModuleXML(kproj);
        kfs2.write("src/main/java/org/test/MyBean.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyBean {\n        private String firstName;\n        private String lastName;\n        public MyBean() { /* empty constructor */ }\n        public MyBean(String firstName) { this.firstName = firstName; }\n        public MyBean(String firstName, String lastName) { this.firstName = firstName; this.lastName = lastName; }\n        public String getFirstName() { return firstName; }\n        public void setFirstName(String firstName) { this.firstName = firstName; }\n        public String getLastName() { return lastName; }\n        public void setLastName(String lastName) { this.lastName = lastName; }\n    }")));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\n\n//from row number: 1\nrule \"Row 1 HelloRules\"\n    when\n        $b : MyBean( firstName == null , lastName == null )\n        $s : String()\n    then\n        System.out.println($s + \" \" + $b);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test; rule RINIT when eval(1==1) then insert(new MyBean()); end")).setResourceType(ResourceType.DRL).setSourcePath("INIT_DRL.drl"));
        kieBuilder2.buildAll(DrlProject.class);
        Results updateResults = kc.updateToVersion(id2);
        Assertions.assertThat((boolean)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testMultipleIncrementalCompilationsWithFireUntilHalt() throws Exception {
        CountDownLatch done;
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getTestRuleForFireUntilHalt(0)});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        DebugList list = new DebugList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)new Message("X"));
        list.done = done = new CountDownLatch(1);
        try {
            new Thread(() -> ((KieSession)kieSession).fireUntilHalt()).start();
            done.await();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("0 - X");
            list.clear();
            for (int i = 1; i < 10; ++i) {
                list.done = done = new CountDownLatch(1);
                ReleaseId releaseIdI = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1." + i);
                KieUtil.getKieModuleFromDrls((ReleaseId)releaseIdI, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getTestRuleForFireUntilHalt(i)});
                kc.updateToVersion(releaseIdI);
                done.await();
                Assertions.assertThat((int)list.size()).isEqualTo(1);
                Assertions.assertThat((String)((String)list.get(0))).isEqualTo(i + " - X");
                list.clear();
            }
        }
        finally {
            kieSession.halt();
        }
    }

    private String getTestRuleForFireUntilHalt(int i) {
        return "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule Rx when\n   Message( $m : message )\nthen\n    list.add(\"" + i + " - \" + $m);\nend\n";
    }

    @Test
    public void testIncrementalCompilationWithExtendsRule() {
        String drl1 = "rule \"test1\" when then end\n";
        String drl2 = "rule \"test2\" extends \"test1\" when then end\nrule \"test3\" extends \"test1\" when then end\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", "rule \"test1\" when then end\n");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", "rule \"test2\" extends \"test1\" when then end\nrule \"test3\" extends \"test1\" when then end\n");
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults.getAddedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testUpdateWithPojoExtensionDifferentPackages() throws Exception {
        String drlDeclare = "package org.drools.compiler.integrationtests\ndeclare DroolsApplications extends " + BaseClass.class.getCanonicalName() + "\n    droolsAppName: String\nend";
        String drlRule = "package org.drools.compiler.test\nrule R1 when\n   $fact : org.drools.compiler.integrationtests.DroolsApplications( droolsAppName == \"appName\" )\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").setDefault(true).newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        kfs.generateAndWritePomXML(releaseId1);
        kfs.writeKModuleXML(kproj);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader(drlDeclare)).setResourceType(ResourceType.DRL).setSourcePath("drlDeclare.drl"));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        FactType factType = kc.getKieBase().getFactType("org.drools.compiler.integrationtests", "DroolsApplications");
        Object fact = factType.newInstance();
        factType.set(fact, "droolsAppName", (Object)"appName");
        ksession.insert(fact);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        kfs2.generateAndWritePomXML(releaseId2);
        kfs2.writeKModuleXML(kproj);
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader(drlDeclare)).setResourceType(ResourceType.DRL).setSourcePath("drlDeclare.drl"));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.drools.compiler.test\nrule R1 when\n   $fact : org.drools.compiler.integrationtests.DroolsApplications( droolsAppName == \"appName\" )\nthen\nend")).setResourceType(ResourceType.DRL).setSourcePath("drlRule.drl"));
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kieBuilder2.buildAll(DrlProject.class);
        Results updateResults = kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testPropertyReactivityOfAKnownClass() {
        String drl1 = "import " + TypeA.class.getCanonicalName() + "\nimport " + TypeB.class.getCanonicalName() + "\nrule \"RULE_1\"\n    when\n        TypeA()        TypeB()    then\nend\n";
        String drl2 = "import " + TypeB.class.getCanonicalName() + "\nrule \"RULE_2\"\n    when\n        $b : TypeB() @watch(!*)    then\n        modify($b) { setValue(0) } \nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        ksession.insert((Object)new TypeB(1));
        int fired = ksession.fireAllRules(10);
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    @Test
    public void testPropertyReactivityOfAnOriginallyUnknownClass() {
        String drl1 = "import " + TypeA.class.getCanonicalName() + "\nrule \"RULE_1\"\n    when\n        TypeA()    then\nend\n";
        String drl2 = "import " + TypeB.class.getCanonicalName() + "\nrule \"RULE_2\"\n    when\n        $b : TypeB() @watch(!*)    then\n        modify($b) { setValue(0) } \nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl2});
        kc.updateToVersion(releaseId2);
        ksession.insert((Object)new TypeB(1));
        int fired = ksession.fireAllRules(10);
        Assertions.assertThat((int)fired).isEqualTo(1);
    }

    @Test
    public void testDeclaredTypeInDifferentPackage() throws IllegalAccessException, InstantiationException {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{DECLARES_DRL, RULES1_DRL});
        KieContainer kContainer = ks.newKieContainer(releaseId1);
        this.doFire(kContainer.getKieBase(), "reply 1");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{DECLARES_DRL, RULES2_DRL});
        kContainer.updateToVersion(releaseId2);
        this.doFire(kContainer.getKieBase(), "reply 2");
    }

    @Test
    public void testDeclaredTypeInIncludedKieBase() throws IllegalAccessException, InstantiationException {
        KieServices ks = KieServices.Factory.get();
        KieModule kModule = this.buildKieModule("0.0.1", RULES1_DRL);
        KieContainer kContainer = ks.newKieContainer(kModule.getReleaseId());
        this.doFire(kContainer.getKieBase("kiemodulemodel"), "reply 1");
        KieModule kModule2 = this.buildKieModule("0.0.2", RULES2_DRL);
        kContainer.updateToVersion(kModule2.getReleaseId());
        this.doFire(kContainer.getKieBase("kiemodulemodel"), "reply 2");
    }

    private KieModule buildKieModule(String version, String rules) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId rid = ks.newReleaseId("org.drools", "kiemodulemodel-example", version);
        kfs.generateAndWritePomXML(rid);
        KieModuleModel kModuleModel = ks.newKieModuleModel();
        kModuleModel.newKieBaseModel("kiemodulemodel").addPackage("kiemodulemodel").addInclude("kiedeclare");
        kModuleModel.newKieBaseModel("kiedeclare").addPackage("kiedeclare");
        kfs.writeKModuleXML(kModuleModel.toXML());
        kfs.write("src/main/resources/kiedeclare/declares.drl", DECLARES_DRL);
        kfs.write("src/main/resources/kiemodulemodel/rules.drl", rules);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        return kb.getKieModule();
    }

    private void doFire(KieBase kbase, String reply) throws InstantiationException, IllegalAccessException {
        FactType ftype = kbase.getFactType("org.drools.example.api.kiedeclare", "Message");
        KieSession kSession = kbase.newKieSession();
        kSession.insert(this.createMessage(ftype));
        Assertions.assertThat((int)kSession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((int)kSession.getObjects().size()).isEqualTo(1);
        Object fact = kSession.getObjects().iterator().next();
        Assertions.assertThat((Object)ftype.get(fact, "name")).isEqualTo((Object)"HAL");
        Assertions.assertThat((Object)ftype.get(fact, "text")).isEqualTo((Object)reply);
        kSession.dispose();
    }

    private Object createMessage(FactType ftype) throws IllegalAccessException, InstantiationException {
        Object fact = ftype.newInstance();
        ftype.set(fact, "name", (Object)"Dave");
        ftype.set(fact, "text", (Object)"What's the problem?");
        Assertions.assertThat((Object)ftype.get(fact, "name")).isEqualTo((Object)"Dave");
        Assertions.assertThat((Object)ftype.get(fact, "text")).isEqualTo((Object)"What's the problem?");
        return fact;
    }

    @Test
    public void testRemoveAndReaddJavaClass() {
        String javaSource = "package org.drools.test;\npublic class Person { }\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId1);
        KieModuleModel kModuleModel = ks.newKieModuleModel();
        kfs.writeKModuleXML(kModuleModel.toXML());
        kfs.write("src/main/java/org/drools/test/Person.java", "package org.drools.test;\npublic class Person { }\n");
        ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        KieContainer kContainer = ks.newKieContainer(releaseId1);
        try {
            Class.forName("org.drools.test.Person", true, kContainer.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        kContainer.getKieBase();
        kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId2);
        kModuleModel = ks.newKieModuleModel();
        kfs.writeKModuleXML(kModuleModel.toXML());
        ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        kContainer.updateToVersion(releaseId2);
        kContainer.getKieBase();
        kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(releaseId3);
        kModuleModel = ks.newKieModuleModel();
        kfs.writeKModuleXML(kModuleModel.toXML());
        kfs.write("src/main/java/org/drools/test/Person.java", "package org.drools.test;\npublic class Person { }\n");
        ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        kContainer.updateToVersion(releaseId3);
    }

    @Test
    public void testChangedPackage() {
        String drl1 = "package org.a\nrule \"RG_1\"\n    when\n        Boolean()\n        Integer()\n    then\n        System.out.println(\"RG_1\");end\n";
        String drl2 = "package org.b\nrule \"RG_2\"\n    when\n        Boolean()\n        String()\n    then\n        System.out.println(\"RG_2\");end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.b\nrule \"RG_2\"\n    when\n        Boolean()\n        String()\n    then\n        System.out.println(\"RG_2\");end\n", "package org.a\nrule \"RG_1\"\n    when\n        Boolean()\n        Integer()\n    then\n        System.out.println(\"RG_1\");end\n"});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieSession kieSession = kieContainer.newKieSession();
        kieSession.insert((Object)"test");
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.a\nrule \"RG_1\"\n    when\n        Boolean()\n        Integer()\n    then\n        System.out.println(\"RG_1\");end\n"});
        kieContainer.updateToVersion(releaseId2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
    }

    @Test
    public void testSegmentSplitAfterMerge() {
        String drl1A = "package org.hightea.a\nrule \"RG_1\"\n    when\n        Boolean()\n        String()\n    then\nend\n";
        String drl2A = "package org.hightea.b\nrule \"RG_2\"\n    when\n        Boolean()\n        Integer()\n    then\nend\n";
        String drl2B = "package org.hightea.b\nrule \"RG_2\"\n    when\n        Boolean()\n        Integer()\n    then\n\t\t //Simple comment to mark the rule as modified\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.hightea.a\nrule \"RG_1\"\n    when\n        Boolean()\n        String()\n    then\nend\n", "package org.hightea.b\nrule \"RG_2\"\n    when\n        Boolean()\n        Integer()\n    then\nend\n"});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieSession kieSession = kieContainer.newKieSession();
        kieSession.insert((Object)"A Test String");
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.hightea.a\nrule \"RG_1\"\n    when\n        Boolean()\n        String()\n    then\nend\n", "package org.hightea.b\nrule \"RG_2\"\n    when\n        Boolean()\n        Integer()\n    then\n\t\t //Simple comment to mark the rule as modified\nend\n"});
        kieContainer.updateToVersion(releaseId2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
    }

    @Test
    public void testAddFieldToDeclaredType() {
        String declares1 = "declare Address\n   streetName : String\n   city : String\nend";
        String declares2 = "declare Address\n   streetName : String\n   city : String\n   flg: String\nend";
        String rules1 = "rule R when\n    a : Address( city == \"Antibes\" )\nthen\n    a.setStreetName(\"Av. Jean Medecin\");\nend";
        String rules2 = "rule R when\n    a : Address( city == \" Paris \", flg == \"yes\" )\nthen\n    a.setStreetName(\" Champs Elisees \");\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare Address\n   streetName : String\n   city : String\nend", "rule R when\n    a : Address( city == \"Antibes\" )\nthen\n    a.setStreetName(\"Av. Jean Medecin\");\nend"});
        KieContainer kieContainer = ks.newKieContainer(releaseId1);
        KieSession kieSession = kieContainer.newKieSession();
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare Address\n   streetName : String\n   city : String\n   flg: String\nend", "rule R when\n    a : Address( city == \" Paris \", flg == \"yes\" )\nthen\n    a.setStreetName(\" Champs Elisees \");\nend"});
        kieContainer.updateToVersion(releaseId2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
    }

    @Test
    public void testIncremenatalCompilationAddingFieldToDeclaredType() {
        String declares1 = "declare Address\n   streetName : String\n   city : String\nend";
        String declares2 = "declare Address\n   streetName : String\n   city : String\n   flg: String\nend";
        String rules1 = "rule R when\n    a : Address( city == \"Antibes\" )\nthen\n    a.setStreetName(\"Av. Jean Medecin\");\nend";
        String rules2 = "rule R when\n    a : Address( city == \" Paris \" )\nthen\n    a.setStreetName(\" Champs Elisees \");\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "foo", "1.0-SNAPSHOT");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("declare Address\n   streetName : String\n   city : String\nend")).setResourceType(ResourceType.DRL).setSourcePath("declares.drl"));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("rule R when\n    a : Address( city == \"Antibes\" )\nthen\n    a.setStreetName(\"Av. Jean Medecin\");\nend")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        ksession.fireAllRules();
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("declare Address\n   streetName : String\n   city : String\n   flg: String\nend")).setResourceType(ResourceType.DRL).setSourcePath("declares.drl"));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("rule R when\n    a : Address( city == \" Paris \" )\nthen\n    a.setStreetName(\" Champs Elisees \");\nend")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        IncrementalResults results = ((InternalKieBuilder)kieBuilder).incrementalBuild();
        System.out.println(results.getAddedMessages());
        Assertions.assertThat((int)results.getAddedMessages().size()).isEqualTo(0);
        Results updateResults = kc.updateToVersion(id);
        Assertions.assertThat((int)updateResults.getMessages().size()).isEqualTo(0);
    }

    @Test
    public void testUnchangedAccumulate() {
        String drl1 = "import java.util.*;\nrule B\nwhen\n    $eventCodeDistinctMois : Integer( intValue>0 ) from accumulate ( String( $id : this ),\n                                                                init( Set set = new HashSet(); ),\n                                                                action( set.add($id); ),\n                                                                reverse( set.remove($id); ),\n                                                                result( set.size()) )\nthen\nend";
        String drl2 = "rule C when then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.*;\nrule B\nwhen\n    $eventCodeDistinctMois : Integer( intValue>0 ) from accumulate ( String( $id : this ),\n                                                                init( Set set = new HashSet(); ),\n                                                                action( set.add($id); ),\n                                                                reverse( set.remove($id); ),\n                                                                result( set.size()) )\nthen\nend", "rule C when then end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        FactHandle fh = ksession.insert((Object)"1");
        ksession.fireAllRules();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.*;\nrule B\nwhen\n    $eventCodeDistinctMois : Integer( intValue>0 ) from accumulate ( String( $id : this ),\n                                                                init( Set set = new HashSet(); ),\n                                                                action( set.add($id); ),\n                                                                reverse( set.remove($id); ),\n                                                                result( set.size()) )\nthen\nend"});
        kc.updateToVersion(releaseId2);
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import java.util.*;\nrule B\nwhen\n    $eventCodeDistinctMois : Integer( intValue>0 ) from accumulate ( String( $id : this ),\n                                                                init( Set set = new HashSet(); ),\n                                                                action( set.add($id); ),\n                                                                reverse( set.remove($id); ),\n                                                                result( set.size()) )\nthen\nend", "rule C when then end\n"});
        kc.updateToVersion(releaseId3);
        ksession.delete(fh);
        ksession.fireAllRules();
        ksession.insert((Object)"2");
        ksession.fireAllRules();
    }

    @Test
    public void testGlobalRemovedFromOneDrl() {
        String drlAWithGlobal = "package org.x.a\nglobal Boolean globalBool\n";
        String drlANoGlobal = "package org.x.a\n";
        String drlBWithGlobal = "package org.x.b\nglobal Boolean globalBool\n";
        String drlBNoGlobal = "package org.x.b\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.x.a\nglobal Boolean globalBool\n", "package org.x.b\nglobal Boolean globalBool\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.setGlobal("globalBool", (Object)Boolean.FALSE);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.x.a\n", "package org.x.b\nglobal Boolean globalBool\n"});
        kc.updateToVersion(releaseId2);
        ksession.setGlobal("globalBool", (Object)Boolean.TRUE);
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.x.a\n", "package org.x.b\n"});
        kc.updateToVersion(releaseId3);
        try {
            ksession.setGlobal("globalBool", (Object)Boolean.TRUE);
            Assertions.fail((String)"the global should be no longer present");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalRemovedAndAdded() {
        String drlAWithGlobal = "package org.x.a\nglobal Boolean globalBool\n";
        String drlANoGlobal = "package org.x.a\n";
        String drlBWithGlobal = "package org.x.b\nglobal Boolean globalBool\n";
        String drlBNoGlobal = "package org.x.b\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.x.a\nglobal Boolean globalBool\n", "package org.x.b\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.setGlobal("globalBool", (Object)Boolean.FALSE);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.x.a\n", "package org.x.b\nglobal Boolean globalBool\n"});
        kc.updateToVersion(releaseId2);
        ksession.setGlobal("globalBool", (Object)Boolean.TRUE);
    }

    @Test
    public void testRuleRemovalAndEval() {
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\n   eval($m != null)\nthen\n   System.out.println( \"Hello R1\" );\nend\n";
        String drl2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2 when\n   $m : Message()\n   eval($m != null)\nthen\n   System.out.println( \"Hello R2\" );\nend\n";
        String drl3 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R3 when\n   $m : Message()\n   eval($m != null)\nthen\n   System.out.println( \"Hello R3\" );\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        KieFileSystem kfs1 = ks.newKieFileSystem();
        kfs1.write("src/main/resources/rules/Sample1.drl", drl1);
        ReleaseId releaseId1 = ks.newReleaseId("com.sample", "my-sample-a", "1.0.0");
        kfs1.generateAndWritePomXML(releaseId1);
        kfs1.writeKModuleXML(kproj);
        ks.newKieBuilder(kfs1).buildAll(DrlProject.class);
        KieFileSystem kfs2 = ks.newKieFileSystem();
        kfs2.write("src/main/resources/rules/Sample2.drl", drl2);
        ReleaseId releaseId2 = ks.newReleaseId("com.sample", "my-sample-a", "2.0.0");
        kfs2.generateAndWritePomXML(releaseId2);
        kfs2.writeKModuleXML(kproj);
        ks.newKieBuilder(kfs2).buildAll(DrlProject.class);
        KieFileSystem kfs3 = ks.newKieFileSystem();
        kfs3.write("src/main/resources/rules/Sample3.drl", drl3);
        ReleaseId releaseId3 = ks.newReleaseId("com.sample", "my-sample-a", "3.0.0");
        kfs3.generateAndWritePomXML(releaseId3);
        kfs3.writeKModuleXML(kproj);
        ks.newKieBuilder(kfs3).buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        kc.updateToVersion(releaseId2);
        kc.updateToVersion(releaseId3);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testGetFactTypeOnIncrementalUpdateWithNestedFacts() throws Exception {
        String drl1 = "package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\") then end\n";
        String drl2 = "package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\n   y : int\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\", nested.y == 42) then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\") then end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kbase = kc.getKieBase();
        FactType ftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "Message");
        Assertions.assertThat((Object)ftype.getField("text")).isNotNull();
        Object fact = ftype.newInstance();
        ftype.set(fact, "text", (Object)"What's the problem?");
        FactType nestedftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "MyNestedFact");
        Assertions.assertThat((Object)nestedftype.getField("x")).isNotNull();
        Object nestedfact = nestedftype.newInstance();
        ftype.set(fact, "nested", nestedfact);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\n   y : int\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\", nested.y == 42) then end\n"});
        kc.updateToVersion(releaseId2);
        kbase = kc.getKieBase();
        ftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "Message");
        Assertions.assertThat((Object)ftype.getField("text")).isNotNull();
        fact = ftype.newInstance();
        ftype.set(fact, "text", (Object)"What's the problem?");
        nestedftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "MyNestedFact");
        Assertions.assertThat((Object)nestedftype.getField("x")).isNotNull();
        Assertions.assertThat((Object)nestedftype.getField("y")).isNotNull();
        nestedfact = nestedftype.newInstance();
        nestedftype.set(nestedfact, "y", (Object)42);
        ftype.set(fact, "nested", nestedfact);
    }

    @Test
    public void testKJarUpgradeWithNewRule() throws Exception {
        String drl1a = "package org.drools.incremental\nglobal java.util.List list\nrule R1 when\n   $s : String()\nthen\n   list.add(\"xxx: \" + $s);end\n";
        String drl1b = "package org.drools.incremental\nglobal java.util.List list\nrule R1 when\n   $s : String()\nthen\n   list.add(\"yyy: \" + $s);end\nrule R2 when\n   $i : Integer()\nthen\n   list.add(\"\" + $i);end\n";
        KieServices ks = KieServices.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1a});
        KieContainer kc = ks.newKieContainer(releaseId1);
        ArrayList list = new ArrayList();
        KieSession session = kc.getKieBase().newKieSession();
        session.setGlobal("list", list);
        session.insert((Object)"test");
        session.insert((Object)1);
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("xxx: test");
        list.clear();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1b});
        kc.updateToVersion(releaseId2);
        session = kc.getKieBase().newKieSession();
        session.setGlobal("list", list);
        session.insert((Object)"test");
        session.insert((Object)1);
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("yyy: test");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("1");
    }

    @Test
    public void testKJarUpgradeWithNewRuleAndStatelessSession() throws Exception {
        String drl1a = "package org.drools.incremental\nglobal java.util.List list\nrule R1 when\n   $s : String()\nthen\n   list.add(\"xxx: \" + $s);end\n";
        String drl1b = "package org.drools.incremental\nglobal java.util.List list\nrule R1 when\n   $s : String()\nthen\n   list.add(\"yyy: \" + $s);end\nrule R2 when\n   $i : Integer()\nthen\n   list.add(\"\" + $i);end\n";
        KieServices ks = KieServices.get();
        KieCommands commands = ks.getCommands();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1a});
        KieContainer kc = ks.newKieContainer(releaseId1);
        StatelessKieSession session = kc.getKieBase().newStatelessKieSession();
        ArrayList list = new ArrayList();
        session.execute((Command)commands.newBatchExecution(Arrays.asList(commands.newSetGlobal("list", list), commands.newInsert((Object)"test"), commands.newInsert((Object)1), commands.newFireAllRules())));
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("xxx: test");
        list.clear();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1b});
        kc.updateToVersion(releaseId2);
        session = kc.getKieBase().newStatelessKieSession();
        session.execute((Command)commands.newBatchExecution(Arrays.asList(commands.newSetGlobal("list", list), commands.newInsert((Object)"test"), commands.newInsert((Object)1), commands.newFireAllRules())));
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("yyy: test");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("1");
    }

    @Test
    public void testArgumentRedefinitionInStaticInvocation() {
        String ARG1 = "package org.test;    public class MyArg {\n        private String value;\n    }";
        String ARG2 = "package org.test;    public class MyArg {\n        private int value;\n    }";
        String FUNC = "package org.test;    public class MyFunc {\n        private String value;\n        public static void func(MyArg arg) {}\n    }";
        String FUNC2 = "package org.test;    public class MyFunc {\n        private int value;\n        public static void func(MyArg arg) {}\n    }";
        String DRL1 = "package org.test;\nrule R dialect\"mvel\" when\n        $arg : MyArg()\n    then\n        MyFunc.func($arg);end";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        ReleaseId id = ks.newReleaseId("org.test", "myTest", "1.0.0");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kfs.generateAndWritePomXML(id);
        kfs.write("src/main/java/org/test/MyArg.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyArg {\n        private String value;\n    }")));
        kfs.write("src/main/java/org/test/MyFunc.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyFunc {\n        private String value;\n        public static void func(MyArg arg) {}\n    }")));
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\nrule R dialect\"mvel\" when\n        $arg : MyArg()\n    then\n        MyFunc.func($arg);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kieBuilder.buildAll(DrlProject.class);
        KieContainer kc = ks.newKieContainer(id);
        KieSession ksession = kc.newKieSession();
        ReleaseId id2 = ks.newReleaseId("org.test", "myTest", "2.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id2);
        kfs2.write("src/main/java/org/test/MyArg.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyArg {\n        private int value;\n    }")));
        kfs2.write("src/main/java/org/test/MyFunc.java", ks.getResources().newReaderResource((Reader)new StringReader("package org.test;    public class MyFunc {\n        private int value;\n        public static void func(MyArg arg) {}\n    }")));
        kfs2.write(ks.getResources().newReaderResource((Reader)new StringReader("package org.test;\nrule R dialect\"mvel\" when\n        $arg : MyArg()\n    then\n        MyFunc.func($arg);end")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        kieBuilder2.buildAll(DrlProject.class);
        Results updateResults = kc.updateToVersion(id2);
        Assertions.assertThat((boolean)updateResults.hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
    }

    @Test
    public void testRemoveRulesWithLogicalAssertions() {
        String DRL1 = "declare MyInt\n    val : Integer @key\nend\n\nrule R1 when\n    String(this == \"I'm active\")\n    $i : Integer(intValue == 1)\nthen\n    insertLogical(new MyInt($i));\nend\n\nrule R2 when\n    String()\n    $i : Integer(intValue == 2)\nthen\n    insertLogical(new MyInt($i));\nend\n\nrule R3 when\n    String(this == \"I'm active\")\n    $i : Integer(intValue == 3)\nthen\n    insertLogical(new MyInt($i));\nend";
        KieServices ks = KieServices.get();
        ReleaseId id = ks.newReleaseId("org.test", "logical", "1.0.0");
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(id);
        kfs.writeKModuleXML(kproj);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("declare MyInt\n    val : Integer @key\nend\n\nrule R1 when\n    String(this == \"I'm active\")\n    $i : Integer(intValue == 1)\nthen\n    insertLogical(new MyInt($i));\nend\n\nrule R2 when\n    String()\n    $i : Integer(intValue == 2)\nthen\n    insertLogical(new MyInt($i));\nend\n\nrule R3 when\n    String(this == \"I'm active\")\n    $i : Integer(intValue == 3)\nthen\n    insertLogical(new MyInt($i));\nend")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll(DrlProject.class);
        KieModule kieModule = kieBuilder.getKieModule();
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        KieSession kieSession = kieContainer.newKieSession();
        kieSession.insert((Object)"I'm active");
        kieSession.insert((Object)1);
        kieSession.insert((Object)2);
        kieSession.insert((Object)3);
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(4);
        kieSession.fireAllRules();
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(7);
        ReleaseId id2 = ks.newReleaseId("org.test", "logical", "2.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id2);
        kfs2.writeKModuleXML(kproj);
        kieBuilder = ks.newKieBuilder(kfs2);
        kieBuilder.buildAll(DrlProject.class);
        kieModule = kieBuilder.getKieModule();
        kieContainer.updateToVersion(id2);
        kieSession.fireAllRules();
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(4);
    }

    @Test
    public void testRemoveRulesWithAccumulateAndLogicalAssertions() {
        String DRL1 = "rule R1 when\n    accumulate(String($l : length > 1); $s : sum($l))\nthen\n    insertLogical($s);\nend";
        KieServices ks = KieServices.get();
        ReleaseId id = ks.newReleaseId("org.test", "logical", "1.0.0");
        KieModuleModel model = ks.newKieModuleModel();
        model.newKieBaseModel("kbase").newKieSessionModel("ksession").setDefault(true);
        String kproj = model.toXML();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(id);
        kfs.writeKModuleXML(kproj);
        kfs.write(ks.getResources().newReaderResource((Reader)new StringReader("rule R1 when\n    accumulate(String($l : length > 1); $s : sum($l))\nthen\n    insertLogical($s);\nend")).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll(DrlProject.class);
        KieModule kieModule = kieBuilder.getKieModule();
        KieContainer kieContainer = ks.newKieContainer(kieModule.getReleaseId());
        KieSession kieSession = kieContainer.newKieSession();
        kieSession.insert((Object)"test");
        kieSession.insert((Object)"test2");
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(2);
        kieSession.fireAllRules();
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(3);
        Assertions.assertThat(kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)).iterator().next()).isEqualTo((Object)9);
        ReleaseId id2 = ks.newReleaseId("org.test", "logical", "2.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem();
        KieBuilder kieBuilder2 = ks.newKieBuilder(kfs2);
        kfs2.generateAndWritePomXML(id2);
        kfs2.writeKModuleXML(kproj);
        kieBuilder = ks.newKieBuilder(kfs2);
        kieBuilder.buildAll(DrlProject.class);
        kieModule = kieBuilder.getKieModule();
        kieContainer.updateToVersion(id2);
        kieSession.fireAllRules();
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(2);
        Assertions.assertThat((boolean)kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)).isEmpty()).isTrue();
    }

    @Test
    public void testRemoveRulesWithSubnetworkAndOR() throws Exception {
        this.checkRemoveRulesWithSubnetworkAndOR(false);
    }

    @Test
    public void testRemoveRulesWithSubnetworkAndORWithDispose() throws Exception {
        this.checkRemoveRulesWithSubnetworkAndOR(true);
    }

    public void checkRemoveRulesWithSubnetworkAndOR(boolean dispose) throws Exception {
        String DRL1 = " package org.drools.compiler;\n declare  B  \n     day : int  \n end  \n declare  D \n end \n declare  O  \n     hash : int  \n end \n declare  F  \n     id : int \n end \n rule R1 \n when \n    D() \n    O( $hash: hash != 0 ) \n    forall( \n    $f : F( )  \n    ) \n    ( \n        B( day in (1)  ) \n        or \n        B( day == 5 ) \n    ) \n then\n end\n rule R2 \n when \n    D() \n    O() \n then\n end";
        String DRL2 = " package org.drools.compiler;\n declare  B  \n     day : int  \n end  \n declare  D \n end \n declare  O  \n     hash : int  \n end \n declare  F  \n     id : int \n end \n rule R2 \n when \n    D() \n    O() \n then\n end";
        KieServices kieService = KieServices.Factory.get();
        KieFileSystem kfs = kieService.newKieFileSystem();
        ReleaseId rid = kieService.newReleaseId("org.drools.test", "npe-reproducer", "1.0.0");
        kfs.generateAndWritePomXML(rid);
        kfs.write(kieService.getResources().newReaderResource((Reader)new StringReader(DRL1)).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        KieBuilder kb = kieService.newKieBuilder(kfs);
        kb.buildAll();
        if (!kb.getResults().getMessages().isEmpty()) {
            throw new RuntimeException("KieBase build failed:\n" + kb.getResults().toString());
        }
        KieModule kModule = kb.getKieModule();
        KieContainer kc = kieService.newKieContainer(kModule.getReleaseId());
        KieBase kbase = kc.getKieBase();
        KieSession ks = kbase.newKieSession();
        FactType D = kbase.getFactType("org.drools.compiler", "D");
        Object d = D.newInstance();
        FactType O = kbase.getFactType("org.drools.compiler", "O");
        Object o = O.newInstance();
        O.set(o, "hash", (Object)1);
        ks.insert(d);
        ks.insert(o);
        Assertions.assertThat((int)ks.fireAllRules()).isEqualTo(1);
        if (dispose) {
            ks.dispose();
        }
        KieFileSystem kfs2 = kieService.newKieFileSystem();
        ReleaseId rid2 = kieService.newReleaseId("org.drools.test", "npe-reproducer", "2.0.0");
        kfs2.generateAndWritePomXML(rid2);
        kfs2.write(kieService.getResources().newReaderResource((Reader)new StringReader(DRL2)).setResourceType(ResourceType.DRL).setSourcePath("rules.drl"));
        KieBuilder kb2 = kieService.newKieBuilder(kfs2);
        kb2.buildAll();
        if (!kb2.getResults().getMessages().isEmpty()) {
            throw new RuntimeException("KieBase build failed:\n" + kb2.getResults().toString());
        }
        KieModule kModule2 = kb2.getKieModule();
        kc.updateToVersion(kModule2.getReleaseId());
        KieBase kbase2 = kc.getKieBase();
        KieSession ks2 = kbase2.newKieSession();
        FactType D2 = kbase2.getFactType("org.drools.compiler", "D");
        Object d2 = D2.newInstance();
        FactType O2 = kbase2.getFactType("org.drools.compiler", "O");
        Object o2 = O2.newInstance();
        O2.set(o2, "hash", (Object)1);
        ks2.insert(d2);
        ks2.insert(o2);
        Assertions.assertThat((int)ks2.fireAllRules()).isEqualTo(1);
        ks2.dispose();
    }

    @Test
    public void testRemoveAndAddRules() throws Exception {
        this.checkRemoveAndAddRules(false);
    }

    @Test
    public void testRemoveAndAddRulesWithDispose() throws Exception {
        this.checkRemoveAndAddRules(true);
    }

    public void checkRemoveAndAddRules(boolean dispose) throws Exception {
        String DRL1 = "package org.kie.test\nglobal java.util.List list\nrule R1 when then\n  list.add( drools.getRule().getName() );\nend\nrule R2 when then\n  list.add( drools.getRule().getName() );\nend\n";
        String DRL2 = "package org.kie.test\nglobal java.util.List list\nrule R2 when then\n  list.add( drools.getRule().getName() );\nend\nrule R3 when then\n  list.add( drools.getRule().getName() );\nend\n";
        KieServices kieService = KieServices.Factory.get();
        KieFileSystem kfs = kieService.newKieFileSystem();
        ReleaseId rid = kieService.newReleaseId("org.drools.test", "empty-rules", "1.0.0");
        kfs.generateAndWritePomXML(rid);
        kfs.write(kieService.getResources().newReaderResource((Reader)new StringReader(DRL1)).setResourceType(ResourceType.DRL).setSourcePath("org/kie/test/rules.drl"));
        KieBuilder kb = kieService.newKieBuilder(kfs);
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            kb.buildAll((Class)this.kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        } else {
            kb.buildAll();
        }
        if (!kb.getResults().getMessages().isEmpty()) {
            throw new RuntimeException("KieBase build failed:\n" + kb.getResults().toString());
        }
        KieModule kModule = kb.getKieModule();
        KieContainer kc = kieService.newKieContainer(kModule.getReleaseId());
        KieBase kbase = kc.getKieBase();
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        Assertions.assertThat((int)ks.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("R1", "R2"))).isTrue();
        if (dispose) {
            ks.dispose();
        }
        KieFileSystem kfs2 = kieService.newKieFileSystem();
        ReleaseId rid2 = kieService.newReleaseId("org.drools.test", "empty-rules", "2.0.0");
        kfs2.generateAndWritePomXML(rid2);
        kfs2.write(kieService.getResources().newReaderResource((Reader)new StringReader(DRL2)).setResourceType(ResourceType.DRL).setSourcePath("org/kie/test/rules.drl"));
        KieBuilder kb2 = kieService.newKieBuilder(kfs2);
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            kb2.buildAll((Class)this.kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        } else {
            kb2.buildAll();
        }
        if (!kb2.getResults().getMessages().isEmpty()) {
            throw new RuntimeException("KieBase build failed:\n" + kb2.getResults().toString());
        }
        KieModule kModule2 = kb2.getKieModule();
        kc.updateToVersion(kModule2.getReleaseId());
        KieBase kbase2 = kc.getKieBase();
        KieSession ks2 = kbase2.newKieSession();
        ArrayList list2 = new ArrayList();
        ks2.setGlobal("list", list2);
        Assertions.assertThat((int)ks2.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)list2.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list2.containsAll(Arrays.asList("R2", "R3"))).isTrue();
    }

    @Test
    public void testKJarUpgradeWithSerializedSession() {
        KieSession ksession2;
        String drl1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R1 when\n   $m : Message()\nthen\nend\n";
        String drl2_1 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_1 when\n   $m : Message( message == \"Hi Universe\" )\nthen\nend\n";
        String drl2_2 = "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nrule R2_2 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_1});
        KieContainer kc1 = ks.newKieContainer(releaseId1);
        KieSession ksession1 = kc1.newKieSession();
        ksession1.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession1.fireAllRules()).isEqualTo(1);
        KieBase kbase = ksession1.getKieBase();
        KieMarshallers marshallers = ks.getMarshallers();
        Marshaller marshaller1 = marshallers.newMarshaller(kc1.getKieBase());
        byte[] marshalledSession = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            marshaller1.marshall((OutputStream)baos, ksession1);
            marshalledSession = baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        KieContainer kc2 = ks.newKieContainer(releaseId1);
        Marshaller marshaller2 = marshallers.newMarshaller(kc2.getKieBase());
        try (ByteArrayInputStream bais = new ByteArrayInputStream(marshalledSession);){
            ksession2 = marshaller2.unmarshall((InputStream)bais);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2_2});
        kc2.updateToVersion(releaseId2);
        ksession2.insert((Object)new Message("Hello World"));
        Assertions.assertThat((int)ksession2.fireAllRules()).isEqualTo(3);
    }

    @Test
    public void testGetFactTypeOnIncrementalUpdateWithNestedFactsRulesFired() throws Exception {
        String drl1 = "package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\") then end\n";
        String drl2 = "package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\n   y : int\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\", nested.y == 42) then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.1");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\") then end\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kbase = kc.getKieBase();
        FactType ftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "Message");
        Assertions.assertThat((Object)ftype.getField("text")).isNotNull();
        Object fact = ftype.newInstance();
        ftype.set(fact, "text", (Object)"What's the problem?");
        FactType nestedftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "MyNestedFact");
        Assertions.assertThat((Object)nestedftype.getField("x")).isNotNull();
        Object nestedfact = nestedftype.newInstance();
        ftype.set(fact, "nested", nestedfact);
        KieSession session = kbase.newKieSession();
        session.insert(fact);
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
        session.dispose();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.2");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.example.api.kiemodulemodel\ndeclare MyNestedFact\n   x : String\n   y : int\nend\ndeclare Message\n   text : String\n   nested : MyNestedFact\nend\n\nrule R when Message(text == \"What's the problem?\", nested.y == 42) then end\n"});
        kc.updateToVersion(releaseId2);
        kbase = kc.getKieBase();
        ftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "Message");
        Assertions.assertThat((Object)ftype.getField("text")).isNotNull();
        fact = ftype.newInstance();
        ftype.set(fact, "text", (Object)"What's the problem?");
        nestedftype = kbase.getFactType("org.drools.example.api.kiemodulemodel", "MyNestedFact");
        Assertions.assertThat((Object)nestedftype.getField("x")).isNotNull();
        Assertions.assertThat((Object)nestedftype.getField("y")).isNotNull();
        nestedfact = nestedftype.newInstance();
        nestedftype.set(nestedfact, "y", (Object)42);
        ftype.set(fact, "nested", nestedfact);
        session = kbase.newKieSession();
        session.insert(fact);
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(1);
        session.dispose();
    }

    @Test
    public void testDecisionTable() {
        String[] results2;
        String[] results;
        KieServices ks = KieServices.get();
        KieResources kr = ks.getResources();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-dtable", "1.1.1");
        this.buildDTableProject(ks, kr, releaseId1, "CanDrinkAndDrive.drl.xls");
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession sessionDtable = kc.newKieSession("dtable");
        Result result = new Result();
        FactHandle fhResult = sessionDtable.insert((Object)result);
        sessionDtable.insert((Object)new Person("Mario", 45));
        sessionDtable.fireAllRules();
        sessionDtable.delete(fhResult);
        for (String r : results = new String[]{"Mario can drink", "Mario can drive"}) {
            Assertions.assertThat((boolean)result.toString().contains(r)).isTrue();
        }
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-dtable", "1.1.2");
        this.buildDTableProject(ks, kr, releaseId2, "CanDrinkAndDrive2.drl.xls");
        kc.updateToVersion(releaseId2);
        result = new Result();
        sessionDtable.insert((Object)result);
        sessionDtable.fireAllRules();
        for (String r : results2 = new String[]{"Mario can drink", "Mario can vote"}) {
            Assertions.assertThat((boolean)result.toString().contains(r)).isTrue();
        }
    }

    private void buildDTableProject(KieServices ks, KieResources kr, ReleaseId releaseId, String dtableFile) {
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls", kr.newFileSystemResource("src/test/resources/data/" + dtableFile)).write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls.properties", "sheets=Sheet1,Sheet2");
        kfs.generateAndWritePomXML(releaseId);
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("dtblaleKB").addPackage("org.drools.simple.candrink").newKieSessionModel("dtable");
        kfs.writeKModuleXML(kproj.toXML());
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            ks.newKieBuilder(kfs).buildAll((Class)this.kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        } else {
            ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        }
    }

    @Test
    public void testIncrementalCompilationFromEmptyProject() {
        String drl1 = "rule \"test1\" when then end\n";
        String drl2 = "rule \"test2\" extends \"test1\" when then end\nrule \"test3\" extends \"test1\" when then end\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r1.drl", "rule \"test1\" when then end\n");
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r2.drl", "rule \"test2\" extends \"test1\" when then end\nrule \"test3\" extends \"test1\" when then end\n");
        IncrementalResults addResults2 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assertions.assertThat((int)addResults2.getAddedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testIncrementalCompilationFromEmptyProject2() {
        String drl1 = "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId id = ks.newReleaseId("org.test", "foo", "1.0-SNAPSHOT");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(id);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r1.drl", "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when then end\n");
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(0);
        KieContainer kieContainer = ks.newKieContainer(id);
        KieSession kieSession = kieContainer.newKieSession();
        Assertions.assertThat((int)kieSession.getKieBase().getKiePackages().size()).isEqualTo(1);
        Assertions.assertThat((Object)kieSession.getKieBase().getKiePackage("org.drools.test")).isNotNull();
        kieSession.setGlobal("list", new ArrayList());
        Collection globals = kieSession.getGlobals().getGlobalKeys();
        Assertions.assertThat((int)globals.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)globals.iterator().next())).isEqualTo("list");
    }

    @Test
    public void testIncrementalCompilationWithErrorFromEmptyProject() {
        String drl_KO = "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when Strinf() then end\n";
        String drl_OK = "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when String() then end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId id = ks.newReleaseId("org.test", "foo", "1.0-SNAPSHOT");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(id);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        kfs.write("src/main/resources/r1.drl", "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when Strinf() then end\n");
        IncrementalResults addResults1 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl"}).build();
        Assertions.assertThat((int)addResults1.getAddedMessages().size()).isEqualTo(1);
        Assertions.assertThat((int)addResults1.getRemovedMessages().size()).isEqualTo(0);
        kfs.write("src/main/resources/r1.drl", "package org.drools.test;\nglobal java.util.List list;\nrule \"test1\" when String() then end\n");
        IncrementalResults addResults2 = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r1.drl"}).build();
        Assertions.assertThat((int)addResults2.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)addResults2.getRemovedMessages().size()).isEqualTo(1);
    }

    @Test
    public void testUnusedDeclaredTypeUpdate() throws Exception {
        String drl1 = "package org.example.rules \n\nimport org.example.facts.*;\n\nrule \"rule updating ReferencedType\"\nwhen\n    $x : ReferencedType( str == \"bar\" )  \nthen\n    modify($x) { setStr(\"foo\") };\nend\n";
        String drl2_1 = "package org.example.facts \n\ndeclare  ReferencedType \n    str : String\nend\ndeclare  UnreferencedType \n    x : int\nend\n\n";
        String drl2_2 = "package org.example.facts \n\ndeclare  ReferencedType \n    str : String\nend\ndeclare  UnreferencedType \n    x : int\n    y : String\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.example.rules \n\nimport org.example.facts.*;\n\nrule \"rule updating ReferencedType\"\nwhen\n    $x : ReferencedType( str == \"bar\" )  \nthen\n    modify($x) { setStr(\"foo\") };\nend\n", "package org.example.facts \n\ndeclare  ReferencedType \n    str : String\nend\ndeclare  UnreferencedType \n    x : int\nend\n\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        KieBase kiebase = ksession.getKieBase();
        FactType referencedType = kiebase.getFactType("org.example.facts", "ReferencedType");
        Object instance = referencedType.newInstance();
        referencedType.set(instance, "str", (Object)"bar");
        Assertions.assertThat((Object)referencedType.get(instance, "str")).isEqualTo((Object)"bar");
        ksession.insert(instance);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.example.rules \n\nimport org.example.facts.*;\n\nrule \"rule updating ReferencedType\"\nwhen\n    $x : ReferencedType( str == \"bar\" )  \nthen\n    modify($x) { setStr(\"foo\") };\nend\n", "package org.example.facts \n\ndeclare  ReferencedType \n    str : String\nend\ndeclare  UnreferencedType \n    x : int\n    y : String\nend\n"});
        kc.updateToVersion(releaseId2);
        KieBase kiebase2 = ksession.getKieBase();
        FactType referencedType2 = kiebase2.getFactType("org.example.facts", "ReferencedType");
        Object instance2 = referencedType2.newInstance();
        referencedType2.set(instance2, "str", (Object)"bar");
        Assertions.assertThat((Object)referencedType2.get(instance2, "str")).isEqualTo((Object)"bar");
        ksession.insert(instance2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testConsecutiveDeclaredTypeUpdates() throws Exception {
        String drl1 = "package org.example.rules \n\nimport org.example.facts.*\nrule \"1\"\nwhen\n  FactType1(x == 42)\n  FactType2(y == 43)\nthen\nend\n";
        String types1 = "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n";
        String types2 = "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \n    z : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n";
        String types3 = "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \n    z : int  \n    w : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.example.rules \n\nimport org.example.facts.*\nrule \"1\"\nwhen\n  FactType1(x == 42)\n  FactType2(y == 43)\nthen\nend\n", "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.example.rules \n\nimport org.example.facts.*\nrule \"1\"\nwhen\n  FactType1(x == 42)\n  FactType2(y == 43)\nthen\nend\n", "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \n    z : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n"});
        kc.updateToVersion(releaseId2);
        ksession = kc.newKieSession();
        ReleaseId releaseId3 = ks.newReleaseId("org.kie", "test-upgrade", "1.2.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId3, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.example.rules \n\nimport org.example.facts.*\nrule \"1\"\nwhen\n  FactType1(x == 42)\n  FactType2(y == 43)\nthen\nend\n", "package org.example.facts \n\ndeclare  FactType1 \n    x : int  \n    z : int  \n    w : int  \nend\n\ndeclare  FactType2 \n    y : int  \nend\n"});
        kc.updateToVersion(releaseId3);
        ksession = kc.newKieSession();
    }

    @Test
    public void testUnlinkedPathUpdate() throws Exception {
        String drl1 = "rule R1 when\n  Boolean()\n  String()\nthen\nend\n";
        String drl2a = "rule R2 when\n  Boolean()\n  Integer()\nthen\n  System.out.println(\"before update\");\nend\n";
        String drl2b = "rule R2 when\n  Boolean()\n  Integer()\nthen\n  System.out.println(\"after update\");\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n  Boolean()\n  String()\nthen\nend\n", "rule R2 when\n  Boolean()\n  Integer()\nthen\n  System.out.println(\"before update\");\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        ksession.insert((Object)"A string");
        ksession.insert((Object)12);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n  Boolean()\n  String()\nthen\nend\n", "rule R2 when\n  Boolean()\n  Integer()\nthen\n  System.out.println(\"after update\");\nend\n"});
        kc.updateToVersion(releaseId2);
        ksession.insert((Object)true);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testUpdateToVersionWithFireUntilHaltWithSlowRHS() throws Exception {
        CountDownLatch done;
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getTestRuleForFireUntilHaltSlow(0)});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession kieSession = kc.newKieSession();
        DebugList list = new DebugList();
        kieSession.setGlobal("list", list);
        kieSession.insert((Object)new Message("X"));
        list.done = done = new CountDownLatch(1);
        try {
            new Thread(() -> ((KieSession)kieSession).fireUntilHalt()).start();
            done.await();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)list.get(0))).isEqualTo("0 - X");
            list.clear();
            for (int i = 1; i < 3; ++i) {
                list.done = done = new CountDownLatch(1);
                ReleaseId releaseIdI = ks.newReleaseId("org.kie", "test-fireUntilHalt", "1." + i);
                KieUtil.getKieModuleFromDrls((ReleaseId)releaseIdI, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getTestRuleForFireUntilHaltSlow(i)});
                kc.updateToVersion(releaseIdI);
                done.await();
                Assertions.assertThat((int)list.size()).isEqualTo(1);
                Assertions.assertThat((String)((String)list.get(0))).isEqualTo(i + " - X");
                list.clear();
            }
        }
        finally {
            kieSession.halt();
        }
    }

    private String getTestRuleForFireUntilHaltSlow(int i) {
        return "package org.drools.compiler\nimport " + Message.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule Rx when\n   Message( $m : message )\nthen\n   list.add(\"" + i + " - \" + $m);\n   System.out.println(\"[\" + Thread.currentThread().getName() + \"] executed! i = " + i + "\");\n   Thread.sleep(200);\nend\n";
    }

    @Test
    public void testAddEntryPoint() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{IncrementalCompilationTest.getRule("a")});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        int objectNr = 2;
        for (int i = 0; i < objectNr; ++i) {
            ksession.getEntryPoint("a").insert((Object)("test" + i));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getEntryPoint("a").getObjects().size()).isEqualTo(objectNr);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{IncrementalCompilationTest.getRule("a", "b")});
        kc.updateToVersion(releaseId2);
        Assertions.assertThat((int)ksession.getEntryPoint("a").getObjects().size()).isEqualTo(objectNr);
    }

    private static String getRule(String ... entryPoints) {
        StringBuilder rules = new StringBuilder();
        rules.append("package com.sample\n");
        for (int i = 0; i < entryPoints.length; ++i) {
            rules.append("rule \"R" + i + "\"\nwhen\n    e : String() from entry-point \"" + entryPoints[i] + "\"\nthen\n    System.out.print(\"Test Output\");\nend\n");
        }
        return rules.toString();
    }

    @Test
    public void testRemoveSharedConstraintWithEval() throws Exception {
        String drl1 = "rule R1 when\n  String( eval(length == 4) )\nthen\nend\nrule R2 when\n  String( eval(length == 4) )\nthen\nend\n";
        String drl2 = "rule R2 when\n  String( eval(length == 4) )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-upgrade", "1.0.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R1 when\n  String( eval(length == 4) )\nthen\nend\nrule R2 when\n  String( eval(length == 4) )\nthen\nend\n"});
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieSession ksession = kc.newKieSession();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "test-upgrade", "1.1.0");
        KieUtil.getKieModuleFromDrls((ReleaseId)releaseId2, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule R2 when\n  String( eval(length == 4) )\nthen\nend\n"});
        kc.updateToVersion(releaseId2);
        ksession.insert((Object)"test");
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    public static class TypeB {
        int value;

        public TypeB(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class TypeA {
    }

    public static class BaseClass {
        String baseField;

        public String getBaseField() {
            return this.baseField;
        }

        public void setBaseField(String baseField) {
            this.baseField = baseField;
        }
    }

    public static class DebugList<T>
    extends ArrayList<T> {
        CountDownLatch done;

        @Override
        public synchronized boolean add(T t) {
            boolean result = super.add(t);
            this.done.countDown();
            return result;
        }
    }

    public static class Deployer
    implements Callable<Boolean> {
        private static final KieServices ks = KieServices.Factory.get();
        private final int i;
        private final KieBaseTestConfiguration kieBaseTestConfiguration;

        public Deployer(int i, KieBaseTestConfiguration kieBaseTestConfiguration) {
            this.i = i;
            this.kieBaseTestConfiguration = kieBaseTestConfiguration;
        }

        @Override
        public Boolean call() {
            String drl = "rule R when\n   Integer( this == " + this.i + " )\nthen\nend\n";
            ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-" + this.i, "1.0.0");
            try {
                for (int i = 0; i < 10; ++i) {
                    KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                    ks.getRepository().removeKieModule(releaseId1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public static Collection<Callable<Boolean>> getDeployer(int nr, KieBaseTestConfiguration kieBaseTestConfiguration) {
            ArrayList<Callable<Boolean>> solvers = new ArrayList<Callable<Boolean>>();
            for (int i = 0; i < nr; ++i) {
                solvers.add(new Deployer(i, kieBaseTestConfiguration));
            }
            return solvers;
        }
    }
}

