/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class ListenersTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final ReleaseId RELEASE_ID = KieServices.Factory.get().newReleaseId("org.drools.mvel.compiler.test", "listeners-test", "1.0.0");
    private static final String PACKAGE = ListenersTest.class.getPackage().getName();
    private static final String PACKAGE_PATH = PACKAGE.replaceAll("\\.", "/");
    private static final String DRL = "import java.util.Collection\nrule R1 when\n String()\nthen\nend\n";
    private KieServices ks = KieServices.Factory.get();
    private KieSession kieSession;
    private StatelessKieSession statelessKieSession;

    public ListenersTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void init() {
        ReleaseId kieModuleId = this.prepareKieModule();
        KieContainer kieContainer = this.ks.newKieContainer(kieModuleId);
        this.kieSession = kieContainer.newKieSession();
        this.statelessKieSession = kieContainer.newStatelessKieSession();
    }

    @After
    public void cleanup() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.statelessKieSession = null;
    }

    @Test
    public void testRegisterAgendaEventListenerStateful() throws Exception {
        this.kieSession.insert((Object)"test");
        this.kieSession.fireAllRules();
        this.checkThatListenerFired(this.kieSession.getAgendaEventListeners());
    }

    @Test
    public void testRegisterRuleRuntimeEventListenerStateful() throws Exception {
        this.kieSession.insert((Object)"test");
        this.kieSession.fireAllRules();
        this.checkThatListenerFired(this.kieSession.getRuleRuntimeEventListeners());
    }

    @Test
    public void testRegisterAgendaEventListenerStateless() throws Exception {
        this.statelessKieSession.execute(KieServices.Factory.get().getCommands().newInsert((Object)"test"));
        this.checkThatListenerFired(this.statelessKieSession.getAgendaEventListeners());
    }

    @Test
    public void testRegisterRuleEventListenerStateless() throws Exception {
        this.statelessKieSession.execute(KieServices.Factory.get().getCommands().newInsert((Object)"test"));
        this.checkThatListenerFired(this.statelessKieSession.getRuleRuntimeEventListeners());
    }

    private void checkThatListenerFired(Collection listeners) {
        ((AbstractBooleanAssert)Assertions.assertThat((listeners.size() >= 1 ? 1 : 0) != 0).as("Listener not registered.", new Object[0])).isTrue();
        MarkingListener listener = this.getMarkingListener(listeners);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)listener.hasFired()).as("Expected listener to fire.", new Object[0])).isTrue();
    }

    private MarkingListener getMarkingListener(Collection listeners) {
        for (Object listener : listeners) {
            if (!(listener instanceof MarkingListener)) continue;
            return (MarkingListener)listener;
        }
        throw new IllegalArgumentException("Expected at least one MarkingListener in the collection");
    }

    private ReleaseId prepareKieModule() {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel baseModel = module.newKieBaseModel("defaultKBase");
        baseModel.setDefault(true);
        baseModel.addPackage("*");
        KieSessionModel sessionModel = baseModel.newKieSessionModel("defaultKSession");
        sessionModel.setDefault(true);
        sessionModel.setType(KieSessionModel.KieSessionType.STATEFUL);
        sessionModel.newListenerModel(MarkingAgendaEventListener.class.getName(), ListenerModel.Kind.AGENDA_EVENT_LISTENER);
        sessionModel.newListenerModel(MarkingRuntimeEventListener.class.getName(), ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER);
        KieSessionModel statelessSessionModel = baseModel.newKieSessionModel("defaultStatelessKSession");
        statelessSessionModel.setDefault(true);
        statelessSessionModel.setType(KieSessionModel.KieSessionType.STATELESS);
        statelessSessionModel.newListenerModel(MarkingAgendaEventListener.class.getName(), ListenerModel.Kind.AGENDA_EVENT_LISTENER);
        statelessSessionModel.newListenerModel(MarkingRuntimeEventListener.class.getName(), ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(module.toXML());
        kfs.generateAndWritePomXML(RELEASE_ID);
        kfs.write("src/main/resources/" + PACKAGE_PATH + "/test.drl", ResourceFactory.newByteArrayResource((byte[])DRL.getBytes()));
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        ((AbstractIntegerAssert)Assertions.assertThat((int)builder.getResults().getMessages().size()).as("Unexpected compilation errors", new Object[0])).isEqualTo(0);
        ks.getRepository().addKieModule(builder.getKieModule());
        return RELEASE_ID;
    }

    public static class MarkingRuntimeEventListener
    extends DefaultRuleRuntimeEventListener
    implements MarkingListener {
        private final AtomicBoolean fired = new AtomicBoolean(false);

        public void objectInserted(ObjectInsertedEvent event) {
            super.objectInserted(event);
            this.fired.compareAndSet(false, true);
        }

        @Override
        public boolean hasFired() {
            return this.fired.get();
        }
    }

    public static class MarkingAgendaEventListener
    extends DefaultAgendaEventListener
    implements MarkingListener {
        private final AtomicBoolean fired = new AtomicBoolean(false);

        public void afterMatchFired(AfterMatchFiredEvent event) {
            super.afterMatchFired(event);
            this.fired.compareAndSet(false, true);
        }

        @Override
        public boolean hasFired() {
            return this.fired.get();
        }
    }

    public static interface MarkingListener {
        public boolean hasFired();
    }
}

