/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.FirstClass;
import org.drools.testcoverage.common.model.SecondClass;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class BetaTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public BetaTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultBetaConstrains() {
        String drl = "package org.drools.compiler\nimport " + FirstClass.class.getCanonicalName() + "\nimport " + SecondClass.class.getCanonicalName() + "\nglobal java.util.List results;\n\nrule \"5+ constraints with not\"\n    when\n        FirstClass($i1 : item1, $i2 : item2, $i3 : item3, $i4 : item4, $i5 : item5)\n        not SecondClass( item1 == $i1, item2 == $i2, item3 == $i3, item4 == $i4, item5 == $i5 )\n    then\n        results.add( \"NOT\" );\nend\n\nrule \"5+ constraints with pattern\"\n    when\n        FirstClass($i1 : item1, $i2 : item2, $i3 : item3, $i4 : item4, $i5 : item5)\n        SecondClass( item1 == $i1, item2 == $i2, item3 == $i3, item4 == $i4, item5 == $i5 )\n    then\n        results.add( \"EQUALS\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"beta-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            FirstClass first = new FirstClass("1", "2", "3", "4", "5");
            FactHandle handle = ksession.insert((Object)first);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat(results.get(0)).isEqualTo((Object)"NOT");
            ksession.insert((Object)new SecondClass());
            ksession.update(handle, (Object)first);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(2);
            Assertions.assertThat(results.get(1)).isEqualTo((Object)"NOT");
            ksession.update(handle, (Object)first);
            ksession.insert((Object)new SecondClass(null, "2", "3", "4", "5"));
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            Assertions.assertThat(results.get(2)).isEqualTo((Object)"NOT");
            ksession.update(handle, (Object)first);
            ksession.insert((Object)new SecondClass("1", null, "3", "4", "5"));
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(4);
            Assertions.assertThat(results.get(3)).isEqualTo((Object)"NOT");
            ksession.update(handle, (Object)first);
            ksession.insert((Object)new SecondClass("1", "2", null, "4", "5"));
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(5);
            Assertions.assertThat(results.get(4)).isEqualTo((Object)"NOT");
            ksession.update(handle, (Object)first);
            ksession.insert((Object)new SecondClass("1", "2", "3", null, "5"));
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(6);
            Assertions.assertThat(results.get(5)).isEqualTo((Object)"NOT");
            ksession.update(handle, (Object)first);
            ksession.insert((Object)new SecondClass("1", "2", "3", "4", null));
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(7);
            Assertions.assertThat(results.get(6)).isEqualTo((Object)"NOT");
            ksession.insert((Object)new SecondClass("1", "2", "3", "4", "5"));
            ksession.update(handle, (Object)first);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(8);
            Assertions.assertThat(results.get(7)).isEqualTo((Object)"EQUALS");
        }
        finally {
            ksession.dispose();
        }
    }

    @Test(timeout=5000L)
    public void testEfficientBetaNodeNetworkUpdate() {
        String drl = "declare SimpleMembership\n    listId : String\n    patientId : String\nend\ndeclare SimplePatientFact\n    value : int\n    patientId : String\nend\nrule \"A\"\nwhen\n$slm : SimpleMembership($pid : patientId, listId == \"5072\" )\nand not (\n    (\n        (\n            SimplePatientFact(value == 1, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 2, patientId == $pid)\n        )\n    ) and (\n        (\n            SimplePatientFact(value == 6, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 7, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 8, patientId == $pid)\n        )\n    ) and (\n       (\n           SimplePatientFact(value == 9, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 10, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 11, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 12, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 13, patientId == $pid)\n       )\n   )\n)\nthen\n   System.out.println(\"activated\");\nend";
        KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)true, (String[])new String[]{"declare SimpleMembership\n    listId : String\n    patientId : String\nend\ndeclare SimplePatientFact\n    value : int\n    patientId : String\nend\nrule \"A\"\nwhen\n$slm : SimpleMembership($pid : patientId, listId == \"5072\" )\nand not (\n    (\n        (\n            SimplePatientFact(value == 1, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 2, patientId == $pid)\n        )\n    ) and (\n        (\n            SimplePatientFact(value == 6, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 7, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 8, patientId == $pid)\n        )\n    ) and (\n       (\n           SimplePatientFact(value == 9, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 10, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 11, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 12, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 13, patientId == $pid)\n       )\n   )\n)\nthen\n   System.out.println(\"activated\");\nend"});
    }
}

