/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ConditionLimitTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ConditionLimitTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testEvalErrorHandling() {
        int INPUT_COUNT = 65;
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"ConditionLimitTest", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.generateRulesFile(65)});
        KieSession kSession = kbase.newKieSession();
        FieldObject[] inputs = new FieldObject[65];
        FactHandle[] fhs = new FactHandle[65];
        for (int i = 0; i < 65; ++i) {
            inputs[i] = new FieldObject("o" + i, "RUN");
            fhs[i] = kSession.insert((Object)inputs[i]);
        }
        FieldObject result = new FieldObject("result", "");
        kSession.insert((Object)result);
        Assertions.assertThat((String)result.getValue()).isEqualTo("");
        kSession.fireAllRules();
        Assertions.assertThat((String)result.getValue()).isEqualTo("The rule has run.");
        result.setValue("XXXXXX");
        kSession.fireAllRules();
        result.setValue("XXXXXX");
        for (int i = 0; i < 65; ++i) {
            kSession.update(fhs[i], (Object)inputs[i]);
            kSession.fireAllRules();
            Assertions.assertThat((String)result.getValue()).isEqualTo("The rule has run.");
            result.setValue("XXXXXX");
        }
    }

    private String generateRulesFile(int inputCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("package rules\nimport " + FieldObject.class.getCanonicalName() + "\n\nrule \"R1\"\n\twhen\n");
        for (int i = 0; i < inputCount; ++i) {
            sb.append("\t\to" + i + ": FieldObject(key == \"o" + i + "\")\n");
        }
        sb.append("\n\t\tresult: FieldObject(key == \"result\")\n\tthen\n\t\tmodify(result) {setValue(\"The rule has run.\")};\n\tend;");
        return sb.toString();
    }

    public static class FieldObject {
        private String key;
        private String value;

        public FieldObject(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

