/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.mvel.MVELConstraint;
import org.drools.testcoverage.common.model.FactWithList;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.Agenda;

@RunWith(value=Parameterized.class)
public class SharingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SharingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDontShareAlphaWithStaticMethod() {
        String drl1 = "package c;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestStaticUtils.class.getCanonicalName() + "\nrule R1 when\n  TestObject(value == 1)\nthen\nend\nrule R2 when\n  TestObject(value == TestStaticUtils.return1())\nthen\nend\nrule R3 when\n  TestObject(value == 0 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        this.assertSinksSize(otn, 3);
        this.assertHashableSinksSize(otn, 2);
        this.assertNonHashableConstraint(otn, "value == TestStaticUtils.return1()");
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    private ObjectTypeNode getObjectTypeNode(KieBase kbase, Class<?> factClass) {
        EntryPointNode epn = (EntryPointNode)((InternalKnowledgeBase)kbase).getRete().getEntryPointNodes().values().iterator().next();
        return (ObjectTypeNode)epn.getObjectTypeNodes().get(new ClassObjectType(factClass));
    }

    private void assertSinksSize(ObjectTypeNode otn, int expected) {
        Assertions.assertThat((int)otn.getSinks().length).isEqualTo(expected);
    }

    private void assertHashableSinksSize(ObjectTypeNode otn, int expected) {
        CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)otn.getObjectSinkPropagator();
        if (expected == 0) {
            Assertions.assertThat((List)sinkAdapter.getHashableSinks()).isNull();
        } else {
            Assertions.assertThat((int)sinkAdapter.getHashableSinks().size()).isEqualTo(expected);
        }
    }

    private void assertNonHashableConstraint(ObjectTypeNode otn, String expected) {
        CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)otn.getObjectSinkPropagator();
        AlphaNode alpha = (AlphaNode)sinkAdapter.getOtherSinks().get(0);
        AlphaNodeFieldConstraint constraint = alpha.getConstraint();
        if (constraint instanceof MVELConstraint) {
            Assertions.assertThat((String)((MVELConstraint)constraint).getExpression()).isEqualTo(expected);
        } else if (constraint instanceof LambdaConstraint) {
            Assertions.assertThat((String)((LambdaConstraint)constraint).getPredicateInformation().getStringConstraint()).isEqualTo(expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDontShareAlphaWithNonFinalField() {
        String drl = "package com.example;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestStaticUtils.class.getCanonicalName() + "\nrule R1 when\n  TestObject(value == 1)\nthen\nend\nrule R2 when\n  TestObject(value == TestStaticUtils.nonFinal1)\nthen\nend\nrule R3 when\n  TestObject(value == 0 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        this.assertSinksSize(otn, 3);
        this.assertHashableSinksSize(otn, 2);
        this.assertNonHashableConstraint(otn, "value == TestStaticUtils.nonFinal1");
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareAlphaWithFinalField() {
        String drl = "package com.example;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestStaticUtils.class.getCanonicalName() + "\nrule R1 when\n  TestObject(value == 1)\nthen\nend\nrule R2 when\n  TestObject(value == TestStaticUtils.FINAL_1)\nthen\nend\nrule R3 when\n  TestObject(value == 0 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            this.assertSinksSize(otn, 3);
            this.assertNonHashableConstraint(otn, "value == TestStaticUtils.FINAL_1");
        } else {
            this.assertSinksSize(otn, 2);
        }
        this.assertHashableSinksSize(otn, 2);
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareAlphaWithNestedFinalField() {
        String drl = "package com.example;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestStaticUtils.class.getCanonicalName() + "\nrule R1 when\n  TestObject(value == 1)\nthen\nend\nrule R2 when\n  TestObject(value == TestStaticUtils.nestedObj.FINAL_1)\nthen\nend\nrule R3 when\n  TestObject(value == 0 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        this.assertSinksSize(otn, 3);
        this.assertHashableSinksSize(otn, 2);
        this.assertNonHashableConstraint(otn, "value == TestStaticUtils.nestedObj.FINAL_1");
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShareAlphaWithEnum() {
        String drl = "package com.example;\nimport " + TestObject.class.getCanonicalName() + "\nimport " + TestEnum.class.getCanonicalName() + "\nrule R1 when\n  TestObject(testEnum == TestEnum.AAA)\nthen\nend\nrule R2 when\n  TestObject(testEnum == TestEnum.AAA)\nthen\nend\nrule R3 when\n  TestObject(testEnum == TestEnum.BBB)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        this.assertSinksSize(otn, 2);
        this.assertHashableSinksSize(otn, 0);
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(TestEnum.AAA));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDontShareAlphaWithBigDecimalConstructor() {
        String drl = "package com.example;\nimport " + Person.class.getCanonicalName() + "\nimport " + BigDecimal.class.getCanonicalName() + "\nrule R1 when\n  Person(salary == 1)\nthen\nend\nrule R2 when\n  Person(salary == new BigDecimal(\"1\"))\nthen\nend\nrule R3 when\n  Person(salary == 0)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, Person.class);
        this.assertSinksSize(otn, 3);
        this.assertHashableSinksSize(otn, 0);
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new Person("John", 20, new BigDecimal("1")));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldAlphaShareNotEqualsInDifferentPackages() {
        String drl1 = "package c;\nimport " + TestObject.class.getCanonicalName() + "\nrule fileArule1 when\n  TestObject(value >= 1 )\nthen\nend\n";
        String drl2 = "package iTzXzx;\nimport " + TestObject.class.getCanonicalName() + "\nrule fileBrule1 when\n  TestObject(value >= 1 )\nthen\nend\nrule fileBrule2 when\n  TestObject(value >= 2 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, TestObject.class);
        this.assertSinksSize(otn, 2);
        KieSession kieSession = kbase.newKieSession();
        try {
            kieSession.insert((Object)new TestObject(1));
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldAlphaShareNotEqualsInDifferentPackages2() {
        String drl1 = "package c;\nimport " + FactWithList.class.getCanonicalName() + "\n\nrule fileArule1 when\n  FactWithList(items contains \"test\")\nthen\nend\n";
        String drl2 = "package iTzXzx;\nimport " + FactWithList.class.getCanonicalName() + "\nrule fileBrule1 when\n  FactWithList(items contains \"test\")\nthen\nend\nrule fileBrule2 when\n  FactWithList(items contains \"testtest\")\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl1, drl2});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, FactWithList.class);
        this.assertSinksSize(otn, 2);
        KieSession kieSession = kbase.newKieSession();
        try {
            FactWithList factWithList = new FactWithList("test");
            kieSession.insert((Object)factWithList);
            Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubnetworkSharing() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\nglobal java.util.List list\nrule R1 agenda-group \"G2\" when\n    Number( intValue < 1 ) from accumulate (\n        A( $id : id )\n        and $b : B( parentId == $id )\n    ;count($b))\nthen\n    list.add(\"R1\");\nend\n\nrule R2 agenda-group \"G1\" when\n    Number( intValue < 1 ) from accumulate (\n        A( $id : id )\n        and $b : B( parentId == $id )\n\n    ;count($b))\nthen\n    list.add(\"R2\");\nend\n\nrule R3 agenda-group \"G1\" no-loop when\n    $a : A( $id : id )\nthen\n    modify($a) { setId($id + 1) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ObjectTypeNode otnA = this.getObjectTypeNode(kbase, A.class);
        this.assertSinksSize(otnA, 2);
        ObjectTypeNode otnB = this.getObjectTypeNode(kbase, B.class);
        this.assertSinksSize(otnB, 1);
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            kieSession.setGlobal("list", list);
            kieSession.insert((Object)new A(1));
            kieSession.insert((Object)new B(1));
            Agenda agenda = kieSession.getAgenda();
            agenda.getAgendaGroup("G2").setFocus();
            agenda.getAgendaGroup("G1").setFocus();
            kieSession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.contains("R1")).isTrue();
            Assertions.assertThat((boolean)list.contains("R2")).isTrue();
        }
        finally {
            kieSession.dispose();
        }
    }

    public static class TestObject {
        private Integer value = -1;
        private TestEnum testEnum = TestEnum.AAA;

        public TestObject(Integer value) {
            this.value = value;
        }

        public TestObject(TestEnum testEnum) {
            this.testEnum = testEnum;
        }

        public Integer getValue() {
            return this.value;
        }

        public TestEnum getTestEnum() {
            return this.testEnum;
        }
    }

    public static class B {
        private final int parentId;

        public B(int parentId) {
            this.parentId = parentId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }

    public static class A {
        private int id;

        public A(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    public static enum TestEnum {
        AAA,
        BBB,
        CCC;

    }

    public static class NestedObj {
        public static final int FINAL_1 = 1;
    }

    public static class TestStaticUtils {
        public static final NestedObj nestedObj = new NestedObj();
        public static final int FINAL_1 = 1;
        public static int nonFinal1 = 1;

        public static int return1() {
            return 1;
        }
    }
}

