/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.reteoo.ReteDumper;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.FactA;
import org.drools.testcoverage.common.model.FactB;
import org.drools.testcoverage.common.model.FactC;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class EvalTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EvalTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalDefaultCompiler() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\nglobal java.lang.Integer five;\nrule \"eval rule test\"\n    when\n        $cheese : Cheese( $type:type == \"stilton\" )\n        eval( $cheese.getPrice() == five.intValue() )\n    then\n        list.add( $cheese );\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kieContainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieBase kbase = kieContainer.getKieBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("five", (Object)5);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 5);
            ksession.insert((Object)stilton);
            ksession.fireAllRules();
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(0)).isEqualTo((Object)stilton);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalNoPatterns() {
        String drl = "package org.drools.compiler.integrationtests.operators\nglobal java.util.List list\nrule \"no patterns1\"\n    when\n        eval(true);\n    then\n        list.add(\"fired1\");\nend    \nrule \"no patterns2\"\n    when\n        eval(false);\n    then\n        list.add(\"fired2\");\nend \nrule \"no patterns3\"\n    when\n        eval(true);\n        eval(1==1);\n    then\n        list.add(\"fired3\");\nend  \nrule \"no patterns4\"\n    when\n        eval(false);\n        eval(true);\n        eval(1==1);\n    then\n        list.add(\"fired4\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators\nglobal java.util.List list\nrule \"no patterns1\"\n    when\n        eval(true);\n    then\n        list.add(\"fired1\");\nend    \nrule \"no patterns2\"\n    when\n        eval(false);\n    then\n        list.add(\"fired2\");\nend \nrule \"no patterns3\"\n    when\n        eval(true);\n        eval(1==1);\n    then\n        list.add(\"fired3\");\nend  \nrule \"no patterns4\"\n    when\n        eval(false);\n        eval(true);\n        eval(1==1);\n    then\n        list.add(\"fired4\");\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assertions.assertThat((boolean)list.contains("fired1")).isTrue();
            Assertions.assertThat((boolean)list.contains("fired3")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalMore() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list\nrule \"another test\"\n    when\n        p : Person()\n        eval(p.getName().equals(\"foo\") && p.getName().startsWith(\"f\"))\n    then\n        list.add( p );\nend  \nrule \"yet more\"\n    when\n        p : Person()\n        eval(p.getName().equals(\"foo\") && p.getName().startsWith(\"f\"))\n        eval(p.getName().equals(\"foo\") && p.getName().startsWith(\"q\"))        \n    then\n        list.add( p );\nend ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Person foo = new Person("foo");
            session.insert((Object)foo);
            session.fireAllRules();
            Assertions.assertThat(((List)session.getGlobal("list")).get(0)).isEqualTo((Object)foo);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalCE() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + Person.class.getCanonicalName() + ";\nrule \"inline eval\"\nwhen\n    $str : String()\n    $p   : Person()\n    eval( $p.getName().startsWith($str) && $p.getName().endsWith($str) )then\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            session.insert((Object)"b");
            session.insert((Object)new Person("mark", 50));
            int rules = session.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(0);
            session.insert((Object)new Person("bob", 18));
            rules = session.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(1);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalException() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nfunction boolean throwException(Object object) {\n    throw new Exception( \"this should throw an exception\" );\n}\n\nrule \"Throw Eval Exception\"\n    when\n        cheese : Cheese( )\n         eval( throwException( cheese ) )\n    then\n\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese brie = new Cheese("brie", 12);
            try {
                ksession.insert((Object)brie);
                ksession.fireAllRules();
                Assertions.fail((String)"Should throw an Exception from the Eval");
            }
            catch (Exception e) {
                Assertions.assertThat((boolean)e.getCause().getMessage().contains("this should throw an exception")).isTrue();
            }
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalInline() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule \"inline eval\"\nwhen\n    $str : String()\n    Person( eval( name.startsWith($str) && age == 18) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"b");
            ksession.insert((Object)new Person("mark", 50));
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(0);
            ksession.insert((Object)new Person("bob", 18));
            rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalWithLineBreaks() {
        String drl = "package org.drools.compiler.integrationtests.operators;\n\nglobal java.util.List results\n\nfunction boolean testEqual( Object o1, Object o2 ) {\n    return o1.equals(o2);\n}\n\nrule \"TestRule\"\nwhen\n    $i : Integer( eval( testEqual( $i,\n                              $i ) ) )\nthen\n    results.add( $i );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\n\nglobal java.util.List results\n\nfunction boolean testEqual( Object o1, Object o2 ) {\n    return o1.equals(o2);\n}\n\nrule \"TestRule\"\nwhen\n    $i : Integer( eval( testEqual( $i,\n                              $i ) ) )\nthen\n    results.add( $i );\nend"});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            session.insert((Object)10);
            session.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)results.get(0))).isEqualTo(10);
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalWithBigDecimal() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport java.math.BigDecimal; \nglobal java.util.List list \nrule rule1 \n    dialect \"java\" \nwhen \n    $bd : BigDecimal() \n    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \nthen \n    list.add( $bd ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\nimport java.math.BigDecimal; \nglobal java.util.List list \nrule rule1 \n    dialect \"java\" \nwhen \n    $bd : BigDecimal() \n    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \nthen \n    list.add( $bd ); \nend \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new BigDecimal(1.5));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)new BigDecimal(1.5));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testFieldBiningsAndEvalSharing() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\n\n// this is to test eval condition node sharing working properly\nrule rule1\n    when\n        Person(val: name)\n        eval(val == null)\n    then\n        list.add(\"rule1 fired\");\nend    \n\n\nrule rule2\n    when\n        Person(val: likes)\n        eval(val == null) // note its the same guts, but different binding\n    then\n        list.add(\"rule2 fired\");\nend ";
        this.evalSharingTest(drl);
    }

    @Test
    public void testFieldBiningsAndPredicateSharing() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\n\n//this is to test eval condition node sharing working properly\nrule rule1\n    when\n        Person(val: name, eval(val == null))\n    then\n        list.add(\"rule1 fired\");\nend    \n\n\nrule rule2\n    when\n        Person(val: likes, eval(val == null))\n    then\n        list.add(\"rule2 fired\");\nend";
        this.evalSharingTest(drl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalSharingTest(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)ksession);
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person tp1 = new Person();
            tp1.setName(null);
            tp1.setLikes("boo");
            ksession.insert((Object)tp1);
            ksession.fireAllRules();
            Assertions.assertThat((int)((List)ksession.getGlobal("list")).size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCastingInsideEvals() {
        String drl = "package org.drools.compiler.integrationtests.operators\n\nglobal java.lang.Integer value;\n\nfunction boolean isEqual( Integer v1, Integer v2 ) {\n    return v1.equals( v2 );\n}\n\nrule \"test casts\"\nwhen\n    eval( isEqual((Integer) value, (Integer)value ) )\nthen\n    // rule fired\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators\n\nglobal java.lang.Integer value;\n\nfunction boolean isEqual( Integer v1, Integer v2 ) {\n    return v1.equals( v2 );\n}\n\nrule \"test casts\"\nwhen\n    eval( isEqual((Integer) value, (Integer)value ) )\nthen\n    // rule fired\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("value", (Object)20);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaEvalWithOrCE() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + FactA.class.getCanonicalName() + ";\nimport " + FactB.class.getCanonicalName() + ";\nimport " + FactC.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"test eval with OR\"\nwhen\n    FactA( eval( \"something\".equals( field1 ) ) )\n    FactB() or FactC()\nthen\n    results.add( \"Should not have fired\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            FactA a = new FactA();
            a.setField1("a value");
            ksession.insert((Object)a);
            ksession.insert((Object)new FactB());
            ksession.insert((Object)new FactC());
            ksession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("should not have fired", new Object[0])).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyWithLiaToEval() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list \nrule xxx \nwhen \n    $p : Person() \n    eval( $p.getAge() > 30 ) \nthen \n  list.add($p); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person p1 = new Person("darth", 25);
            FactHandle fh = ksession.insert((Object)p1);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            p1.setAge(35);
            ksession.update(fh, (Object)p1);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigDecimalWithFromAndEval() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nrule \"Test Rule\"\nwhen\n    $dec : java.math.BigDecimal() from java.math.BigDecimal.TEN;\n    eval( $dec.compareTo(java.math.BigDecimal.ONE) > 0 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\nrule \"Test Rule\"\nwhen\n    $dec : java.math.BigDecimal() from java.math.BigDecimal.TEN;\n    eval( $dec.compareTo(java.math.BigDecimal.ONE) > 0 )\nthen\nend"});
        KieSession session = kbase.newKieSession();
        try {
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredicate() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list;\nglobal java.lang.Integer two;\n\nrule \"predicate rule test\"\n    when\n        $person1 : Person( $age1 : age )\n        // We have no autoboxing of primtives, so have to do by hand\n        person2 : Person( $age2:age, eval( $age2 == ( $age1 + two.intValue() ) ) )\n    then\n        list.add( $person1 );\n        list.add( person2 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("two", (Object)2);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Person peter = new Person("peter", null, 12);
            ksession.insert((Object)peter);
            Person jane = new Person("jane", null, 10);
            ksession.insert((Object)jane);
            ksession.fireAllRules();
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(0)).isEqualTo((Object)jane);
            Assertions.assertThat(((List)ksession.getGlobal("list")).get(1)).isEqualTo((Object)peter);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredicateException() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nfunction boolean throwException(Object object) {\n    throw new RuntimeException( \"this should throw an exception\" );\n}\n\nrule \"Throw Predicate Exception\"\n    when\n        Cheese( type1:type, eval( throwException( type1 ) ) )\n    then\n\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Cheese brie = new Cheese("brie", 12);
            try {
                ksession.insert((Object)brie);
                ksession.fireAllRules();
                Assertions.fail((String)"Should throw an Exception from the Predicate");
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof InvocationTargetException) {
                    cause = ((InvocationTargetException)cause).getTargetException();
                }
                Assertions.assertThat((boolean)cause.getMessage().contains("this should throw an exception")).isTrue();
            }
        }
        finally {
            ksession.dispose();
        }
    }
}

