/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.phases;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.GlobalVariableContextImpl;
import org.drools.compiler.builder.impl.InternalKnowledgeBaseProvider;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.PackageRegistryCompiler;
import org.drools.compiler.builder.impl.PackageRegistryManagerImpl;
import org.drools.compiler.builder.impl.RootClassLoaderProvider;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.TypeDeclarationContextImpl;
import org.drools.compiler.builder.impl.TypeDeclarationManagerImpl;
import org.drools.compiler.builder.impl.processors.AccumulateFunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.ConsequenceCompilationPhase;
import org.drools.compiler.builder.impl.processors.EntryPointDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.ImmutableFunctionCompiler;
import org.drools.compiler.builder.impl.processors.ImmutableGlobalCompilationPhase;
import org.drools.compiler.builder.impl.processors.ImmutableRuleCompilationPhase;
import org.drools.compiler.builder.impl.processors.ImportCompilationPhase;
import org.drools.compiler.builder.impl.processors.RuleAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.RuleValidator;
import org.drools.compiler.builder.impl.processors.TypeDeclarationAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.TypeDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.WindowDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.io.ClassPathResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.SessionsAwareKnowledgeBase;
import org.drools.util.TypeResolver;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;

public class ExplicitCompilerTest {
    @Test
    public void testCompile() throws DroolsParserException, IOException {
        ClassPathResource resource = new ClassPathResource("org/drools/compiler/integrationtests/phases/ExplicitCompilerTest.drl");
        int parallelRulesBuildThreshold = 0;
        InternalKnowledgeBase kBase = null;
        KnowledgeBuilderConfigurationImpl configuration = new KnowledgeBuilderConfigurationImpl();
        ClassLoader rootClassLoader = configuration.getClassLoader();
        BuildResultCollectorImpl results = new BuildResultCollectorImpl();
        RootClassLoaderProvider rootClassLoaderProvider = () -> rootClassLoader;
        InternalKnowledgeBaseProvider internalKnowledgeBaseProvider = () -> kBase;
        PackageRegistryManagerImpl packageRegistryManager = new PackageRegistryManagerImpl(configuration, rootClassLoaderProvider, internalKnowledgeBaseProvider);
        GlobalVariableContextImpl globalVariableContext = new GlobalVariableContextImpl();
        TypeDeclarationContextImpl typeDeclarationContext = new TypeDeclarationContextImpl(configuration, (PackageRegistryManager)packageRegistryManager, (GlobalVariableContext)globalVariableContext);
        TypeDeclarationBuilder typeBuilder = new TypeDeclarationBuilder((TypeDeclarationContext)typeDeclarationContext, (BuildResultCollector)results);
        typeDeclarationContext.setTypeDeclarationManager(new TypeDeclarationManagerImpl(typeBuilder, kBase));
        DrlResourceHandler handler = new DrlResourceHandler(configuration);
        PackageDescr packageDescr = handler.process((Resource)resource);
        handler.getResults().forEach(arg_0 -> ((BuildResultCollectorImpl)results).addBuilderResult(arg_0));
        PackageRegistry packageRegistry = packageRegistryManager.getOrCreatePackageRegistry(packageDescr);
        AnnotationNormalizer annotationNormalizer = AnnotationNormalizer.of((TypeResolver)packageRegistry.getTypeResolver(), (boolean)configuration.getLanguageLevel().useJavaAnnotations());
        Map attributesForPackage = packageRegistryManager.getPackageAttributes().get(packageDescr.getNamespace());
        List<CompilationPhase> phases = Arrays.asList(new ImportCompilationPhase(packageRegistry, packageDescr), new TypeDeclarationAnnotationNormalizer(annotationNormalizer, packageDescr), new EntryPointDeclarationCompilationPhase(packageRegistry, packageDescr), new AccumulateFunctionCompilationPhase(packageRegistry, packageDescr), new TypeDeclarationCompilationPhase(packageDescr, typeBuilder, packageRegistry, null), new WindowDeclarationCompilationPhase(packageRegistry, packageDescr, (TypeDeclarationContext)typeDeclarationContext), new FunctionCompilationPhase(packageRegistry, packageDescr, (KnowledgeBuilderConfiguration)configuration), new ImmutableGlobalCompilationPhase(packageRegistry, packageDescr, (GlobalVariableContext)globalVariableContext), new RuleAnnotationNormalizer(annotationNormalizer, packageDescr), new RuleValidator(packageRegistry, packageDescr, (KnowledgeBuilderConfiguration)configuration), new ImmutableFunctionCompiler(packageRegistry, packageDescr, rootClassLoader), new ImmutableRuleCompilationPhase(packageRegistry, packageDescr, parallelRulesBuildThreshold, attributesForPackage, (Resource)resource, (TypeDeclarationContext)typeDeclarationContext), new ConsequenceCompilationPhase((PackageRegistryCompiler)packageRegistryManager));
        for (CompilationPhase phase : phases) {
            phase.process();
            phase.getResults().forEach(arg_0 -> ((BuildResultCollectorImpl)results).addBuilderResult(arg_0));
            if (!results.hasErrors()) continue;
            results.getErrors().forEach(System.out::println);
            Assertions.fail((String)("Found compilation errors at Phase " + phase.getClass().getSimpleName()));
        }
        List packages = packageRegistryManager.getPackageRegistry().values().stream().map(PackageRegistry::getPackage).collect(Collectors.toList());
        RuleBase kbase = RuleBaseFactory.newRuleBase((KieBaseConfiguration)null);
        kbase.addPackages(packages);
        SessionsAwareKnowledgeBase sessionsAwareKnowledgeBase = new SessionsAwareKnowledgeBase(kbase);
        KieSession kieSession = sessionsAwareKnowledgeBase.newKieSession();
        kieSession.insert((Object)"HELLO");
        kieSession.fireAllRules();
    }
}

