/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kproject.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.util.StringUtils;
import org.junit.Test;

public class MemoryFileTest {
    @Test
    public void testFileCreation() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        File f1 = mres.getFile("MyClass.java");
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        mres.create();
        f1 = mres.getFile("MyClass.java");
        Assertions.assertThat((boolean)f1.exists()).isTrue();
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        f1 = mres.getFile("MyClass.java");
        Assertions.assertThat((boolean)f1.exists()).isTrue();
        Assertions.assertThat((String)StringUtils.toString((InputStream)f1.getContents())).isEqualTo("ABC");
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        f1.setContents((InputStream)new ByteArrayInputStream("DEF".getBytes()));
        Assertions.assertThat((String)StringUtils.toString((InputStream)f1.getContents())).isEqualTo("DEF");
    }

    @Test
    public void testFileRemoval() throws IOException {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        mres.create();
        File f1 = mres.getFile("MyClass.java");
        f1.create((InputStream)new ByteArrayInputStream("ABC".getBytes()));
        Assertions.assertThat((boolean)f1.exists()).isTrue();
        Assertions.assertThat((String)StringUtils.toString((InputStream)f1.getContents())).isEqualTo("ABC");
        fs.remove(f1);
        f1 = mres.getFile("MyClass.java");
        Assertions.assertThat((boolean)f1.exists()).isFalse();
        try {
            f1.getContents();
            Assertions.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testFilePath() {
        MemoryFileSystem fs = new MemoryFileSystem();
        Folder mres = fs.getFolder("src/main/java/org/domain");
        File f1 = mres.getFile("MyClass.java");
        Assertions.assertThat((String)f1.getPath().asString()).isEqualTo("src/main/java/org/domain/MyClass.java");
    }
}

