/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath.graph;

import java.util.List;
import org.drools.core.phreak.AbstractReactiveObject;
import org.drools.core.phreak.ReactiveList;
import org.drools.mvel.compiler.oopath.graph.Edge;

public class Vertex<T>
extends AbstractReactiveObject {
    private static int ID_GENERATOR = 1;
    private final int id;
    private final T it;
    private final List<Edge> inEs = new ReactiveList();
    private final List<Edge> outEs = new ReactiveList();
    private final List<Vertex<?>> inVs = new ReactiveList();
    private final List<Vertex<?>> outVs = new ReactiveList();

    public Vertex(T content) {
        this(ID_GENERATOR++, content);
    }

    public Vertex(int id, T it) {
        this.id = id;
        this.it = it;
    }

    public int getId() {
        return this.id;
    }

    public T getIt() {
        return this.it;
    }

    public List<Edge> getInEs() {
        return this.inEs;
    }

    public List<Vertex<?>> getInVs() {
        return this.inVs;
    }

    public List<Edge> getOutEs() {
        return this.outEs;
    }

    public List<Vertex<?>> getOutVs() {
        return this.outVs;
    }

    public void addInEdge(Edge edge) {
        this.inEs.add(edge);
        edge.setOutV(this);
    }

    public void addOutEdge(Edge edge) {
        this.outEs.add(edge);
        edge.setInV(this);
    }

    public Edge connectTo(Vertex<?> other) {
        Edge edge = new Edge();
        this.addOutEdge(edge);
        other.addInEdge(edge);
        this.outVs.add(other);
        other.inVs.add(this);
        return edge;
    }
}

