/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.core.ClassObjectFilter;
import org.drools.core.ClockType;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.mvel.integrationtests.facts.BasicEvent;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Role;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

@RunWith(value=Parameterized.class)
public class ExpirationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ExpirationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Test
    public void testAlpha() {
        String drl = "import " + A.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(11ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nrule R0 when\n  $a: A( $Aid: id > 0 )\nthen\n  System.out.println(\"[\" + $a + \"]\");  counter.incrementAndGet();\nend";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)new A(1));
        sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new A(2));
        sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
    }

    @Test
    public void testBeta() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(11ms) end\ndeclare B @role( event ) @expires(11ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nrule R0 when\n  $a: A( $Aid: id > 0 )\n  $b: B( ($Bid: id <= $Aid) && (id > ($Aid - 1 )))\nthen\n  System.out.println(\"[\" + $a + \",\" + $b + \"]\");  counter.incrementAndGet();\nend";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)new A(1));
        ksession.insert((Object)new B(1));
        sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new A(2));
        ksession.insert((Object)new B(2));
        sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
    }

    @Test
    public void testBetaRightExpired() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(11ms) end\ndeclare B @role( event ) @expires(11ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nrule R0 when\n  $a: A( $Aid: id > 0 )\n  $b: B( id == $Aid )\nthen\n  System.out.println(\"[\" + $a + \",\" + $b + \"]\");  counter.incrementAndGet();\nend";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)new A(1));
        sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new B(1));
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(0);
    }

    @Test
    public void testBetaLeftExpired() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(11ms) end\ndeclare B @role( event ) @expires(11ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nrule R0 when\n  $a: A( $Aid: id > 0 )\n  $b: B( id == $Aid )\nthen\n  System.out.println(\"[\" + $a + \",\" + $b + \"]\");  counter.incrementAndGet();\nend";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)new B(1));
        sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new A(1));
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(0);
    }

    @Test
    public void testBetaLeftExpired2() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\nimport " + C.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(31ms) end\ndeclare B @role( event ) @expires(11ms) end\ndeclare C @role( event ) @expires(31ms) end\nglobal java.util.concurrent.atomic.AtomicInteger counter;\nrule R0 when\n  $a: A( $Aid: id > 0 )\n  $b: B( $Bid: id == $Aid )\n  $c: C( id == $Bid )\nthen\n  System.out.println(\"[\" + $a + \",\" + $b + \",\" + $c + \"]\");  counter.incrementAndGet();\nend";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        ksession.insert((Object)new A(1));
        ksession.insert((Object)new B(1));
        sessionClock.advanceTime(20L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new C(1));
        ksession.fireAllRules();
        Assertions.assertThat((int)counter.get()).isEqualTo(0);
    }

    @Test
    public void testSoftExpiration() {
        String drl = "import " + ExpiringEventA.class.getCanonicalName() + "\nimport " + ExpiringEventB.class.getCanonicalName() + "\nimport " + ExpiringEventC.class.getCanonicalName() + "\nrule Ra when\n  $e : ExpiringEventA() over window:time(20s)\nthen end\n rule Rb when\n  $e : ExpiringEventB() over window:time(20s)\nthen end\n rule Rc when\n  $e : ExpiringEventC()\nthen end\n";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        ksession.insert((Object)new ExpiringEventA());
        ksession.insert((Object)new ExpiringEventB());
        ksession.insert((Object)new ExpiringEventC());
        ksession.fireAllRules();
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventA.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventB.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventC.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventA.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventB.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventC.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventA.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventB.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventC.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventA.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventB.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(ExpiringEventC.class)).size()).isEqualTo(0);
    }

    @Test
    public void testSoftExpirationWithDeclaration() {
        String drl = "import " + A.class.getCanonicalName() + "\nimport " + B.class.getCanonicalName() + "\nimport " + C.class.getCanonicalName() + "\ndeclare A @role( event ) @expires(10s) end\ndeclare B @role( event ) @expires(value = 30s, policy = TIME_SOFT) end\ndeclare C @role( event ) @expires(value = 30s, policy = TIME_SOFT) end\nrule Ra when\n  $e : A() over window:time(20s)\nthen end\n rule Rb when\n  $e : B() over window:time(20s)\nthen end\n rule Rc when\n  $e : C()\nthen end\n";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        ksession.insert((Object)new A(1));
        ksession.insert((Object)new B(2));
        ksession.insert((Object)new C(3));
        ksession.fireAllRules();
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(A.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(B.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(C.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(A.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(B.class)).size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(C.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(A.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(B.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(C.class)).size()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(A.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(B.class)).size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getObjects((ObjectFilter)new ClassObjectFilter(C.class)).size()).isEqualTo(0);
    }

    @Test
    public void testEventsExpiredInThePast() throws InterruptedException {
        String drl = " package org.drools.mvel.integrationtests;\n import " + BasicEvent.class.getCanonicalName() + ";\n declare BasicEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @duration( eventDuration )\n end\n \n rule R1\n when\n     $A : BasicEvent()\n     $B : BasicEvent( this starts $A )\n then \n end\n";
        this.testEventsExpiredInThePast(drl);
    }

    @Test
    public void testEventsExpiredInThePastTemporalConstraint() throws InterruptedException {
        String drl = " package org.drools.mvel.integrationtests;\n import " + BasicEvent.class.getCanonicalName() + ";\n declare BasicEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @duration( eventDuration )\n end\n \n rule R1\n when\n     $A : BasicEvent()\n     $B : BasicEvent( this starts[5ms] $A )\n then \n end\n";
        this.testEventsExpiredInThePast(drl);
    }

    private void testEventsExpiredInThePast(String drl) {
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = clock.getCurrentTime();
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        kieSession.insert((Object)new BasicEvent(new Date(currentTime + 20L), 10L, "20ms-30ms"));
        clock.advanceTime(1L, TimeUnit.MILLISECONDS);
        kieSession.insert((Object)new BasicEvent(new Date(currentTime + 20L), 20L, "20ms-40ms"));
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((Collection)kieSession.getObjects()).isEmpty();
    }

    @Test
    public void testExpiredEventWithIdConstraint() throws InterruptedException {
        this.testEventExpiredContraint(true, true);
    }

    @Test
    public void testExpiredEventWithoutIdConstraint() throws InterruptedException {
        this.testEventExpiredContraint(true, false);
    }

    @Test
    public void testNotExpiredEventWithIdConstraint() throws InterruptedException {
        this.testEventExpiredContraint(false, true);
    }

    @Test
    public void testNotExpiredEventWithoutIdConstraint() throws InterruptedException {
        this.testEventExpiredContraint(false, false);
    }

    private void testEventExpiredContraint(boolean expired, boolean constraint) throws InterruptedException {
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @expires( 2h )\n end\n \n rule R1 when\n     $dummyEvent : DummyEvent(state != \"release\")\n     $dummyEventContext : DummyEvent(this != $dummyEvent, this before $dummyEvent, state != \"release\"" + (constraint ? ", idA == $dummyEvent.idA" : "") + ")\n then \n     System.out.println(\"R1\");\n     modify($dummyEventContext){setState(\"release\");} \n end\n rule R2 when\n     $dummyEvent : DummyEvent(state != \"release\")\n     $dummyEventContext : DummyEvent(this != $dummyEvent, this before $dummyEvent, state !=  \"release\"" + (constraint ? ", idB == $dummyEvent.idB" : "") + ")\n then \n     System.out.println(\"R2\");\n     modify($dummyEventContext){setState(\"release\");} \n end\n";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = System.currentTimeMillis();
        clock.setStartupTime(currentTime - 1L);
        kieSession.insert((Object)new DummyEvent(1, currentTime));
        kieSession.insert((Object)new DummyEvent(2, expired ? currentTime - Duration.ofHours(8L).toMillis() : currentTime + Duration.ofHours(8L).toMillis()));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testEventSameContraint() throws InterruptedException {
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n end\n \n rule R1 when\n     $dummyEvent : DummyEvent(state != \"release\")\n     $otherDummyEvent : DummyEvent(this != $dummyEvent, this before $dummyEvent, idA == $dummyEvent.idA)\n then \n     System.out.println(\"R1\");\n end\n rule R2 when\n     $dummyEvent : DummyEvent(state != \"release\")\n     $otherDummyEvent : DummyEvent(this != $dummyEvent, this before $dummyEvent, idA == $dummyEvent.idA)\n then \n     System.out.println(\"R2\");\n end\n";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = System.currentTimeMillis();
        clock.setStartupTime(currentTime - 1L);
        kieSession.insert((Object)new DummyEvent(1, currentTime));
        kieSession.insert((Object)new DummyEvent(2, currentTime - Duration.ofHours(8L).toMillis()));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testCollectWithExpiredEvent() {
        this.testCollectExpiredEvent(true);
    }

    @Test
    public void testCollectWithoutExpiredEvent() {
        this.testCollectExpiredEvent(false);
    }

    private void testCollectExpiredEvent(boolean expired) {
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n import java.util.Collection\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @expires( 3d )\n end\n rule R when\n     $listEvent: Collection(size >= 2) from collect (DummyEvent()) then \n\t  System.out.println(\"R is fired\");  \n end\n";
        SessionConfigurationImpl sessionConfig = new SessionConfigurationImpl();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession((KieSessionConfiguration)sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = System.currentTimeMillis();
        clock.setStartupTime(currentTime);
        kieSession.fireAllRules();
        DummyEvent event1 = new DummyEvent(1, currentTime);
        long timestamp = currentTime;
        if (expired) {
            timestamp = currentTime - Duration.ofDays(8L).toMillis();
        }
        DummyEvent event2 = new DummyEvent(2, timestamp);
        kieSession.insert((Object)event1);
        kieSession.insert((Object)event2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testSameConstraintAllExpired() {
        this.testMultipleExpiredEvent(2, false);
    }

    @Test
    public void testSameConstraintOneExpired() {
        this.testMultipleExpiredEvent(1, false);
    }

    @Test
    public void testSameConstraintNoExpiration() {
        this.testMultipleExpiredEvent(0, false);
    }

    @Test
    public void testDifferentConstraintAllExpired() {
        this.testMultipleExpiredEvent(2, true);
    }

    @Test
    public void testDifferentConstraintOneExpired() {
        this.testMultipleExpiredEvent(1, true);
    }

    @Test
    public void testDifferentConstraintNoExpiration() {
        this.testMultipleExpiredEvent(0, true);
    }

    private void testMultipleExpiredEvent(int expiredNumber, boolean differentConstraint) {
        long timeStampEvent2;
        long timeStampEvent1;
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n\t  @expires( 2h )\n end\n rule R1 when\n     $dummyEvent : DummyEvent()\n     $otherDummyEvent : DummyEvent( this before $dummyEvent )\n then \n    System.out.println(\"R1 Fired\"); \n end\n rule R2 when\n     $dummyEvent : DummyEvent()\n" + (differentConstraint ? "     $otherDummyEvent : DummyEvent( state == \"initial\", this before $dummyEvent )\n" : "     $otherDummyEvent : DummyEvent( this before $dummyEvent )\n") + " then \n    System.out.println(\"R2 Fired\"); \n end\n";
        SessionConfigurationImpl sessionConfig = new SessionConfigurationImpl();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession((KieSessionConfiguration)sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = System.currentTimeMillis();
        clock.setStartupTime(currentTime);
        kieSession.fireAllRules();
        switch (expiredNumber) {
            case 2: {
                timeStampEvent1 = currentTime - Duration.ofHours(9L).toMillis();
                timeStampEvent2 = currentTime - Duration.ofHours(8L).toMillis();
                break;
            }
            case 1: {
                timeStampEvent1 = currentTime - Duration.ofHours(8L).toMillis();
                timeStampEvent2 = currentTime;
                break;
            }
            default: {
                timeStampEvent1 = currentTime - Duration.ofHours(1L).toMillis();
                timeStampEvent2 = currentTime;
            }
        }
        DummyEvent event1 = new DummyEvent(1, timeStampEvent1);
        DummyEvent event2 = new DummyEvent(2, timeStampEvent2);
        kieSession.insert((Object)event1);
        kieSession.insert((Object)event2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(2 - expiredNumber);
    }

    @Test
    public void testInstanceofExpired() {
        this.testEvalExpiredEvent(true, false);
    }

    @Test
    public void testInstanceofNotExpired() {
        this.testEvalExpiredEvent(false, false);
    }

    @Test
    public void testEvalExpired() {
        this.testEvalExpiredEvent(true, true);
    }

    @Test
    public void testEvalNotExpired() {
        this.testEvalExpiredEvent(false, true);
    }

    private void testEvalExpiredEvent(boolean isExpired, boolean useEval) {
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n import " + OtherEvent.class.getCanonicalName() + ";\n import " + ApplicationEvent.class.getCanonicalName() + ";\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @expires( 1s )\n end\n declare OtherEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @expires( 1s )\n end\n rule R1 when\n     $dummyEvent : DummyEvent()\n     $otherEvent : OtherEvent()\n then\n     System.out.println(\"R1 is fired\");\n end\n rule R2 when\n" + (useEval ? "     $evt : ApplicationEvent() \n     eval( !($evt.getClass().getSimpleName().equals(\"DummyEvent\"))) \n" : "     $evt : ApplicationEvent( !(this instanceof DummyEvent))\n") + " then\n     System.out.println(\"R2 is fired\");\n end";
        SessionConfigurationImpl sessionConfig = new SessionConfigurationImpl();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession((KieSessionConfiguration)sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = System.currentTimeMillis();
        clock.setStartupTime(currentTime);
        kieSession.fireAllRules();
        long timestamp = currentTime;
        if (isExpired) {
            timestamp = currentTime - Duration.ofDays(8L).toMillis();
        }
        DummyEvent dummyEvent = new DummyEvent(1, timestamp);
        OtherEvent otherEvent = new OtherEvent(2, timestamp, 1);
        kieSession.insert((Object)dummyEvent);
        kieSession.insert((Object)otherEvent);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)kieSession.getObjects().size()).isEqualTo(isExpired ? 0 : 2);
    }

    @Test
    public void testPolymorphicAlphaExpired() throws InterruptedException {
        String drl = " package org.drools.mvel.integrationtests;\n import " + DummyEvent.class.getCanonicalName() + ";\n import " + ApplicationEvent.class.getCanonicalName() + ";\n declare DummyEvent\n     @role( event )\n     @timestamp( eventTimestamp )\n     @expires( 1s )\n end\n rule R1\n when\n     $evt : DummyEvent()\n then \n end\n rule R2\n when\n     $evt : ApplicationEvent()\n then \n end\n";
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession(sessionConfig, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        long currentTime = clock.getCurrentTime();
        clock.advanceTime(10L, TimeUnit.SECONDS);
        kieSession.insert((Object)new DummyEvent(10, currentTime));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
    }

    @Test
    public void testAvoidAlreadyExpiredFactsToForeverRemainInWM() {
        String drl = " import " + DummyEvent.class.getCanonicalName() + ";\n import " + OtherEvent.class.getCanonicalName() + ";\n\ndeclare DummyEvent\n    @role(event)\n    @timestamp(eventTimestamp)\n    @expires (3d)\nend\nrule \"R1\"\nno-loop \nwhen\n    $evt: DummyEvent()\nthen\n    modify($evt){\n        setState(\"value\")\n    }\nend\nrule \"R2\"\nwhen\n    $b: OtherEvent()\n    $a: DummyEvent()\nthen\nend";
        KieBaseTestConfiguration equalityConfig = TestParametersUtil.getEqualityInstanceOf((KieBaseTestConfiguration)this.kieBaseTestConfiguration);
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)equalityConfig, (String[])new String[]{drl});
        KieSessionConfiguration sessionConfig = RuleBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieSession kieSession = kieBase.newKieSession(sessionConfig, null);
        long now = System.currentTimeMillis();
        PseudoClockScheduler clock = (PseudoClockScheduler)kieSession.getSessionClock();
        clock.advanceTime(now, TimeUnit.MILLISECONDS);
        long fiveDaysAgo = now - Duration.ofDays(5L).toMillis();
        DummyEvent dummyEvent = new DummyEvent(1, fiveDaysAgo);
        kieSession.insert((Object)dummyEvent);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((long)kieSession.getFactCount()).isEqualTo(0L);
    }

    public static class OtherEvent
    implements ApplicationEvent {
        private int id;
        private long eventTimestamp;
        private int dummyEventId;

        public OtherEvent(int id, long eventTimestamp, int dummyEventId) {
            this.id = id;
            this.eventTimestamp = eventTimestamp;
            this.dummyEventId = dummyEventId;
        }

        public String toString() {
            return "OtherEvent{id=" + this.id + ", eventTimestamp=" + this.eventTimestamp + ", dummyEventId=" + this.dummyEventId + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OtherEvent that = (OtherEvent)o;
            return this.id == that.id && this.eventTimestamp == that.eventTimestamp && this.dummyEventId == that.dummyEventId;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.eventTimestamp, this.dummyEventId);
        }

        public int getId() {
            return this.id;
        }

        public long getEventTimestamp() {
            return this.eventTimestamp;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setEventTimestamp(long eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        public int getDummyEventId() {
            return this.dummyEventId;
        }

        public void setDummyEventId(int dummyEventId) {
            this.dummyEventId = dummyEventId;
        }
    }

    public static class DummyEvent
    implements ApplicationEvent {
        private int id;
        private long eventTimestamp;
        private String state;

        public DummyEvent(int id, long eventTimestamp) {
            this.id = id;
            this.eventTimestamp = eventTimestamp;
            this.state = "initial";
        }

        public String getState() {
            return this.state;
        }

        public DummyEvent setState(String state) {
            this.state = state;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public DummyEvent setId(int id) {
            this.id = id;
            return this;
        }

        public long getEventTimestamp() {
            return this.eventTimestamp;
        }

        public DummyEvent setEventTimestamp(long eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public String getIdA() {
            return "A";
        }

        public String getIdB() {
            return "B";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DummyEvent that = (DummyEvent)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.eventTimestamp, that.eventTimestamp) && Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.eventTimestamp, this.state);
        }

        public String toString() {
            return "DummyEvent{id=" + this.id + ", eventTimestamp=" + this.eventTimestamp + ", state=" + this.state + "}";
        }
    }

    public static interface ApplicationEvent {
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="30s", policy=Expires.Policy.TIME_SOFT)
    public static class ExpiringEventC {
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="30s", policy=Expires.Policy.TIME_SOFT)
    public static class ExpiringEventB {
    }

    @Role(value=Role.Type.EVENT)
    @Expires(value="10s")
    public static class ExpiringEventA {
    }

    public class C {
        private final int id;

        public C(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "C(" + this.id + ")";
        }
    }

    public class B {
        private final int id;

        public B(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "B(" + this.id + ")";
        }
    }

    public class A {
        private final int id;

        public A(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "A(" + this.id + ")";
        }
    }
}

