/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.Collection;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class SoundsLikeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SoundsLikeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSoundsLike() {
        this.testFiredRules("package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule SoundsLike\nwhen\n    Person( name soundslike \"Bob\" )\nthen\nend", 1, "Mark", "Bob");
    }

    @Test
    public void testSoundsLikeNegativeCase() {
        this.testFiredRules("package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule SoundsLike\nwhen\n    Person( name soundslike \"Bob\" )\nthen\nend", 0, "Mark");
    }

    @Test
    public void testNotSoundsLike() {
        this.testFiredRules("package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule NotSoundsLike\nwhen\n    Person( name not soundslike \"Bob\" )\nthen\nend", 1, "John");
    }

    @Test
    public void testNotSoundsLikeNegativeCase() {
        this.testFiredRules("package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule NotSoundsLike\nwhen\n    Person( name not soundslike \"Bob\" )\nthen\nend", 0, "Bob");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFiredRules(String rule, int firedRulesCount, String ... persons) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"sounds-like-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        try {
            Stream.of(persons).forEach(person -> ksession.insert((Object)new Person(person)));
            int rules = ksession.fireAllRules();
            Assertions.assertThat((int)rules).isEqualTo(firedRulesCount);
        }
        finally {
            ksession.dispose();
        }
    }
}

