/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.facts.VarargsFact;
import org.drools.mvel.integrationtests.facts.vehicles.DieselCar;
import org.drools.mvel.integrationtests.facts.vehicles.ElectricCar;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class KnownExecModelDifferenceTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KnownExecModelDifferenceTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void setter_intToWrapperLongCoercion() {
        String str = "package com.example.reproducer\nimport " + VarargsFact.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $f : VarargsFact()\nthen\n  $f.setOneWrapperValue(10);\nend";
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
            Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
        } else {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSession ksession = kbase.newKieSession();
            VarargsFact fact = new VarargsFact();
            ksession.insert((Object)fact);
            ksession.fireAllRules();
            Assertions.assertThat(fact.getValueList()).containsExactly((Object[])new Long[]{10L});
        }
    }

    @Test
    public void setter_intToPrimitiveLongCoercion() {
        String str = "package com.example.reproducer\nimport " + VarargsFact.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $f : VarargsFact()\nthen\n  $f.setOnePrimitiveValue(10);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        VarargsFact fact = new VarargsFact();
        ksession.insert((Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat(fact.getValueList()).containsExactly((Object[])new Long[]{10L});
    }

    @Test
    public void setter_intToWrapperLongCoercionVarargs() {
        String str = "package com.example.reproducer\nimport " + VarargsFact.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $f : VarargsFact()\nthen\n  $f.setWrapperValues(10, 20);\nend";
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
            Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
        } else {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSession ksession = kbase.newKieSession();
            VarargsFact fact = new VarargsFact();
            ksession.insert((Object)fact);
            ksession.fireAllRules();
            Assertions.assertThat(fact.getValueList()).containsExactly((Object[])new Long[]{10L, 20L});
        }
    }

    @Test
    public void setter_intToPrimitiveLongCoercionVarargs() {
        String str = "package com.example.reproducer\nimport " + VarargsFact.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $f : VarargsFact()\nthen\n  $f.setPrimitiveValues(10, 20);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        VarargsFact fact = new VarargsFact();
        ksession.insert((Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat(fact.getValueList()).containsExactly((Object[])new Long[]{10L, 20L});
    }

    @Test
    public void property_subClassMethod_genericsReturnType() {
        String str = "package com.example.reproducer\nimport " + DieselCar.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $v : DieselCar(motor.adBlueRequired == true)\nthen\n  $v.score = 5;\nend";
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
            Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
        } else {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSession ksession = kbase.newKieSession();
            DieselCar dieselCar = new DieselCar("ABC", "Model 1.6", 85, true);
            ksession.insert((Object)dieselCar);
            ksession.fireAllRules();
            Assertions.assertThat((int)dieselCar.getScore()).isEqualTo(5);
        }
    }

    @Test
    public void property_subClassMethod_explicitReturnType() {
        String str = "package com.example.reproducer\nimport " + ElectricCar.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $v : ElectricCar(engine.batterySize > 70)\nthen\n  $v.score = 5;\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ElectricCar electricCar = new ElectricCar("XYZ", "Model 3", 200, 90);
        ksession.insert((Object)electricCar);
        ksession.fireAllRules();
        Assertions.assertThat((int)electricCar.getScore()).isEqualTo(5);
    }

    @Test
    public void invalid_cast_intToString() {
        String str = "package com.example.reproducer\nimport " + Person.class.getCanonicalName() + ";\nrule R\ndialect \"mvel\"\nwhen\n  $p : Person()\nthen\n  $p.setStatus((String) $p.age );\nend";
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
            Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
        } else {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSession ksession = kbase.newKieSession();
            Person person = new Person("John", 35);
            ksession.insert((Object)person);
            ksession.fireAllRules();
            Assertions.assertThat((String)person.getStatus()).isEqualTo("35");
        }
    }

    @Test
    public void generics_addStringToBigDecimalList() {
        String str = "package com.example.reproducer\nimport " + BDListHolder.class.getCanonicalName() + ";\nrule R\n  no-loop true\n  dialect \"mvel\"\n  when\n    $fact : BDListHolder(str == \"ADD\", $val : \"100\")\n  then\n    modify($fact) {\n      bdList.add($val);\n    }\nend";
        if (this.kieBaseTestConfiguration.isExecutableModel()) {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
            Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
        } else {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
            KieSession ksession = kbase.newKieSession();
            BDListHolder holder = new BDListHolder();
            holder.setStr("ADD");
            ksession.insert((Object)holder);
            ksession.fireAllRules();
            BigDecimal object = holder.getBdList().get(0);
            Assertions.assertThat((Object)object).isEqualTo((Object)"100");
        }
    }

    public static class BDListHolder {
        private String str;
        private List<BigDecimal> bdList = new ArrayList<BigDecimal>();

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }

        public List<BigDecimal> getBdList() {
            return this.bdList;
        }

        public void setBdList(List<BigDecimal> bdList) {
            this.bdList = bdList;
        }
    }
}

