/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.RoutingMessage;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class StrEvaluatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public StrEvaluatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrStartsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("R1:messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((list.size() == 4 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)list.get(0).equals("Message starts with R1")).isTrue();
            Assertions.assertThat((boolean)list.get(1).equals("Message length is not 17")).isTrue();
            Assertions.assertThat((boolean)list.get(2).equals("Message does not start with R2")).isTrue();
            Assertions.assertThat((boolean)list.get(3).equals("Message does not end with R1")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrEndsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody:R2");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((list.size() == 4 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)list.get(0).equals("Message ends with R2")).isTrue();
            Assertions.assertThat((boolean)list.get(1).equals("Message length is not 17")).isTrue();
            Assertions.assertThat((boolean)list.get(2).equals("Message does not start with R2")).isTrue();
            Assertions.assertThat((boolean)list.get(3).equals("Message does not end with R1")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrLengthEquals() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("R1:messageBody:R2");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(6);
            Assertions.assertThat((boolean)list.contains("Message length is 17")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrNotStartsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((list.size() == 3 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)list.get(1).equals("Message does not start with R2")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrNotEndsWith() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((list.size() == 3 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)list.get(0).equals("Message length is not 17")).isTrue();
            Assertions.assertThat((boolean)list.get(1).equals("Message does not start with R2")).isTrue();
            Assertions.assertThat((boolean)list.get(2).equals("Message does not end with R1")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrLengthNoEquals() {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            RoutingMessage m = new RoutingMessage();
            m.setRoutingValue("messageBody");
            ksession.insert((Object)m);
            ksession.fireAllRules();
            Assertions.assertThat((list.size() == 3 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)list.get(0).equals("Message length is not 17")).isTrue();
            Assertions.assertThat((boolean)list.get(1).equals("Message does not start with R2")).isTrue();
            Assertions.assertThat((boolean)list.get(2).equals("Message does not end with R1")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithLogicalOr() {
        String drl = "package org.drools.mvel.integrationtests\nimport org.drools.mvel.compiler.RoutingMessage\nrule R1\n when\n RoutingMessage( routingValue == \"R2\" || routingValue str[startsWith] \"R1\" )\n then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            for (String msgValue : new String[]{"R1something", "R2something", "R2"}) {
                RoutingMessage msg = new RoutingMessage();
                msg.setRoutingValue(msgValue);
                ksession.insert((Object)msg);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)ksession.fireAllRules()).as("Wrong number of rules fired", new Object[0])).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithInlineCastAndFieldOnThis() {
        String drl = "package org.drools.mvel.integrationtests import " + Person.class.getName() + "; rule R1  when  Object( this#" + Person.class.getName() + ".name str[startsWith] \"M\" )  then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mark"));
            ((AbstractIntegerAssert)Assertions.assertThat((int)ksession.fireAllRules()).as("Wrong number of rules fired", new Object[0])).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrWithInlineCastOnThis() {
        String drl = "package org.drools.mvel.integrationtests rule R1  when  Object( this#String str[startsWith] \"M\" )  then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"Mark");
            ((AbstractIntegerAssert)Assertions.assertThat((int)ksession.fireAllRules()).as("Wrong number of rules fired", new Object[0])).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    private KieBase readKnowledgeBase() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"strevaluator_test.drl"});
        return kbase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUrlInStringComparison() {
        String drl = "package org.drools.mvel.integrationtests import " + FactMap.class.getCanonicalName() + "; rule R1  when  FactMap( String.valueOf(this.getElement(\"classHistory[0].class.where(system='http://domain/url/Code').exists()\")) == \"1\" )  then end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("classHistory[0].class.where(system='http://domain/url/Code').exists()", 1);
            ksession.insert(new FactMap(map));
            ((AbstractIntegerAssert)Assertions.assertThat((int)ksession.fireAllRules()).as("Wrong number of rules fired", new Object[0])).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    public static class FactMap<K, V> {
        private final Map<K, V> map;

        public FactMap(Map<K, V> map) {
            this.map = map;
        }

        public V getElement(K key) {
            return this.map.get(key);
        }
    }
}

