/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class SwitchOverStringTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String FUNCTION_WITH_SWITCH_OVER_STRING = "function void theTest(String input) {\n  switch(input) {\n    case \"Hello World\" :      System.out.println(\"yep\");\n      break;\n    default :\n      System.out.println(\"uh\");\n      break;\n  }\n}";

    public SwitchOverStringTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @After
    public void cleanUp() {
        System.clearProperty("drools.dialect.java.compiler.lnglevel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompileSwitchOverStringWithLngLevel17() {
        double javaVersion = Double.valueOf(System.getProperty("java.specification.version"));
        Assume.assumeTrue((String)"Test only makes sense on Java 7+.", (javaVersion >= 1.7 ? 1 : 0) != 0);
        System.setProperty("drools.dialect.java.compiler.lnglevel", "1.7");
        try {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{FUNCTION_WITH_SWITCH_OVER_STRING});
            List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        }
        finally {
            System.clearProperty("drools.dialect.java.compiler.lnglevel");
        }
    }

    @Test
    public void testShouldFailToCompileSwitchOverStringWithLngLevel16() {
        System.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        try {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{FUNCTION_WITH_SWITCH_OVER_STRING});
            List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
        }
        finally {
            System.clearProperty("drools.dialect.java.compiler.lnglevel");
        }
    }
}

