/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class PassivePatternTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PassivePatternTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPassiveInsert() {
        String drl = "global java.util.List list\nrule R when\n    $i : Integer()\n    ?String( this == $i.toString() )\nthen\n    list.add( $i );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"pasive-pattern-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"global java.util.List list\nrule R when\n    $i : Integer()\n    ?String( this == $i.toString() )\nthen\n    list.add( $i );\nend\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)1);
            ksession.insert((Object)"2");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)"1");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            ksession.insert((Object)2);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list.containsAll(Arrays.asList(1, 2))).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }
}

